/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Internal;
import java.util.HashMap;
import java.util.Map;

@Internal
public enum SQLOperation {
    SELECT("SELECT"),
    INSERT("INSERT"),
    UPDATE("UPDATE"),
    DELETE("DELETE"),
    CREATE("CREATE"),
    DROP("DROP"),
    ALTER("ALTER"),
    SHOW("SHOW"),
    DESCRIBE("DESCRIBE"),
    USE("USE"),
    RENAME("RENAME"),
    BEGIN_TRANSACTION("BEGIN TRANSACTION"),
    COMMIT("COMMIT"),
    ROLLBACK("ROLLBACK"),
    CALL("CALL"),
    UNKNOWN("UNKNOWN");

    private String name;
    private static final Map<String, SQLOperation> operationMap;

    private SQLOperation(String name) {
        this.name = name;
    }

    public static SQLOperation getOperation(String name) {
        return operationMap.get(name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        operationMap = new HashMap<String, SQLOperation>();
        SQLOperation[] values = SQLOperation.values();
        for (int i = 0; i < values.length; ++i) {
            operationMap.put(values[i].name, values[i]);
        }
    }
}

