/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SQLParser {
    private static final String KEEP_COMMENTS = "-- Keep comments";
    private static final char TAB = '\t';
    private static final char ENTER = '\n';
    private static final char ENTER_2 = '\r';
    private static final Set<Object> seperators = N.newHashSet();
    private static final Map<String, String[]> compositeWords;

    private SQLParser() {
    }

    public static List<String> parse(String sql) {
        int sqlLength = sql.length();
        StringBuilder sb = Objectory.createStringBuilder();
        ArrayList<String> words = new ArrayList<String>();
        String temp = "";
        char quoteChar = '\u0000';
        int keepComments = -1;
        block0: for (int index = 0; index < sqlLength; ++index) {
            char c = sql.charAt(index);
            if (quoteChar != '\u0000') {
                sb.append(c);
                if (c != quoteChar || sql.charAt(index - 1) == '\\') continue;
                words.add(sb.toString());
                sb.setLength(0);
                quoteChar = '\u0000';
                continue;
            }
            if (c == '-' && index < sqlLength - 1 && sql.charAt(index + 1) == '-') {
                if (sb.length() > 0) {
                    words.add(sb.toString());
                    sb.setLength(0);
                }
                while (++index < sqlLength && (c = sql.charAt(index)) != '\n' && c != '\r') {
                }
                continue;
            }
            if (c == '/' && index < sqlLength - 1 && sql.charAt(index + 1) == '*') {
                if (sb.length() > 0) {
                    words.add(sb.toString());
                    sb.setLength(0);
                }
                if (keepComments == -1) {
                    int n = keepComments = StringUtil.startsWithIgnoreCase(sql, KEEP_COMMENTS) ? 1 : 0;
                }
                if (keepComments == 1) {
                    sb.append(c);
                    while (++index < sqlLength) {
                        c = sql.charAt(index);
                        sb.append(c);
                        if (c != '*' || index >= sqlLength - 1 || sql.charAt(index + 1) != '/') continue;
                        sb.append(sql.charAt(++index));
                        words.add(sb.toString());
                        sb.setLength(0);
                        continue block0;
                    }
                    continue;
                }
                while (++index < sqlLength) {
                    c = sql.charAt(index);
                    if (c != '*' || index >= sqlLength - 1 || sql.charAt(index + 1) != '/') continue;
                    ++index;
                    continue block0;
                }
                continue;
            }
            if (SQLParser.isSeperator(sql, sqlLength, index, c)) {
                if (sb.length() > 0) {
                    words.add(sb.toString());
                    sb.setLength(0);
                }
                if (index < sqlLength - 2 && seperators.contains(temp = sql.substring(index, index + 3))) {
                    words.add(temp);
                    index += 2;
                    continue;
                }
                if (index < sqlLength - 1 && seperators.contains(temp = sql.substring(index, index + 2))) {
                    words.add(temp);
                    ++index;
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                    if (words.size() <= 0 || ((String)words.get(words.size() - 1)).equals(" ")) continue;
                    words.add(" ");
                    continue;
                }
                words.add(String.valueOf(c));
                continue;
            }
            sb.append(c);
            if (c != '\'' && c != '\"') continue;
            quoteChar = c;
        }
        if (sb.length() > 0) {
            words.add(sb.toString());
            sb.setLength(0);
        }
        Objectory.recycle(sb);
        return words;
    }

    public static int indexWord(String sql, String word, int fromIndex, boolean caseSensitive) {
        String[] subWords = compositeWords.get(word);
        if (subWords == null) {
            subWords = Splitter.with(" ").trimResults().splitToArray(word);
            compositeWords.put(word, subWords);
        }
        if (subWords == null || subWords.length <= 1) {
            int result = -1;
            StringBuilder sb = Objectory.createStringBuilder();
            int sqlLength = sql.length();
            String temp = "";
            char quoteChar = '\u0000';
            for (int index = fromIndex; index < sqlLength; ++index) {
                char c = sql.charAt(index);
                if (quoteChar != '\u0000') {
                    sb.append(c);
                    if (c != quoteChar) continue;
                    temp = sb.toString();
                    if (word.equals(temp) || !caseSensitive && word.equalsIgnoreCase(temp)) {
                        result = index - word.length() + 1;
                        break;
                    }
                    sb.setLength(0);
                    quoteChar = '\u0000';
                    continue;
                }
                if (SQLParser.isSeperator(sql, sqlLength, index, c)) {
                    if (sb.length() > 0) {
                        temp = sb.toString();
                        if (word.equals(temp) || !caseSensitive && word.equalsIgnoreCase(temp)) {
                            result = index - word.length();
                            break;
                        }
                        sb.setLength(0);
                    } else if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                    if (index < sqlLength - 2 && seperators.contains(temp = sql.substring(index, index + 3))) {
                        if (word.equals(temp) || !caseSensitive && word.equalsIgnoreCase(temp)) {
                            result = index;
                            break;
                        }
                        index += 2;
                        continue;
                    }
                    if (index < sqlLength - 1 && seperators.contains(temp = sql.substring(index, index + 2))) {
                        if (word.equals(temp) || !caseSensitive && word.equalsIgnoreCase(temp)) {
                            result = index;
                            break;
                        }
                        ++index;
                        continue;
                    }
                    if (!word.equals(String.valueOf(c)) && (caseSensitive || !word.equalsIgnoreCase(String.valueOf(c)))) continue;
                    result = index;
                    break;
                }
                sb.append(c);
                if (c != '\'' && c != '\"') continue;
                quoteChar = c;
            }
            if (result < 0 && sb.length() > 0 && (word.equals(temp = sb.toString()) || !caseSensitive && word.equalsIgnoreCase(temp))) {
                result = sqlLength - word.length();
            }
            Objectory.recycle(sb);
            return result;
        }
        int result = SQLParser.indexWord(sql, subWords[0], fromIndex, caseSensitive);
        if (result >= 0) {
            int tmpIndex = result + subWords[0].length();
            String nextWord = null;
            for (int i = 1; i < subWords.length; ++i) {
                nextWord = SQLParser.nextWord(sql, tmpIndex);
                if (N.notNullOrEmpty(nextWord) && (nextWord.equals(subWords[i]) || !caseSensitive && nextWord.equalsIgnoreCase(subWords[i]))) {
                    tmpIndex += subWords[i].length() + 1;
                    continue;
                }
                result = -1;
                break;
            }
        }
        return result;
    }

    public static String nextWord(String sql, int fromIndex) {
        int sqlLength = sql.length();
        StringBuilder sb = Objectory.createStringBuilder();
        String temp = "";
        char quoteChar = '\u0000';
        for (int index = fromIndex; index < sqlLength; ++index) {
            char c = sql.charAt(index);
            if (quoteChar != '\u0000') {
                sb.append(c);
                if (c != quoteChar) continue;
                break;
            }
            if (SQLParser.isSeperator(sql, sqlLength, index, c)) {
                if (sb.length() > 0) break;
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                if (index < sqlLength - 2 && seperators.contains(temp = sql.substring(index, index + 3)) || index < sqlLength - 1 && seperators.contains(temp = sql.substring(index, index + 2))) {
                    sb.append(temp);
                    break;
                }
                sb.append(c);
                break;
            }
            sb.append(c);
            if (c != '\'' && c != '\"') continue;
            quoteChar = c;
        }
        String st = sb.length() == 0 ? "" : sb.toString();
        Objectory.recycle(sb);
        return st;
    }

    public static void registerSeperator(char seperator) {
        N.checkArgPositive(seperator, "seperator");
        seperators.add(Character.valueOf(seperator));
    }

    public static void registerSeperator(String seperator) {
        N.checkArgNotNull(seperator, "seperator");
        seperators.add(seperator);
        if (seperator.length() == 1) {
            seperators.add(Character.valueOf(seperator.charAt(0)));
        }
    }

    public static boolean isSeperator(String str, int len, int index, char ch) {
        if (ch == '#' && index < len - 1 && str.charAt(index + 1) == '{') {
            return false;
        }
        return seperators.contains(Character.valueOf(ch));
    }

    public static boolean isFunctionName(List<String> words, int len, int index) {
        return index < len - 1 && words.get(index + 1).charAt(0) == '(';
    }

    static {
        seperators.add(Character.valueOf('\t'));
        seperators.add(Character.valueOf('\n'));
        seperators.add(Character.valueOf('\r'));
        seperators.add(Character.valueOf(' '));
        seperators.add(Character.valueOf('?'));
        seperators.add(Character.valueOf(','));
        seperators.add(Character.valueOf('~'));
        seperators.add(Character.valueOf('!'));
        seperators.add(Character.valueOf('@'));
        seperators.add(Character.valueOf('^'));
        seperators.add(Character.valueOf('#'));
        seperators.add("!!");
        seperators.add(Character.valueOf(';'));
        seperators.add(Character.valueOf('('));
        seperators.add(Character.valueOf(')'));
        seperators.add(Character.valueOf('='));
        seperators.add("==");
        seperators.add(":=");
        seperators.add("^=");
        seperators.add("~=");
        seperators.add("+=");
        seperators.add("-=");
        seperators.add("*=");
        seperators.add("/=");
        seperators.add("%=");
        seperators.add("&=");
        seperators.add("|=");
        seperators.add("!=");
        seperators.add("!<");
        seperators.add("!>");
        seperators.add(Character.valueOf('>'));
        seperators.add(">>");
        seperators.add(">=");
        seperators.add("@>");
        seperators.add("&>");
        seperators.add(">^");
        seperators.add(Character.valueOf('<'));
        seperators.add("<<");
        seperators.add("<=");
        seperators.add("<@");
        seperators.add("&<");
        seperators.add("<^");
        seperators.add(Character.valueOf('+'));
        seperators.add(Character.valueOf('-'));
        seperators.add(Character.valueOf('%'));
        seperators.add(Character.valueOf('/'));
        seperators.add(Character.valueOf('*'));
        seperators.add(Character.valueOf('&'));
        seperators.add("&&");
        seperators.add(Character.valueOf('|'));
        seperators.add("||");
        seperators.add("|/");
        seperators.add("||/");
        seperators.add(Character.valueOf('^'));
        seperators.add(Character.valueOf('~'));
        seperators.add(Character.valueOf('!'));
        seperators.add("->");
        seperators.add(Character.valueOf('#'));
        seperators.add("##");
        seperators.add("@@");
        seperators.add("@-@");
        seperators.add("@@@");
        seperators.add("->>");
        seperators.add("<->");
        seperators.add("<=>");
        seperators.add(">>=");
        seperators.add("<<=");
        seperators.add("<<|");
        seperators.add("|>>");
        seperators.add("&<|");
        seperators.add("|&>");
        seperators.add("|>>");
        seperators.add("(+)");
        seperators.add("?#");
        seperators.add("?-");
        seperators.add("?-");
        seperators.add("?|");
        seperators.add("?-|");
        seperators.add("?||");
        seperators.add("~*");
        seperators.add("!~");
        seperators.add("!~*");
        seperators.add("^-=");
        seperators.add("|*=");
        compositeWords = new ObjectPool<String, String[]>(64);
        compositeWords.put("LEFT JOIN", new String[]{"LEFT", "JOIN"});
        compositeWords.put("RIGHT JOIN", new String[]{"RIGHT", "JOIN"});
        compositeWords.put("FULL JOIN", new String[]{"FULL", "JOIN"});
        compositeWords.put("CROSS JOIN", new String[]{"CROSS", "JOIN"});
        compositeWords.put("INNER JOIN", new String[]{"INNER", "JOIN"});
        compositeWords.put("NATURAL JOIN", new String[]{"NATURAL", "JOIN"});
        compositeWords.put("INNER JOIN", new String[]{"INNER", "JOIN"});
        compositeWords.put("GROUP BY", new String[]{"GROUP", "BY"});
        compositeWords.put("ORDER BY", new String[]{"ORDER", "BY"});
        compositeWords.put("FOR UPDATE", new String[]{"FOR", "UPDATE"});
        compositeWords.put("FETCH FIRST", new String[]{"FETCH", "FIRST"});
        compositeWords.put("FETCH NEXT", new String[]{"FETCH", "NEXT"});
        compositeWords.put("ROWS ONLY", new String[]{"ROWS", "ONLY"});
        compositeWords.put("UNION ALL", new String[]{"UNION", "ALL"});
        compositeWords.put("IS NOT", new String[]{"IS", "NOT"});
        compositeWords.put("IS NULL", new String[]{"IS", "NULL"});
        compositeWords.put("IS NOT NULL", new String[]{"IS", "NOT", "NULL"});
        compositeWords.put("IS EMPTY", new String[]{"IS", "EMPTY"});
        compositeWords.put("IS NOT EMPTY", new String[]{"IS", "NOT", "EMPTY"});
        compositeWords.put("IS BLANK", new String[]{"IS", "BLANK"});
        compositeWords.put("IS NOT BLANK", new String[]{"IS", "NOT", "BLANK"});
        compositeWords.put("NOT IN", new String[]{"NOT", "IN"});
        compositeWords.put("NOT EXISTS", new String[]{"NOT", "EXISTS"});
        ArrayList<String> list = new ArrayList<String>(compositeWords.keySet());
        for (String e : list) {
            if (!compositeWords.containsKey(e = e.toLowerCase())) {
                compositeWords.put(e, Splitter.with(" ").trimResults().splitToArray(e));
            }
            if (compositeWords.containsKey(e = e.toUpperCase())) continue;
            compositeWords.put(e, Splitter.with(" ").trimResults().splitToArray(e));
        }
    }
}

