/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.InternalUtil;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.function.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Splitter {
    public static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    private static final SubStringFunc defaultSubStringFunc = new SubStringFunc(){

        @Override
        public String subString(CharSequence source, int start, int end) {
            return source.subSequence(start, end).toString();
        }
    };
    private static final SubStringFunc trimSubStringFunc = new SubStringFunc(){

        @Override
        public String subString(CharSequence source, int start, int end) {
            while (start < end && source.charAt(start) == ' ') {
                ++start;
            }
            while (end > start && source.charAt(end - 1) == ' ') {
                --end;
            }
            return start >= end ? N.EMPTY_STRING : source.subSequence(start, end).toString();
        }
    };
    private static final SubStringFunc stripSubStringFunc = new SubStringFunc(){

        @Override
        public String subString(CharSequence source, int start, int end) {
            while (start < end && Character.isWhitespace(source.charAt(start))) {
                ++start;
            }
            while (end > start && Character.isWhitespace(source.charAt(end - 1))) {
                --end;
            }
            return start >= end ? N.EMPTY_STRING : source.subSequence(start, end).toString();
        }
    };
    private final Strategy strategy;
    private boolean omitEmptyStrings = false;
    private boolean trimResults = false;
    private boolean stripResults = false;
    private int limit = Integer.MAX_VALUE;

    Splitter(Strategy strategy) {
        this.strategy = strategy;
    }

    public static Splitter defauLt() {
        return Splitter.with(Joiner.DEFAULT_DELIMITER);
    }

    public static Splitter with(final char delimiter) {
        return new Splitter(new Strategy(){

            @Override
            public ObjIterator<String> split(final CharSequence source, final boolean omitEmptyStrings, final boolean trim, final boolean strip, final int limit) {
                if (source == null) {
                    return ObjIterator.empty();
                }
                return new ObjIterator<String>(){
                    private final SubStringFunc subStringFunc;
                    private final int sourceLen;
                    private String next;
                    private int start;
                    private int cursor;
                    private int cnt;
                    {
                        this.subStringFunc = strip ? stripSubStringFunc : (trim ? trimSubStringFunc : defaultSubStringFunc);
                        this.sourceLen = source.length();
                        this.next = null;
                        this.start = 0;
                        this.cursor = 0;
                        this.cnt = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null && this.cursor >= 0 && this.cursor <= this.sourceLen) {
                            if (limit - this.cnt == 1) {
                                this.next = this.subStringFunc.subString(source, this.start, this.sourceLen);
                                this.start = this.cursor = this.sourceLen + 1;
                                if (omitEmptyStrings && this.next.length() == 0) {
                                    this.next = null;
                                }
                            } else {
                                while (this.cursor >= 0 && this.cursor <= this.sourceLen) {
                                    if (this.cursor == this.sourceLen || source.charAt(this.cursor) == delimiter) {
                                        this.next = this.subStringFunc.subString(source, this.start, this.cursor);
                                        this.start = ++this.cursor;
                                        if (omitEmptyStrings && this.next.length() == 0) {
                                            this.next = null;
                                        }
                                        if (this.next == null) continue;
                                        break;
                                    }
                                    ++this.cursor;
                                }
                            }
                        }
                        return this.next != null;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String result = this.next;
                        this.next = null;
                        ++this.cnt;
                        return result;
                    }
                };
            }
        });
    }

    public static Splitter with(final CharSequence delimiter) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(delimiter, "delimiter");
        if (N.isNullOrEmpty(delimiter)) {
            return Splitter.with(WHITE_SPACE_PATTERN);
        }
        if (delimiter.length() == 1) {
            return Splitter.with(delimiter.charAt(0));
        }
        return new Splitter(new Strategy(){

            @Override
            public ObjIterator<String> split(final CharSequence source, final boolean omitEmptyStrings, final boolean trim, final boolean strip, final int limit) {
                if (source == null) {
                    return ObjIterator.empty();
                }
                return new ObjIterator<String>(){
                    private final SubStringFunc subStringFunc;
                    private final char[] sourceChars;
                    private final char[] delimiterChars;
                    private final int sourceLen;
                    private final int delimiterLen;
                    private String next;
                    private int start;
                    private int cursor;
                    private int cnt;
                    {
                        this.subStringFunc = strip ? stripSubStringFunc : (trim ? trimSubStringFunc : defaultSubStringFunc);
                        this.sourceChars = InternalUtil.getCharsForReadOnly(source.toString());
                        this.delimiterChars = InternalUtil.getCharsForReadOnly(delimiter.toString());
                        this.sourceLen = this.sourceChars.length;
                        this.delimiterLen = this.delimiterChars.length;
                        this.next = null;
                        this.start = 0;
                        this.cursor = 0;
                        this.cnt = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null && this.cursor >= 0 && this.cursor <= this.sourceLen) {
                            if (limit - this.cnt == 1) {
                                this.next = this.subStringFunc.subString(source, this.start, this.sourceLen);
                                this.start = this.cursor = this.sourceLen + 1;
                                if (omitEmptyStrings && this.next.length() == 0) {
                                    this.next = null;
                                }
                            } else {
                                while (this.cursor >= 0 && this.cursor <= this.sourceLen) {
                                    if (this.cursor > this.sourceLen - this.delimiterLen || this.sourceChars[this.cursor] == this.delimiterChars[0] && this.match(this.cursor)) {
                                        if (this.cursor > this.sourceLen - this.delimiterLen) {
                                            this.next = this.subStringFunc.subString(source, this.start, this.sourceLen);
                                            this.start = this.cursor = this.sourceLen + 1;
                                        } else {
                                            this.next = this.subStringFunc.subString(source, this.start, this.cursor);
                                            this.start = this.cursor += delimiter.length();
                                        }
                                        if (omitEmptyStrings && this.next.length() == 0) {
                                            this.next = null;
                                        }
                                        if (this.next == null) continue;
                                        break;
                                    }
                                    ++this.cursor;
                                }
                            }
                        }
                        return this.next != null;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String result = this.next;
                        this.next = null;
                        ++this.cnt;
                        return result;
                    }

                    private boolean match(int cursor) {
                        for (int i = 1; i < this.delimiterLen; ++i) {
                            if (this.sourceChars[cursor + i] == this.delimiterChars[i]) continue;
                            return false;
                        }
                        return true;
                    }
                };
            }
        });
    }

    public static Splitter with(final Pattern delimiter) throws IllegalArgumentException {
        N.checkArgNotNull(delimiter, "delimiter");
        N.checkArgument(!delimiter.matcher("").matches(), "Empty string may be matched by pattern: %s", delimiter);
        return new Splitter(new Strategy(){

            @Override
            public ObjIterator<String> split(final CharSequence source, final boolean omitEmptyStrings, final boolean trim, final boolean strip, final int limit) {
                if (source == null) {
                    return ObjIterator.empty();
                }
                return new ObjIterator<String>(){
                    private final SubStringFunc subStringFunc;
                    private final int sourceLen;
                    private final Matcher matcher;
                    private String next;
                    private int start;
                    private int cursor;
                    private int cnt;
                    private boolean matches;
                    {
                        this.subStringFunc = strip ? stripSubStringFunc : (trim ? trimSubStringFunc : defaultSubStringFunc);
                        this.sourceLen = source.length();
                        this.matcher = delimiter.matcher(source);
                        this.next = null;
                        this.start = 0;
                        this.cursor = 0;
                        this.cnt = 0;
                        this.matches = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null && this.cursor >= 0 && this.cursor <= this.sourceLen) {
                            if (limit - this.cnt == 1) {
                                this.next = this.subStringFunc.subString(source, this.start, this.sourceLen);
                                this.start = this.cursor = this.sourceLen + 1;
                                if (omitEmptyStrings && this.next.length() == 0) {
                                    this.next = null;
                                }
                            } else {
                                while (this.cursor >= 0 && this.cursor <= this.sourceLen) {
                                    if (this.cursor == this.sourceLen || (this.matches = this.matcher.find(this.start))) {
                                        if (this.matches) {
                                            this.next = this.subStringFunc.subString(source, this.start, this.matcher.start());
                                            this.start = this.cursor = this.matcher.end();
                                            this.matches = false;
                                        } else {
                                            this.next = this.subStringFunc.subString(source, this.start, this.sourceLen);
                                            this.start = this.cursor = this.sourceLen + 1;
                                        }
                                        if (omitEmptyStrings && this.next.length() == 0) {
                                            this.next = null;
                                        }
                                        if (this.next == null) continue;
                                        break;
                                    }
                                    ++this.cursor;
                                }
                            }
                        }
                        return this.next != null;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String result = this.next;
                        this.next = null;
                        ++this.cnt;
                        return result;
                    }
                };
            }
        });
    }

    public static Splitter pattern(CharSequence delimiterRegex) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(delimiterRegex, "delimiterRegex");
        return Splitter.with(Pattern.compile(delimiterRegex.toString()));
    }

    @Deprecated
    public Splitter omitEmptyStrings(boolean omitEmptyStrings) {
        this.omitEmptyStrings = omitEmptyStrings;
        return this;
    }

    public Splitter omitEmptyStrings() {
        this.omitEmptyStrings = true;
        return this;
    }

    @Deprecated
    public Splitter trim(boolean trim) {
        this.trimResults = trim;
        return this;
    }

    public Splitter trimResults() {
        this.trimResults = true;
        return this;
    }

    @Deprecated
    public Splitter strip(boolean strip) {
        this.stripResults = strip;
        return this;
    }

    public Splitter stripResults() {
        this.stripResults = true;
        return this;
    }

    public Splitter limit(int limit) {
        N.checkArgPositive(limit, "limit");
        this.limit = limit;
        return this;
    }

    public List<String> split(CharSequence source) {
        ArrayList<String> result = new ArrayList<String>();
        this.split(result, source);
        return result;
    }

    public <R, E extends Exception> List<R> split(CharSequence source, Throwables.Function<? super String, R, E> mapper) throws E {
        ArrayList<R> tmp = new ArrayList<R>();
        this.split(tmp, source);
        ArrayList<R> result = tmp;
        int size = tmp.size();
        for (int i = 0; i < size; ++i) {
            result.set(i, mapper.apply((String)tmp.get(i)));
        }
        return result;
    }

    public <T> List<T> split(Class<T> targetType, CharSequence source) {
        N.checkArgNotNull(targetType, "targetType");
        Type type = N.typeOf(targetType);
        return this.split((Collection)((Object)type), source);
    }

    public <T> List<T> split(Type<T> targetType, CharSequence source) {
        N.checkArgNotNull(targetType, "targetType");
        ArrayList result = new ArrayList();
        this.split(result, targetType, source);
        return result;
    }

    public <C extends Collection<String>> C split(C output, CharSequence source) {
        N.checkArgNotNull(output, "output");
        ObjIterator<String> iter = this.iterate(source);
        while (iter.hasNext()) {
            output.add(iter.next());
        }
        return output;
    }

    public <T, C extends Collection<T>> C split(C output, Class<T> targetType, CharSequence source) {
        N.checkArgNotNull(output, "output");
        N.checkArgNotNull(targetType, "targetType");
        Type type = N.typeOf(targetType);
        return this.split(output, type, source);
    }

    public <T, C extends Collection<T>> C split(C output, Type<T> targetType, CharSequence source) {
        N.checkArgNotNull(output, "output");
        N.checkArgNotNull(targetType, "targetType");
        ObjIterator<String> iter = this.iterate(source);
        while (iter.hasNext()) {
            output.add(targetType.valueOf((String)iter.next()));
        }
        return output;
    }

    public <C extends Collection<String>> C split(CharSequence source, Supplier<? extends C> supplier) {
        return (C)this.split((Collection)supplier.get(), source);
    }

    public <T, C extends Collection<T>> C split(Class<T> targetType, CharSequence source, Supplier<? extends C> supplier) {
        return (C)this.split((Collection)supplier.get(), targetType, source);
    }

    public <T, C extends Collection<T>> C split(Type<T> targetType, CharSequence source, Supplier<? extends C> supplier) {
        return (C)this.split((Collection)supplier.get(), targetType, source);
    }

    public ImmutableList<String> splitToImmutableList(CharSequence source) {
        return ImmutableList.of(this.split(source));
    }

    public <T> ImmutableList<T> splitToImmutableList(Class<T> targetType, CharSequence source) {
        return ImmutableList.of(this.split((Collection)((Object)targetType), source));
    }

    public String[] splitToArray(String[] output, CharSequence source) {
        N.checkArgNotNullOrEmpty(output, "output");
        ObjIterator<String> iter = this.iterate(source);
        int len = output.length;
        for (int i = 0; i < len && iter.hasNext(); ++i) {
            output[i] = (String)iter.next();
        }
        return output;
    }

    public String[] splitToArray(CharSequence source) {
        List<String> substrs = this.split(source);
        return substrs.toArray(new String[substrs.size()]);
    }

    public <E extends Exception> String[] splitToArray(CharSequence source, Throwables.Function<? super String, String, E> mapper) throws E {
        List<String> substrs = this.split(source, mapper);
        return substrs.toArray(new String[substrs.size()]);
    }

    public <T> T splitToArray(Class<T> arrayType, CharSequence source) {
        N.checkArgNotNull(arrayType, "arrayType");
        Class<?> eleCls = arrayType.getComponentType();
        List<String> substrs = this.split(source);
        if (eleCls.equals(String.class) || eleCls.equals(Object.class)) {
            return (T)substrs.toArray((Object[])N.newArray(eleCls, substrs.size()));
        }
        Type eleType = N.typeOf(eleCls);
        Object a = N.newArray(eleCls, substrs.size());
        if (N.isPrimitiveType(eleCls)) {
            int len = substrs.size();
            for (int i = 0; i < len; ++i) {
                Array.set(a, i, eleType.valueOf(substrs.get(i)));
            }
        } else {
            Object[] objArray = (Object[])a;
            int len = substrs.size();
            for (int i = 0; i < len; ++i) {
                objArray[i] = eleType.valueOf(substrs.get(i));
            }
        }
        return a;
    }

    public <T, E extends Exception> T splitAndThen(CharSequence source, Throwables.Function<? super List<String>, T, E> converter) throws E {
        N.checkArgNotNull(converter, "converter");
        return converter.apply(this.split(source));
    }

    ObjIterator<String> iterate(CharSequence source) {
        return this.strategy.split(source, this.omitEmptyStrings, this.trimResults, this.stripResults, this.limit);
    }

    static interface SubStringFunc {
        public String subString(CharSequence var1, int var2, int var3);
    }

    static interface Strategy {
        public ObjIterator<String> split(CharSequence var1, boolean var2, boolean var3, boolean var4, int var5);
    }

    public static final class MapSplitter {
        private final Splitter entrySplitter;
        private final Splitter keyValueSplitter;

        MapSplitter(Splitter entrySplitter, Splitter keyValueSplitter) {
            this.entrySplitter = entrySplitter;
            this.keyValueSplitter = keyValueSplitter;
        }

        public static MapSplitter defauLt() {
            return MapSplitter.with(Joiner.DEFAULT_DELIMITER, "=");
        }

        public static MapSplitter with(CharSequence entryDelimiter, CharSequence keyValueDelimiter) throws IllegalArgumentException {
            return new MapSplitter(Splitter.with(entryDelimiter), Splitter.with(keyValueDelimiter));
        }

        public static MapSplitter with(Pattern entryDelimiter, Pattern keyValueDelimiter) throws IllegalArgumentException {
            return new MapSplitter(Splitter.with(entryDelimiter), Splitter.with(keyValueDelimiter));
        }

        public static MapSplitter pattern(CharSequence entryDelimiterRegex, CharSequence keyValueDelimiterRegex) throws IllegalArgumentException {
            return new MapSplitter(Splitter.pattern(entryDelimiterRegex), Splitter.pattern(keyValueDelimiterRegex));
        }

        @Deprecated
        public MapSplitter omitEmptyStrings(boolean omitEmptyStrings) {
            this.keyValueSplitter.omitEmptyStrings(omitEmptyStrings);
            return this;
        }

        public MapSplitter omitEmptyStrings() {
            this.keyValueSplitter.omitEmptyStrings();
            return this;
        }

        @Deprecated
        public MapSplitter trim(boolean trim) {
            this.entrySplitter.trim(trim);
            this.keyValueSplitter.trim(trim);
            return this;
        }

        public MapSplitter trimResults() {
            this.entrySplitter.trimResults();
            this.keyValueSplitter.trimResults();
            return this;
        }

        @Deprecated
        public MapSplitter strip(boolean strip) {
            this.entrySplitter.strip(strip);
            this.keyValueSplitter.strip(strip);
            return this;
        }

        public MapSplitter stripResults() {
            this.entrySplitter.stripResults();
            this.keyValueSplitter.stripResults();
            return this;
        }

        public MapSplitter limit(int limit) {
            N.checkArgPositive(limit, "limit");
            this.entrySplitter.limit(limit);
            return this;
        }

        public Map<String, String> split(CharSequence source) {
            return this.split(new LinkedHashMap(), source);
        }

        public <K, V> Map<K, V> split(Class<K> keyType, Class<V> valueType, CharSequence source) {
            N.checkArgNotNull(keyType, "keyType");
            N.checkArgNotNull(valueType, "valueType");
            Type typeOfKey = N.typeOf(keyType);
            Type typeOfValue = N.typeOf(valueType);
            return this.split(typeOfKey, typeOfValue, source);
        }

        public <K, V> Map<K, V> split(Type<K> keyType, Type<V> valueType, CharSequence source) {
            N.checkArgNotNull(keyType, "keyType");
            N.checkArgNotNull(valueType, "valueType");
            return this.split(new LinkedHashMap(), keyType, valueType, source);
        }

        public <M extends Map<String, String>> M split(M output, CharSequence source) {
            N.checkArgNotNull(output, "output");
            this.entrySplitter.omitEmptyStrings();
            this.keyValueSplitter.limit(2);
            ObjIterator<String> iter = this.entrySplitter.iterate(source);
            ObjIterator<String> keyValueIter = null;
            String entryString = null;
            String key = null;
            String value = null;
            while (iter.hasNext()) {
                entryString = (String)iter.next();
                keyValueIter = this.keyValueSplitter.iterate(entryString);
                if (!keyValueIter.hasNext()) continue;
                key = (String)keyValueIter.next();
                if (!keyValueIter.hasNext()) {
                    throw new IllegalArgumentException("Invalid map entry String: " + entryString);
                }
                value = (String)keyValueIter.next();
                if (keyValueIter.hasNext()) {
                    throw new IllegalArgumentException("Invalid map entry String: " + entryString);
                }
                output.put((String)key, (String)value);
            }
            return output;
        }

        public <K, V, M extends Map<K, V>> M split(M output, Class<K> keyType, Class<V> valueType, CharSequence source) {
            N.checkArgNotNull(output, "output");
            N.checkArgNotNull(keyType, "keyType");
            N.checkArgNotNull(valueType, "valueType");
            Type typeOfKey = N.typeOf(keyType);
            Type typeOfValue = N.typeOf(valueType);
            return this.split(output, typeOfKey, typeOfValue, source);
        }

        public <K, V, M extends Map<K, V>> M split(M output, Type<K> keyType, Type<V> valueType, CharSequence source) {
            N.checkArgNotNull(output, "output");
            N.checkArgNotNull(keyType, "keyType");
            N.checkArgNotNull(valueType, "valueType");
            this.entrySplitter.omitEmptyStrings();
            this.keyValueSplitter.limit(2);
            ObjIterator<String> iter = this.entrySplitter.iterate(source);
            ObjIterator<String> keyValueIter = null;
            String entryString = null;
            String key = null;
            String value = null;
            while (iter.hasNext()) {
                entryString = (String)iter.next();
                keyValueIter = this.keyValueSplitter.iterate(entryString);
                if (!keyValueIter.hasNext()) continue;
                key = (String)keyValueIter.next();
                if (!keyValueIter.hasNext()) {
                    throw new IllegalArgumentException("Invalid map entry String: " + entryString);
                }
                value = (String)keyValueIter.next();
                if (keyValueIter.hasNext()) {
                    throw new IllegalArgumentException("Invalid map entry String: " + entryString);
                }
                output.put(keyType.valueOf(key), valueType.valueOf(value));
            }
            return output;
        }

        public <M extends Map<String, String>> M split(CharSequence source, Supplier<? extends M> supplier) {
            return (M)this.split((Map)supplier.get(), source);
        }

        public <K, V, M extends Map<K, V>> M split(Class<K> keyType, Class<V> valueType, CharSequence source, Supplier<? extends M> supplier) {
            return (M)this.split((Map)supplier.get(), keyType, valueType, source);
        }

        public <K, V, M extends Map<K, V>> M split(Type<K> keyType, Type<V> valueType, CharSequence source, Supplier<? extends M> supplier) {
            return (M)this.split((Map)supplier.get(), keyType, valueType, source);
        }

        public ImmutableMap<String, String> splitToImmutableMap(CharSequence source) {
            return ImmutableMap.of(this.split(source));
        }

        public <K, V> ImmutableMap<K, V> splitToImmutableMap(Class<K> keyType, Class<V> valueType, CharSequence source) {
            return ImmutableMap.of(this.split(keyType, valueType, source));
        }

        public <T, E extends Exception> T splitAndThen(CharSequence source, Throwables.Function<? super Map<String, String>, T, E> converter) throws E {
            return converter.apply(this.split(source));
        }
    }
}

