/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.InternalUtil;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Numbers;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.function.IntUnaryOperator;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.u;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.RandomAccess;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class StringUtil {
    public static final String EMPTY = N.EMPTY_STRING;
    public static final String SPACE = " ";
    public static final String LF = "\n";
    public static final String CR = "\r";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?: |\\u00A0|\\s|[\\s&&[^ ]])\\s*");
    private static final Map<Object, Splitter> splitterPool = new HashMap<Object, Splitter>();
    private static final Map<Object, Splitter> trimSplitterPool = new HashMap<Object, Splitter>();
    private static final Map<Object, Splitter> preserveSplitterPool = new HashMap<Object, Splitter>();
    private static final Map<Object, Splitter> trimPreserveSplitterPool = new HashMap<Object, Splitter>();
    private static final Pattern pattern_accent;

    private StringUtil() {
    }

    public static String valueOf(char[] value) {
        return value == null ? null : String.valueOf(value);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        return N.isNullOrEmptyOrBlank(cs);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return cs != null && cs.length() > 0;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return N.notNullOrEmptyOrBlank(cs);
    }

    public static boolean isAllEmpty(CharSequence ... css) {
        if (N.isNullOrEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtil.isNotEmpty(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllBlank(CharSequence ... css) {
        if (N.isNullOrEmpty(css)) {
            return true;
        }
        for (CharSequence cs : css) {
            if (!StringUtil.isNotBlank(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(CharSequence ... css) {
        if (N.isNullOrEmpty(css)) {
            return false;
        }
        for (CharSequence cs : css) {
            if (!StringUtil.isEmpty(cs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (N.isNullOrEmpty(css)) {
            return false;
        }
        for (CharSequence cs : css) {
            if (!StringUtil.isBlank(cs)) continue;
            return true;
        }
        return false;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultStr) {
        return StringUtil.isEmpty(str) ? defaultStr : str;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, Supplier<? extends T> getterForDefaultStr) {
        if (StringUtil.isEmpty(str)) {
            return (T)((CharSequence)getterForDefaultStr.get());
        }
        return str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        return StringUtil.isBlank(str) ? defaultStr : str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, Supplier<? extends T> getterForDefaultStr) {
        if (StringUtil.isBlank(str)) {
            return (T)((CharSequence)getterForDefaultStr.get());
        }
        return str;
    }

    @SafeVarargs
    public static <T extends CharSequence> T firstNonBlank(T ... values) {
        if (values != null) {
            for (T val : values) {
                if (!StringUtil.isNotBlank(val)) continue;
                return val;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T extends CharSequence> T firstNonEmpty(T ... values) {
        if (values != null) {
            for (T val : values) {
                if (!StringUtil.isNotEmpty(val)) continue;
                return val;
            }
        }
        return null;
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtil.abbreviate(str, "...", 0, maxWidth);
    }

    public static String nullToEmpty(String str) {
        return str == null ? N.EMPTY_STRING : str;
    }

    public static void nullToEmpty(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = strs[i] == null ? N.EMPTY_STRING : strs[i];
        }
    }

    public static String emptyToNull(String str) {
        return str == null || str.length() > 0 ? str : null;
    }

    public static void emptyToNull(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = strs[i] == null || strs[i].length() > 0 ? strs[i] : null;
        }
    }

    @Deprecated
    static String abbreviate(String str, int offset, int maxWidth) {
        return StringUtil.abbreviate(str, "...", offset, maxWidth);
    }

    public static String abbreviate(String str, String abbrevMarker, int maxWidth) {
        return StringUtil.abbreviate(str, abbrevMarker, 0, maxWidth);
    }

    @Deprecated
    static String abbreviate(String str, String abbrevMarker, int offset, int maxWidth) {
        int abbrevMarkerLength = N.len(abbrevMarker);
        int minAbbrevWidth = abbrevMarkerLength + 1;
        int minAbbrevWidthOffset = abbrevMarkerLength + abbrevMarkerLength + 1;
        if (maxWidth < minAbbrevWidth) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width is %d", minAbbrevWidth));
        }
        if (N.notNullOrEmpty(str) && N.EMPTY_STRING.equals(abbrevMarker) && maxWidth > 0) {
            return StringUtil.substring(str, 0, maxWidth);
        }
        if (N.anyNullOrEmpty((CharSequence)str, (CharSequence)abbrevMarker)) {
            return str;
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - abbrevMarkerLength) {
            offset = str.length() - (maxWidth - abbrevMarkerLength);
        }
        if (offset <= abbrevMarkerLength + 1) {
            return str.substring(0, maxWidth - abbrevMarkerLength) + abbrevMarker;
        }
        if (maxWidth < minAbbrevWidthOffset) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width with offset is %d", minAbbrevWidthOffset));
        }
        if (offset + maxWidth - abbrevMarkerLength < str.length()) {
            return abbrevMarker + StringUtil.abbreviate(str.substring(offset), abbrevMarker, maxWidth - abbrevMarkerLength);
        }
        return abbrevMarker + str.substring(str.length() - (maxWidth - abbrevMarkerLength));
    }

    public static String abbreviateMiddle(String str, String middle, int length) {
        if (N.anyNullOrEmpty((CharSequence)str, (CharSequence)middle) || length >= str.length() || length < middle.length() + 2) {
            return str;
        }
        int targetSting = length - middle.length();
        int startOffset = targetSting / 2 + targetSting % 2;
        int endOffset = str.length() - targetSting / 2;
        return str.substring(0, startOffset) + middle + str.substring(endOffset);
    }

    public static String center(String str, int size) {
        return StringUtil.center(str, size, ' ');
    }

    public static String center(String str, int size, char padChar) {
        N.checkArgNotNegative(size, "size");
        if (str == null) {
            str = N.EMPTY_STRING;
        }
        if (str.length() >= size) {
            return str;
        }
        int strLen = str.length();
        int pads = size - strLen;
        str = StringUtil.padStart(str, strLen + pads / 2, padChar);
        str = StringUtil.padEnd(str, size, padChar);
        return str;
    }

    public static String center(String str, int minLength, String padStr) {
        N.checkArgNotNegative(minLength, "minLength");
        if (str == null) {
            str = N.EMPTY_STRING;
        }
        if (str.length() >= minLength) {
            return str;
        }
        if (StringUtil.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int strLen = str.length();
        int pads = minLength - strLen;
        str = StringUtil.padStart(str, strLen + pads / 2, padStr);
        str = StringUtil.padEnd(str, minLength, padStr);
        return str;
    }

    public static String padStart(String str, int minLength) {
        return StringUtil.padStart(str, minLength, ' ');
    }

    public static String padStart(String str, int minLength, char padChar) {
        if (str == null) {
            str = N.EMPTY_STRING;
        }
        if (str.length() >= minLength) {
            return str;
        }
        int delta = minLength - str.length();
        char[] chars = new char[minLength];
        N.fill(chars, 0, delta, padChar);
        str.getChars(0, str.length(), chars, delta);
        return InternalUtil.newString(chars, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String padStart(String str, int minLength, String padStr) {
        if (str == null) {
            str = N.EMPTY_STRING;
        }
        if (str.length() >= minLength) {
            return str;
        }
        int delta = (minLength - str.length()) % padStr.length() == 0 ? (minLength - str.length()) / padStr.length() : (minLength - str.length()) / padStr.length() + 1;
        switch (delta) {
            case 1: {
                return padStr + str;
            }
            case 2: {
                return padStr + padStr + str;
            }
            case 3: {
                return padStr + padStr + padStr + str;
            }
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = 0; i < delta; ++i) {
                sb.append(padStr);
            }
            sb.append(str);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String padEnd(String str, int minLength) {
        return StringUtil.padEnd(str, minLength, ' ');
    }

    public static String padEnd(String str, int minLength, char padChar) {
        if (str == null) {
            str = N.EMPTY_STRING;
        }
        if (str.length() >= minLength) {
            return str;
        }
        char[] chars = new char[minLength];
        str.getChars(0, str.length(), chars, 0);
        N.fill(chars, str.length(), minLength, padChar);
        return InternalUtil.newString(chars, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String padEnd(String str, int minLength, String padStr) {
        if (str == null) {
            str = N.EMPTY_STRING;
        }
        if (str.length() >= minLength) {
            return str;
        }
        int delta = (minLength - str.length()) % padStr.length() == 0 ? (minLength - str.length()) / padStr.length() : (minLength - str.length()) / padStr.length() + 1;
        switch (delta) {
            case 1: {
                return str + padStr;
            }
            case 2: {
                return str + padStr + padStr;
            }
            case 3: {
                return str + padStr + padStr + padStr;
            }
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(str);
            for (int i = 0; i < delta; ++i) {
                sb.append(padStr);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String repeat(char ch, int n) {
        int cnt;
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return N.EMPTY_STRING;
        }
        if (n == 1) {
            return String.valueOf(ch);
        }
        if (n < 16) {
            char[] array = new char[n];
            Arrays.fill(array, ch);
            return InternalUtil.newString(array, true);
        }
        char[] array = new char[n];
        array[0] = ch;
        for (cnt = 1; cnt < n - cnt; cnt <<= 1) {
            N.copy(array, 0, array, cnt, cnt);
        }
        if (cnt < n) {
            N.copy(array, 0, array, cnt, n - cnt);
        }
        return InternalUtil.newString(array, true);
    }

    public static String repeat(char ch, int n, char delimiter) {
        return StringUtil.repeat(String.valueOf(ch), n, String.valueOf(delimiter));
    }

    public static String repeat(String str, int repeat) {
        return StringUtil.repeat(str, repeat, N.EMPTY_STRING);
    }

    public static String repeat(String str, int n, String delimiter) {
        return StringUtil.repeat(str, n, delimiter, N.EMPTY_STRING, N.EMPTY_STRING);
    }

    public static String repeat(String str, int n, String delimiter, String prefix, String suffix) {
        int filledLen;
        int pieceLen;
        int suffixLen;
        N.checkArgNotNegative(n, "n");
        str = str == null ? N.EMPTY_STRING : str;
        delimiter = delimiter == null ? N.EMPTY_STRING : delimiter;
        prefix = prefix == null ? N.EMPTY_STRING : prefix;
        String string = suffix = suffix == null ? N.EMPTY_STRING : suffix;
        if (n == 0 || N.isNullOrEmpty(str) && N.isNullOrEmpty(delimiter)) {
            return prefix + suffix;
        }
        if (n == 1) {
            return prefix + str + suffix;
        }
        int strLen = str.length();
        int delimiterLen = delimiter.length();
        int prefixLen = prefix.length();
        if ((Integer.MAX_VALUE - prefixLen - (suffixLen = suffix.length())) / (pieceLen = strLen + delimiterLen) < n) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + 1L * (long)pieceLen * (long)n);
        }
        int size = pieceLen * n - delimiterLen + prefixLen + suffixLen;
        char[] cbuf = new char[size];
        prefix.getChars(0, prefixLen, cbuf, 0);
        str.getChars(0, strLen, cbuf, prefixLen);
        delimiter.getChars(0, delimiterLen, cbuf, strLen + prefixLen);
        int lenToFill = size - (prefixLen + suffixLen);
        for (filledLen = pieceLen; filledLen <= lenToFill - filledLen; filledLen <<= 1) {
            N.copy(cbuf, prefixLen, cbuf, filledLen + prefixLen, filledLen);
        }
        if (filledLen < lenToFill) {
            N.copy(cbuf, prefixLen, cbuf, filledLen + prefixLen, size - filledLen - prefixLen - suffixLen);
        }
        suffix.getChars(0, suffixLen, cbuf, size - suffixLen);
        return InternalUtil.newString(cbuf, true);
    }

    public static char toLowerCase(char ch) {
        return Character.toLowerCase(ch);
    }

    public static String toLowerCase(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.toLowerCase();
    }

    public static String toLowerCase(String str, Locale locale) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.toLowerCase(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toLowerCaseWithUnderscore(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (Character.isUpperCase(ch)) {
                    if (i > 0 && (Character.isLowerCase(str.charAt(i - 1)) || i < len - 1 && Character.isLowerCase(str.charAt(i + 1))) && sb.length() > 0 && sb.charAt(sb.length() - 1) != '_') {
                        sb.append('_');
                    }
                    sb.append(Character.toLowerCase(ch));
                    continue;
                }
                sb.append(ch);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static char toUpperCase(char ch) {
        return Character.toUpperCase(ch);
    }

    public static String toUpperCase(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.toUpperCase();
    }

    public static String toUpperCase(String str, Locale locale) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.toUpperCase(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toUpperCaseWithUnderscore(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (Character.isUpperCase(ch)) {
                    if (i > 0 && (Character.isLowerCase(str.charAt(i - 1)) || i < len - 1 && Character.isLowerCase(str.charAt(i + 1))) && sb.length() > 0 && sb.charAt(sb.length() - 1) != '_') {
                        sb.append('_');
                    }
                    sb.append(ch);
                    continue;
                }
                sb.append(Character.toUpperCase(ch));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toCamelCase(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        if (str.indexOf(95) >= 0) {
            String[] substrs = StringUtil.split(str, '_');
            StringBuilder sb = Objectory.createStringBuilder();
            try {
                for (String substr : substrs) {
                    if (!N.notNullOrEmpty(substr)) continue;
                    sb.append(StringUtil.toLowerCase(substr));
                    if (sb.length() <= substr.length()) continue;
                    sb.setCharAt(sb.length() - substr.length(), Character.toTitleCase(substr.charAt(0)));
                }
                String string = sb.toString();
                return string;
            }
            finally {
                Objectory.recycle(sb);
            }
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLowerCase(str.charAt(i))) {
                if (i == 1) {
                    return StringUtil.uncapitalize(str);
                }
                if (i <= 1) break;
                return str.substring(0, i - 1).toLowerCase() + str.substring(i - 1);
            }
            if (i + 1 != str.length()) continue;
            return str.toLowerCase();
        }
        return str;
    }

    public static char[] toCharArray(CharSequence source) {
        int len = N.len(source);
        if (len == 0) {
            return N.EMPTY_CHAR_ARRAY;
        }
        if (source instanceof String) {
            return ((String)source).toCharArray();
        }
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = source.charAt(i);
        }
        return array;
    }

    public static int[] toCodePoints(CharSequence str) {
        if (N.isNullOrEmpty(str)) {
            return N.EMPTY_INT_ARRAY;
        }
        String s = str.toString();
        int[] result = new int[s.codePointCount(0, s.length())];
        int index = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = s.codePointAt(index);
            index += Character.charCount(result[i]);
        }
        return result;
    }

    public static char swapCase(char ch) {
        return Character.isLowerCase(ch) ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
    }

    public static String swapCase(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char[] cbuf = str.toCharArray();
        char ch = '\u0000';
        int len = cbuf.length;
        for (int i = 0; i < len; ++i) {
            ch = cbuf[i];
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                cbuf[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            cbuf[i] = Character.toUpperCase(ch);
        }
        return InternalUtil.newString(cbuf, true);
    }

    public static String capitalize(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char ch = str.charAt(0);
        if (Character.isTitleCase(ch)) {
            return str;
        }
        if (str.length() == 1) {
            return String.valueOf(Character.toTitleCase(ch));
        }
        return Character.toTitleCase(ch) + str.substring(1);
    }

    public static String uncapitalize(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char ch = str.charAt(0);
        if (Character.isLowerCase(ch)) {
            return str;
        }
        if (str.length() == 1) {
            return String.valueOf(Character.toLowerCase(ch));
        }
        return Character.toLowerCase(ch) + str.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quoteEscaped(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        char[] chars = InternalUtil.getCharsForReadOnly(str);
        try {
            char ch = '\u0000';
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                ch = chars[i];
                if (ch == '\\' && i < len - 1) {
                    sb.append(ch);
                    sb.append(str.charAt(++i));
                    continue;
                }
                if (ch == '\'' || ch == '\"') {
                    sb.append('\\');
                    sb.append(ch);
                    continue;
                }
                sb.append(ch);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String unicodeEscaped(char ch) {
        if (ch < '\u0010') {
            return "\\u000" + Integer.toHexString(ch);
        }
        if (ch < '\u0100') {
            return "\\u00" + Integer.toHexString(ch);
        }
        if (ch < '\u1000') {
            return "\\u0" + Integer.toHexString(ch);
        }
        return "\\u" + Integer.toHexString(ch);
    }

    public static String normalizeSpace(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return WHITESPACE_PATTERN.matcher(str.trim()).replaceAll(SPACE);
    }

    public static String replaceAll(String str, String target, String replacement) {
        return StringUtil.replaceAll(str, 0, target, replacement);
    }

    public static String replaceAll(String str, int fromIndex, String target, String replacement) {
        return StringUtil.replace(str, fromIndex, target, replacement, -1);
    }

    public static String replaceOnce(String str, String target, String replacement) {
        return StringUtil.replaceOnce(str, 0, target, replacement);
    }

    public static String replaceOnce(String str, int fromIndex, String target, String replacement) {
        return StringUtil.replace(str, fromIndex, target, replacement, 1);
    }

    public static String replace(String str, int fromIndex, String target, String replacement, int max) {
        return StringUtil.replace(str, fromIndex, target, replacement, max, false);
    }

    public static String replaceAllIgnoreCase(String str, String target, String replacement) {
        return StringUtil.replaceAllIgnoreCase(str, 0, target, replacement);
    }

    public static String replaceAllIgnoreCase(String str, int fromIndex, String target, String replacement) {
        return StringUtil.replaceIgnoreCase(str, fromIndex, target, replacement, -1);
    }

    public static String replaceOnceIgnoreCase(String str, String target, String replacement) {
        return StringUtil.replaceOnceIgnoreCase(str, 0, target, replacement);
    }

    public static String replaceOnceIgnoreCase(String str, int fromIndex, String target, String replacement) {
        return StringUtil.replaceIgnoreCase(str, fromIndex, target, replacement, 1);
    }

    public static String replaceIgnoreCase(String str, int fromIndex, String target, String replacement, int max) {
        return StringUtil.replace(str, fromIndex, target, replacement, max, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String replace(String str, int fromIndex, String target, String replacement, int max, boolean ignoreCase) {
        String searchTarget;
        if (replacement == null) {
            replacement = "";
        }
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(target) || max == 0) {
            return str;
        }
        String searchText = ignoreCase ? str.toLowerCase() : str;
        int end = searchText.indexOf(searchTarget = ignoreCase ? target.toLowerCase() : target, fromIndex);
        if (end == -1) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        int substrLength = target.length();
        sb.append(str, 0, fromIndex);
        int start = fromIndex;
        try {
            while (end != -1) {
                sb.append(str, start, end).append(replacement);
                start = end + substrLength;
                if (--max == 0) break;
                end = searchText.indexOf(searchTarget, start);
            }
            sb.append(str, start, str.length());
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String replacePattern(String source, String regex, String replacement) {
        return Pattern.compile(regex, 32).matcher(source).replaceAll(replacement);
    }

    public static String removeStart(String str, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        if (str.startsWith(removeStr)) {
            return str.substring(removeStr.length());
        }
        return str;
    }

    public static String removeStartIgnoreCase(String str, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        if (StringUtil.startsWithIgnoreCase(str, removeStr)) {
            return str.substring(removeStr.length());
        }
        return str;
    }

    public static String removeEnd(String str, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        if (str.endsWith(removeStr)) {
            return str.substring(0, str.length() - removeStr.length());
        }
        return str;
    }

    public static String removeEndIgnoreCase(String str, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        if (StringUtil.endsWithIgnoreCase(str, removeStr)) {
            return str.substring(0, str.length() - removeStr.length());
        }
        return str;
    }

    public static String removeAll(String str, char removeChar) {
        return StringUtil.removeAll(str, 0, removeChar);
    }

    public static String removeAll(String str, int fromIndex, char removeChar) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        int index = str.indexOf(removeChar, fromIndex);
        if (index == -1) {
            return str;
        }
        char[] chars = InternalUtil.getCharsForReadOnly(str);
        char[] cbuf = new char[str.length()];
        if (index > 0) {
            str.getChars(0, index, cbuf, 0);
        }
        int count = index;
        int len = chars.length;
        for (int i = index + 1; i < len; ++i) {
            if (chars[i] == removeChar) continue;
            cbuf[count++] = chars[i];
        }
        return count == chars.length ? str : new String(cbuf, 0, count);
    }

    public static String removeAll(String str, String removeStr) {
        return StringUtil.removeAll(str, 0, removeStr);
    }

    public static String removeAll(String str, int fromIndex, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        return StringUtil.replace(str, fromIndex, removeStr, N.EMPTY_STRING, -1);
    }

    public static String removePattern(String source, String regex) {
        return StringUtil.replacePattern(source, regex, N.EMPTY_STRING);
    }

    public static String[] split(String str, char delimiter) {
        Splitter splitter = splitterPool.get(Character.valueOf(delimiter));
        return (splitter == null ? Splitter.with(delimiter).omitEmptyStrings() : splitter).splitToArray(str);
    }

    public static String[] split(String str, char delimiter, boolean trim) {
        if (trim) {
            Splitter splitter = trimSplitterPool.get(Character.valueOf(delimiter));
            return (splitter == null ? Splitter.with(delimiter).omitEmptyStrings().trim(trim) : splitter).splitToArray(str);
        }
        return StringUtil.split(str, delimiter);
    }

    public static String[] split(String str, String delimiter) {
        Splitter splitter = splitterPool.get(delimiter);
        return (splitter == null ? Splitter.with(delimiter).omitEmptyStrings() : splitter).splitToArray(str);
    }

    public static String[] split(String str, String delimiter, boolean trim) {
        if (trim) {
            Splitter splitter = trimSplitterPool.get(delimiter);
            return (splitter == null ? Splitter.with(delimiter).omitEmptyStrings().trim(trim) : splitter).splitToArray(str);
        }
        return StringUtil.split(str, delimiter);
    }

    @Deprecated
    public static String[] split(String str, String delimiter, int max) {
        return Splitter.with(delimiter).omitEmptyStrings().limit(max).splitToArray(str);
    }

    @Deprecated
    public static String[] split(String str, String delimiter, int max, boolean trim) {
        return Splitter.with(delimiter).omitEmptyStrings().trim(trim).limit(max).splitToArray(str);
    }

    public static String[] splitPreserveAllTokens(String str, char delimiter) {
        Splitter splitter = preserveSplitterPool.get(Character.valueOf(delimiter));
        return (splitter == null ? Splitter.with(delimiter) : splitter).splitToArray(str);
    }

    public static String[] splitPreserveAllTokens(String str, char delimiter, boolean trim) {
        if (trim) {
            Splitter splitter = trimPreserveSplitterPool.get(Character.valueOf(delimiter));
            return (splitter == null ? Splitter.with(delimiter).trim(trim) : splitter).splitToArray(str);
        }
        return StringUtil.splitPreserveAllTokens(str, delimiter);
    }

    public static String[] splitPreserveAllTokens(String str, String delimiter) {
        Splitter splitter = preserveSplitterPool.get(delimiter);
        return (splitter == null ? Splitter.with(delimiter) : splitter).splitToArray(str);
    }

    public static String[] splitPreserveAllTokens(String str, String delimiter, boolean trim) {
        if (trim) {
            Splitter splitter = trimPreserveSplitterPool.get(delimiter);
            return (splitter == null ? Splitter.with(delimiter).trim(trim) : splitter).splitToArray(str);
        }
        return StringUtil.splitPreserveAllTokens(str, delimiter);
    }

    @Deprecated
    public static String[] splitPreserveAllTokens(String str, String delimiter, int max) {
        return Splitter.with(delimiter).limit(max).splitToArray(str);
    }

    @Deprecated
    public static String[] splitPreserveAllTokens(String str, String delimiter, int max, boolean trim) {
        return Splitter.with(delimiter).trim(trim).limit(max).splitToArray(str);
    }

    public static String trim(String str) {
        return N.isNullOrEmpty(str) || str.charAt(0) != ' ' && str.charAt(str.length() - 1) != ' ' ? str : str.trim();
    }

    public static void trim(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.trim(strs[i]);
        }
    }

    public static String trimToNull(String str) {
        return N.isNullOrEmpty(str = StringUtil.trim(str)) ? null : str;
    }

    public static void trimToNull(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.trimToNull(strs[i]);
        }
    }

    public static String trimToEmpty(String str) {
        return N.isNullOrEmpty(str) ? N.EMPTY_STRING : str.trim();
    }

    public static void trimToEmpty(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.trimToEmpty(strs[i]);
        }
    }

    public static String strip(String str) {
        return StringUtil.strip(str, null);
    }

    public static void strip(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.strip(strs[i]);
        }
    }

    public static String stripToNull(String str) {
        return N.isNullOrEmpty(str = StringUtil.strip(str, null)) ? null : str;
    }

    public static void stripToNull(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.stripToNull(strs[i]);
        }
    }

    public static String stripToEmpty(String str) {
        return N.isNullOrEmpty(str) ? N.EMPTY_STRING : StringUtil.strip(str, null);
    }

    public static void stripToEmpty(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.stripToEmpty(strs[i]);
        }
    }

    public static String strip(String str, String stripChars) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return StringUtil.stripEnd(StringUtil.stripStart(str, stripChars), stripChars);
    }

    public static void strip(String[] strs, String stripChars) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.strip(strs[i], stripChars);
        }
    }

    public static String stripStart(String str, String stripChars) {
        int start;
        if (N.isNullOrEmpty(str) || stripChars != null && stripChars.isEmpty()) {
            return str;
        }
        int strLen = str.length();
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return start == 0 ? str : str.substring(start);
    }

    public static void stripStart(String[] strs, String stripChars) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.stripStart(strs[i], stripChars);
        }
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (N.isNullOrEmpty(str) || stripChars != null && stripChars.isEmpty()) {
            return str;
        }
        if (stripChars == null) {
            for (end = str.length(); end > 0 && Character.isWhitespace(str.charAt(end - 1)); --end) {
            }
        } else {
            while (end > 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return end == str.length() ? str : str.substring(0, end);
    }

    public static void stripEnd(String[] strs, String stripChars) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.stripEnd(strs[i], stripChars);
        }
    }

    public static String stripAccents(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        String decomposed = Normalizer.normalize(str, Normalizer.Form.NFD);
        return pattern_accent.matcher(decomposed).replaceAll("");
    }

    public static void stripAccents(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.stripAccents(strs[i]);
        }
    }

    public static String chomp(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return N.EMPTY_STRING;
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (last != '\r') {
            ++lastIdx;
        }
        return lastIdx == str.length() ? str : str.substring(0, lastIdx);
    }

    public static void chomp(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.chomp(strs[i]);
        }
    }

    public static String chop(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return N.EMPTY_STRING;
        }
        int lastIdx = strLen - 1;
        if (str.charAt(lastIdx) == '\n' && str.charAt(lastIdx - 1) == '\r') {
            return str.substring(0, lastIdx - 1);
        }
        return str.substring(0, lastIdx);
    }

    public static void chop(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.chop(strs[i]);
        }
    }

    public static String truncate(String str, int maxWidth) {
        return StringUtil.truncate(str, 0, maxWidth);
    }

    public static String truncate(String str, int offset, int maxWidth) {
        N.checkArgNotNegative(offset, "offset");
        N.checkArgNotNegative(maxWidth, "maxWidth");
        if (str == null) {
            return null;
        }
        if (str.length() <= offset || maxWidth == 0) {
            return EMPTY;
        }
        if (str.length() - offset <= maxWidth) {
            return offset == 0 ? str : str.substring(offset);
        }
        return str.substring(offset, offset + maxWidth);
    }

    public static String deleteWhitespace(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char[] chars = InternalUtil.getCharsForReadOnly(str);
        char[] cbuf = new char[chars.length];
        int count = 0;
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            cbuf[count++] = chars[i];
        }
        return count == chars.length ? str : new String(cbuf, 0, count);
    }

    public static void deleteWhitespace(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = StringUtil.deleteWhitespace(strs[i]);
        }
    }

    public static String appendIfMissing(String str, String suffix) {
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return suffix;
        }
        if (str.endsWith(suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static String appendIfMissingIgnoreCase(String str, String suffix) {
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return suffix;
        }
        if (StringUtil.endsWithIgnoreCase(str, suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static String prependIfMissing(String str, String prefix) {
        N.checkArgNotNull(prefix);
        if (N.isNullOrEmpty(str)) {
            return prefix;
        }
        if (str.startsWith(prefix)) {
            return str;
        }
        return prefix + str;
    }

    public static String prependIfMissingIgnoreCase(String str, String prefix) {
        N.checkArgNotNull(prefix);
        if (N.isNullOrEmpty(str)) {
            return prefix;
        }
        if (StringUtil.startsWithIgnoreCase(str, prefix)) {
            return str;
        }
        return prefix + str;
    }

    public static String wrapIfMissing(String str, String prefixSuffix) {
        return StringUtil.wrapIfMissing(str, prefixSuffix, prefixSuffix);
    }

    public static String wrapIfMissing(String str, String prefix, String suffix) {
        N.checkArgNotNull(prefix);
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return prefix + suffix;
        }
        if (str.startsWith(prefix)) {
            return str.length() - prefix.length() >= suffix.length() && str.endsWith(suffix) ? str : str + suffix;
        }
        if (str.endsWith(suffix)) {
            return prefix + str;
        }
        return StringUtil.concat(prefix, str, suffix);
    }

    public static String wrap(String str, String prefixSuffix) {
        return StringUtil.wrap(str, prefixSuffix, prefixSuffix);
    }

    public static String wrap(String str, String prefix, String suffix) {
        N.checkArgNotNull(prefix);
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return prefix + suffix;
        }
        return StringUtil.concat(prefix, str, suffix);
    }

    public static String unwrap(String str, String prefixSuffix) {
        return StringUtil.unwrap(str, prefixSuffix, prefixSuffix);
    }

    public static String unwrap(String str, String prefix, String suffix) {
        N.checkArgNotNull(prefix);
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return N.EMPTY_STRING;
        }
        if (str.length() - prefix.length() >= suffix.length() && str.startsWith(prefix) && str.endsWith(suffix)) {
            return str.substring(prefix.length(), str.length() - suffix.length());
        }
        return str;
    }

    public static boolean isLowerCase(char ch) {
        return Character.isLowerCase(ch);
    }

    public static boolean isAsciiLowerCase(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isUpperCase(char ch) {
        return Character.isUpperCase(ch);
    }

    public static boolean isAsciiUpperCase(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (!Character.isUpperCase(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!Character.isUpperCase(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (!Character.isLowerCase(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!Character.isLowerCase(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMixedCase(CharSequence cs) {
        if (N.isNullOrEmpty(cs) || cs.length() == 1) {
            return false;
        }
        boolean containsUppercase = false;
        boolean containsLowercase = false;
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (containsUppercase && containsLowercase) {
                    return true;
                }
                if (Character.isUpperCase(chars[i])) {
                    containsUppercase = true;
                    continue;
                }
                if (!Character.isLowerCase(chars[i])) continue;
                containsLowercase = true;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (containsUppercase && containsLowercase) {
                    return true;
                }
                if (Character.isUpperCase(cs.charAt(i))) {
                    containsUppercase = true;
                    continue;
                }
                if (!Character.isLowerCase(cs.charAt(i))) continue;
                containsLowercase = true;
            }
        }
        return containsUppercase && containsLowercase;
    }

    public static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }

    public static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    public static boolean isLetterOrDigit(char ch) {
        return Character.isLetterOrDigit(ch);
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch > '\u001f' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isAsciiAlpha(char ch) {
        return StringUtil.isAsciiAlphaUpper(ch) || StringUtil.isAsciiAlphaLower(ch);
    }

    public static boolean isAsciiAlphaUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isAsciiAlphaLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isAsciiNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isAsciiAlphanumeric(char ch) {
        return StringUtil.isAsciiAlpha(ch) || StringUtil.isAsciiNumeric(ch);
    }

    public static boolean isAsciiPrintable(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiPrintable(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiPrintable(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiAlpha(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlpha(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlpha(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiAlphaSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlpha(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlpha(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiAlphanumeric(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlphanumeric(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlphanumeric(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiAlphanumericSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlphanumeric(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlphanumeric(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiNumeric(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiNumeric(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiNumeric(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlpha(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isLetter(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isLetter(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlphaSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isLetter(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isLetter(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlphanumeric(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isLetterOrDigit(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isLetterOrDigit(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlphanumericSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isLetterOrDigit(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isLetterOrDigit(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNumeric(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isDigit(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isDigit(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNumericSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isDigit(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isDigit(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isWhitespace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = InternalUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNumber(String str) {
        return Numbers.createNumber(str).isPresent();
    }

    public static boolean isAsciiDigtalNumber(String str) {
        if (N.isNullOrEmpty(str)) {
            return false;
        }
        char[] chs = InternalUtil.getCharsForReadOnly(str);
        int i = 0;
        int num = 0;
        if (chs[i] == '+' || chs[i] == '-') {
            ++i;
        }
        while (i < chs.length && chs[i] >= '0' && chs[i] <= '9') {
            ++num;
            ++i;
        }
        if (i < chs.length && chs[i] == '.') {
            if (num == 0) {
                return false;
            }
            num = 0;
            ++i;
        }
        while (i < chs.length && chs[i] >= '0' && chs[i] <= '9') {
            ++num;
            ++i;
        }
        if (num == 0) {
            return false;
        }
        if (i == chs.length) {
            return true;
        }
        if (chs[i] != 'e' && chs[i] != 'E') {
            return false;
        }
        num = 0;
        if (++i < chs.length && (chs[i] == '+' || chs[i] == '-')) {
            ++i;
        }
        while (i < chs.length && chs[i] >= '0' && chs[i] <= '9') {
            ++num;
            ++i;
        }
        if (num == 0) {
            return false;
        }
        return i == chs.length;
    }

    public static boolean isAsciiDigtalInteger(String str) {
        if (N.isNullOrEmpty(str)) {
            return false;
        }
        char[] chs = InternalUtil.getCharsForReadOnly(str);
        int i = 0;
        int num = 0;
        if (chs[i] == '+' || chs[i] == '-') {
            ++i;
        }
        while (i < chs.length && chs[i] >= '0' && chs[i] <= '9') {
            ++num;
            ++i;
        }
        if (num == 0) {
            return false;
        }
        return i == chs.length;
    }

    public static int indexOf(String str, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        return str.indexOf(targetChar);
    }

    public static int indexOf(String str, int fromIndex, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        return str.indexOf(targetChar, fromIndex);
    }

    public static int indexOf(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        return str.indexOf(substr);
    }

    public static int indexOf(String str, int fromIndex, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length() - fromIndex) {
            return -1;
        }
        return str.indexOf(substr, fromIndex);
    }

    @SafeVarargs
    public static int indexOfAny(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return -1;
        }
        int strLen = str.length();
        int strLast = strLen - 1;
        int chsLen = chs.length;
        int chsLast = chsLen - 1;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < chsLen; ++j) {
                if (chs[j] != ch) continue;
                if (i < strLast && j < chsLast && Character.isHighSurrogate(ch)) {
                    if (chs[j + 1] != str.charAt(i + 1)) continue;
                    return i;
                }
                return i;
            }
        }
        return -1;
    }

    @SafeVarargs
    public static int indexOfAny(String str, String ... substrs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substrs)) {
            return -1;
        }
        int result = -1;
        int tmp = 0;
        for (String substr : substrs) {
            if (N.isNullOrEmpty(substr) || (tmp = StringUtil.indexOf(str, substr)) == -1 || result != -1 && tmp >= result) continue;
            result = tmp;
        }
        return result;
    }

    @SafeVarargs
    public static int indexOfAnyBut(String str, char ... chs) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        if (N.isNullOrEmpty(chs)) {
            return 0;
        }
        int strLen = str.length();
        int strLast = strLen - 1;
        int chsLen = chs.length;
        int chsLast = chsLen - 1;
        block0: for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < chsLen; ++j) {
                if (chs[j] == ch && (i >= strLast || j >= chsLast || !Character.isHighSurrogate(ch) || chs[j + 1] == str.charAt(i + 1))) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(String str, String substr, String delimiter) {
        return StringUtil.indexOf(str, 0, substr, delimiter);
    }

    public static int indexOf(String str, int fromIndex, String substr, String delimiter) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return -1;
        }
        int index = str.indexOf(substr, fromIndex);
        if (index < 0) {
            return -1;
        }
        if (index + substr.length() == str.length()) {
            return index;
        }
        if (str.length() >= index + substr.length() + delimiter.length()) {
            int i = 0;
            int j = index + substr.length();
            int seperatorLen = delimiter.length();
            while (i < seperatorLen) {
                if (delimiter.charAt(i++) == str.charAt(j++)) continue;
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String str, String substr) {
        return StringUtil.indexOfIgnoreCase(str, 0, substr);
    }

    public static int indexOfIgnoreCase(String str, int fromIndex, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length() - fromIndex) {
            return -1;
        }
        int len = str.length();
        int substrLen = substr.length();
        int end = len - substrLen + 1;
        for (int i = fromIndex; i < end; ++i) {
            if (!str.regionMatches(true, i, substr, 0, substrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String substr, int ordinal) {
        return StringUtil.ordinalIndexOf(str, substr, ordinal, false);
    }

    public static int lastIndexOf(String str, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        return str.lastIndexOf(targetChar);
    }

    public static int lastIndexOf(String str, int fromIndex, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        return str.lastIndexOf(targetChar, fromIndex);
    }

    public static int lastIndexOf(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        return str.lastIndexOf(substr);
    }

    public static int lastIndexOf(String str, int fromIndex, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        return str.lastIndexOf(substr, fromIndex);
    }

    @SafeVarargs
    public static int lastIndexOfAny(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return -1;
        }
        int result = -1;
        int tmp = 0;
        for (char ch : chs) {
            tmp = str.lastIndexOf(ch);
            if (tmp == -1 || result != -1 && tmp <= result) continue;
            result = tmp;
        }
        return result;
    }

    @SafeVarargs
    public static int lastIndexOfAny(String str, String ... substrs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substrs)) {
            return -1;
        }
        int result = -1;
        int tmp = 0;
        for (String substr : substrs) {
            if (N.isNullOrEmpty(substr) || (tmp = str.lastIndexOf(substr)) == -1 || result != -1 && tmp <= result) continue;
            result = tmp;
        }
        return result;
    }

    public static int lastIndexOf(String str, String substr, String delimiter) {
        return StringUtil.lastIndexOf(str, str.length(), substr, delimiter);
    }

    public static int lastIndexOf(String str, int fromIndex, String substr, String delimiter) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return -1;
        }
        int index = str.lastIndexOf(substr, N.min(fromIndex, str.length()));
        if (index < 0) {
            return -1;
        }
        if (index + substr.length() == str.length()) {
            return index;
        }
        if (str.length() >= index + substr.length() + delimiter.length()) {
            int i = 0;
            int j = index + substr.length();
            int len = delimiter.length();
            while (i < len) {
                if (delimiter.charAt(i++) == str.charAt(j++)) continue;
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        return StringUtil.lastIndexOfIgnoreCase(str, str.length(), substr);
    }

    public static int lastIndexOfIgnoreCase(String str, int fromIndex, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        int substrLen = substr.length();
        for (int i = N.min(fromIndex, str.length() - substr.length()); i >= 0; --i) {
            if (!str.regionMatches(true, i, substr, 0, substrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int lastOrdinalIndexOf(String str, String substr, int ordinal) {
        return StringUtil.ordinalIndexOf(str, substr, ordinal, true);
    }

    private static int ordinalIndexOf(String str, String substr, int ordinal, boolean isLastIndex) {
        if (ordinal < 1) {
            throw new IllegalArgumentException("ordinal(" + ordinal + ") must be >= 1");
        }
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        int fromIndex = isLastIndex ? str.length() : 0;
        int found = 0;
        while (fromIndex >= 0) {
            int n = fromIndex = isLastIndex ? str.lastIndexOf(substr, fromIndex) : str.indexOf(substr, fromIndex);
            if (fromIndex < 0) {
                return -1;
            }
            if (++found >= ordinal) break;
            fromIndex = isLastIndex ? fromIndex - substr.length() : fromIndex + substr.length();
        }
        return fromIndex;
    }

    public static int occurrencesOf(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return 0;
        }
        int occurrences = 0;
        int len = N.len(str);
        int substrLen = N.len(substr);
        int index = 0;
        int fromIndex = 0;
        int toIndex = len - substrLen;
        while (fromIndex <= toIndex && (index = str.indexOf(substr, fromIndex)) >= 0) {
            fromIndex = index + substrLen;
            ++occurrences;
        }
        return occurrences;
    }

    public static boolean contains(String str, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return false;
        }
        return StringUtil.indexOf(str, targetChar) != -1;
    }

    public static boolean contains(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return false;
        }
        return StringUtil.indexOf(str, substr) != -1;
    }

    public static boolean contains(String str, String substr, String delimiter) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return false;
        }
        return StringUtil.indexOf(str, substr, delimiter) != -1;
    }

    public static boolean containsIgnoreCase(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return false;
        }
        return StringUtil.indexOfIgnoreCase(str, substr) != -1;
    }

    @SafeVarargs
    public static boolean containsAny(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return false;
        }
        return StringUtil.indexOfAny(str, chs) != -1;
    }

    @SafeVarargs
    public static boolean containsOnly(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return false;
        }
        return StringUtil.indexOfAnyBut(str, chs) == -1;
    }

    @SafeVarargs
    public static boolean containsNone(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return true;
        }
        int strLen = str.length();
        int strLast = strLen - 1;
        int chsLen = chs.length;
        int chsLast = chsLen - 1;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < chsLen; ++j) {
                if (chs[j] != ch) continue;
                if (Character.isHighSurrogate(ch)) {
                    if (j == chsLast) {
                        return false;
                    }
                    if (i >= strLast || chs[j + 1] != str.charAt(i + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean containsWhitespace(String str) {
        if (N.isNullOrEmpty(str)) {
            return false;
        }
        char[] chars = InternalUtil.getCharsForReadOnly(str);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isWhitespace(chars[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String str, String prefix) {
        return StringUtil.startsWith(str, prefix, false);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return StringUtil.startsWith(str, prefix, true);
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null || prefix.length() > str.length()) {
            return false;
        }
        return ignoreCase ? str.regionMatches(true, 0, prefix, 0, prefix.length()) : str.startsWith(prefix);
    }

    @SafeVarargs
    public static boolean startsWithAny(String str, String ... substrs) {
        if (str == null || N.isNullOrEmpty(substrs)) {
            return false;
        }
        for (String substr : substrs) {
            if (!StringUtil.startsWith(str, substr)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(String str, String suffix) {
        return StringUtil.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return StringUtil.endsWith(str, suffix, true);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null || suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return ignoreCase ? str.regionMatches(true, strOffset, suffix, 0, suffix.length()) : str.endsWith(suffix);
    }

    @SafeVarargs
    public static boolean endsWithAny(String str, String ... substrs) {
        if (str == null || N.isNullOrEmpty(substrs)) {
            return false;
        }
        for (String searchString : substrs) {
            if (!StringUtil.endsWith(str, searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(String a, String b) {
        return a == null ? b == null : (b == null ? false : a.length() == b.length() && a.equals(b));
    }

    @SafeVarargs
    public static boolean equalsAny(String str, String ... searchStrings) {
        if (N.isNullOrEmpty(searchStrings)) {
            return false;
        }
        for (String searchString : searchStrings) {
            if (!StringUtil.equals(str, searchString)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean equalsAnyIgnoreCase(String str, String ... searchStrings) {
        if (N.isNullOrEmpty(searchStrings)) {
            return false;
        }
        for (String searchString : searchStrings) {
            if (!StringUtil.equalsIgnoreCase(str, searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        return a == null ? b == null : (b == null ? false : a.equalsIgnoreCase(b));
    }

    public static int indexOfDifference(String a, String b) {
        int i;
        if (N.equals(a, b) || N.isNullOrEmpty(a) && N.isNullOrEmpty(b)) {
            return -1;
        }
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return 0;
        }
        int len = N.min(a.length(), b.length());
        for (i = 0; i < len && a.charAt(i) == b.charAt(i); ++i) {
        }
        if (i < b.length() || i < a.length()) {
            return i;
        }
        return -1;
    }

    @SafeVarargs
    public static int indexOfDifference(String ... strs) {
        if (N.isNullOrEmpty(strs) || strs.length == 1) {
            return -1;
        }
        int arrayLen = strs.length;
        int shortestStrLen = Integer.MAX_VALUE;
        int longestStrLen = 0;
        for (int i = 0; i < arrayLen; ++i) {
            if (strs[i] == null) {
                shortestStrLen = 0;
                continue;
            }
            shortestStrLen = Math.min(strs[i].length(), shortestStrLen);
            longestStrLen = Math.max(strs[i].length(), longestStrLen);
        }
        if (longestStrLen == 0) {
            return -1;
        }
        if (shortestStrLen == 0) {
            return 0;
        }
        int firstDiff = -1;
        for (int stringPos = 0; stringPos < shortestStrLen; ++stringPos) {
            char comparisonChar = strs[0].charAt(stringPos);
            for (int arrayPos = 1; arrayPos < arrayLen; ++arrayPos) {
                if (strs[arrayPos].charAt(stringPos) == comparisonChar) continue;
                firstDiff = stringPos;
                break;
            }
            if (firstDiff != -1) break;
        }
        if (firstDiff == -1 && shortestStrLen != longestStrLen) {
            return shortestStrLen;
        }
        return firstDiff;
    }

    public static String commonPrefix(String a, String b) {
        int p;
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return N.EMPTY_STRING;
        }
        int maxPrefixLength = Math.min(a.length(), b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (StringUtil.validSurrogatePairAt(a, p - 1) || StringUtil.validSurrogatePairAt(b, p - 1)) {
            --p;
        }
        if (p == a.length()) {
            return a.toString();
        }
        if (p == b.length()) {
            return b.toString();
        }
        return a.subSequence(0, p).toString();
    }

    @SafeVarargs
    public static String commonPrefix(String ... strs) {
        if (N.isNullOrEmpty(strs)) {
            return N.EMPTY_STRING;
        }
        if (strs.length == 1) {
            return N.isNullOrEmpty(strs[0]) ? N.EMPTY_STRING : strs[0];
        }
        String commonPrefix = StringUtil.commonPrefix(strs[0], strs[1]);
        if (N.isNullOrEmpty(commonPrefix)) {
            return N.EMPTY_STRING;
        }
        int len = strs.length;
        for (int i = 2; i < len; ++i) {
            if (!N.isNullOrEmpty(commonPrefix = StringUtil.commonPrefix(commonPrefix, strs[i]))) continue;
            return commonPrefix;
        }
        return commonPrefix;
    }

    public static String commonSuffix(String a, String b) {
        int s;
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return N.EMPTY_STRING;
        }
        int aLength = a.length();
        int bLength = b.length();
        int maxSuffixLength = Math.min(aLength, bLength);
        for (s = 0; s < maxSuffixLength && a.charAt(aLength - s - 1) == b.charAt(bLength - s - 1); ++s) {
        }
        if (StringUtil.validSurrogatePairAt(a, aLength - s - 1) || StringUtil.validSurrogatePairAt(b, bLength - s - 1)) {
            --s;
        }
        if (s == aLength) {
            return a.toString();
        }
        if (s == bLength) {
            return b.toString();
        }
        return a.subSequence(aLength - s, aLength).toString();
    }

    @SafeVarargs
    public static String commonSuffix(String ... strs) {
        if (N.isNullOrEmpty(strs)) {
            return N.EMPTY_STRING;
        }
        if (strs.length == 1) {
            return N.isNullOrEmpty(strs[0]) ? N.EMPTY_STRING : strs[0];
        }
        String commonSuffix = StringUtil.commonSuffix(strs[0], strs[1]);
        if (N.isNullOrEmpty(commonSuffix)) {
            return N.EMPTY_STRING;
        }
        int len = strs.length;
        for (int i = 2; i < len; ++i) {
            if (!N.isNullOrEmpty(commonSuffix = StringUtil.commonSuffix(commonSuffix, strs[i]))) continue;
            return commonSuffix;
        }
        return commonSuffix;
    }

    static boolean validSurrogatePairAt(String str, int index) {
        return index >= 0 && index <= str.length() - 2 && Character.isHighSurrogate(str.charAt(index)) && Character.isLowSurrogate(str.charAt(index + 1));
    }

    public static String longestCommonSubstring(String a, String b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return N.EMPTY_STRING;
        }
        int lenA = N.len(a);
        int lenB = N.len(b);
        int[] dp = new int[lenB + 1];
        int endIndex = 0;
        int maxLen = 0;
        if (lenA > 16 || lenB > 16) {
            char[] chsA = a.toCharArray();
            char[] chsB = b.toCharArray();
            for (int i = 1; i <= lenA; ++i) {
                for (int j = lenB; j > 0; --j) {
                    if (chsA[i - 1] == chsB[j - 1]) {
                        dp[j] = 1 + dp[j - 1];
                        if (dp[j] <= maxLen) continue;
                        maxLen = dp[j];
                        endIndex = i;
                        continue;
                    }
                    dp[j] = 0;
                }
            }
        } else {
            for (int i = 1; i <= lenA; ++i) {
                for (int j = lenB; j > 0; --j) {
                    if (a.charAt(i - 1) == b.charAt(j - 1)) {
                        dp[j] = 1 + dp[j - 1];
                        if (dp[j] <= maxLen) continue;
                        maxLen = dp[j];
                        endIndex = i;
                        continue;
                    }
                    dp[j] = 0;
                }
            }
        }
        if (maxLen == 0) {
            return N.EMPTY_STRING;
        }
        return a.substring(endIndex - maxLen, endIndex);
    }

    public static int countMatches(String str, char ch) {
        if (N.isNullOrEmpty(str)) {
            return 0;
        }
        int count = 0;
        char[] chs = InternalUtil.getCharsForReadOnly(str);
        int len = chs.length;
        for (int i = 0; i < len; ++i) {
            if (chs[i] != ch) continue;
            ++count;
        }
        return count;
    }

    public static int countMatches(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(substr, index)) != -1) {
            ++count;
            index += substr.length();
        }
        return count;
    }

    public static String substring(String str, int inclusiveBeginIndex, int exclusiveEndIndex) {
        if (str == null || inclusiveBeginIndex < 0 || exclusiveEndIndex < 0 || inclusiveBeginIndex > exclusiveEndIndex) {
            return null;
        }
        return str.substring(inclusiveBeginIndex, exclusiveEndIndex);
    }

    public static String substring(String str, int inclusiveBeginIndex) {
        if (str == null || inclusiveBeginIndex < 0) {
            return null;
        }
        return str.substring(inclusiveBeginIndex);
    }

    public static String substring(String str, char delimiterOfInclusiveBeginIndex) {
        if (str == null || str.length() == 0) {
            return null;
        }
        return StringUtil.substring(str, str.indexOf(delimiterOfInclusiveBeginIndex));
    }

    public static String substring(String str, String delimiterOfInclusiveBeginIndex) {
        if (str == null || delimiterOfInclusiveBeginIndex == null) {
            return null;
        }
        return StringUtil.substring(str, str.indexOf(delimiterOfInclusiveBeginIndex));
    }

    public static String substring(String str, int inclusiveBeginIndex, char delimiterOfExclusiveEndIndex) {
        if (str == null || str.length() == 0 || inclusiveBeginIndex < 0) {
            return null;
        }
        return StringUtil.substring(str, inclusiveBeginIndex, str.indexOf(delimiterOfExclusiveEndIndex, inclusiveBeginIndex + 1));
    }

    public static String substring(String str, int inclusiveBeginIndex, String delimiterOfExclusiveEndIndex) {
        if (str == null || inclusiveBeginIndex < 0 || delimiterOfExclusiveEndIndex == null) {
            return null;
        }
        if (delimiterOfExclusiveEndIndex.length() == 0) {
            return str.substring(inclusiveBeginIndex, inclusiveBeginIndex);
        }
        return StringUtil.substring(str, inclusiveBeginIndex, str.indexOf(delimiterOfExclusiveEndIndex, inclusiveBeginIndex + 1));
    }

    public static String substring(String str, int inclusiveBeginIndex, IntUnaryOperator funcOfExclusiveEndIndex) {
        if (str == null || inclusiveBeginIndex < 0) {
            return null;
        }
        return StringUtil.substring(str, inclusiveBeginIndex, funcOfExclusiveEndIndex.applyAsInt(inclusiveBeginIndex));
    }

    public static String substring(String str, char delimiterOfInclusiveBeginIndex, int exclusiveEndIndex) {
        if (str == null || str.length() == 0 || exclusiveEndIndex <= 0) {
            return null;
        }
        return StringUtil.substring(str, str.lastIndexOf(delimiterOfInclusiveBeginIndex, exclusiveEndIndex - 1), exclusiveEndIndex);
    }

    public static String substring(String str, String delimiterOfInclusiveBeginIndex, int exclusiveEndIndex) {
        if (str == null || delimiterOfInclusiveBeginIndex == null || exclusiveEndIndex < 0) {
            return null;
        }
        if (delimiterOfInclusiveBeginIndex.length() == 0) {
            return str.substring(exclusiveEndIndex, exclusiveEndIndex);
        }
        if (exclusiveEndIndex == 0) {
            return null;
        }
        return StringUtil.substring(str, str.lastIndexOf(delimiterOfInclusiveBeginIndex, exclusiveEndIndex - 1), exclusiveEndIndex);
    }

    public static String substring(String str, IntUnaryOperator funcOfInclusiveBeginIndex, int exclusiveEndIndex) {
        if (str == null || exclusiveEndIndex < 0) {
            return null;
        }
        return StringUtil.substring(str, funcOfInclusiveBeginIndex.applyAsInt(exclusiveEndIndex), exclusiveEndIndex);
    }

    public static String substringBetween(String str, int exclusiveBeginIndex, int exclusiveEndIndex) {
        if (str == null || str.length() == 0 || exclusiveBeginIndex < 0 || exclusiveEndIndex < 0 || exclusiveBeginIndex >= exclusiveEndIndex) {
            return null;
        }
        return str.substring(exclusiveBeginIndex + 1, exclusiveEndIndex);
    }

    public static String substringBetween(String str, int exclusiveBeginIndex, char delimiterOfExclusiveEndIndex) {
        if (str == null || str.length() == 0 || exclusiveBeginIndex < 0) {
            return null;
        }
        return StringUtil.substringBetween(str, exclusiveBeginIndex, str.indexOf(delimiterOfExclusiveEndIndex, exclusiveBeginIndex + 1));
    }

    public static String substringBetween(String str, int exclusiveBeginIndex, String delimiterOfExclusiveEndIndex) {
        if (str == null || str.length() == 0 || exclusiveBeginIndex < 0 || delimiterOfExclusiveEndIndex == null || delimiterOfExclusiveEndIndex.length() == 0) {
            return null;
        }
        return StringUtil.substringBetween(str, exclusiveBeginIndex, str.indexOf(delimiterOfExclusiveEndIndex, exclusiveBeginIndex + 1));
    }

    public static String substringBetween(String str, int exclusiveBeginIndex, IntUnaryOperator funcOfExclusiveEndIndex) {
        if (str == null || str.length() == 0 || exclusiveBeginIndex < 0) {
            return null;
        }
        return StringUtil.substringBetween(str, exclusiveBeginIndex, funcOfExclusiveEndIndex.applyAsInt(exclusiveBeginIndex));
    }

    public static String substringBetween(String str, char delimiterOfExclusiveBeginIndex, int exclusiveEndIndex) {
        if (str == null || str.length() == 0 || exclusiveEndIndex <= 0) {
            return null;
        }
        return StringUtil.substringBetween(str, str.lastIndexOf(delimiterOfExclusiveBeginIndex, exclusiveEndIndex - 1), exclusiveEndIndex);
    }

    public static String substringBetween(String str, String delimiterOfExclusiveBeginIndex, int exclusiveEndIndex) {
        if (str == null || str.length() == 0 || delimiterOfExclusiveBeginIndex == null || delimiterOfExclusiveBeginIndex.length() == 0 || exclusiveEndIndex <= 0) {
            return null;
        }
        int index = str.lastIndexOf(delimiterOfExclusiveBeginIndex, exclusiveEndIndex - 1);
        int exclusiveBeginIndex = index >= 0 ? index + delimiterOfExclusiveBeginIndex.length() - 1 : index;
        return StringUtil.substringBetween(str, exclusiveBeginIndex, exclusiveEndIndex);
    }

    public static String substringBetween(String str, IntUnaryOperator funcOfExclusiveBeginIndex, int exclusiveEndIndex) {
        if (str == null || str.length() == 0 || exclusiveEndIndex <= 0) {
            return null;
        }
        return StringUtil.substringBetween(str, funcOfExclusiveBeginIndex.applyAsInt(exclusiveEndIndex), exclusiveEndIndex);
    }

    public static String substringBetween(String str, char delimiterOfExclusiveBeginIndex, char delimiterOfExclusiveEndIndex) {
        if (str == null || str.length() == 0) {
            return null;
        }
        int start = str.indexOf(delimiterOfExclusiveBeginIndex);
        if (start < 0) {
            return null;
        }
        int end = str.indexOf(delimiterOfExclusiveEndIndex, start + 1);
        if (end < 0) {
            return null;
        }
        return StringUtil.substringBetween(str, start, end);
    }

    public static String substringBetween(String str, String delimiterOfExclusiveBeginIndex, String delimiterOfExclusiveEndIndex) {
        if (str == null || str.length() == 0 || delimiterOfExclusiveBeginIndex == null || delimiterOfExclusiveBeginIndex.length() == 0 || delimiterOfExclusiveEndIndex == null || delimiterOfExclusiveEndIndex.length() == 0) {
            return null;
        }
        int start = str.indexOf(delimiterOfExclusiveBeginIndex);
        if (start < 0) {
            return null;
        }
        int end = str.indexOf(delimiterOfExclusiveEndIndex, start + delimiterOfExclusiveBeginIndex.length());
        if (end < 0) {
            return null;
        }
        return StringUtil.substringBetween(str, start + delimiterOfExclusiveBeginIndex.length() - 1, end);
    }

    public static String substringAfter(String str, String delimiterOfExclusiveBeginIndex) {
        if (str == null || delimiterOfExclusiveBeginIndex == null) {
            return null;
        }
        int index = str.indexOf(delimiterOfExclusiveBeginIndex);
        if (index < 0) {
            return null;
        }
        return str.substring(index + delimiterOfExclusiveBeginIndex.length());
    }

    public static String substringAfterLast(String str, String delimiterOfExclusiveBeginIndex) {
        if (str == null || delimiterOfExclusiveBeginIndex == null) {
            return null;
        }
        int index = str.lastIndexOf(delimiterOfExclusiveBeginIndex);
        if (index < 0) {
            return null;
        }
        return str.substring(index + delimiterOfExclusiveBeginIndex.length());
    }

    public static String substringBefore(String str, String delimiterOfExclusiveEndIndex) {
        if (str == null || delimiterOfExclusiveEndIndex == null) {
            return null;
        }
        int index = str.indexOf(delimiterOfExclusiveEndIndex);
        if (index < 0) {
            return null;
        }
        return str.substring(0, index);
    }

    public static String substringBeforeLast(String str, String delimiterOfExclusiveEndIndex) {
        if (str == null || delimiterOfExclusiveEndIndex == null) {
            return null;
        }
        int index = str.lastIndexOf(delimiterOfExclusiveEndIndex);
        if (index < 0) {
            return null;
        }
        return str.substring(0, index);
    }

    public static u.OptionalChar firstChar(String str) {
        if (str == null || str.length() == 0) {
            return u.OptionalChar.empty();
        }
        return u.OptionalChar.of(str.charAt(0));
    }

    public static u.OptionalChar lastChar(String str) {
        if (str == null || str.length() == 0) {
            return u.OptionalChar.empty();
        }
        return u.OptionalChar.of(str.charAt(str.length() - 1));
    }

    public static String firstChars(String str, int n) {
        N.checkArgNotNegative(n, "n");
        if (str == null || str.length() == 0 || n == 0) {
            return N.EMPTY_STRING;
        }
        if (str.length() <= n) {
            return str;
        }
        return str.substring(0, n);
    }

    public static String lastChars(String str, int n) {
        N.checkArgNotNegative(n, "n");
        if (str == null || str.length() == 0 || n == 0) {
            return N.EMPTY_STRING;
        }
        if (str.length() <= n) {
            return str;
        }
        return str.substring(str.length() - n);
    }

    public static String join(boolean[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(boolean[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(boolean[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(boolean[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(boolean[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(char[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(char[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(char[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(char[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(char[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(byte[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(byte[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(byte[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(byte[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(byte[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(short[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(short[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(short[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(short[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(short[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(int[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(int[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(int[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(int[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(int[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(long[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(long[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(long[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(long[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(long[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(float[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(float[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(float[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(float[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(float[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(double[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(double[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(double[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(double[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(double[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Object[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(Object[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(Object[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(Object[] a, int fromIndex, int toIndex, char delimiter) {
        return StringUtil.join(a, fromIndex, toIndex, delimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Object[] a, int fromIndex, int toIndex, char delimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return trim ? N.toString(a[fromIndex]).trim() : N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(trim ? N.toString(a[i]).trim() : N.toString(a[i]));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Object[] a, int fromIndex, int toIndex, String delimiter) {
        return StringUtil.join(a, fromIndex, toIndex, delimiter, false);
    }

    public static String join(Object[] a, int fromIndex, int toIndex, String delimiter, boolean trim) {
        return StringUtil.join(a, fromIndex, toIndex, delimiter, null, null, trim);
    }

    public static String join(Object[] a, String delimiter, String prefix, String suffix) {
        return StringUtil.join(a, 0, N.len(a), delimiter, prefix, suffix, false);
    }

    public static String join(Object[] a, String delimiter, String prefix, String suffix, boolean trim) {
        return StringUtil.join(a, 0, N.len(a), delimiter, prefix, suffix, trim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Object[] a, int fromIndex, int toIndex, String delimiter, String prefix, String suffix, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            if (N.isNullOrEmpty(prefix) && N.isNullOrEmpty(suffix)) {
                return N.EMPTY_STRING;
            }
            if (N.isNullOrEmpty(prefix)) {
                return suffix;
            }
            return prefix;
        }
        if (toIndex - fromIndex == 1 && N.isNullOrEmpty(prefix) && N.isNullOrEmpty(suffix)) {
            return trim ? N.toString(a[fromIndex]).trim() : N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.notNullOrEmpty(prefix)) {
                sb.append(prefix);
            }
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(trim ? N.toString(a[i]).trim() : N.toString(a[i]));
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(trim ? N.toString(a[i]).trim() : N.toString(a[i]));
                }
            }
            if (N.notNullOrEmpty(suffix)) {
                sb.append(suffix);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Collection<?> c) {
        return StringUtil.join(c, N.ELEMENT_SEPARATOR);
    }

    public static String join(Collection<?> c, char delimiter) {
        if (N.isNullOrEmpty(c)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(c, 0, c.size(), delimiter);
    }

    public static String join(Collection<?> c, String delimiter) {
        if (N.isNullOrEmpty(c)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(c, 0, c.size(), delimiter);
    }

    public static String join(Collection<?> c, int fromIndex, int toIndex, char delimiter) {
        return StringUtil.join(c, fromIndex, toIndex, delimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Collection<?> c, int fromIndex, int toIndex, char delimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i = 0;
            for (Object e : c) {
                if (i++ > fromIndex) {
                    sb.append(delimiter);
                }
                if (i > fromIndex) {
                    sb.append(trim ? N.toString(e).trim() : N.toString(e));
                }
                if (i < toIndex) continue;
                break;
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Collection<?> c, int fromIndex, int toIndex, String delimiter) {
        return StringUtil.join(c, fromIndex, toIndex, delimiter, false);
    }

    public static String join(Collection<?> c, int fromIndex, int toIndex, String delimiter, boolean trim) {
        return StringUtil.join(c, fromIndex, toIndex, delimiter, null, null, trim);
    }

    public static String join(Collection<?> c, String delimiter, String prefix, String suffix) {
        return StringUtil.join(c, 0, N.size(c), delimiter, prefix, suffix, false);
    }

    public static String join(Collection<?> c, String delimiter, String prefix, String suffix, boolean trim) {
        return StringUtil.join(c, 0, N.size(c), delimiter, prefix, suffix, trim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Collection<?> c, int fromIndex, int toIndex, String delimiter, String prefix, String suffix, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) || fromIndex == toIndex) {
            if (N.isNullOrEmpty(prefix) && N.isNullOrEmpty(suffix)) {
                return N.EMPTY_STRING;
            }
            if (N.isNullOrEmpty(prefix)) {
                return suffix;
            }
            return prefix;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            if (N.notNullOrEmpty(prefix)) {
                sb.append(prefix);
            }
            if (c instanceof List && c instanceof RandomAccess) {
                List list = (List)c;
                if (N.isNullOrEmpty(delimiter)) {
                    for (int i = fromIndex; i < toIndex; ++i) {
                        sb.append(trim ? N.toString(list.get(i)).trim() : N.toString(list.get(i)));
                    }
                } else {
                    for (int i = fromIndex; i < toIndex; ++i) {
                        if (i > fromIndex) {
                            sb.append(delimiter);
                        }
                        sb.append(trim ? N.toString(list.get(i)).trim() : N.toString(list.get(i)));
                    }
                }
            } else {
                int i = 0;
                if (N.isNullOrEmpty(delimiter)) {
                    for (Object e : c) {
                        if (i++ >= fromIndex) {
                            sb.append(trim ? N.toString(e).trim() : N.toString(e));
                        }
                        if (i < toIndex) continue;
                        break;
                    }
                } else {
                    for (Object e : c) {
                        if (i++ > fromIndex) {
                            sb.append(delimiter);
                        }
                        if (i > fromIndex) {
                            sb.append(trim ? N.toString(e).trim() : N.toString(e));
                        }
                        if (i < toIndex) continue;
                        break;
                    }
                }
            }
            if (N.notNullOrEmpty(suffix)) {
                sb.append(suffix);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Iterator<?> iter) {
        return StringUtil.join(iter, N.ELEMENT_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Iterator<?> iter, char delimiter) {
        if (iter == null) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            if (iter.hasNext()) {
                sb.append(N.toString(iter.next()));
            }
            while (iter.hasNext()) {
                sb.append(delimiter);
                sb.append(N.toString(iter.next()));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Iterator<?> iter, String delimiter) {
        return StringUtil.join(iter, delimiter, EMPTY, EMPTY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Iterator<?> iter, String delimiter, String prefix, String suffix, boolean trim) {
        if (iter == null) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            if (N.notNullOrEmpty(prefix)) {
                sb.append(prefix);
            }
            if (N.isNullOrEmpty(delimiter)) {
                while (iter.hasNext()) {
                    if (trim) {
                        sb.append(N.toString(iter.next()).trim());
                        continue;
                    }
                    sb.append(N.toString(iter.next()));
                }
            } else {
                if (iter.hasNext()) {
                    sb.append(N.toString(iter.next()));
                }
                while (iter.hasNext()) {
                    sb.append(delimiter);
                    if (trim) {
                        sb.append(N.toString(iter.next()).trim());
                        continue;
                    }
                    sb.append(N.toString(iter.next()));
                }
            }
            if (N.notNullOrEmpty(suffix)) {
                sb.append(suffix);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String joinEntries(Map<?, ?> m) {
        return StringUtil.joinEntries(m, N.ELEMENT_SEPARATOR);
    }

    public static String joinEntries(Map<?, ?> m, char entryDelimiter) {
        if (N.isNullOrEmpty(m)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.joinEntries(m, 0, m.size(), entryDelimiter);
    }

    public static String joinEntries(Map<?, ?> m, String entryDelimiter) {
        if (N.isNullOrEmpty(m)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.joinEntries(m, 0, m.size(), entryDelimiter);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, char entryDelimiter) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, false);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, char entryDelimiter, boolean trim) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, '=', trim);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, String entryDelimiter) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, false);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, String entryDelimiter, boolean trim) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, "=", null, null, trim);
    }

    public static String joinEntries(Map<?, ?> m, char entryDelimiter, char keyValueDelimiter) {
        if (N.isNullOrEmpty(m)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.joinEntries(m, 0, m.size(), entryDelimiter, keyValueDelimiter);
    }

    public static String joinEntries(Map<?, ?> m, String entryDelimiter, String keyValueDelimiter) {
        if (N.isNullOrEmpty(m)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.joinEntries(m, 0, m.size(), entryDelimiter, keyValueDelimiter);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, char entryDelimiter, char keyValueDelimiter) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, keyValueDelimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, char entryDelimiter, char keyValueDelimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(m));
        if (N.isNullOrEmpty(m) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i = 0;
            for (Map.Entry<?, ?> entry : m.entrySet()) {
                if (i++ > fromIndex) {
                    sb.append(entryDelimiter);
                }
                if (i > fromIndex) {
                    sb.append(trim ? N.toString(entry.getKey()).trim() : N.toString(entry.getKey()));
                    sb.append(keyValueDelimiter);
                    sb.append(trim ? N.toString(entry.getValue()).trim() : N.toString(entry.getValue()));
                }
                if (i < toIndex) continue;
                break;
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, String entryDelimiter, String keyValueDelimiter) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, keyValueDelimiter, null, null, false);
    }

    public static String joinEntries(Map<?, ?> m, String entryDelimiter, String keyValueDelimiter, String prefix, String suffix) {
        return StringUtil.joinEntries(m, 0, N.size(m), entryDelimiter, keyValueDelimiter, prefix, suffix, false);
    }

    public static String joinEntries(Map<?, ?> m, String entryDelimiter, String keyValueDelimiter, String prefix, String suffix, boolean trim) {
        return StringUtil.joinEntries(m, 0, N.size(m), entryDelimiter, keyValueDelimiter, prefix, suffix, trim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, String entryDelimiter, String keyValueDelimiter, String prefix, String suffix, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(m));
        if (N.isNullOrEmpty(m) || fromIndex == toIndex) {
            if (N.isNullOrEmpty(prefix) && N.isNullOrEmpty(suffix)) {
                return N.EMPTY_STRING;
            }
            if (N.isNullOrEmpty(prefix)) {
                return suffix;
            }
            return prefix;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            if (N.notNullOrEmpty(prefix)) {
                sb.append(prefix);
            }
            int i = 0;
            for (Map.Entry<?, ?> entry : m.entrySet()) {
                if (i++ > fromIndex) {
                    sb.append(entryDelimiter);
                }
                if (i > fromIndex) {
                    sb.append(trim ? N.toString(entry.getKey()).trim() : N.toString(entry.getKey()));
                    sb.append(keyValueDelimiter);
                    sb.append(trim ? N.toString(entry.getValue()).trim() : N.toString(entry.getValue()));
                }
                if (i < toIndex) continue;
                break;
            }
            if (N.notNullOrEmpty(suffix)) {
                sb.append(suffix);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e, String f) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).append(f).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e, String f, String g) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).append(f).append(g).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e, String f, String g, String h) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).append(f).append(g).append(h).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e, String f, String g, String h, String i) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).append(f).append(g).append(h).append(i).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static String concat(String ... a) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        if (a.length == 1) {
            return N.toString(a[0]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (String e : a) {
                sb.append(e);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String concat(Object a, Object b) {
        return StringUtil.concat(N.toString(a), N.toString(b));
    }

    public static String concat(Object a, Object b, Object c) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c));
    }

    public static String concat(Object a, Object b, Object c, Object d) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e, Object f) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e), N.toString(f));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e, Object f, Object g) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e), N.toString(f), N.toString(g));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e, Object f, Object g, Object h) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e), N.toString(f), N.toString(g), N.toString(h));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e, Object f, Object g, Object h, Object i) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e), N.toString(f), N.toString(g), N.toString(h), N.toString(i));
    }

    public static String lenientFormat(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = StringUtil.lenientToString(args[i]);
            }
        }
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            sb.append(template, templateStart, placeholderStart);
            sb.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        sb.append(template, templateStart, template.length());
        if (i < args.length) {
            sb.append(" [");
            sb.append(args[i++]);
            while (i < args.length) {
                sb.append(", ");
                sb.append(args[i++]);
            }
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    private static String lenientToString(Object obj) {
        try {
            return String.valueOf(obj);
        }
        catch (Exception e) {
            String objectToString = obj.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(obj));
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + objectToString, e);
            return "<" + objectToString + " threw " + e.getClass().getName() + ">";
        }
    }

    public static String reverse(String str) {
        if (N.len(str) <= 1) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(str);
            String string = sb.reverse().toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String reverseDelimited(String str, char delimiter) {
        if (N.len(str) <= 1) {
            return str;
        }
        Object[] strs = StringUtil.split(str, delimiter);
        N.reverse(strs);
        return StringUtil.join(strs, delimiter);
    }

    public static String reverseDelimited(String str, String delimiter) {
        if (N.len(str) <= 1) {
            return str;
        }
        Object[] strs = StringUtil.split(str, delimiter);
        N.reverse(strs);
        return Joiner.with(delimiter).reuseCachedBuffer().appendAll(strs).toString();
    }

    public static String sort(String str) {
        if (N.len(str) <= 1) {
            return str;
        }
        char[] chs = str.toCharArray();
        N.sort(chs);
        return InternalUtil.newString(chs, true);
    }

    public static String rotate(String str, int shift) {
        int strLen = N.len(str);
        if (strLen <= 1 || shift == 0 || shift % strLen == 0) {
            return str;
        }
        int offset = -(shift % strLen);
        if (offset < 0) {
            offset = str.length() + offset;
        }
        if (offset < 0) {
            offset = 0;
        }
        return StringUtil.substring(str, offset) + StringUtil.substring(str, 0, offset);
    }

    public static String shuffle(String str) {
        return StringUtil.shuffle(str, N.RAND);
    }

    public static String shuffle(String str, Random rnd) {
        int strLen = N.len(str);
        if (strLen <= 1) {
            return str;
        }
        char[] chars = str.toCharArray();
        N.shuffle(chars, rnd);
        return String.valueOf(chars);
    }

    public static String overlay(String str, String overlay, int start, int end) {
        N.checkFromToIndex(start, end, N.len(str));
        if (overlay == null) {
            overlay = N.EMPTY_STRING;
        }
        if (N.isNullOrEmpty(str)) {
            return overlay;
        }
        return str.substring(0, start) + overlay + str.substring(end);
    }

    static {
        List<String> delimiters = Array.asList(SPACE, "  ", "   ", "\t", LF, CR, ",", ", ", ";", "; ", ":", ": ", " : ", "-", " - ", "_", " _ ", "#", "##", " # ", "=", "==", " = ", "|", " | ", "||", " || ", "&", "&&", "@", "@@", "$", "$$", "*", "**", "+", "++");
        for (String delimiter : delimiters) {
            splitterPool.put(delimiter, Splitter.with(delimiter).omitEmptyStrings());
            trimSplitterPool.put(delimiter, Splitter.with(delimiter).omitEmptyStrings().trimResults());
            preserveSplitterPool.put(delimiter, Splitter.with(delimiter));
            trimPreserveSplitterPool.put(delimiter, Splitter.with(delimiter).trimResults());
            if (delimiter.length() != 1) continue;
            char delimiterChar = delimiter.charAt(0);
            splitterPool.put(Character.valueOf(delimiterChar), Splitter.with(delimiterChar).omitEmptyStrings());
            trimSplitterPool.put(Character.valueOf(delimiterChar), Splitter.with(delimiterChar).omitEmptyStrings().trimResults());
            preserveSplitterPool.put(Character.valueOf(delimiterChar), Splitter.with(delimiterChar));
            trimPreserveSplitterPool.put(Character.valueOf(delimiterChar), Splitter.with(delimiterChar).trimResults());
        }
        pattern_accent = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    }

    public static final class MoreStringUtil {
        private MoreStringUtil() {
        }

        public static u.Optional<String> substring(String str, int inclusiveBeginIndex, int exclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, inclusiveBeginIndex, exclusiveEndIndex));
        }

        public static u.Optional<String> substring(String str, int inclusiveBeginIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, inclusiveBeginIndex));
        }

        public static u.Optional<String> substring(String str, char delimiterOfInclusiveBeginIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, delimiterOfInclusiveBeginIndex));
        }

        public static u.Optional<String> substring(String str, String delimiterOfInclusiveBeginIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, delimiterOfInclusiveBeginIndex));
        }

        public static u.Optional<String> substring(String str, int inclusiveBeginIndex, char delimiterOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, inclusiveBeginIndex, delimiterOfExclusiveEndIndex));
        }

        public static u.Optional<String> substring(String str, int inclusiveBeginIndex, String delimiterOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, inclusiveBeginIndex, delimiterOfExclusiveEndIndex));
        }

        public static u.Optional<String> substring(String str, int inclusiveBeginIndex, IntUnaryOperator funcOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, inclusiveBeginIndex, funcOfExclusiveEndIndex));
        }

        public static u.Optional<String> substring(String str, char delimiterOfInclusiveBeginIndex, int exclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, delimiterOfInclusiveBeginIndex, exclusiveEndIndex));
        }

        public static u.Optional<String> substring(String str, String delimiterOfInclusiveBeginIndex, int exclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, delimiterOfInclusiveBeginIndex, exclusiveEndIndex));
        }

        public static u.Optional<String> substring(String str, IntUnaryOperator funcOfInclusiveBeginIndex, int exclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substring(str, funcOfInclusiveBeginIndex, exclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, int exclusiveBeginIndex, int exclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, exclusiveBeginIndex, exclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, int exclusiveBeginIndex, char delimiterOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, exclusiveBeginIndex, delimiterOfExclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, int exclusiveBeginIndex, String delimiterOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, exclusiveBeginIndex, delimiterOfExclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, int exclusiveBeginIndex, IntUnaryOperator funcOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, exclusiveBeginIndex, funcOfExclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, char delimiterOfExclusiveBeginIndex, int exclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, delimiterOfExclusiveBeginIndex, exclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, String delimiterOfExclusiveBeginIndex, int exclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, delimiterOfExclusiveBeginIndex, exclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, IntUnaryOperator funcOfExclusiveBeginIndex, int exclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, funcOfExclusiveBeginIndex, exclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, char delimiterOfExclusiveBeginIndex, char delimiterOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, delimiterOfExclusiveBeginIndex, delimiterOfExclusiveEndIndex));
        }

        public static u.Optional<String> substringBetween(String str, String delimiterOfExclusiveBeginIndex, String delimiterOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBetween(str, delimiterOfExclusiveBeginIndex, delimiterOfExclusiveEndIndex));
        }

        public static u.Optional<String> substringAfter(String str, String delimiterOfExclusiveBeginIndex) {
            return u.Optional.ofNullable(StringUtil.substringAfter(str, delimiterOfExclusiveBeginIndex));
        }

        public static u.Optional<String> substringAfterLast(String str, String delimiterOfExclusiveBeginIndex) {
            return u.Optional.ofNullable(StringUtil.substringAfterLast(str, delimiterOfExclusiveBeginIndex));
        }

        public static u.Optional<String> substringBefore(String str, String delimiterOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBefore(str, delimiterOfExclusiveEndIndex));
        }

        public static u.Optional<String> substringBeforeLast(String str, String delimiterOfExclusiveEndIndex) {
            return u.Optional.ofNullable(StringUtil.substringBeforeLast(str, delimiterOfExclusiveEndIndex));
        }

        @Beta
        public static String[] copyThenTrim(String[] strs) {
            return N.copyThenApply(strs, Fn.trim());
        }

        @Beta
        public static String[] copyThenStrip(String[] strs) {
            return N.copyThenApply(strs, Fn.strip());
        }
    }

    public static final class Strings
    extends StringUtil {
        private Strings() {
        }
    }
}

