/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;

public final class Throwables {
    private Throwables() {
    }

    public static void run(Runnable<? extends Throwable> cmd) {
        try {
            cmd.run();
        }
        catch (Throwable e) {
            throw N.toRuntimeException(e);
        }
    }

    public static void run(Runnable<? extends Throwable> cmd, com.landawn.abacus.util.function.Consumer<? super Throwable> actionOnError) {
        N.checkArgNotNull(actionOnError);
        try {
            cmd.run();
        }
        catch (Throwable e) {
            actionOnError.accept(e);
        }
    }

    public static <R> R call(Callable<R, ? extends Throwable> cmd) {
        try {
            return cmd.call();
        }
        catch (Throwable e) {
            throw N.toRuntimeException(e);
        }
    }

    public static <R> R call(Callable<R, ? extends Throwable> cmd, com.landawn.abacus.util.function.Function<? super Throwable, R> actionOnError) {
        N.checkArgNotNull(actionOnError);
        try {
            return cmd.call();
        }
        catch (Throwable e) {
            return actionOnError.apply(e);
        }
    }

    public static <R> R call(Callable<R, ? extends Throwable> cmd, com.landawn.abacus.util.function.Supplier<R> supplier) {
        N.checkArgNotNull(supplier);
        try {
            return cmd.call();
        }
        catch (Throwable e) {
            return supplier.get();
        }
    }

    public static <R> R call(Callable<R, ? extends Throwable> cmd, R defaultValue) {
        try {
            return cmd.call();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static <R> R call(Callable<R, ? extends Throwable> cmd, com.landawn.abacus.util.function.Predicate<? super Throwable> predicate, com.landawn.abacus.util.function.Supplier<R> supplier) {
        N.checkArgNotNull(predicate);
        N.checkArgNotNull(supplier);
        try {
            return cmd.call();
        }
        catch (Throwable e) {
            if (predicate.test(e)) {
                return supplier.get();
            }
            throw N.toRuntimeException(e);
        }
    }

    public static <R> R call(Callable<R, ? extends Throwable> cmd, com.landawn.abacus.util.function.Predicate<? super Throwable> predicate, R defaultValue) {
        N.checkArgNotNull(predicate);
        try {
            return cmd.call();
        }
        catch (Throwable e) {
            if (predicate.test(e)) {
                return defaultValue;
            }
            throw N.toRuntimeException(e);
        }
    }

    public static final class LazyInitializer<T, E extends Throwable>
    implements Supplier<T, E> {
        private volatile boolean initialized = false;
        private volatile T value = null;
        private final Supplier<T, E> supplier;

        LazyInitializer(Supplier<T, E> supplier) {
            N.checkArgNotNull(supplier, "supplier");
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T get() throws E {
            if (!this.initialized) {
                LazyInitializer lazyInitializer = this;
                synchronized (lazyInitializer) {
                    if (!this.initialized) {
                        this.value = this.supplier.get();
                        this.initialized = true;
                    }
                }
            }
            return this.value;
        }

        public static <T, E extends Throwable> LazyInitializer<T, E> of(Supplier<T, E> supplier) {
            N.checkArgNotNull(supplier);
            if (supplier instanceof LazyInitializer) {
                return (LazyInitializer)supplier;
            }
            return new LazyInitializer<T, E>(supplier);
        }
    }

    public static final class EEE {
        private EEE() {
        }

        public static interface TriConsumer<A, B, C, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public void accept(A var1, B var2, C var3) throws E, E2, E3;
        }

        public static interface BiConsumer<T, U, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public void accept(T var1, U var2) throws E, E2, E3;
        }

        public static interface Consumer<T, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public void accept(T var1) throws E, E2, E3;
        }

        public static interface TriFunction<A, B, C, R, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public R apply(A var1, B var2, C var3) throws E, E2, E3;
        }

        public static interface BiFunction<T, U, R, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public R apply(T var1, U var2) throws E, E2, E3;
        }

        public static interface Function<T, R, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public R apply(T var1) throws E, E2, E3;
        }

        public static interface TriPredicate<A, B, C, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public boolean test(A var1, B var2, C var3) throws E, E2, E3;
        }

        public static interface BiPredicate<T, U, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public boolean test(T var1, U var2) throws E, E2, E3;
        }

        public static interface Predicate<T, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public boolean test(T var1) throws E, E2, E3;
        }

        public static interface Supplier<T, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public T get() throws E, E2, E3;
        }

        public static interface Callable<R, E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public R call() throws E, E2, E3;
        }

        public static interface Runnable<E extends Throwable, E2 extends Throwable, E3 extends Throwable> {
            public void run() throws E, E2, E3;
        }
    }

    public static final class EE {
        private EE() {
        }

        public static interface TriConsumer<A, B, C, E extends Throwable, E2 extends Throwable> {
            public void accept(A var1, B var2, C var3) throws E, E2;
        }

        public static interface BiConsumer<T, U, E extends Throwable, E2 extends Throwable> {
            public void accept(T var1, U var2) throws E, E2;
        }

        public static interface Consumer<T, E extends Throwable, E2 extends Throwable> {
            public void accept(T var1) throws E, E2;
        }

        public static interface TriFunction<A, B, C, R, E extends Throwable, E2 extends Throwable> {
            public R apply(A var1, B var2, C var3) throws E, E2;
        }

        public static interface BiFunction<T, U, R, E extends Throwable, E2 extends Throwable> {
            public R apply(T var1, U var2) throws E, E2;
        }

        public static interface Function<T, R, E extends Throwable, E2 extends Throwable> {
            public R apply(T var1) throws E, E2;
        }

        public static interface TriPredicate<A, B, C, E extends Throwable, E2 extends Throwable> {
            public boolean test(A var1, B var2, C var3) throws E, E2;
        }

        public static interface BiPredicate<T, U, E extends Throwable, E2 extends Throwable> {
            public boolean test(T var1, U var2) throws E, E2;
        }

        public static interface Predicate<T, E extends Throwable, E2 extends Throwable> {
            public boolean test(T var1) throws E, E2;
        }

        public static interface Supplier<T, E extends Throwable, E2 extends Throwable> {
            public T get() throws E, E2;
        }

        public static interface Callable<R, E extends Throwable, E2 extends Throwable> {
            public R call() throws E, E2;
        }

        public static interface Runnable<E extends Throwable, E2 extends Throwable> {
            public void run() throws E, E2;
        }
    }

    public static interface BiIntObjConsumer<T, E extends Throwable> {
        public void accept(int var1, int var2, T var3) throws E;
    }

    public static interface IntObjConsumer<T, E extends Throwable> {
        public void accept(int var1, T var2) throws E;
    }

    public static interface ObjDoubleConsumer<T, E extends Throwable> {
        public void accept(T var1, double var2) throws E;
    }

    public static interface ObjFloatConsumer<T, E extends Throwable> {
        public void accept(T var1, float var2) throws E;
    }

    public static interface ObjLongConsumer<T, E extends Throwable> {
        public void accept(T var1, long var2) throws E;
    }

    public static interface ObjIntConsumer<T, E extends Throwable> {
        public void accept(T var1, int var2) throws E;
    }

    public static interface ObjShortConsumer<T, E extends Throwable> {
        public void accept(T var1, short var2) throws E;
    }

    public static interface ObjByteConsumer<T, E extends Throwable> {
        public void accept(T var1, byte var2) throws E;
    }

    public static interface ObjCharConsumer<T, E extends Throwable> {
        public void accept(T var1, char var2) throws E;
    }

    public static interface ObjBooleanConsumer<T, E extends Throwable> {
        public void accept(T var1, boolean var2) throws E;
    }

    public static interface DoubleTriConsumer<E extends Throwable> {
        public void accept(double var1, double var3, double var5) throws E;
    }

    public static interface FloatTriConsumer<E extends Throwable> {
        public void accept(float var1, float var2, float var3) throws E;
    }

    public static interface LongTriConsumer<E extends Throwable> {
        public void accept(long var1, long var3, long var5) throws E;
    }

    public static interface IntTriConsumer<E extends Throwable> {
        public void accept(int var1, int var2, int var3) throws E;
    }

    public static interface ShortTriConsumer<E extends Throwable> {
        public void accept(short var1, short var2, short var3) throws E;
    }

    public static interface ByteTriConsumer<E extends Throwable> {
        public void accept(byte var1, byte var2, byte var3) throws E;
    }

    public static interface CharTriConsumer<E extends Throwable> {
        public void accept(char var1, char var2, char var3) throws E;
    }

    public static interface BooleanTriConsumer<E extends Throwable> {
        public void accept(boolean var1, boolean var2, boolean var3) throws E;
    }

    public static interface DoubleTriFunction<R, E extends Throwable> {
        public R apply(double var1, double var3, double var5) throws E;
    }

    public static interface FloatTriFunction<R, E extends Throwable> {
        public R apply(float var1, float var2, float var3) throws E;
    }

    public static interface LongTriFunction<R, E extends Throwable> {
        public R apply(long var1, long var3, long var5) throws E;
    }

    public static interface IntTriFunction<R, E extends Throwable> {
        public R apply(int var1, int var2, int var3) throws E;
    }

    public static interface ShortTriFunction<R, E extends Throwable> {
        public R apply(short var1, short var2, short var3) throws E;
    }

    public static interface ByteTriFunction<R, E extends Throwable> {
        public R apply(byte var1, byte var2, byte var3) throws E;
    }

    public static interface CharTriFunction<R, E extends Throwable> {
        public R apply(char var1, char var2, char var3) throws E;
    }

    public static interface BooleanTriFunction<R, E extends Throwable> {
        public R apply(boolean var1, boolean var2, boolean var3) throws E;
    }

    public static interface DoubleTriPredicate<E extends Throwable> {
        public boolean test(double var1, double var3, double var5) throws E;
    }

    public static interface FloatTriPredicate<E extends Throwable> {
        public boolean test(float var1, float var2, float var3) throws E;
    }

    public static interface LongTriPredicate<E extends Throwable> {
        public boolean test(long var1, long var3, long var5) throws E;
    }

    public static interface IntTriPredicate<E extends Throwable> {
        public boolean test(int var1, int var2, int var3) throws E;
    }

    public static interface ShortTriPredicate<E extends Throwable> {
        public boolean test(short var1, short var2, short var3) throws E;
    }

    public static interface ByteTriPredicate<E extends Throwable> {
        public boolean test(byte var1, byte var2, byte var3) throws E;
    }

    public static interface CharTriPredicate<E extends Throwable> {
        public boolean test(char var1, char var2, char var3) throws E;
    }

    public static interface BooleanTriPredicate<E extends Throwable> {
        public boolean test(boolean var1, boolean var2, boolean var3) throws E;
    }

    public static interface DoubleBiConsumer<E extends Throwable> {
        public void accept(double var1, double var3) throws E;
    }

    public static interface FloatBiConsumer<E extends Throwable> {
        public void accept(float var1, float var2) throws E;
    }

    public static interface LongBiConsumer<E extends Throwable> {
        public void accept(long var1, long var3) throws E;
    }

    public static interface IntBiConsumer<E extends Throwable> {
        public void accept(int var1, int var2) throws E;
    }

    public static interface ShortBiConsumer<E extends Throwable> {
        public void accept(short var1, short var2) throws E;
    }

    public static interface ByteBiConsumer<E extends Throwable> {
        public void accept(byte var1, byte var2) throws E;
    }

    public static interface CharBiConsumer<E extends Throwable> {
        public void accept(char var1, char var2) throws E;
    }

    public static interface BooleanBiConsumer<E extends Throwable> {
        public void accept(boolean var1, boolean var2) throws E;
    }

    public static interface DoubleBiFunction<R, E extends Throwable> {
        public R apply(double var1, double var3) throws E;
    }

    public static interface FloatBiFunction<R, E extends Throwable> {
        public R apply(float var1, float var2) throws E;
    }

    public static interface LongBiFunction<R, E extends Throwable> {
        public R apply(long var1, long var3) throws E;
    }

    public static interface IntBiFunction<R, E extends Throwable> {
        public R apply(int var1, int var2) throws E;
    }

    public static interface ShortBiFunction<R, E extends Throwable> {
        public R apply(short var1, short var2) throws E;
    }

    public static interface ByteBiFunction<R, E extends Throwable> {
        public R apply(byte var1, byte var2) throws E;
    }

    public static interface CharBiFunction<R, E extends Throwable> {
        public R apply(char var1, char var2) throws E;
    }

    public static interface BooleanBiFunction<R, E extends Throwable> {
        public R apply(boolean var1, boolean var2) throws E;
    }

    public static interface DoubleBiPredicate<E extends Throwable> {
        public boolean test(double var1, double var3) throws E;
    }

    public static interface FloatBiPredicate<E extends Throwable> {
        public boolean test(float var1, float var2) throws E;
    }

    public static interface LongBiPredicate<E extends Throwable> {
        public boolean test(long var1, long var3) throws E;
    }

    public static interface IntBiPredicate<E extends Throwable> {
        public boolean test(int var1, int var2) throws E;
    }

    public static interface ShortBiPredicate<E extends Throwable> {
        public boolean test(short var1, short var2) throws E;
    }

    public static interface ByteBiPredicate<E extends Throwable> {
        public boolean test(byte var1, byte var2) throws E;
    }

    public static interface CharBiPredicate<E extends Throwable> {
        public boolean test(char var1, char var2) throws E;
    }

    public static interface BooleanBiPredicate<E extends Throwable> {
        public boolean test(boolean var1, boolean var2) throws E;
    }

    public static interface DoubleTernaryOperator<E extends Throwable> {
        public double applyAsDouble(double var1, double var3, double var5) throws E;
    }

    public static interface FloatTernaryOperator<E extends Throwable> {
        public float applyAsFloat(float var1, float var2, float var3) throws E;
    }

    public static interface LongTernaryOperator<E extends Throwable> {
        public long applyAsLong(long var1, long var3, long var5) throws E;
    }

    public static interface IntTernaryOperator<E extends Throwable> {
        public int applyAsInt(int var1, int var2, int var3) throws E;
    }

    public static interface ShortTernaryOperator<E extends Throwable> {
        public short applyAsShort(short var1, short var2, short var3) throws E;
    }

    public static interface ByteTernaryOperator<E extends Throwable> {
        public byte applyAsByte(byte var1, byte var2, byte var3) throws E;
    }

    public static interface CharTernaryOperator<E extends Throwable> {
        public char applyAsChar(char var1, char var2, char var3) throws E;
    }

    public static interface BooleanTernaryOperator<E extends Throwable> {
        public boolean applyAsBoolean(boolean var1, boolean var2, boolean var3) throws E;
    }

    public static interface DoubleBinaryOperator<E extends Throwable> {
        public double applyAsDouble(double var1, double var3) throws E;
    }

    public static interface FloatBinaryOperator<E extends Throwable> {
        public float applyAsFloat(float var1, float var2) throws E;
    }

    public static interface LongBinaryOperator<E extends Throwable> {
        public long applyAsLong(long var1, long var3) throws E;
    }

    public static interface IntBinaryOperator<E extends Throwable> {
        public int applyAsInt(int var1, int var2) throws E;
    }

    public static interface ShortBinaryOperator<E extends Throwable> {
        public short applyAsShort(short var1, short var2) throws E;
    }

    public static interface ByteBinaryOperator<E extends Throwable> {
        public byte applyAsByte(byte var1, byte var2) throws E;
    }

    public static interface CharBinaryOperator<E extends Throwable> {
        public char applyAsChar(char var1, char var2) throws E;
    }

    public static interface BooleanBinaryOperator<E extends Throwable> {
        public boolean applyAsBoolean(boolean var1, boolean var2) throws E;
    }

    public static interface DoubleUnaryOperator<E extends Throwable> {
        public double applyAsDouble(double var1) throws E;
    }

    public static interface FloatUnaryOperator<E extends Throwable> {
        public float applyAsFloat(float var1) throws E;
    }

    public static interface LongUnaryOperator<E extends Throwable> {
        public long applyAsLong(long var1) throws E;
    }

    public static interface IntUnaryOperator<E extends Throwable> {
        public int applyAsInt(int var1) throws E;
    }

    public static interface ShortUnaryOperator<E extends Throwable> {
        public short applyAsShort(short var1) throws E;
    }

    public static interface ByteUnaryOperator<E extends Throwable> {
        public byte applyAsByte(byte var1) throws E;
    }

    public static interface CharUnaryOperator<E extends Throwable> {
        public char applyAsChar(char var1) throws E;
    }

    public static interface BooleanUnaryOperator<E extends Throwable> {
        public boolean applyAsBoolean(boolean var1) throws E;
    }

    public static interface TernaryOperator<T, E extends Throwable>
    extends BiFunction<T, T, T, E> {
    }

    public static interface BinaryOperator<T, E extends Throwable>
    extends BiFunction<T, T, T, E> {
    }

    public static interface UnaryOperator<T, E extends Throwable>
    extends Function<T, T, E> {
    }

    public static interface ToDoubleFunction<T, E extends Throwable> {
        public double applyAsDouble(T var1) throws E;
    }

    public static interface ToFloatFunction<T, E extends Throwable> {
        public float applyAsFloat(T var1) throws E;
    }

    public static interface ToLongFunction<T, E extends Throwable> {
        public long applyAsLong(T var1) throws E;
    }

    public static interface ToIntFunction<T, E extends Throwable> {
        public int applyAsInt(T var1) throws E;
    }

    public static interface ToShortFunction<T, E extends Throwable> {
        public short applyAsShort(T var1) throws E;
    }

    public static interface ToByteFunction<T, E extends Throwable> {
        public byte applyAsByte(T var1) throws E;
    }

    public static interface ToCharFunction<T, E extends Throwable> {
        public char applyAsChar(T var1) throws E;
    }

    public static interface ToBooleanFunction<T, E extends Throwable> {
        public boolean applyAsBoolean(T var1) throws E;
    }

    public static interface DoubleConsumer<E extends Throwable> {
        public void accept(double var1) throws E;
    }

    public static interface DoubleFunction<R, E extends Throwable> {
        public R apply(double var1) throws E;
    }

    public static interface DoublePredicate<E extends Throwable> {
        public boolean test(double var1) throws E;
    }

    public static interface FloatConsumer<E extends Throwable> {
        public void accept(float var1) throws E;
    }

    public static interface FloatFunction<R, E extends Throwable> {
        public R apply(float var1) throws E;
    }

    public static interface FloatPredicate<E extends Throwable> {
        public boolean test(float var1) throws E;
    }

    public static interface LongConsumer<E extends Throwable> {
        public void accept(long var1) throws E;
    }

    public static interface LongFunction<R, E extends Throwable> {
        public R apply(long var1) throws E;
    }

    public static interface LongPredicate<E extends Throwable> {
        public boolean test(long var1) throws E;
    }

    public static interface IntConsumer<E extends Throwable> {
        public void accept(int var1) throws E;
    }

    public static interface IntFunction<R, E extends Throwable> {
        public R apply(int var1) throws E;
    }

    public static interface IntPredicate<E extends Throwable> {
        public boolean test(int var1) throws E;
    }

    public static interface ShortConsumer<E extends Throwable> {
        public void accept(short var1) throws E;
    }

    public static interface ShortFunction<R, E extends Throwable> {
        public R apply(short var1) throws E;
    }

    public static interface ShortPredicate<E extends Throwable> {
        public boolean test(short var1) throws E;
    }

    public static interface ByteConsumer<E extends Throwable> {
        public void accept(byte var1) throws E;
    }

    public static interface ByteFunction<R, E extends Throwable> {
        public R apply(byte var1) throws E;
    }

    public static interface BytePredicate<E extends Throwable> {
        public boolean test(byte var1) throws E;
    }

    public static interface CharConsumer<E extends Throwable> {
        public void accept(char var1) throws E;
    }

    public static interface CharFunction<R, E extends Throwable> {
        public R apply(char var1) throws E;
    }

    public static interface CharPredicate<E extends Throwable> {
        public boolean test(char var1) throws E;
    }

    public static interface BooleanConsumer<E extends Throwable> {
        public void accept(boolean var1) throws E;
    }

    public static interface BooleanFunction<R, E extends Throwable> {
        public R apply(boolean var1) throws E;
    }

    public static interface BooleanPredicate<E extends Throwable> {
        public boolean test(boolean var1) throws E;
    }

    public static interface IndexedDoubleConsumer<E extends Throwable> {
        public void accept(int var1, double var2) throws E;
    }

    public static interface IndexedFloatConsumer<E extends Throwable> {
        public void accept(int var1, float var2) throws E;
    }

    public static interface IndexedLongConsumer<E extends Throwable> {
        public void accept(int var1, long var2) throws E;
    }

    public static interface IndexedIntConsumer<E extends Throwable> {
        public void accept(int var1, int var2) throws E;
    }

    public static interface IndexedShortConsumer<E extends Throwable> {
        public void accept(int var1, short var2) throws E;
    }

    public static interface IndexedByteConsumer<E extends Throwable> {
        public void accept(int var1, byte var2) throws E;
    }

    public static interface IndexedCharConsumer<E extends Throwable> {
        public void accept(int var1, char var2) throws E;
    }

    public static interface IndexedBooleanConsumer<E extends Throwable> {
        public void accept(int var1, boolean var2) throws E;
    }

    public static interface IndexedBiPredicate<U, T, E extends Throwable> {
        public boolean test(U var1, int var2, T var3) throws E;
    }

    public static interface IndexedPredicate<T, E extends Throwable> {
        public boolean test(int var1, T var2) throws E;
    }

    public static interface IndexedBiFunction<U, T, R, E extends Throwable> {
        public R apply(U var1, int var2, T var3) throws E;
    }

    public static interface IndexedFunction<T, R, E extends Throwable> {
        public R apply(int var1, T var2) throws E;
    }

    public static interface IndexedBiConsumer<U, T, E extends Throwable> {
        public void accept(U var1, int var2, T var3) throws E;
    }

    public static interface IndexedConsumer<T, E extends Throwable> {
        public void accept(int var1, T var2) throws E;
    }

    public static interface QuadConsumer<A, B, C, D, E extends Throwable> {
        public void accept(A var1, B var2, C var3, D var4) throws E;
    }

    public static interface TriConsumer<A, B, C, E extends Throwable> {
        public void accept(A var1, B var2, C var3) throws E;
    }

    public static interface BiConsumer<T, U, E extends Throwable> {
        public void accept(T var1, U var2) throws E;
    }

    public static interface Consumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    public static interface QuadFunction<A, B, C, D, R, E extends Throwable> {
        public R apply(A var1, B var2, C var3, D var4) throws E;
    }

    public static interface TriFunction<A, B, C, R, E extends Throwable> {
        public R apply(A var1, B var2, C var3) throws E;
    }

    public static interface BiFunction<T, U, R, E extends Throwable> {
        public R apply(T var1, U var2) throws E;
    }

    public static interface Function<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    public static interface QuadPredicate<A, B, C, D, E extends Throwable> {
        public boolean test(A var1, B var2, C var3, D var4) throws E;
    }

    public static interface TriPredicate<A, B, C, E extends Throwable> {
        public boolean test(A var1, B var2, C var3) throws E;
    }

    public static interface BiPredicate<T, U, E extends Throwable> {
        public boolean test(T var1, U var2) throws E;
    }

    public static interface Predicate<T, E extends Throwable> {
        public boolean test(T var1) throws E;
    }

    public static interface DoubleSupplier<E extends Throwable> {
        public double getAsDouble() throws E;
    }

    public static interface FloatSupplier<E extends Throwable> {
        public float getAsFloat() throws E;
    }

    public static interface LongSupplier<E extends Throwable> {
        public long getAsLong() throws E;
    }

    public static interface IntSupplier<E extends Throwable> {
        public int getAsInt() throws E;
    }

    public static interface ShortSupplier<E extends Throwable> {
        public short getAsShort() throws E;
    }

    public static interface ByteSupplier<E extends Throwable> {
        public byte getAsByte() throws E;
    }

    public static interface CharSupplier<E extends Throwable> {
        public char getAsChar() throws E;
    }

    public static interface BooleanSupplier<E extends Throwable> {
        public boolean getAsBoolean() throws E;
    }

    public static interface Supplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface Callable<R, E extends Throwable> {
        public R call() throws E;
    }

    public static interface Runnable<E extends Throwable> {
        public void run() throws E;
    }
}

