/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.util.Mutable;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.u;

public final class Triple<L, M, R>
implements Mutable {
    public L left;
    public M middle;
    public R right;
    private static final Triple<?, ?, ?>[] EMPTY_ARRAY = new Triple[0];

    public Triple() {
    }

    Triple(L l, M m, R r) {
        this.left = l;
        this.middle = m;
        this.right = r;
    }

    public static <L, M, R> Triple<L, M, R> of(L l, M m, R r) {
        return new Triple<L, M, R>(l, m, r);
    }

    public static <L, M, R> Triple<L, M, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public L getLeft() {
        return this.left;
    }

    public void setLeft(L left) {
        this.left = left;
    }

    public M getMiddle() {
        return this.middle;
    }

    public void setMiddle(M middle) {
        this.middle = middle;
    }

    public R getRight() {
        return this.right;
    }

    public void setRight(R right) {
        this.right = right;
    }

    public void set(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public L getAndSetLeft(L newLeft) {
        L res = this.left;
        this.left = newLeft;
        return res;
    }

    public L setAndGetLeft(L newLeft) {
        this.left = newLeft;
        return this.left;
    }

    public M getAndSetMiddle(M newMiddle) {
        M res = this.middle;
        this.middle = newMiddle;
        return res;
    }

    public M setAndGetMiddle(M newMiddle) {
        this.middle = newMiddle;
        return this.middle;
    }

    public R getAndSetRight(R newRight) {
        R res = newRight;
        this.right = newRight;
        return res;
    }

    public R setAndGetRight(R newRight) {
        this.right = newRight;
        return this.right;
    }

    public <E extends Exception> boolean setLeftIf(L newLeft, Throwables.BiPredicate<? super Triple<L, M, R>, ? super L, E> predicate) throws E {
        if (predicate.test(this, newLeft)) {
            this.left = newLeft;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean setMiddleIf(M newMiddle, Throwables.BiPredicate<? super Triple<L, M, R>, ? super M, E> predicate) throws E {
        if (predicate.test(this, newMiddle)) {
            this.middle = newMiddle;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean setRightIf(R newRight, Throwables.BiPredicate<? super Triple<L, M, R>, ? super R, E> predicate) throws E {
        if (predicate.test(this, newRight)) {
            this.right = newRight;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean setIf(L newLeft, M newMiddle, R newRight, Throwables.QuadPredicate<? super Triple<L, M, R>, ? super L, ? super M, ? super R, E> predicate) throws E {
        if (predicate.test(this, newLeft, newMiddle, newRight)) {
            this.left = newLeft;
            this.middle = newMiddle;
            this.right = newRight;
            return true;
        }
        return false;
    }

    @Beta
    public Triple<R, M, L> reverse() {
        return new Triple<R, M, L>(this.right, this.middle, this.left);
    }

    public Triple<L, M, R> copy() {
        return new Triple<L, M, R>(this.left, this.middle, this.right);
    }

    public Object[] toArray() {
        return new Object[]{this.left, this.middle, this.right};
    }

    public <A> A[] toArray(A[] a) {
        if (a.length < 3) {
            a = N.copyOf(a, 3);
        }
        a[0] = this.left;
        a[1] = this.middle;
        a[2] = this.right;
        return a;
    }

    public <E extends Exception> void forEach(Throwables.Consumer<?, E> comsumer) throws E {
        Throwables.Consumer<?, E> objComsumer = comsumer;
        objComsumer.accept(this.left);
        objComsumer.accept(this.middle);
        objComsumer.accept(this.right);
    }

    public <E extends Exception> void accept(Throwables.TriConsumer<? super L, ? super M, ? super R, E> action) throws E {
        action.accept(this.left, this.middle, this.right);
    }

    public <E extends Exception> void accept(Throwables.Consumer<? super Triple<L, M, R>, E> action) throws E {
        action.accept(this);
    }

    public <U, E extends Exception> U map(Throwables.TriFunction<? super L, ? super M, ? super R, U, E> mapper) throws E {
        return mapper.apply(this.left, this.middle, this.right);
    }

    public <U, E extends Exception> U map(Throwables.Function<? super Triple<L, M, R>, U, E> mapper) throws E {
        return mapper.apply(this);
    }

    public <E extends Exception> u.Optional<Triple<L, M, R>> filter(Throwables.TriPredicate<? super L, ? super M, ? super R, E> predicate) throws E {
        return predicate.test(this.left, this.middle, this.right) ? u.Optional.of(this) : u.Optional.empty();
    }

    public <E extends Exception> u.Optional<Triple<L, M, R>> filter(Throwables.Predicate<? super Triple<L, M, R>, E> predicate) throws E {
        return predicate.test(this) ? u.Optional.of(this) : u.Optional.empty();
    }

    public u.Optional<Triple<L, M, R>> toOptional() {
        return u.Optional.of(this);
    }

    public Tuple.Tuple3<L, M, R> toTuple() {
        return Tuple.of(this.left, this.middle, this.right);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + N.hashCode(this.left);
        result = 31 * result + N.hashCode(this.middle);
        result = 31 * result + N.hashCode(this.right);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Triple) {
            Triple other = (Triple)obj;
            return N.equals(this.left, other.left) && N.equals(this.middle, other.middle) && N.equals(this.right, other.right);
        }
        return false;
    }

    public String toString() {
        return "[" + N.toString(this.left) + ", " + N.toString(this.middle) + ", " + N.toString(this.right) + "]";
    }
}

