/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.function.Consumer;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.Predicate;
import com.landawn.abacus.util.function.Supplier;
import java.util.concurrent.Callable;

public final class Try<T extends AutoCloseable> {
    private static final AutoCloseable EMPTY = new AutoCloseable(){

        @Override
        public void close() throws Exception {
        }
    };
    private final T targetResource;
    private final Throwables.Supplier<T, ? extends Exception> targetResourceSupplier;
    private final Runnable finalAction;

    Try(T targetResource, Throwables.Supplier<T, ? extends Exception> targetResourceSupplier, Runnable finalAction) {
        this.targetResource = targetResource;
        this.targetResourceSupplier = targetResourceSupplier;
        this.finalAction = finalAction;
    }

    public static <T extends AutoCloseable> Try<T> with(T targetResource) {
        N.checkArgNotNull(targetResource, "targetResourceSupplier");
        return new Try<T>(targetResource, null, null);
    }

    public static <T extends AutoCloseable> Try<T> with(T targetResource, Runnable finalAction) {
        N.checkArgNotNull(targetResource, "targetResourceSupplier");
        N.checkArgNotNull(finalAction, "finalAction");
        return new Try<T>(targetResource, null, finalAction);
    }

    public static <T extends AutoCloseable> Try<T> with(Throwables.Supplier<T, ? extends Exception> targetResourceSupplier) {
        N.checkArgNotNull(targetResourceSupplier, "targetResourceSupplier");
        return new Try<Object>(null, targetResourceSupplier, null);
    }

    public static <T extends AutoCloseable> Try<T> with(Throwables.Supplier<T, ? extends Exception> targetResourceSupplier, Runnable finalAction) {
        N.checkArgNotNull(targetResourceSupplier, "targetResourceSupplier");
        N.checkArgNotNull(finalAction, "finalAction");
        return new Try<Object>(null, targetResourceSupplier, finalAction);
    }

    public static <T extends AutoCloseable> Try<T> with(Runnable finalAction) {
        N.checkArgNotNull(finalAction);
        return new Try<Object>(null, null, finalAction);
    }

    public static void run(Throwables.Runnable<? extends Exception> cmd) {
        try {
            cmd.run();
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
    }

    public static void run(Throwables.Runnable<? extends Exception> cmd, Consumer<? super Exception> actionOnError) {
        try {
            cmd.run();
        }
        catch (Exception e) {
            actionOnError.accept(e);
        }
    }

    public static <R> R call(Callable<R> cmd) {
        try {
            return cmd.call();
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
    }

    public static <R> R call(Callable<R> cmd, Function<? super Exception, R> actionOnError) {
        try {
            return cmd.call();
        }
        catch (Exception e) {
            return actionOnError.apply(e);
        }
    }

    public static <R> R call(Callable<R> cmd, Supplier<R> supplier) {
        try {
            return cmd.call();
        }
        catch (Exception e) {
            return supplier.get();
        }
    }

    public static <R> R call(Callable<R> cmd, R defaultValue) {
        try {
            return cmd.call();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <R> R call(Callable<R> cmd, Predicate<? super Exception> predicate, Supplier<R> supplier) {
        try {
            return cmd.call();
        }
        catch (Exception e) {
            if (predicate.test(e)) {
                return supplier.get();
            }
            throw N.toRuntimeException(e);
        }
    }

    public static <R> R call(Callable<R> cmd, Predicate<? super Exception> predicate, R defaultValue) {
        try {
            return cmd.call();
        }
        catch (Exception e) {
            if (predicate.test(e)) {
                return defaultValue;
            }
            throw N.toRuntimeException(e);
        }
    }

    public void run(Throwables.Consumer<? super T, ? extends Exception> cmd) {
        try (T c = this.targetResource == null ? (this.targetResourceSupplier == null ? EMPTY : (AutoCloseable)this.targetResourceSupplier.get()) : this.targetResource;){
            cmd.accept(this.targetResource);
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
        finally {
            if (this.finalAction != null) {
                this.finalAction.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Throwables.Consumer<? super T, ? extends Exception> cmd, Consumer<? super Exception> actionOnError) {
        try (T c = this.targetResource == null ? (this.targetResourceSupplier == null ? EMPTY : (AutoCloseable)this.targetResourceSupplier.get()) : this.targetResource;){
            cmd.accept(this.targetResource);
        }
        catch (Exception e) {
            actionOnError.accept(e);
        }
        finally {
            if (this.finalAction != null) {
                this.finalAction.run();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public <R> R call(Throwables.Function<? super T, R, ? extends Exception> cmd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <R> R call(Throwables.Function<? super T, R, ? extends Exception> cmd, Function<? super Exception, R> actionOnError) {
        try {
            R r;
            Object object;
            T c;
            block18: {
                block19: {
                    c = this.targetResource == null ? (this.targetResourceSupplier == null ? EMPTY : (AutoCloseable)this.targetResourceSupplier.get()) : this.targetResource;
                    object = null;
                    r = cmd.apply(this.targetResource);
                    if (c == null) break block18;
                    if (object == null) break block19;
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block18;
                }
                c.close();
            }
            return r;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (c != null) {
                            if (object != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                c.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    object = actionOnError.apply(e);
                    return (R)object;
                }
            }
        }
        finally {
            if (this.finalAction != null) {
                this.finalAction.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <R> R call(Throwables.Function<? super T, R, ? extends Exception> cmd, Supplier<R> supplier) {
        try {
            R r;
            Object object;
            T c;
            block18: {
                block19: {
                    c = this.targetResource == null ? (this.targetResourceSupplier == null ? EMPTY : (AutoCloseable)this.targetResourceSupplier.get()) : this.targetResource;
                    object = null;
                    r = cmd.apply(this.targetResource);
                    if (c == null) break block18;
                    if (object == null) break block19;
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block18;
                }
                c.close();
            }
            return r;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (c != null) {
                            if (object != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                c.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    object = supplier.get();
                    return (R)object;
                }
            }
        }
        finally {
            if (this.finalAction != null) {
                this.finalAction.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <R> R call(Throwables.Function<? super T, R, ? extends Exception> cmd, R defaultValue) {
        try {
            R r;
            Object object;
            T c;
            block18: {
                block19: {
                    c = this.targetResource == null ? (this.targetResourceSupplier == null ? EMPTY : (AutoCloseable)this.targetResourceSupplier.get()) : this.targetResource;
                    object = null;
                    r = cmd.apply(this.targetResource);
                    if (c == null) break block18;
                    if (object == null) break block19;
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block18;
                }
                c.close();
            }
            return r;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (c != null) {
                            if (object != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                c.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    object = defaultValue;
                    return (R)object;
                }
            }
        }
        finally {
            if (this.finalAction != null) {
                this.finalAction.run();
            }
        }
    }

    /*
     * Loose catch block
     */
    public <R> R call(Throwables.Function<? super T, R, ? extends Exception> cmd, Predicate<? super Exception> predicate, Supplier<R> supplier) {
        try {
            R r;
            Throwable throwable;
            T c;
            block20: {
                block21: {
                    c = this.targetResource == null ? (this.targetResourceSupplier == null ? EMPTY : (AutoCloseable)this.targetResourceSupplier.get()) : this.targetResource;
                    throwable = null;
                    r = cmd.apply(this.targetResource);
                    if (c == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        c.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                c.close();
            }
            return r;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (c != null) {
                            if (throwable != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                c.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    if (predicate.test(e)) {
                        throwable = (Throwable)supplier.get();
                        return (R)throwable;
                    }
                    throw N.toRuntimeException(e);
                }
            }
        }
        finally {
            if (this.finalAction != null) {
                this.finalAction.run();
            }
        }
    }

    /*
     * Loose catch block
     */
    public <R> R call(Throwables.Function<? super T, R, ? extends Exception> cmd, Predicate<? super Exception> predicate, R defaultValue) {
        try {
            R r;
            Throwable throwable;
            T c;
            block20: {
                block21: {
                    c = this.targetResource == null ? (this.targetResourceSupplier == null ? EMPTY : (AutoCloseable)this.targetResourceSupplier.get()) : this.targetResource;
                    throwable = null;
                    r = cmd.apply(this.targetResource);
                    if (c == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        c.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                c.close();
            }
            return r;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (c != null) {
                            if (throwable != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                c.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    if (predicate.test(e)) {
                        throwable = (Throwable)defaultValue;
                        return (R)throwable;
                    }
                    throw N.toRuntimeException(e);
                }
            }
        }
        finally {
            if (this.finalAction != null) {
                this.finalAction.run();
            }
        }
    }
}

