/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;

public final class TypeAttrParser {
    private final String className;
    private final String[] typeParameters;
    private final String[] parameters;

    private TypeAttrParser(String className, String[] typeParameters, String[] parameters) {
        this.className = className;
        this.typeParameters = typeParameters == null ? new String[0] : typeParameters;
        this.parameters = parameters == null ? new String[0] : parameters;
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getTypeParameters() {
        return this.typeParameters;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public static TypeAttrParser parse(String attr) {
        String className = null;
        String[] typeParameters = null;
        String[] parameters = null;
        int beginIndex = attr.indexOf(60);
        if (beginIndex >= 0) {
            int idx;
            int endIndex = attr.lastIndexOf(62);
            className = attr.substring(0, beginIndex).trim();
            ArrayList<String> typeParameterList = new ArrayList<String>();
            int bracketNum = 0;
            int previousIndex = idx = beginIndex + 1;
            while (idx < endIndex) {
                char ch = attr.charAt(idx);
                if (ch == '<') {
                    ++bracketNum;
                } else {
                    if (bracketNum > 0 && ch == '>') {
                        --bracketNum;
                    }
                    if (bracketNum == 0 && (ch == ',' || idx == endIndex - 1)) {
                        typeParameterList.add(StringUtil.trim(ch == ',' ? attr.substring(previousIndex, idx) : attr.substring(previousIndex, idx + 1)));
                        previousIndex = idx + 1;
                    }
                }
                ++idx;
            }
            typeParameters = typeParameterList.toArray(new String[typeParameterList.size()]);
            beginIndex = endIndex;
        }
        if ((beginIndex = attr.indexOf(40, N.max(0, beginIndex))) >= 0) {
            String[] stringArray;
            String str;
            if (className == null) {
                className = attr.substring(0, beginIndex);
            }
            if (",".equals((str = attr.substring(beginIndex + 1, attr.lastIndexOf(41))).trim())) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ",";
            } else {
                stringArray = parameters = Splitter.with(",").trimResults().splitToArray(str);
            }
        }
        if (className == null) {
            className = attr;
        }
        return new TypeAttrParser(className, typeParameters, parameters);
    }

    @SafeVarargs
    public static <T> T newInstance(Class<?> cls, String attr, Object ... args) {
        int parameterLength;
        TypeAttrParser attrResult = TypeAttrParser.parse(attr);
        String className = attrResult.getClassName();
        String[] attrTypeParameters = attrResult.getTypeParameters();
        String[] attrParameters = attrResult.getParameters();
        if (cls == null) {
            cls = ClassUtil.forClass(className);
        }
        if ((parameterLength = attrTypeParameters.length + attrParameters.length + args.length / 2) > 0) {
            int i;
            Object[] parameterTypes = new Class[parameterLength];
            Object[] paramters = new Object[parameterLength];
            for (i = 0; i < args.length; ++i) {
                parameterTypes[i / 2] = (Class)args[i];
                paramters[i / 2] = args[++i];
            }
            for (i = 0; i < attrTypeParameters.length; ++i) {
                parameterTypes[i + args.length / 2] = String.class;
                paramters[i + args.length / 2] = attrTypeParameters[i];
            }
            for (i = 0; i < attrParameters.length; ++i) {
                parameterTypes[i + args.length / 2 + attrTypeParameters.length] = String.class;
                paramters[i + args.length / 2 + attrTypeParameters.length] = attrParameters[i];
            }
            Constructor<Object> constructor = ClassUtil.getDeclaredConstructor(cls, parameterTypes);
            if (constructor == null) {
                parameterLength = attrTypeParameters.length + (attrParameters.length > 1 ? 1 : 0) + args.length / 2;
                if (parameterLength > 0) {
                    int i2;
                    parameterTypes = new Class[parameterLength];
                    paramters = new Object[parameterLength];
                    for (i2 = 0; i2 < args.length; ++i2) {
                        parameterTypes[i2 / 2] = (Class)args[i2];
                        paramters[i2 / 2] = args[++i2];
                    }
                    for (i2 = 0; i2 < attrTypeParameters.length; ++i2) {
                        parameterTypes[i2 + args.length / 2] = String.class;
                        paramters[i2 + args.length / 2] = attrTypeParameters[i2];
                    }
                    if (attrParameters.length > 1) {
                        parameterTypes[parameterTypes.length - 1] = String[].class;
                        paramters[paramters.length - 1] = attrParameters;
                    }
                }
                constructor = ClassUtil.getDeclaredConstructor(cls, parameterTypes);
            }
            if (constructor == null) {
                throw new IllegalArgumentException("No constructor found with parameters: " + N.toString(parameterTypes) + ". in class: " + cls.getCanonicalName());
            }
            ClassUtil.setAccessibleQuietly(constructor, true);
            return (T)ClassUtil.invokeConstructor(constructor, paramters);
        }
        return (T)N.newInstance(cls);
    }

    public String toString() {
        return "{className=" + this.className + ", typeParameters=" + Arrays.toString(this.typeParameters) + ", parameters=" + Arrays.toString(this.parameters) + "}";
    }
}

