/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.N;
import java.security.MessageDigest;
import java.security.SecureRandom;

public final class WSSecurityUtil {
    private static final String RNG_ALGORITHM = "SHA1PRNG";
    private static final String HASH_ALGORITHM = "SHA-1";
    private static SecureRandom random = null;
    private static MessageDigest digest = null;

    private WSSecurityUtil() {
    }

    public static byte[] generateNonce(int length) {
        Class<WSSecurityUtil> clazz = WSSecurityUtil.class;
        synchronized (WSSecurityUtil.class) {
            try {
                if (random == null) {
                    random = SecureRandom.getInstance(RNG_ALGORITHM);
                }
                byte[] temp = new byte[length];
                random.nextBytes(temp);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return temp;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error in generating nonce of length " + length, ex);
            }
        }
    }

    public static byte[] generateDigest(byte[] inputBytes) {
        Class<WSSecurityUtil> clazz = WSSecurityUtil.class;
        synchronized (WSSecurityUtil.class) {
            try {
                if (digest == null) {
                    digest = MessageDigest.getInstance(HASH_ALGORITHM);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return digest.digest(inputBytes);
            }
            catch (Exception e) {
                throw new RuntimeException("Error in generating digest", e);
            }
        }
    }

    public static String doPasswordDigest(byte[] nonce, byte[] created, byte[] password) {
        String passwdDigest = null;
        byte[] b4 = new byte[nonce.length + created.length + password.length];
        int offset = 0;
        N.copy(nonce, 0, b4, offset, nonce.length);
        N.copy(created, 0, b4, offset += nonce.length, created.length);
        N.copy(password, 0, b4, offset += created.length, password.length);
        byte[] digestBytes = WSSecurityUtil.generateDigest(b4);
        passwdDigest = N.base64Encode(digestBytes);
        return passwdDigest;
    }

    public static String doPasswordDigest(String nonce, String created, String password) {
        return WSSecurityUtil.doPasswordDigest(nonce.getBytes(Charsets.UTF_8), created.getBytes(Charsets.UTF_8), password.getBytes(Charsets.UTF_8));
    }
}

