/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util.function;

import com.landawn.abacus.util.Throwables;

public interface FloatBiPredicate
extends Throwables.FloatBiPredicate<RuntimeException> {
    public static final FloatBiPredicate ALWAYS_TRUE = new FloatBiPredicate(){

        @Override
        public boolean test(float t, float u2) {
            return true;
        }
    };
    public static final FloatBiPredicate ALWAYS_FALSE = new FloatBiPredicate(){

        @Override
        public boolean test(float t, float u2) {
            return false;
        }
    };
    public static final FloatBiPredicate EQUAL = new FloatBiPredicate(){

        @Override
        public boolean test(float t, float u2) {
            return Float.compare(t, u2) == 0;
        }
    };
    public static final FloatBiPredicate NOT_EQUAL = new FloatBiPredicate(){

        @Override
        public boolean test(float t, float u2) {
            return Float.compare(t, u2) != 0;
        }
    };
    public static final FloatBiPredicate GREATER_THAN = new FloatBiPredicate(){

        @Override
        public boolean test(float t, float u2) {
            return Float.compare(t, u2) > 0;
        }
    };
    public static final FloatBiPredicate GREATER_EQUAL = new FloatBiPredicate(){

        @Override
        public boolean test(float t, float u2) {
            return Float.compare(t, u2) >= 0;
        }
    };
    public static final FloatBiPredicate LESS_THAN = new FloatBiPredicate(){

        @Override
        public boolean test(float t, float u2) {
            return Float.compare(t, u2) < 0;
        }
    };
    public static final FloatBiPredicate LESS_EQUAL = new FloatBiPredicate(){

        @Override
        public boolean test(float t, float u2) {
            return Float.compare(t, u2) <= 0;
        }
    };

    @Override
    public boolean test(float var1, float var2);
}

