/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Expression
extends AbstractCondition {
    private static final long serialVersionUID = -1270437226702741887L;
    static final String NULL_STRING = "null".intern();
    static final char[] NULL_CHAR_ARRAY = NULL_STRING.toCharArray();
    static final String TRUE = Boolean.TRUE.toString().intern();
    static final char[] TRUE_CHAR_ARRAY = TRUE.toCharArray();
    static final String FALSE = Boolean.FALSE.toString().intern();
    static final char[] FALSE_CHAR_ARRAY = FALSE.toCharArray();
    private static final String LEFT_SHIFT = "<<";
    private static final String RIGTH_SHIFT = ">>";
    private static final String NULL = "NULL";
    private static final String EMPTY = "BLANK";
    private static final Map<String, Expression> cachedExpression = new ConcurrentHashMap<String, Expression>();
    final String literal;

    Expression() {
        this.literal = null;
    }

    public Expression(String literal) {
        super(Operator.EMPTY);
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public static Expression of(String literal) {
        Expression expr = cachedExpression.get(literal);
        if (expr == null) {
            expr = new Expression(literal);
            cachedExpression.put(literal, expr);
        }
        return expr;
    }

    public static String equal(String literal, Object value) {
        return Expression.link(Operator.EQUAL, literal, value);
    }

    public static String eq(String literal, Object value) {
        return Expression.link(Operator.EQUAL, literal, value);
    }

    public static String notEqual(String literal, Object value) {
        return Expression.link(Operator.NOT_EQUAL, literal, value);
    }

    public static String ne(String literal, Object value) {
        return Expression.link(Operator.NOT_EQUAL, literal, value);
    }

    public static String greaterThan(String literal, Object value) {
        return Expression.link(Operator.GREATER_THAN, literal, value);
    }

    public static String gt(String literal, Object value) {
        return Expression.link(Operator.GREATER_THAN, literal, value);
    }

    public static String greaterEqual(String literal, Object value) {
        return Expression.link(Operator.GREATER_EQUAL, literal, value);
    }

    public static String ge(String literal, Object value) {
        return Expression.link(Operator.GREATER_EQUAL, literal, value);
    }

    public static String lessThan(String literal, Object value) {
        return Expression.link(Operator.LESS_THAN, literal, value);
    }

    public static String lt(String literal, Object value) {
        return Expression.link(Operator.LESS_THAN, literal, value);
    }

    public static String lessEqual(String literal, Object value) {
        return Expression.link(Operator.LESS_EQUAL, literal, value);
    }

    public static String le(String literal, Object value) {
        return Expression.link(Operator.LESS_EQUAL, literal, value);
    }

    public static String between(String literal, Object min, Object max) {
        return Expression.link(Operator.BETWEEN, literal, min, max);
    }

    public static String bt(String literal, Object min, Object max) {
        return Expression.link(Operator.BETWEEN, literal, min, max);
    }

    public static String like(String literal, String value) {
        return Expression.link(Operator.LIKE, literal, (Object)value);
    }

    public static String isNull(String literal) {
        return Expression.link2(Operator.IS, literal, NULL);
    }

    public static String isNotNull(String literal) {
        return Expression.link2(Operator.IS_NOT, literal, NULL);
    }

    public static String isEmpty(String literal) {
        return Expression.link2(Operator.IS, literal, EMPTY);
    }

    public static String isNotEmpty(String literal) {
        return Expression.link2(Operator.IS_NOT, literal, EMPTY);
    }

    @SafeVarargs
    public static String and(String ... literals) {
        return Expression.link2(Operator.AND, literals);
    }

    @SafeVarargs
    public static String or(String ... literals) {
        return Expression.link2(Operator.OR, literals);
    }

    @SafeVarargs
    public static String plus(Object ... objects) {
        return Expression.link("+", objects);
    }

    @SafeVarargs
    public static String minus(Object ... objects) {
        return Expression.link("-", objects);
    }

    @SafeVarargs
    public static String multi(Object ... objects) {
        return Expression.link("*", objects);
    }

    @SafeVarargs
    public static String division(Object ... objects) {
        return Expression.link("/", objects);
    }

    @SafeVarargs
    public static String modulus(Object ... objects) {
        return Expression.link("%", objects);
    }

    @SafeVarargs
    public static String lShift(Object ... objects) {
        return Expression.link(LEFT_SHIFT, objects);
    }

    @SafeVarargs
    public static String rShift(Object ... objects) {
        return Expression.link(RIGTH_SHIFT, objects);
    }

    @SafeVarargs
    public static String bitwiseAnd(Object ... objects) {
        return Expression.link("&", objects);
    }

    @SafeVarargs
    public static String bitwiseOr(Object ... objects) {
        return Expression.link("|", objects);
    }

    @SafeVarargs
    public static String bitwiseXOr(Object ... objects) {
        return Expression.link("^", objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String link(Operator operator, String literal, Object value) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(literal);
            sb.append(' ');
            sb.append(operator.getName());
            sb.append(' ');
            sb.append(Expression.formalize(value));
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String link(Operator operator, String literal, Object min, Object max) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(literal);
            sb.append(' ');
            sb.append(operator.getName());
            sb.append(' ');
            sb.append('(');
            sb.append(Expression.formalize(min));
            sb.append(", ");
            sb.append(Expression.formalize(max));
            sb.append(')');
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String link2(Operator operator, String literal, String operatorPostfix) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(literal);
            sb.append(' ');
            sb.append(operator.getName());
            sb.append(' ');
            sb.append(operatorPostfix);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String link2(Operator operator, String ... literals) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = 0; i < literals.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                    sb.append(operator.getName());
                    sb.append(' ');
                }
                sb.append(literals[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String link(String linkedSymbol, Object ... objects) {
        if (!" ".equals(linkedSymbol) && !", ".equals(linkedSymbol)) {
            linkedSymbol = ' ' + linkedSymbol + ' ';
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = 0; i < objects.length; ++i) {
                if (i > 0) {
                    sb.append(linkedSymbol);
                }
                sb.append(Expression.formalize(objects[i]));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String formalize(Object value) {
        if (value == null) {
            return NULL_STRING;
        }
        if (value instanceof String) {
            return '\'' + StringUtil.quoteEscaped((String)value) + '\'';
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Expression) {
            return ((Expression)value).getLiteral();
        }
        return '\'' + StringUtil.quoteEscaped(N.stringOf(value)) + '\'';
    }

    public static String count(String expression) {
        return Expression.function("COUNT", expression);
    }

    public static String average(String expression) {
        return Expression.function("AVG", expression);
    }

    public static String sum(String expression) {
        return Expression.function("SUM", expression);
    }

    public static String min(String expression) {
        return Expression.function("MIN", expression);
    }

    public static String max(String expression) {
        return Expression.function("MAX", expression);
    }

    public static String abs(String expression) {
        return Expression.function("ABS", expression);
    }

    public static String acos(String expression) {
        return Expression.function("ACOS", expression);
    }

    public static String asin(String expression) {
        return Expression.function("ASIN", expression);
    }

    public static String atan(String expression) {
        return Expression.function("ATAN", expression);
    }

    public static String ceil(String expression) {
        return Expression.function("CEIL", expression);
    }

    public static String cos(String expression) {
        return Expression.function("COS", expression);
    }

    public static String exp(String expression) {
        return Expression.function("EXP", expression);
    }

    public static String floor(String expression) {
        return Expression.function("FLOOR", expression);
    }

    public static String log(String b, String x) {
        return Expression.function("LOG", b, x);
    }

    public static String ln(String expression) {
        return Expression.function("LN", expression);
    }

    public static String mod(String n1, String n2) {
        return Expression.function("MOD", n1, n2);
    }

    public static String power(String n1, String n2) {
        return Expression.function("POWER", n1, n2);
    }

    public static String sign(String expression) {
        return Expression.function("SIGN", expression);
    }

    public static String sin(String expression) {
        return Expression.function("SIN", expression);
    }

    public static String sqrt(String expression) {
        return Expression.function("SQRT", expression);
    }

    public static String tan(String expression) {
        return Expression.function("TAN", expression);
    }

    public static String concat(String st1, String st2) {
        return Expression.function("CONCAT", st1, st2);
    }

    public static String replace(String st, String oldString, String replacement) {
        return Expression.function("REPLACE", st, oldString, replacement);
    }

    public static String stringLength(String st) {
        return Expression.function("LENGTH", st);
    }

    public static String subString(String st, int fromIndex) {
        return Expression.function("SUBSTR", st, fromIndex);
    }

    public static String subString(String st, int fromIndex, int length) {
        return Expression.function("SUBSTR", st, fromIndex, length);
    }

    public static String trim(String st) {
        return Expression.function("TRIM", st);
    }

    public static String lTrim(String st) {
        return Expression.function("LTRIM", st);
    }

    public static String rTrim(String st) {
        return Expression.function("RTRIM", st);
    }

    public static String lPad(String st, int length, String padStr) {
        return Expression.function("LPAD", st, length, padStr);
    }

    public static String rPad(String st, int length, String padStr) {
        return Expression.function("RPAD", st, length, padStr);
    }

    public static String lower(String st) {
        return Expression.function("LOWER", st);
    }

    public static String upper(String st) {
        return Expression.function("UPPER", st);
    }

    @Override
    public List<Object> getParameters() {
        return N.emptyList();
    }

    @Override
    public void clearParameters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String function(String functionName, Object ... args) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(functionName);
            sb.append('(');
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(N.stringOf(args[i]));
            }
            sb.append(')');
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    @Override
    public String toString(NamingPolicy namingPolicy) {
        return this.literal;
    }

    public int hashCode() {
        return this.literal == null ? 0 : this.literal.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof Expression && N.equals(this.literal, ((Expression)obj).literal);
    }

    public static class Expr
    extends Expression {
        private static final long serialVersionUID = 3865184718953833862L;

        public Expr(String literal) {
            super(literal);
        }
    }
}

