/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class In
extends AbstractCondition {
    private static final long serialVersionUID = 6765878262342593960L;
    final String propName;
    private List<?> values;

    In() {
        this.propName = null;
    }

    public In(String propName, Collection<?> values) {
        super(Operator.IN);
        N.checkArgNotNullOrEmpty(values, "'values' can't be null or empty");
        this.propName = propName;
        this.values = new ArrayList(values);
    }

    public String getPropName() {
        return this.propName;
    }

    public List<?> getValues() {
        return this.values;
    }

    public void setValues(List<?> values) {
        this.values = values;
    }

    @Override
    public List<Object> getParameters() {
        return this.values == null ? N.emptyList() : this.values;
    }

    @Override
    public void clearParameters() {
        if (N.notNullOrEmpty(this.values)) {
            N.fill(this.values, null);
        }
    }

    @Override
    public <T extends Condition> T copy() {
        In copy = (In)super.copy();
        copy.values = new ArrayList(this.values);
        return (T)copy;
    }

    @Override
    public String toString(NamingPolicy namingPolicy) {
        switch (namingPolicy) {
            case LOWER_CAMEL_CASE: {
                return this.propName + ' ' + this.getOperator().toString() + Joiner.with(", ", " (", ")").reuseCachedBuffer(true).appendAll(this.values).toString();
            }
            case LOWER_CASE_WITH_UNDERSCORE: {
                return ClassUtil.toLowerCaseWithUnderscore(this.propName) + ' ' + this.getOperator().toString() + Joiner.with(", ", " (", ")").reuseCachedBuffer(true).appendAll(this.values).toString();
            }
            case UPPER_CASE_WITH_UNDERSCORE: {
                return ClassUtil.toUpperCaseWithUnderscore(this.propName) + ' ' + this.getOperator().toString() + Joiner.with(", ", " (", ")").reuseCachedBuffer(true).appendAll(this.values).toString();
            }
        }
        throw new IllegalArgumentException("Unsupported naming policy: " + (Object)((Object)namingPolicy));
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + this.propName.hashCode();
        h = h * 31 + this.operator.hashCode();
        h = h * 31 + (this.values == null ? 0 : this.values.hashCode());
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof In) {
            In other = (In)obj;
            return N.equals(this.propName, other.propName) && N.equals((Object)this.operator, (Object)other.operator) && N.equals(this.values, other.values);
        }
        return false;
    }
}

