/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.ConditionFactory;
import com.landawn.abacus.condition.CriteriaUtil;
import com.landawn.abacus.condition.Expression;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Objectory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SubQuery
extends AbstractCondition {
    private static final long serialVersionUID = -2791944344613082244L;
    final String entityName;
    private Collection<String> propNames;
    final String sql;
    private Condition condition;

    SubQuery() {
        this.entityName = null;
        this.sql = null;
    }

    public SubQuery(String entityName, String sql) {
        super(Operator.EMPTY);
        this.entityName = entityName;
        if (N.isNullOrEmpty(sql)) {
            throw new IllegalArgumentException("The sql script can't be null or empty.");
        }
        this.propNames = null;
        this.condition = null;
        this.sql = sql;
    }

    public SubQuery(String entityName, Collection<String> propNames, Condition condition) {
        super(Operator.EMPTY);
        this.entityName = entityName;
        this.propNames = propNames;
        this.condition = condition == null || CriteriaUtil.isClause(condition) || condition instanceof Expression ? condition : ConditionFactory.CF.where(condition);
        this.sql = null;
    }

    public String getSql() {
        return this.sql;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Collection<String> getSelectPropNames() {
        return this.propNames;
    }

    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public List<Object> getParameters() {
        return this.condition == null ? N.emptyList() : this.condition.getParameters();
    }

    @Override
    public void clearParameters() {
        if (this.condition != null) {
            this.condition.clearParameters();
        }
    }

    @Override
    public <T extends Condition> T copy() {
        SubQuery result = (SubQuery)super.copy();
        if (this.propNames != null) {
            result.propNames = new ArrayList<String>(this.propNames);
        }
        if (this.condition != null) {
            result.condition = this.condition.copy();
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(NamingPolicy namingPolicy) {
        if (this.sql == null) {
            StringBuilder sb = Objectory.createStringBuilder();
            try {
                sb.append("SELECT");
                sb.append(' ');
                int i = 0;
                for (String propName : this.propNames) {
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(propName);
                }
                sb.append(' ');
                sb.append("FROM");
                sb.append(' ');
                sb.append(this.entityName);
                if (this.condition != null) {
                    sb.append(' ');
                    sb.append(this.condition.toString(namingPolicy));
                }
                String string = sb.toString();
                return string;
            }
            finally {
                Objectory.recycle(sb);
            }
        }
        return this.sql;
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + (this.sql == null ? 0 : this.sql.hashCode());
        h = h * 31 + (this.propNames == null ? 0 : this.propNames.hashCode());
        h = h * 31 + (this.condition == null ? 0 : this.condition.hashCode());
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubQuery) {
            SubQuery other = (SubQuery)obj;
            return N.equals(this.sql, other.sql) && N.equals(this.propNames, other.propNames) && N.equals(this.condition, other.condition);
        }
        return false;
    }
}

