/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.core;

import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.core.NameUtil;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.ExceptionUtil;
import com.landawn.abacus.util.N;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;

public abstract class AbstractDirtyMarker
implements DirtyMarker {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDirtyMarker.class);
    private static final String DIRTY_MARKER_IMPL_FIELD_NAME = "dirtyMarkerImpl";
    protected final String entityName;
    Set<String> signedPropNames = N.emptySet();
    Set<String> dirtyPropNames = N.emptySet();
    long version = -1L;
    boolean isFrozen = false;

    AbstractDirtyMarker() {
        this(N.EMPTY_STRING);
    }

    protected AbstractDirtyMarker(String entityName) {
        this.entityName = entityName;
        this.init();
    }

    protected void init() {
        this.signedPropNames = N.newHashSet();
        this.dirtyPropNames = N.newHashSet();
    }

    @Override
    public String entityName() {
        return this.entityName;
    }

    @Override
    @XmlTransient
    public boolean isDirty() {
        return this.dirtyPropNames.size() > 0;
    }

    @Override
    @XmlTransient
    public boolean isDirty(String propName) {
        if (NameUtil.isCanonicalName(this.entityName, propName)) {
            return this.dirtyPropNames.contains(NameUtil.getSimpleName(propName));
        }
        return this.dirtyPropNames.contains(propName);
    }

    @Override
    public void markDirty(boolean isDirty) {
        this.checkForzen();
        if (isDirty) {
            this.dirtyPropNames.addAll(this.signedPropNames());
        } else {
            this.dirtyPropNames.clear();
        }
    }

    @Override
    public void markDirty(String propName, boolean isDirty) {
        this.checkForzen();
        if (isDirty) {
            if (NameUtil.isCanonicalName(this.entityName, propName)) {
                this.dirtyPropNames.add(NameUtil.getSimpleName(propName));
            } else {
                this.dirtyPropNames.add(propName);
            }
        } else if (NameUtil.isCanonicalName(this.entityName, propName)) {
            this.dirtyPropNames.remove(NameUtil.getSimpleName(propName));
        } else {
            this.dirtyPropNames.remove(propName);
        }
    }

    @Override
    public void markDirty(Collection<String> propNames, boolean isDirty) {
        this.checkForzen();
        if (isDirty) {
            for (String propName : propNames) {
                if (NameUtil.isCanonicalName(this.entityName, propName)) {
                    this.dirtyPropNames.add(NameUtil.getSimpleName(propName));
                    continue;
                }
                this.dirtyPropNames.add(propName);
            }
        } else {
            for (String propName : propNames) {
                if (NameUtil.isCanonicalName(this.entityName, propName)) {
                    this.dirtyPropNames.remove(NameUtil.getSimpleName(propName));
                    continue;
                }
                this.dirtyPropNames.remove(propName);
            }
        }
    }

    @Override
    @XmlTransient
    public Set<String> signedPropNames() {
        return this.signedPropNames;
    }

    @Override
    @XmlTransient
    public Set<String> dirtyPropNames() {
        return this.dirtyPropNames;
    }

    @Override
    @XmlTransient
    public long version() {
        return this.version;
    }

    @Override
    public void freeze() {
        this.isFrozen = true;
    }

    @Override
    @XmlTransient
    public boolean frozen() {
        return this.isFrozen;
    }

    protected void setUpdatedPropName(String propName) {
        this.checkForzen();
        if (NameUtil.isCanonicalName(this.entityName, propName)) {
            propName = NameUtil.getSimpleName(propName);
        }
        this.signedPropNames.add(propName);
        this.dirtyPropNames.add(propName);
    }

    protected void setUpdatedPropNames(Collection<String> propNames) {
        this.checkForzen();
        for (String propName : propNames) {
            if (NameUtil.isCanonicalName(this.entityName, propName)) {
                propName = NameUtil.getSimpleName(propName);
            }
            this.signedPropNames.add(propName);
            this.dirtyPropNames.add(propName);
        }
    }

    protected void checkForzen() {
        if (this.isFrozen) {
            throw new IllegalStateException("This Entity is frozen, can't modify it.");
        }
    }

    protected boolean isEntityDirty(Collection<? extends DirtyMarker> entities) {
        if (entities == null) {
            return false;
        }
        for (DirtyMarker dirtyMarker : entities) {
            if (!dirtyMarker.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void markEntityDirty(Collection<? extends DirtyMarker> entities, boolean isDirty) {
        if (entities != null) {
            for (DirtyMarker dirtyMarker : entities) {
                dirtyMarker.markDirty(isDirty);
            }
        }
    }

    static AbstractDirtyMarker getDirtyMarkerImpl(DirtyMarker entity) {
        Object dirtyMarkerImpl;
        block5: {
            dirtyMarkerImpl = null;
            try {
                Field field = entity.getClass().getDeclaredField(DIRTY_MARKER_IMPL_FIELD_NAME);
                field.setAccessible(true);
                dirtyMarkerImpl = field.get(entity);
            }
            catch (NoSuchFieldException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn(ExceptionUtil.getMessage(e));
                }
            }
            catch (IllegalAccessException e) {
                if (!logger.isWarnEnabled()) break block5;
                logger.warn(ExceptionUtil.getMessage(e));
            }
        }
        if (dirtyMarkerImpl != null && dirtyMarkerImpl instanceof AbstractDirtyMarker) {
            return (AbstractDirtyMarker)dirtyMarkerImpl;
        }
        return null;
    }
}

