/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.core;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjectPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class NameUtil {
    static final int POOL_SIZE = (int)(Runtime.getRuntime().maxMemory() / 1024L) < 8192 ? 8192 : (int)(Runtime.getRuntime().maxMemory() / 1024L);
    private static final Map<String, String> cachedNamePool = new ObjectPool<String, String>(POOL_SIZE);
    private static final Map<String, String> simpleNamePool = new ObjectPool<String, String>(POOL_SIZE);
    private static final Map<String, Map<String, String>> parentCanonicalNamePool = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, String> parentNamePool = new ObjectPool<String, String>(POOL_SIZE);

    private NameUtil() {
    }

    public static boolean isCachedName(String str) {
        return cachedNamePool.containsKey(str);
    }

    public static String getCachedName(String str) {
        String cachedString = cachedNamePool.get(str);
        if (cachedString == null) {
            cachedString = NameUtil.cacheName(str, false);
        }
        return cachedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cacheName(String name, boolean force) {
        Map<String, String> map = cachedNamePool;
        synchronized (map) {
            if (force || !cachedNamePool.containsKey(name)) {
                name = name.intern();
                cachedNamePool.put(name, name);
            }
            return name;
        }
    }

    public static boolean isCanonicalName(String parentName, String name) {
        return name.length() > parentName.length() && name.charAt(parentName.length()) == '.' && parentName.equals(NameUtil.getParentName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCanonicalName(String parentName, String name) {
        String canonicalName = null;
        Map<String, String> canonicalNameMap = parentCanonicalNamePool.get(parentName);
        if (canonicalNameMap == null) {
            Map<String, Map<String, String>> map = parentCanonicalNamePool;
            synchronized (map) {
                canonicalNameMap = parentCanonicalNamePool.get(parentName);
                if (canonicalNameMap == null) {
                    canonicalNameMap = new ConcurrentHashMap<String, String>();
                    parentCanonicalNamePool.put(parentName, canonicalNameMap);
                }
            }
        }
        if ((canonicalName = canonicalNameMap.get(name)) == null) {
            int idx = name.indexOf(46);
            canonicalName = idx < 0 ? NameUtil.getCachedName(parentName + "." + name) : (parentName.equals(NameUtil.getParentName(name)) ? NameUtil.getCachedName(canonicalName) : N.EMPTY_STRING);
            canonicalNameMap.put(name, canonicalName);
        }
        return canonicalName;
    }

    public static String getSimpleName(String name) {
        String simplePropName = simpleNamePool.get(name);
        if (simplePropName == null) {
            int idx = name.lastIndexOf(46);
            simplePropName = idx < 0 ? NameUtil.getCachedName(name) : NameUtil.getCachedName(name.substring(idx + 1));
            simpleNamePool.put(name, simplePropName);
        }
        return simplePropName;
    }

    public static String getParentName(String name) {
        String parentName = parentNamePool.get(name);
        if (parentName == null) {
            int indx = name.lastIndexOf(46);
            parentName = indx < 1 ? N.EMPTY_STRING : NameUtil.getCachedName(name.substring(0, indx));
            parentNamePool.put(name, parentName);
        }
        return parentName;
    }
}

