/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HTTP;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpSettings;
import com.landawn.abacus.util.N;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;

public abstract class AbstractHttpClient
implements Closeable {
    public static final int DEFAULT_MAX_CONNECTION = 16;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 8000;
    public static final int DEFAULT_READ_TIMEOUT = 16000;
    protected final String _url;
    protected final int _maxConnection;
    protected final long _connTimeout;
    protected final long _readTimeout;
    protected final HttpSettings _settings;

    protected AbstractHttpClient(String url) {
        this(url, 16, 8000L, 16000L);
    }

    protected AbstractHttpClient(String url, int maxConnection) {
        this(url, maxConnection, 8000L, 16000L);
    }

    protected AbstractHttpClient(String url, int maxConnection, long connTimeout, long readTimeout) {
        this(url, maxConnection, connTimeout, readTimeout, null);
    }

    protected AbstractHttpClient(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings) throws UncheckedIOException {
        if (N.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("url can't be null or empty");
        }
        if (maxConnection < 0 || connTimeout < 0L || readTimeout < 0L) {
            throw new IllegalArgumentException("maxConnection, connTimeout or readTimeout can't be less than 0: " + maxConnection + ", " + connTimeout + ", " + readTimeout);
        }
        this._url = url;
        this._maxConnection = maxConnection == 0 ? 16 : maxConnection;
        this._connTimeout = connTimeout == 0L ? 8000L : connTimeout;
        this._readTimeout = readTimeout == 0L ? 16000L : readTimeout;
        this._settings = settings == null ? HttpSettings.create() : settings;
    }

    public String url() {
        return this._url;
    }

    public String get() throws UncheckedIOException {
        return this.get(String.class);
    }

    public String get(HttpSettings settings) throws UncheckedIOException {
        return this.get(String.class, settings);
    }

    public String get(Object queryParameters) throws UncheckedIOException {
        return this.get(String.class, queryParameters);
    }

    public String get(Object queryParameters, HttpSettings settings) throws UncheckedIOException {
        return this.get(String.class, queryParameters, settings);
    }

    public <T> T get(Class<T> resultClass) throws UncheckedIOException {
        return this.get(resultClass, null, this._settings);
    }

    public <T> T get(Class<T> resultClass, HttpSettings settings) throws UncheckedIOException {
        return this.get(resultClass, null, settings);
    }

    public <T> T get(Class<T> resultClass, Object queryParameters) throws UncheckedIOException {
        return this.get(resultClass, queryParameters, this._settings);
    }

    public <T> T get(Class<T> resultClass, Object queryParameters, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, HttpMethod.GET, queryParameters, settings);
    }

    public String delete() throws UncheckedIOException {
        return this.delete(String.class);
    }

    public String delete(HttpSettings settings) throws UncheckedIOException {
        return this.delete(String.class, settings);
    }

    public String delete(Object queryParameters) throws UncheckedIOException {
        return this.delete(String.class, queryParameters);
    }

    public String delete(Object queryParameters, HttpSettings settings) throws UncheckedIOException {
        return this.delete(String.class, queryParameters, settings);
    }

    public <T> T delete(Class<T> resultClass) throws UncheckedIOException {
        return this.delete(resultClass, null, this._settings);
    }

    public <T> T delete(Class<T> resultClass, HttpSettings settings) throws UncheckedIOException {
        return this.delete(resultClass, null, settings);
    }

    public <T> T delete(Class<T> resultClass, Object queryParameters) throws UncheckedIOException {
        return this.delete(resultClass, queryParameters, this._settings);
    }

    public <T> T delete(Class<T> resultClass, Object queryParameters, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, HttpMethod.DELETE, queryParameters, settings);
    }

    public String post(Object request) throws UncheckedIOException {
        return this.post(String.class, request);
    }

    public String post(Object request, HttpSettings settings) throws UncheckedIOException {
        return this.post(String.class, request, settings);
    }

    public <T> T post(Class<T> resultClass, Object request) throws UncheckedIOException {
        return this.post(resultClass, request, this._settings);
    }

    public <T> T post(Class<T> resultClass, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, HttpMethod.POST, request, settings);
    }

    public String put(Object request) throws UncheckedIOException {
        return this.put(String.class, request);
    }

    public String put(Object request, HttpSettings settings) throws UncheckedIOException {
        return this.put(String.class, request, settings);
    }

    public <T> T put(Class<T> resultClass, Object request) throws UncheckedIOException {
        return this.put(resultClass, request, this._settings);
    }

    public <T> T put(Class<T> resultClass, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, HttpMethod.PUT, request, settings);
    }

    public String execute(HttpMethod httpMethod, Object request) throws UncheckedIOException {
        return this.execute(String.class, httpMethod, request);
    }

    public String execute(HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(String.class, httpMethod, request, settings);
    }

    public <T> T execute(Class<T> resultClass, HttpMethod httpMethod, Object request) throws UncheckedIOException {
        return this.execute(resultClass, httpMethod, request, this._settings);
    }

    public abstract <T> T execute(Class<T> var1, HttpMethod var2, Object var3, HttpSettings var4) throws UncheckedIOException;

    public abstract void execute(File var1, HttpMethod var2, Object var3, HttpSettings var4) throws UncheckedIOException;

    public abstract void execute(OutputStream var1, HttpMethod var2, Object var3, HttpSettings var4) throws UncheckedIOException;

    public abstract void execute(Writer var1, HttpMethod var2, Object var3, HttpSettings var4) throws UncheckedIOException;

    @Override
    public void close() {
    }

    protected boolean isOneWayRequest(HttpSettings settings) {
        return this._settings.isOneWayRequest() || settings != null && settings.isOneWayRequest();
    }

    protected ContentFormat getContentFormat(HttpSettings settings) {
        String contentEncoding;
        String contentType;
        ContentFormat contentFormat = null;
        if (settings != null && (contentFormat = settings.getContentFormat()) == null) {
            contentType = (String)settings.headers().get("Content-Type");
            contentEncoding = (String)settings.headers().get("Content-Encoding");
            contentFormat = HTTP.getContentFormat(contentType, contentEncoding);
        }
        if (contentFormat == null && (contentFormat = this._settings.getContentFormat()) == null) {
            contentType = (String)this._settings.headers().get("Content-Type");
            contentEncoding = (String)this._settings.headers().get("Content-Encoding");
            contentFormat = HTTP.getContentFormat(contentType, contentEncoding);
        }
        return contentFormat;
    }

    protected String getContentType(HttpSettings settings) {
        String contentType = null;
        if (settings != null) {
            contentType = settings.getContentFormat() != null ? HTTP.getContentType(settings.getContentFormat()) : (String)settings.headers().get("Content-Type");
        }
        if (N.isNullOrEmpty(contentType)) {
            contentType = this._settings.getContentFormat() != null ? HTTP.getContentType(this._settings.getContentFormat()) : (String)this._settings.headers().get("Content-Type");
        }
        return contentType;
    }

    protected String getContentEncoding(HttpSettings settings) {
        String contentEncoding = null;
        if (settings != null) {
            contentEncoding = settings.getContentFormat() != null ? HTTP.getContentEncoding(settings.getContentFormat()) : (String)settings.headers().get("Content-Encoding");
        }
        if (N.isNullOrEmpty(contentEncoding)) {
            contentEncoding = this._settings.getContentFormat() != null ? HTTP.getContentEncoding(this._settings.getContentFormat()) : (String)this._settings.headers().get("Content-Encoding");
        }
        return contentEncoding;
    }
}

