/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.http.AbstractHttpClient;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpSettings;
import java.util.Map;

abstract class AbstractHttpRequest<S extends AbstractHttpRequest<S>> {
    final AbstractHttpClient httpClient;
    HttpMethod httpMethod;
    HttpSettings settings;
    Object request;

    AbstractHttpRequest(AbstractHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public S header(String name, Object value) {
        this.checkSettings();
        this.settings.header(name, value);
        return (S)this;
    }

    public S headers(String name1, Object value1, String name2, Object value2) {
        this.checkSettings();
        this.settings.headers(name1, value1, name2, value2);
        return (S)this;
    }

    public S headers(String name1, Object value1, String name2, Object value2, String name3, Object value3) {
        this.checkSettings();
        this.settings.headers(name1, value1, name2, value2, name3, value3);
        return (S)this;
    }

    public S headers(Map<String, Object> headers) {
        this.checkSettings();
        this.settings.headers(headers);
        return (S)this;
    }

    public S headers(HttpHeaders headers) {
        this.checkSettings();
        this.settings.headers(headers);
        return (S)this;
    }

    public String get() throws UncheckedIOException {
        return this.get(String.class);
    }

    public <T> T get(Class<T> resultClass) throws UncheckedIOException {
        return this.get(resultClass, null);
    }

    public String get(Object query) {
        return this.get(String.class, query);
    }

    public <T> T get(Class<T> resultClass, Object query) throws UncheckedIOException {
        this.httpMethod = HttpMethod.GET;
        this.request = query;
        return this.execute(resultClass);
    }

    public String post(Object body) {
        return this.post(String.class, body);
    }

    public <T> T post(Class<T> resultClass, Object body) throws UncheckedIOException {
        this.httpMethod = HttpMethod.POST;
        this.request = body;
        return this.execute(resultClass);
    }

    public String put(Object body) throws UncheckedIOException {
        return this.put(String.class, body);
    }

    public <T> T put(Class<T> resultClass, Object body) throws UncheckedIOException {
        this.httpMethod = HttpMethod.PUT;
        this.request = body;
        return this.execute(resultClass);
    }

    public String delete() throws UncheckedIOException {
        return this.delete(String.class);
    }

    public <T> T delete(Class<T> resultClass) throws UncheckedIOException {
        return this.delete(resultClass, null);
    }

    public String delete(Object query) throws UncheckedIOException {
        return this.delete(String.class, query);
    }

    public <T> T delete(Class<T> resultClass, Object query) throws UncheckedIOException {
        this.httpMethod = HttpMethod.DELETE;
        this.request = query;
        return this.execute(resultClass);
    }

    protected <T> T execute(Class<T> resultClass) {
        if (this.httpMethod == null) {
            throw new RuntimeException("HTTP method is not set");
        }
        switch (this.httpMethod) {
            case GET: {
                return this.httpClient.get(resultClass, this.request, this.settings);
            }
            case POST: {
                return this.httpClient.post(resultClass, this.request, this.settings);
            }
            case PUT: {
                return this.httpClient.put(resultClass, this.request, this.settings);
            }
            case DELETE: {
                return this.httpClient.delete(resultClass, this.request, this.settings);
            }
        }
        throw new RuntimeException("Unsupported HTTP method: " + (Object)((Object)this.httpMethod));
    }

    protected void checkSettings() {
        if (this.settings == null) {
            this.settings = new HttpSettings();
        }
    }
}

