/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.parser.DeserializationConfig;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.KryoParser;
import com.landawn.abacus.parser.Parser;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.LZ4BlockOutputStream;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjectPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

@Internal
public final class HTTP {
    static final String JSON = "json";
    static final String XML = "xml";
    static final String GZIP = "gzip";
    static final String SNAPPY = "snappy";
    static final String LZ4 = "lz4";
    static final String KRYO = "kryo";
    static final String URL_ENCODED = "urlencoded";
    static final JSONParser jsonParser = ParserFactory.createJSONParser();
    static final XMLParser xmlParser = ParserFactory.isXMLAvailable() ? ParserFactory.createXMLParser() : null;
    static final KryoParser kryoParser = ParserFactory.isKryoAvailable() ? ParserFactory.createKryoParser() : null;
    private static final Map<ContentFormat, Parser<?, ?>> contentFormat2Parser = new EnumMap(ContentFormat.class);
    private static final Map<ContentFormat, String> contentFormat2Type;
    private static final Map<ContentFormat, String> contentFormat2Encoding;
    private static final Map<String, Map<String, ContentFormat>> contentTypeEncoding2Format;

    public static String getContentType(ContentFormat contentFormat) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE) {
            return null;
        }
        return contentFormat2Type.get((Object)contentFormat);
    }

    public static String getContentEncoding(ContentFormat contentFormat) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE) {
            return null;
        }
        return contentFormat2Encoding.get((Object)contentFormat);
    }

    public static ContentFormat getContentFormat(String contentType, String contentEncoding) {
        Map<String, ContentFormat> contentEncoding2Format;
        if (contentType == null) {
            contentType = N.EMPTY_STRING;
        }
        if (contentEncoding == null) {
            contentEncoding = N.EMPTY_STRING;
        }
        if ((contentEncoding2Format = contentTypeEncoding2Format.get(contentType)) == null) {
            contentEncoding2Format = contentType.contains(JSON) ? contentTypeEncoding2Format.get("application/json") : (contentType.contains(XML) ? contentTypeEncoding2Format.get("application/xml") : (contentType.contains(KRYO) ? contentTypeEncoding2Format.get("application/kryo") : contentTypeEncoding2Format.get(N.EMPTY_STRING)));
        }
        return N.defaultIfNull(contentEncoding2Format.get(contentEncoding), ContentFormat.NONE);
    }

    public static ContentFormat getContentFormat(HttpURLConnection connection) {
        return HTTP.getContentFormat(connection.getHeaderField("Content-Type"), connection.getHeaderField("Content-Encoding"));
    }

    public static <SC extends SerializationConfig<?>, DC extends DeserializationConfig<?>> Parser<SC, DC> getParser(ContentFormat contentFormat) {
        if (contentFormat == null) {
            return jsonParser;
        }
        Parser<?, ?> parser = contentFormat2Parser.get((Object)contentFormat);
        if (parser == null) {
            throw new IllegalArgumentException("Unsupported content format: " + (Object)((Object)contentFormat));
        }
        return parser;
    }

    public static InputStream wrapInputStream(InputStream is, ContentFormat contentFormat) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE || is == null) {
            return is;
        }
        if (contentFormat.name().contains("GZIP")) {
            return IOUtil.newGZIPInputStream(is);
        }
        if (contentFormat.name().contains("SNAPPY")) {
            return IOUtil.newSnappyInputStream(is);
        }
        if (contentFormat.name().contains("LZ4")) {
            return IOUtil.newLZ4BlockInputStream(is);
        }
        return is;
    }

    public static OutputStream wrapOutputStream(OutputStream os, ContentFormat contentFormat) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE || os == null) {
            return os;
        }
        if (contentFormat.name().contains("GZIP")) {
            return IOUtil.newGZIPOutputStream(os);
        }
        if (contentFormat.name().contains("SNAPPY")) {
            return IOUtil.newSnappyOutputStream(os);
        }
        if (contentFormat.name().contains("LZ4")) {
            return IOUtil.newLZ4BlockOutputStream(os);
        }
        return os;
    }

    public static OutputStream getOutputStream(HttpURLConnection connection, ContentFormat contentFormat) throws IOException {
        return HTTP.getOutputStream(connection, contentFormat, HTTP.getContentType(contentFormat), HTTP.getContentEncoding(contentFormat));
    }

    public static OutputStream getOutputStream(HttpURLConnection connection, ContentFormat contentFormat, String contentType, String contentEncoding) throws IOException {
        if (N.isNullOrEmpty(contentType) && contentFormat != null) {
            contentType = HTTP.getContentType(contentFormat);
        }
        if (N.notNullOrEmpty(contentType)) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        if (N.isNullOrEmpty(contentEncoding) && contentFormat != null) {
            contentEncoding = HTTP.getContentEncoding(contentFormat);
        }
        if (N.notNullOrEmpty(contentEncoding)) {
            connection.setRequestProperty("Content-Encoding", contentEncoding);
        }
        return HTTP.wrapOutputStream(connection.getOutputStream(), contentFormat);
    }

    public static InputStream getInputStream(HttpURLConnection connection) throws IOException {
        return HTTP.getInputStream(connection, HTTP.getContentFormat(connection));
    }

    public static InputStream getInputStream(HttpURLConnection connection, ContentFormat contentFormat) throws IOException {
        return HTTP.wrapInputStream(connection.getInputStream(), contentFormat);
    }

    public static InputStream getInputOrErrorStream(HttpURLConnection connection) throws IOException {
        return HTTP.getInputOrErrorStream(connection, HTTP.getContentFormat(connection));
    }

    public static InputStream getInputOrErrorStream(HttpURLConnection connection, ContentFormat contentFormat) throws IOException {
        try {
            return N.defaultIfNull(HTTP.wrapInputStream(connection.getInputStream(), contentFormat), N.emptyInputStream());
        }
        catch (IOException e) {
            return N.defaultIfNull(HTTP.wrapInputStream(connection.getErrorStream(), contentFormat), N.emptyInputStream());
        }
    }

    public static void flush(OutputStream os) throws IOException {
        if (os instanceof LZ4BlockOutputStream) {
            ((LZ4BlockOutputStream)os).finish();
        } else if (os instanceof GZIPOutputStream) {
            ((GZIPOutputStream)os).finish();
        }
        os.flush();
    }

    public static Charset getCharset(HttpHeaders headers) {
        String contentType;
        Charset charset = Charsets.UTF_8;
        if (headers != null && headers.headerNameSet().contains("Content-Type") && N.notNullOrEmpty(contentType = N.stringOf(headers.get("Content-Type"))) && contentType.indexOf("charset=") >= 0) {
            charset = HTTP.getCharset(contentType);
        }
        return charset;
    }

    public static Charset getCharset(Map<String, ?> headers) {
        Charset charset = Charsets.UTF_8;
        if (headers != null && headers.containsKey("Content-Type")) {
            Object values = headers.get("Content-Type");
            if (values instanceof Collection) {
                for (String contentType : (Collection)values) {
                    if (!N.notNullOrEmpty(contentType) || contentType.indexOf("charset=") < 0) continue;
                    charset = HTTP.getCharset(contentType);
                    break;
                }
            } else {
                String str = N.stringOf(values);
                if (N.notNullOrEmpty(str) && str.indexOf("charset=") >= 0) {
                    charset = HTTP.getCharset(str);
                }
            }
        }
        return charset;
    }

    public static Charset getCharset(String contentType) {
        if (N.notNullOrEmpty(contentType)) {
            return Charsets.UTF_8;
        }
        int fromIndex = contentType.indexOf("charset=");
        int toIndex = contentType.indexOf(59, fromIndex);
        return Charsets.get(contentType.substring(fromIndex + "charset=".length(), toIndex > 0 ? toIndex : contentType.length()));
    }

    static {
        contentFormat2Parser.put(ContentFormat.JSON, jsonParser);
        contentFormat2Parser.put(ContentFormat.JSON_LZ4, jsonParser);
        contentFormat2Parser.put(ContentFormat.JSON_SNAPPY, jsonParser);
        contentFormat2Parser.put(ContentFormat.JSON_GZIP, jsonParser);
        contentFormat2Parser.put(ContentFormat.XML, xmlParser);
        contentFormat2Parser.put(ContentFormat.XML_LZ4, xmlParser);
        contentFormat2Parser.put(ContentFormat.XML_SNAPPY, xmlParser);
        contentFormat2Parser.put(ContentFormat.XML_GZIP, xmlParser);
        contentFormat2Parser.put(ContentFormat.KRYO, kryoParser);
        contentFormat2Parser.put(ContentFormat.NONE, jsonParser);
        contentFormat2Parser.put(ContentFormat.LZ4, jsonParser);
        contentFormat2Parser.put(ContentFormat.SNAPPY, jsonParser);
        contentFormat2Parser.put(ContentFormat.GZIP, jsonParser);
        contentFormat2Type = new EnumMap<ContentFormat, String>(ContentFormat.class);
        contentFormat2Type.put(ContentFormat.XML, "application/xml");
        contentFormat2Type.put(ContentFormat.XML_LZ4, "application/xml");
        contentFormat2Type.put(ContentFormat.XML_SNAPPY, "application/xml");
        contentFormat2Type.put(ContentFormat.XML_GZIP, "application/xml");
        contentFormat2Type.put(ContentFormat.JSON, "application/json");
        contentFormat2Type.put(ContentFormat.JSON_LZ4, "application/json");
        contentFormat2Type.put(ContentFormat.JSON_SNAPPY, "application/json");
        contentFormat2Type.put(ContentFormat.JSON_GZIP, "application/json");
        contentFormat2Type.put(ContentFormat.KRYO, "application/kryo");
        contentFormat2Encoding = new EnumMap<ContentFormat, String>(ContentFormat.class);
        contentFormat2Encoding.put(ContentFormat.XML_GZIP, GZIP);
        contentFormat2Encoding.put(ContentFormat.XML_SNAPPY, SNAPPY);
        contentFormat2Encoding.put(ContentFormat.XML_LZ4, LZ4);
        contentFormat2Encoding.put(ContentFormat.JSON_GZIP, GZIP);
        contentFormat2Encoding.put(ContentFormat.JSON_SNAPPY, SNAPPY);
        contentFormat2Encoding.put(ContentFormat.JSON_LZ4, LZ4);
        contentFormat2Encoding.put(ContentFormat.GZIP, GZIP);
        contentFormat2Encoding.put(ContentFormat.SNAPPY, SNAPPY);
        contentFormat2Encoding.put(ContentFormat.LZ4, LZ4);
        contentFormat2Encoding.put(ContentFormat.KRYO, KRYO);
        contentTypeEncoding2Format = new ObjectPool<String, Map<String, ContentFormat>>(64);
        for (Map.Entry<ContentFormat, String> entry : contentFormat2Type.entrySet()) {
            Map<String, ContentFormat> contentEncoding2Format = contentTypeEncoding2Format.get(entry.getValue());
            if (contentEncoding2Format == null) {
                contentEncoding2Format = new HashMap<String, ContentFormat>();
                contentTypeEncoding2Format.put(entry.getValue(), contentEncoding2Format);
            }
            if (entry.getKey().name().contains("GZIP")) {
                contentEncoding2Format.put(GZIP, entry.getKey());
                continue;
            }
            if (entry.getKey().name().contains("SNAPPY")) {
                contentEncoding2Format.put(SNAPPY, entry.getKey());
                continue;
            }
            if (entry.getKey().name().contains("LZ4")) {
                contentEncoding2Format.put(LZ4, entry.getKey());
                continue;
            }
            if (entry.getKey().name().contains("KRYO")) {
                contentEncoding2Format.put(KRYO, entry.getKey());
                contentEncoding2Format.put(N.EMPTY_STRING, entry.getKey());
                continue;
            }
            contentEncoding2Format.put(N.EMPTY_STRING, entry.getKey());
        }
        Map<String, ContentFormat> contentEncoding2Format = contentTypeEncoding2Format.get(N.EMPTY_STRING);
        if (contentEncoding2Format == null) {
            contentEncoding2Format = new HashMap<String, ContentFormat>();
            contentTypeEncoding2Format.put(N.EMPTY_STRING, contentEncoding2Format);
        }
        contentEncoding2Format.put(GZIP, ContentFormat.GZIP);
        contentEncoding2Format.put(SNAPPY, ContentFormat.SNAPPY);
        contentEncoding2Format.put(LZ4, ContentFormat.LZ4);
        contentEncoding2Format.put(KRYO, ContentFormat.KRYO);
        contentEncoding2Format.put(N.EMPTY_STRING, ContentFormat.NONE);
    }
}

