/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.http.AbstractHttpClient;
import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HTTP;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpResponse;
import com.landawn.abacus.http.HttpSettings;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.URLEncodedUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public final class HttpClient
extends AbstractHttpClient {
    static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    protected final URL _netURL;
    protected final AtomicInteger _activeConnectionCounter;

    protected HttpClient(String url) {
        this(url, 16);
    }

    protected HttpClient(String url, int maxConnection) {
        this(url, maxConnection, 8000L, 16000L);
    }

    protected HttpClient(String url, int maxConnection, long connTimeout, long readTimeout) {
        this(url, maxConnection, connTimeout, readTimeout, null);
    }

    protected HttpClient(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings) throws UncheckedIOException {
        this(url, maxConnection, connTimeout, readTimeout, settings, new AtomicInteger(0));
    }

    protected HttpClient(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings, AtomicInteger sharedActiveConnectionCounter) {
        super(url, maxConnection, connTimeout, readTimeout, settings);
        try {
            this._netURL = new URL(url);
        }
        catch (MalformedURLException e) {
            throw N.toRuntimeException(e);
        }
        this._activeConnectionCounter = sharedActiveConnectionCounter;
    }

    public static HttpClient create(String url) {
        return new HttpClient(url);
    }

    public static HttpClient create(String url, int maxConnection) {
        return new HttpClient(url, maxConnection);
    }

    public static HttpClient create(String url, long connTimeout, long readTimeout) {
        return new HttpClient(url, 16, connTimeout, readTimeout);
    }

    public static HttpClient create(String url, int maxConnection, long connTimeout, long readTimeout) {
        return new HttpClient(url, maxConnection, connTimeout, readTimeout);
    }

    public static HttpClient create(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings) throws UncheckedIOException {
        return new HttpClient(url, maxConnection, connTimeout, readTimeout, settings);
    }

    public static HttpClient create(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings, AtomicInteger sharedActiveConnectionCounter) {
        return new HttpClient(url, maxConnection, connTimeout, readTimeout, settings, sharedActiveConnectionCounter);
    }

    @Override
    public <T> T execute(Class<T> resultClass, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, null, null, httpMethod, request, settings);
    }

    @Override
    public void execute(File output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(output);
            this.execute(os, httpMethod, request, settings);
        }
        catch (FileNotFoundException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void execute(OutputStream output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        this.execute(null, output, null, httpMethod, request, settings);
    }

    @Override
    public void execute(Writer output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        this.execute(null, null, output, httpMethod, request, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> T execute(Class<T> resultClass, OutputStream outputStream, Writer outputWriter, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        Charset respCharset;
        ContentFormat respContentFormat;
        OutputStream os;
        InputStream is;
        HttpURLConnection connection;
        block55: {
            block54: {
                block53: {
                    block52: {
                        Map<String, List<String>> respHeaders;
                        int code;
                        long sentRequestAtMillis;
                        block50: {
                            block49: {
                                block48: {
                                    ContentFormat requestContentFormat = this.getContentFormat(settings);
                                    connection = this.openConnection(httpMethod, request, request != null, settings);
                                    Charset requestCharset = HTTP.getCharset(settings == null || settings.headers().isEmpty() ? this._settings.headers() : settings.headers());
                                    sentRequestAtMillis = System.currentTimeMillis();
                                    is = null;
                                    os = null;
                                    if (request != null && (httpMethod.equals((Object)HttpMethod.POST) || httpMethod.equals((Object)HttpMethod.PUT))) {
                                        os = HTTP.getOutputStream(connection, requestContentFormat, this.getContentType(settings), this.getContentEncoding(settings));
                                        Type type = N.typeOf(request.getClass());
                                        if (request instanceof File) {
                                            try (FileInputStream fileInputStream = new FileInputStream((File)request);){
                                                IOUtil.write(os, (InputStream)fileInputStream);
                                            }
                                        }
                                        if (type.isInputStream()) {
                                            IOUtil.write(os, (InputStream)request);
                                        } else {
                                            BufferedWriter bw;
                                            if (type.isReader()) {
                                                bw = Objectory.createBufferedWriter(new OutputStreamWriter(os, requestCharset));
                                                try {
                                                    IOUtil.write((Writer)bw, (Reader)request);
                                                    bw.flush();
                                                }
                                                finally {
                                                    Objectory.recycle(bw);
                                                }
                                            }
                                            if (request instanceof String) {
                                                IOUtil.write(os, ((String)request).getBytes(requestCharset));
                                            } else if (request.getClass().equals(byte[].class)) {
                                                IOUtil.write(os, (byte[])request);
                                            } else if (requestContentFormat == ContentFormat.KRYO && HTTP.kryoParser != null) {
                                                HTTP.kryoParser.serialize(os, request);
                                            } else {
                                                bw = Objectory.createBufferedWriter(new OutputStreamWriter(os, requestCharset));
                                                try {
                                                    HTTP.getParser(requestContentFormat).serialize(bw, request);
                                                    bw.flush();
                                                }
                                                finally {
                                                    Objectory.recycle(bw);
                                                }
                                            }
                                        }
                                        HTTP.flush(os);
                                    }
                                    respContentFormat = HTTP.getContentFormat(connection);
                                    code = connection.getResponseCode();
                                    respHeaders = connection.getHeaderFields();
                                    respCharset = HTTP.getCharset(respHeaders);
                                    is = HTTP.getInputOrErrorStream(connection, respContentFormat);
                                    if (!(code >= 200 && code < 300 || resultClass != null && resultClass.equals(HttpResponse.class))) {
                                        throw new UncheckedIOException(new IOException(code + ": " + connection.getResponseMessage() + ". " + IOUtil.readString(is, respCharset)));
                                    }
                                    if (!this.isOneWayRequest(settings)) break block48;
                                    T t = null;
                                    this.close(os, is, connection);
                                    return t;
                                }
                                if (outputStream == null) break block49;
                                IOUtil.write(outputStream, is, true);
                                T t = null;
                                this.close(os, is, connection);
                                return t;
                            }
                            if (outputWriter == null) break block50;
                            BufferedReader br = Objectory.createBufferedReader(new InputStreamReader(is, respCharset));
                            try {
                                IOUtil.write(outputWriter, (Reader)br, true);
                            }
                            finally {
                                Objectory.recycle(br);
                            }
                            T t = null;
                            this.close(os, is, connection);
                            return t;
                        }
                        if (resultClass == null || !resultClass.equals(HttpResponse.class)) break block52;
                        HttpResponse br = new HttpResponse(sentRequestAtMillis, System.currentTimeMillis(), code, connection.getResponseMessage(), respHeaders, IOUtil.readBytes(is), respContentFormat);
                        this.close(os, is, connection);
                        return (T)br;
                    }
                    if (resultClass != null && !resultClass.equals(String.class)) break block53;
                    String br = IOUtil.readString(is, respCharset);
                    this.close(os, is, connection);
                    return (T)br;
                }
                if (!byte[].class.equals(resultClass)) break block54;
                byte[] br = IOUtil.readBytes(is);
                this.close(os, is, connection);
                return (T)br;
            }
            if (respContentFormat != ContentFormat.KRYO || HTTP.kryoParser == null) break block55;
            Object br = HTTP.kryoParser.deserialize((Class)resultClass, is);
            this.close(os, is, connection);
            return (T)br;
        }
        BufferedReader br = Objectory.createBufferedReader(new InputStreamReader(is, respCharset));
        T t = HTTP.getParser(respContentFormat).deserialize(resultClass, br);
        Objectory.recycle(br);
        this.close(os, is, connection);
        return t;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Objectory.recycle(br);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                catch (Throwable throwable2) {
                    this.close(os, is, connection);
                    throw throwable2;
                }
            }
        }
    }

    HttpURLConnection openConnection(HttpMethod httpMethod) throws UncheckedIOException {
        return this.openConnection(httpMethod, HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.PUT.equals((Object)httpMethod));
    }

    HttpURLConnection openConnection(HttpMethod httpMethod, boolean doOutput) throws UncheckedIOException {
        return this.openConnection(httpMethod, doOutput, this._settings);
    }

    HttpURLConnection openConnection(HttpMethod httpMethod, HttpSettings settings) throws UncheckedIOException {
        return this.openConnection(httpMethod, HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.PUT.equals((Object)httpMethod), settings);
    }

    HttpURLConnection openConnection(HttpMethod httpMethod, boolean doOutput, HttpSettings settings) throws UncheckedIOException {
        return this.openConnection(httpMethod, null, doOutput, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpURLConnection openConnection(HttpMethod httpMethod, Object queryParameters, boolean doOutput, HttpSettings settings) throws UncheckedIOException {
        HttpURLConnection connection = null;
        if (this._activeConnectionCounter.incrementAndGet() > this._maxConnection) {
            this._activeConnectionCounter.decrementAndGet();
            throw new AbacusException("Can not get connection, exceeded max connection number: " + this._maxConnection);
        }
        try {
            int readTimeout;
            int connTimeout;
            SSLSocketFactory ssf;
            URL uRL = this._netURL;
            synchronized (uRL) {
                connection = queryParameters != null && (httpMethod.equals((Object)HttpMethod.GET) || httpMethod.equals((Object)HttpMethod.DELETE)) ? (HttpURLConnection)new URL(URLEncodedUtil.encode(this._url, queryParameters)).openConnection() : (HttpURLConnection)this._netURL.openConnection();
            }
            if (connection instanceof HttpsURLConnection && (ssf = (settings == null ? this._settings : settings).getSSLSocketFactory()) != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(ssf);
            }
            int n = connTimeout = this._connTimeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._connTimeout;
            if (settings != null) {
                connTimeout = settings.getConnectionTimeout();
            }
            if (connTimeout > 0) {
                connection.setConnectTimeout(connTimeout);
            }
            int n2 = readTimeout = this._readTimeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._readTimeout;
            if (settings != null) {
                readTimeout = settings.getReadTimeout();
            }
            if (readTimeout > 0) {
                connection.setReadTimeout(readTimeout);
            }
            if (settings != null) {
                connection.setDoInput(settings.doInput());
                connection.setDoOutput(settings.doOutput());
            }
            connection.setUseCaches(settings != null && settings.getUseCaches() || this._settings != null && this._settings.getUseCaches());
            this.setHttpProperties(connection, settings == null || settings.headers().isEmpty() ? this._settings : settings);
            if (this.isOneWayRequest(settings)) {
                connection.setDoInput(false);
            }
            connection.setDoOutput(doOutput);
            connection.setRequestMethod(httpMethod.name());
            return connection;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void setHttpProperties(HttpURLConnection connection, HttpSettings settings) throws UncheckedIOException {
        HttpHeaders headers = settings.headers();
        if (headers != null) {
            Object headerValue = null;
            for (String headerName : headers.headerNameSet()) {
                headerValue = headers.get(headerName);
                if (headerValue instanceof Collection) {
                    Iterator iter = ((Collection)headerValue).iterator();
                    if (iter.hasNext()) {
                        connection.setRequestProperty(headerName, N.stringOf(iter.next()));
                    }
                    while (iter.hasNext()) {
                        connection.addRequestProperty(headerName, N.stringOf(iter.next()));
                    }
                    continue;
                }
                connection.setRequestProperty(headerName, N.stringOf(headerValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(OutputStream os, InputStream is, HttpURLConnection connection) {
        try {
            IOUtil.closeQuietly(os);
            IOUtil.closeQuietly(is);
        }
        finally {
            this._activeConnectionCounter.decrementAndGet();
        }
    }

    static {
        if (!IOUtil.IS_PLATFORM_ANDROID) {
            int maxConnections = IOUtil.CPU_CORES * 8;
            System.setProperty("http.keepAlive", "true");
            System.setProperty("http.maxConnections", String.valueOf(maxConnections));
        }
    }
}

