/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.core.MapEntity;
import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.Field;
import com.landawn.abacus.http.HTTP;
import com.landawn.abacus.http.HttpClient;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpSettings;
import com.landawn.abacus.http.MessageEncryption;
import com.landawn.abacus.http.Path;
import com.landawn.abacus.http.RestMethod;
import com.landawn.abacus.http.SecurityDTO;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.DeserializationConfig;
import com.landawn.abacus.parser.Parser;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.AndroidUtil;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.function.Function;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpProxy {
    private static final Logger logger = LoggerFactory.getLogger(HttpProxy.class);
    private static final int DEFAULT_MAX_CONNECTION = 16;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 8000;
    private static final int DEFAULT_READ_TIMEOUT = 16000;
    private static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
    private static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
    private static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");

    public static <T> T createClientProxy(Class<T> interfaceClass, ContentFormat contentFormat, String url) {
        return HttpProxy.createClientProxy(interfaceClass, contentFormat, url, 16, 8000L, 16000L);
    }

    public static <T> T createClientProxy(Class<T> interfaceClass, ContentFormat contentFormat, String url, Config config) {
        return HttpProxy.createClientProxy(interfaceClass, contentFormat, url, 16, 8000L, 16000L, config);
    }

    public static <T> T createClientProxy(Class<T> interfaceClass, ContentFormat contentFormat, String url, int maxConnection) {
        return HttpProxy.createClientProxy(interfaceClass, contentFormat, url, maxConnection, 8000L, 16000L);
    }

    public static <T> T createClientProxy(Class<T> interfaceClass, ContentFormat contentFormat, String url, int maxConnection, long connTimeout, long readTimeout) {
        return HttpProxy.createClientProxy(interfaceClass, contentFormat, url, maxConnection, connTimeout, readTimeout, null);
    }

    public static <T> T createClientProxy(final Class<T> interfaceClass, final ContentFormat contentFormat, final String url, final int maxConnection, final long connTimeout, final long readTimeout, final Config config) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE) {
            throw new IllegalArgumentException("Content format can't be null or NONE");
        }
        InvocationHandler h = new InvocationHandler(){
            private final Logger _logger;
            private final ContentFormat _contentFormat;
            private final String _url;
            private final int _maxConnection;
            private final long _connTimeout;
            private final long _readTimeout;
            private final Config _config;
            private final AtomicInteger sharedActiveConnectionCounter;
            private final Map<String, HttpClient> _httpClientPool;
            private final HttpClient _httpClient;
            private final Executor _asyncExecutor;
            {
                this._logger = LoggerFactory.getLogger(interfaceClass);
                this._contentFormat = contentFormat;
                this._url = url;
                this._maxConnection = maxConnection;
                this._connTimeout = connTimeout;
                this._readTimeout = readTimeout;
                this._config = config == null ? new Config() : N.copy(config);
                Set<Method> declaredMethods = N.asLinkedHashSet(interfaceClass.getDeclaredMethods());
                for (Class<?> superClass : interfaceClass.getInterfaces()) {
                    declaredMethods.addAll(Arrays.asList(superClass.getDeclaredMethods()));
                }
                if (this._config.parser == null) {
                    this._config.setParser(HTTP.getParser(this._contentFormat));
                }
                HashMap<String, OperationConfig> newOperationConfigs = new HashMap<String, OperationConfig>(N.initHashCapacity(declaredMethods.size()));
                if (config != null && N.notNullOrEmpty(config.operationConfigs)) {
                    for (Map.Entry entry : config.operationConfigs.entrySet()) {
                        OperationConfig copy;
                        OperationConfig operationConfig = copy = entry.getValue() == null ? new OperationConfig() : (OperationConfig)N.copy(entry.getValue());
                        if (entry.getValue() != null && ((OperationConfig)entry.getValue()).getRequestSettings() != null) {
                            copy.setRequestSettings(((OperationConfig)entry.getValue()).getRequestSettings().copy());
                        }
                        newOperationConfigs.put((String)entry.getKey(), copy);
                    }
                }
                this._config.setOperationConfigs(newOperationConfigs);
                for (Method method : declaredMethods) {
                    String methodName = method.getName();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    int parameterCount = parameterTypes.length;
                    OperationConfig operationConfig = (OperationConfig)this._config.operationConfigs.get(methodName);
                    if (operationConfig == null) {
                        operationConfig = new OperationConfig();
                        this._config.operationConfigs.put(methodName, operationConfig);
                    }
                    operationConfig.requestEntityName = StringUtil.capitalize(methodName) + "Request";
                    operationConfig.responseEntityName = StringUtil.capitalize(methodName) + "Response";
                    RestMethod methodInfo = null;
                    for (Annotation methodAnnotation : method.getAnnotations()) {
                        Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
                        for (Annotation innerAnnotation : annotationType.getAnnotations()) {
                            if (RestMethod.class != innerAnnotation.annotationType()) continue;
                            methodInfo = (RestMethod)innerAnnotation;
                            break;
                        }
                        if (methodInfo == null) continue;
                        if (N.isNullOrEmpty(operationConfig.getRequestUrl())) {
                            try {
                                String path = (String)annotationType.getMethod("value", new Class[0]).invoke((Object)methodAnnotation, new Object[0]);
                                if (N.notNullOrEmpty(path)) {
                                    operationConfig.setRequestUrl(path);
                                }
                            }
                            catch (Exception e) {
                                throw new AbacusException("Failed to extract String 'value' from @%s annotation:" + annotationType.getSimpleName());
                            }
                        }
                        if (operationConfig.getHttpMethod() != null) break;
                        operationConfig.setHttpMethod(HttpMethod.valueOf(methodInfo.value()));
                        break;
                    }
                    if (N.isNullOrEmpty(operationConfig.paramNameTypeMap)) {
                        operationConfig.paramTypes = new Type[parameterCount];
                        operationConfig.paramFields = new Field[parameterCount];
                        operationConfig.paramPaths = new Path[parameterCount];
                        operationConfig.paramNameTypeMap = new HashMap();
                        Annotation[][] parameterAnnotationArrays = method.getParameterAnnotations();
                        for (int i = 0; i < parameterCount; ++i) {
                            operationConfig.paramTypes[i] = N.typeOf(parameterTypes[i]);
                            for (Annotation parameterAnnotation : parameterAnnotationArrays[i]) {
                                if (parameterAnnotation.annotationType() == Field.class) {
                                    operationConfig.paramFields[i] = (Field)parameterAnnotation;
                                    if (operationConfig.paramNameTypeMap.put(operationConfig.paramFields[i].value(), operationConfig.paramTypes[i]) == null) continue;
                                    throw new AbacusException("Duplicated parameter names: " + operationConfig.paramFields[i].value());
                                }
                                if (parameterAnnotation.annotationType() != Path.class) continue;
                                operationConfig.validatePathName(((Path)parameterAnnotation).value());
                                operationConfig.paramPaths[i] = (Path)parameterAnnotation;
                                if (operationConfig.paramNameTypeMap.put(operationConfig.paramPaths[i].value(), operationConfig.paramTypes[i]) == null) continue;
                                throw new AbacusException("Duplicated parameter names: " + operationConfig.paramPaths[i].value());
                            }
                        }
                    }
                    if (operationConfig.httpMethod == null) {
                        operationConfig.httpMethod = HttpMethod.POST;
                    } else if (operationConfig.httpMethod != HttpMethod.GET && operationConfig.httpMethod != HttpMethod.POST && operationConfig.httpMethod != HttpMethod.PUT && operationConfig.httpMethod != HttpMethod.DELETE) {
                        throw new IllegalArgumentException("Unsupported http method: " + (Object)((Object)operationConfig.httpMethod));
                    }
                    if (parameterCount > 1 && operationConfig.paramNameTypeMap.isEmpty()) {
                        throw new IllegalArgumentException("Unsupported web service method: " + method.getName() + ". Only one parameter or multi parameters with Field/Path annotaions are supported");
                    }
                    if (N.notNullOrEmpty(operationConfig.requestUrl)) {
                        if (!StringUtil.startsWithIgnoreCase(operationConfig.requestUrl, "http:") && !StringUtil.startsWithIgnoreCase(operationConfig.requestUrl, "https:")) {
                            if (this._url.endsWith("/") || this._url.endsWith("\\")) {
                                if (operationConfig.requestUrl.startsWith("/") || operationConfig.requestUrl.startsWith("\\")) {
                                    operationConfig.requestUrl = this._url + operationConfig.requestUrl.substring(1);
                                } else {
                                    operationConfig.requestUrl = this._url + operationConfig.requestUrl;
                                }
                            } else if (operationConfig.requestUrl.startsWith("/") || operationConfig.requestUrl.startsWith("\\")) {
                                operationConfig.requestUrl = this._url + operationConfig.requestUrl;
                            } else {
                                operationConfig.requestUrl = this._url + "/" + operationConfig.requestUrl;
                            }
                        }
                    } else if (this._config.requestByOperatioName) {
                        String operationNameUrl = null;
                        operationNameUrl = this._config.requestUrlNamingPolicy == NamingPolicy.LOWER_CASE_WITH_UNDERSCORE ? ClassUtil.toLowerCaseWithUnderscore(methodName) : (this._config.requestUrlNamingPolicy == NamingPolicy.UPPER_CASE_WITH_UNDERSCORE ? ClassUtil.toUpperCaseWithUnderscore(methodName) : methodName);
                        if (this._url.endsWith("/") || this._url.endsWith("\\")) {
                            operationConfig.requestUrl = this._url + operationNameUrl;
                        } else {
                            operationConfig.requestUrl = this._url + "/" + operationNameUrl;
                        }
                    } else {
                        operationConfig.requestUrl = this._url;
                    }
                    if (!N.notNullOrEmpty(this._config.getEncryptionUserName()) && !N.notNullOrEmpty(this._config.getEncryptionPassword()) || !N.isNullOrEmpty(operationConfig.getEncryptionUserName()) || !N.isNullOrEmpty(operationConfig.getEncryptionPassword())) continue;
                    if (N.isNullOrEmpty(operationConfig.getEncryptionUserName())) {
                        operationConfig.setEncryptionUserName(this._config.getEncryptionUserName());
                    }
                    if (N.isNullOrEmpty(operationConfig.getEncryptionPassword())) {
                        operationConfig.setEncryptionPassword(this._config.getEncryptionPassword());
                    }
                    if (operationConfig.getEncryptionMessage() == null) {
                        operationConfig.setEncryptionMessage(this._config.getEncryptionMessage());
                    }
                    if (operationConfig.getEncryptionMessage() != null) continue;
                    operationConfig.setEncryptionMessage(MessageEncryption.NONE);
                }
                if (config != null && config.getRequestSettings() != null) {
                    this._config.setRequestSettings(config.getRequestSettings().copy());
                }
                this.sharedActiveConnectionCounter = new AtomicInteger(0);
                this._httpClientPool = new HashMap<String, HttpClient>(N.initHashCapacity(this._config.operationConfigs.size()));
                this._httpClient = HttpClient.create(this._url, this._maxConnection, this._connTimeout, this._readTimeout, this._config.getRequestSettings(), this.sharedActiveConnectionCounter);
                Executor executor = null;
                if (this._config.executedByThreadPool) {
                    if (this._config.getAsyncExecutor() != null) {
                        executor = this._config.getAsyncExecutor();
                    } else if (IOUtil.IS_PLATFORM_ANDROID) {
                        executor = AndroidUtil.getThreadPoolExecutor();
                    } else {
                        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(Math.max(8, IOUtil.CPU_CORES), Math.max(16, IOUtil.CPU_CORES), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
                        threadPoolExecutor.allowCoreThreadTimeOut(true);
                        executor = threadPoolExecutor;
                    }
                }
                this._asyncExecutor = executor;
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (_asyncExecutor instanceof ExecutorService) {
                            ExecutorService executorService = (ExecutorService)_asyncExecutor;
                            logger.warn("Starting to shutdown task in HttpProxy");
                            try {
                                executorService.shutdown();
                                executorService.awaitTermination(60L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                logger.warn("Not all the requests/tasks executed in HttpProxy are completed successfully before shutdown.");
                            }
                            finally {
                                logger.warn("Completed to shutdown task in HttpProxy");
                            }
                        }
                    }
                });
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                String methodName = method.getName();
                OperationConfig operationConfig = (OperationConfig)this._config.operationConfigs.get(methodName);
                if (operationConfig.getRetryTimes() > 0) {
                    try {
                        return this.invoke(method, args);
                    }
                    catch (Exception e) {
                        this._logger.error("Failed to call: " + method.getName(), (Throwable)e);
                        int retryTimes = operationConfig.getRetryTimes();
                        long retryInterval = operationConfig.getRetryInterval();
                        Function<Throwable, Boolean> ifRetry = operationConfig.getIfRetry();
                        int retriedTimes = 0;
                        Exception throwable = e;
                        while (retriedTimes++ < retryTimes && (ifRetry == null || ifRetry.apply(e).booleanValue())) {
                            try {
                                if (retryInterval > 0L) {
                                    N.sleep(retryInterval);
                                }
                                return this.invoke(method, args);
                            }
                            catch (Exception e2) {
                                throwable = e2;
                            }
                        }
                        throw N.toRuntimeException(throwable);
                    }
                }
                return this.invoke(method, args);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invoke(final Method method, final Object[] args) throws InterruptedException, ExecutionException {
                if (this._config.executedByThreadPool) {
                    Callable<Object> cmd = new Callable<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object call() throws Exception {
                            if (_config.handler == null) {
                                return this.execute(method, args);
                            }
                            _config.handler.preInvoke(method, args);
                            Object result = null;
                            Exception exception = null;
                            try {
                                result = this.execute(method, args);
                            }
                            catch (Exception e) {
                                exception = e;
                            }
                            finally {
                                result = _config.handler.postInvoke(exception, result, method, args);
                            }
                            return result;
                        }
                    };
                    FutureTask<Object> futureTask = new FutureTask<Object>(cmd);
                    this._asyncExecutor.execute(futureTask);
                    return futureTask.get();
                }
                if (this._config.handler == null) {
                    return this.execute(method, args);
                }
                this._config.handler.preInvoke(method, args);
                Object result = null;
                Exception exception = null;
                try {
                    result = this.execute(method, args);
                }
                catch (Exception e) {
                    exception = e;
                }
                finally {
                    result = this._config.handler.postInvoke(exception, result, method, args);
                }
                return result;
            }

            private Object execute(Method method, Object[] args) {
                Parser responseParser;
                Charset charset;
                ContentFormat responseContentFormat;
                HttpURLConnection connection;
                OutputStream os;
                InputStream is;
                Class<?> returnType;
                HttpClient httpClient;
                block27: {
                    String methodName = method.getName();
                    OperationConfig operationConfig = (OperationConfig)this._config.operationConfigs.get(methodName);
                    Object requestParameter = this.readRequestParameter(args, operationConfig);
                    if (N.notNullOrEmpty(operationConfig.getEncryptionUserName()) && N.notNullOrEmpty(operationConfig.getEncryptionPassword())) {
                        ((SecurityDTO)requestParameter).encrypt(operationConfig.getEncryptionUserName(), operationConfig.getEncryptionPassword(), operationConfig.getEncryptionMessage());
                    }
                    httpClient = this.getHttpClient(method, requestParameter, operationConfig);
                    returnType = method.getReturnType();
                    if (this._logger.isInfoEnabled()) {
                        this._logger.info(this._config.parser.serialize(requestParameter, this._config.sc));
                    }
                    is = null;
                    os = null;
                    connection = httpClient.openConnection(operationConfig.httpMethod, operationConfig.requestSettings);
                    if (requestParameter != null && (operationConfig.httpMethod == HttpMethod.POST || operationConfig.httpMethod == HttpMethod.PUT)) {
                        os = HTTP.getOutputStream(connection, this._contentFormat);
                        switch (this._contentFormat) {
                            case JSON: 
                            case JSON_LZ4: 
                            case JSON_SNAPPY: 
                            case JSON_GZIP: {
                                Type<Object> type = N.typeOf(requestParameter.getClass());
                                if (type.isSerializable()) {
                                    os.write(type.stringOf(requestParameter).getBytes());
                                    break;
                                }
                                this._config.parser.serialize(os, requestParameter, this._config.sc);
                                break;
                            }
                            case XML: 
                            case XML_LZ4: 
                            case XML_SNAPPY: 
                            case XML_GZIP: {
                                if (requestParameter instanceof Map) {
                                    this._config.parser.serialize(os, (Object)MapEntity.valueOf(operationConfig.requestEntityName, (Map)requestParameter), this._config.sc);
                                    break;
                                }
                                this._config.parser.serialize(os, requestParameter, this._config.sc);
                                break;
                            }
                            case KRYO: {
                                this._config.parser.serialize(os, requestParameter, this._config.sc);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported content type: " + this._contentFormat.toString());
                            }
                        }
                        HTTP.flush(os);
                    } else {
                        String contentEncoding;
                        String contentType = HTTP.getContentType(this._contentFormat);
                        if (N.notNullOrEmpty(contentType)) {
                            connection.setRequestProperty("Content-Type", contentType);
                        }
                        if (N.notNullOrEmpty(contentEncoding = HTTP.getContentEncoding(this._contentFormat))) {
                            connection.setRequestProperty("Content-Encoding", contentEncoding);
                        }
                    }
                    responseContentFormat = HTTP.getContentFormat(connection);
                    Map<String, List<String>> respHeaders = connection.getHeaderFields();
                    charset = HTTP.getCharset(respHeaders);
                    responseParser = responseContentFormat == this._contentFormat ? this._config.parser : HTTP.getParser(responseContentFormat);
                    is = HTTP.getInputStream(connection, responseContentFormat);
                    if (!Void.TYPE.equals(returnType)) break block27;
                    Object var15_16 = null;
                    httpClient.close(os, is, connection);
                    return var15_16;
                }
                try {
                    Object result = null;
                    Type type = null;
                    switch (responseContentFormat) {
                        case JSON: 
                        case JSON_LZ4: 
                        case JSON_SNAPPY: 
                        case JSON_GZIP: {
                            type = N.typeOf(returnType);
                            if (type.isSerializable()) {
                                result = type.valueOf(IOUtil.readString(is, charset));
                                break;
                            }
                            result = responseParser.deserialize(returnType, IOUtil.newBufferedReader(is, charset), this._config.dc);
                            break;
                        }
                        case XML: 
                        case XML_LZ4: 
                        case XML_SNAPPY: 
                        case XML_GZIP: {
                            result = responseParser.deserialize(returnType, IOUtil.newBufferedReader(is, charset), this._config.dc);
                            break;
                        }
                        case KRYO: {
                            result = responseParser.deserialize(returnType, is, this._config.dc);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported content type: " + responseContentFormat.toString());
                        }
                    }
                    if (this._logger.isInfoEnabled()) {
                        if (type != null && type.isSerializable()) {
                            this._logger.info(type.stringOf(result));
                        } else {
                            this._logger.info(this._config.parser.serialize(result, this._config.sc));
                        }
                    }
                    Object t = result;
                    httpClient.close(os, is, connection);
                    return t;
                }
                catch (IOException e) {
                    try {
                        throw new UncheckedIOException(e);
                    }
                    catch (Throwable throwable) {
                        httpClient.close(os, is, connection);
                        throw throwable;
                    }
                }
            }

            private Object readRequestParameter(Object[] args, OperationConfig operationConfig) {
                if (N.isNullOrEmpty(args)) {
                    return null;
                }
                if (operationConfig.paramNameTypeMap.isEmpty()) {
                    return args[0];
                }
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                int len = args.length;
                for (int i = 0; i < len; ++i) {
                    if (operationConfig.paramFields[i] != null) {
                        parameterMap.put(operationConfig.paramFields[i].value(), args[i]);
                        continue;
                    }
                    if (operationConfig.paramPaths[i] == null) continue;
                    parameterMap.put(operationConfig.paramPaths[i].value(), args[i] == null ? "null" : (operationConfig.paramPaths[i].encode() ? N.urlEncode(N.stringOf(args[i])) : N.stringOf(args[i])));
                }
                return parameterMap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private HttpClient getHttpClient(Method method, Object parameter, OperationConfig operationConfig) {
                String methodName = method.getName();
                HttpClient httpClient = null;
                if (operationConfig.httpMethod == HttpMethod.POST || operationConfig.httpMethod == HttpMethod.PUT || parameter == null) {
                    Map<String, HttpClient> map = this._httpClientPool;
                    synchronized (map) {
                        httpClient = this._httpClientPool.get(methodName);
                        if (httpClient == null) {
                            httpClient = operationConfig.requestUrl.equals(this._url) ? this._httpClient : HttpClient.create(operationConfig.requestUrl, this._maxConnection, this._connTimeout, this._readTimeout, this._config.getRequestSettings(), this.sharedActiveConnectionCounter);
                            this._httpClientPool.put(methodName, httpClient);
                        }
                    }
                } else {
                    Type type = N.typeOf(parameter.getClass());
                    String requestUrl = operationConfig.requestUrl;
                    if (N.notNullOrEmpty(operationConfig.requestUrlParamNames)) {
                        Map m = parameter;
                        for (Map.Entry<String, String> entry : operationConfig.requestUrlParamNames.entrySet()) {
                            requestUrl = requestUrl.replace(entry.getValue(), m.remove(entry.getKey()).toString());
                        }
                    }
                    if (!type.isMap() || ((Map)parameter).size() != 0) {
                        if (this._config.requestParamNamingPolicy == null || this._config.requestParamNamingPolicy == NamingPolicy.LOWER_CAMEL_CASE) {
                            requestUrl = requestUrl + "?" + N.urlEncode(parameter);
                        } else {
                            Map<String, Object> newParameter = parameter;
                            if (type.isEntity()) {
                                newParameter = Maps.entity2Map(parameter, !DirtyMarkerUtil.isDirtyMarker(parameter.getClass()), null, this._config.requestParamNamingPolicy);
                            } else if (type.isMap()) {
                                Map m = parameter;
                                LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                                switch (this._config.requestParamNamingPolicy) {
                                    case LOWER_CASE_WITH_UNDERSCORE: 
                                    case UPPER_CASE_WITH_UNDERSCORE: {
                                        for (Map.Entry entry : m.entrySet()) {
                                            newMap.put(this._config.requestParamNamingPolicy.convert((String)entry.getKey()), entry.getValue());
                                        }
                                        break;
                                    }
                                    case LOWER_CAMEL_CASE: {
                                        newMap.putAll(m);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Unsupported Naming policy: " + (Object)((Object)this._config.requestParamNamingPolicy));
                                    }
                                }
                                newParameter = newMap;
                            }
                            requestUrl = requestUrl + "?" + N.urlEncode(newParameter);
                        }
                    }
                    httpClient = HttpClient.create(requestUrl, this._maxConnection, this._connTimeout, this._readTimeout, this._config.getRequestSettings(), this.sharedActiveConnectionCounter);
                }
                return httpClient;
            }
        };
        return N.newProxyInstance(N.asArray(interfaceClass), h);
    }

    static Set<String> parsePathParameters(String path) {
        Matcher m = PARAM_URL_REGEX.matcher(path);
        Set<String> patterns = N.newLinkedHashSet();
        while (m.find()) {
            patterns.add(m.group(1));
        }
        return patterns;
    }

    public static interface Handler {
        public void preInvoke(Method var1, Object ... var2);

        public Object postInvoke(Throwable var1, Object var2, Method var3, Object ... var4);
    }

    public static class OperationConfig {
        private String requestUrl;
        private HttpMethod httpMethod;
        private HttpSettings requestSettings;
        private int retryTimes;
        private long retryInterval;
        private Function<Throwable, Boolean> ifRetry;
        private String encryptionUserName;
        private byte[] encryptionPassword;
        private MessageEncryption encryptionMessage;
        String requestEntityName;
        String responseEntityName;
        Map<String, String> requestUrlParamNames;
        Type<?>[] paramTypes;
        Field[] paramFields;
        Path[] paramPaths;
        Map<String, Type<?>> paramNameTypeMap;

        public String getRequestUrl() {
            return this.requestUrl;
        }

        public OperationConfig setRequestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
            this.requestUrlParamNames = new LinkedHashMap<String, String>();
            Matcher m = PARAM_URL_REGEX.matcher(requestUrl);
            while (m.find()) {
                this.requestUrlParamNames.put(m.group(1), m.group());
            }
            return this;
        }

        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        public OperationConfig setHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public HttpSettings getRequestSettings() {
            return this.requestSettings;
        }

        public OperationConfig setRequestSettings(HttpSettings requestSettings) {
            this.requestSettings = requestSettings;
            return this;
        }

        public int getRetryTimes() {
            return this.retryTimes;
        }

        public OperationConfig setRetryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public long getRetryInterval() {
            return this.retryInterval;
        }

        public OperationConfig setRetryInterval(long retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Function<Throwable, Boolean> getIfRetry() {
            return this.ifRetry;
        }

        public OperationConfig setIfRetry(Function<Throwable, Boolean> ifRetry) {
            this.ifRetry = ifRetry;
            return this;
        }

        public String getEncryptionUserName() {
            return this.encryptionUserName;
        }

        public OperationConfig setEncryptionUserName(String encryptionUserName) {
            this.encryptionUserName = encryptionUserName;
            return this;
        }

        public byte[] getEncryptionPassword() {
            return this.encryptionPassword;
        }

        public OperationConfig setEncryptionPassword(byte[] encryptionPassword) {
            this.encryptionPassword = encryptionPassword;
            return this;
        }

        public MessageEncryption getEncryptionMessage() {
            return this.encryptionMessage;
        }

        public OperationConfig setEncryptionMessage(MessageEncryption encryptionMessage) {
            this.encryptionMessage = encryptionMessage;
            return this;
        }

        void validatePathName(String name) {
            if (!PARAM_NAME_REGEX.matcher(name).matches()) {
                throw new AbacusException(String.format("@Path parameter name must match %s. Found: %s", PARAM_URL_REGEX.pattern(), name));
            }
            if (!this.requestUrlParamNames.containsKey(name)) {
                throw new AbacusException(String.format("URL \"%s\" does not contain \"{%s}\".", this.requestUrl, name));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.httpMethod == null ? 0 : this.httpMethod.hashCode());
            result = 31 * result + (this.requestUrl == null ? 0 : this.requestUrl.hashCode());
            result = 31 * result + (this.requestSettings == null ? 0 : this.requestSettings.hashCode());
            result = 31 * result + this.retryTimes;
            result = 31 * result + (int)this.retryInterval;
            result = 31 * result + (this.ifRetry == null ? 0 : this.ifRetry.hashCode());
            result = 31 * result + (this.encryptionUserName == null ? 0 : this.encryptionUserName.hashCode());
            result = 31 * result + (this.encryptionPassword == null ? 0 : N.hashCode(this.encryptionPassword));
            result = 31 * result + (this.encryptionMessage == null ? 0 : this.encryptionMessage.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OperationConfig) {
                OperationConfig other = (OperationConfig)obj;
                return N.equals((Object)this.httpMethod, (Object)other.httpMethod) && N.equals(this.requestUrl, other.requestUrl) && N.equals(this.requestSettings, other.requestSettings) && N.equals(this.retryTimes, other.retryTimes) && N.equals(this.retryInterval, other.retryInterval) && N.equals(this.ifRetry, other.ifRetry) && N.equals(this.encryptionUserName, other.encryptionUserName) && N.equals(this.encryptionPassword, other.encryptionPassword) && N.equals((Object)this.encryptionMessage, (Object)other.encryptionMessage);
            }
            return false;
        }

        public String toString() {
            return "{httpMethod=" + (Object)((Object)this.httpMethod) + ", requestUrl=" + this.requestUrl + ", requestSettings=" + this.requestSettings + ", retryTimes=" + this.retryTimes + ", retryInterval=" + this.retryInterval + ", ifRetry=" + this.ifRetry + "}";
        }
    }

    public static final class Config {
        private Parser<SerializationConfig<?>, DeserializationConfig<?>> parser;
        private SerializationConfig<?> sc;
        private DeserializationConfig<?> dc;
        private Handler handler;
        private boolean executedByThreadPool;
        private Executor asyncExecutor;
        private HttpSettings requestSettings;
        private Map<String, OperationConfig> operationConfigs;
        private boolean requestByOperatioName;
        private NamingPolicy requestUrlNamingPolicy;
        private NamingPolicy requestParamNamingPolicy;
        private String encryptionUserName;
        private byte[] encryptionPassword;
        private MessageEncryption encryptionMessage;

        public Parser<SerializationConfig<?>, DeserializationConfig<?>> getParser() {
            return this.parser;
        }

        public Config setParser(Parser<SerializationConfig<?>, DeserializationConfig<?>> parser) {
            this.parser = parser;
            return this;
        }

        public SerializationConfig<?> getSerializationConfig() {
            return this.sc;
        }

        public Config setSerializationConfig(SerializationConfig<?> sc) {
            this.sc = sc;
            return this;
        }

        public DeserializationConfig<?> getDeserializationConfig() {
            return this.dc;
        }

        public Config setDeserializationConfig(DeserializationConfig<?> dc) {
            this.dc = dc;
            return this;
        }

        public boolean isExecutedByThreadPool() {
            return this.executedByThreadPool;
        }

        public Config setExecutedByThreadPool(boolean executedByThreadPool) {
            this.executedByThreadPool = executedByThreadPool;
            return this;
        }

        public Executor getAsyncExecutor() {
            return this.asyncExecutor;
        }

        public Config setAsyncExecutor(Executor asyncExecutor) {
            this.asyncExecutor = asyncExecutor;
            return this;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public Config setHandler(Handler handler) {
            this.handler = handler;
            return this;
        }

        public HttpSettings getRequestSettings() {
            return this.requestSettings;
        }

        public Config setRequestSettings(HttpSettings requestSettings) {
            this.requestSettings = requestSettings;
            return this;
        }

        public boolean isRequestByOperatioName() {
            return this.requestByOperatioName;
        }

        public Config setRequestByOperatioName(boolean requestByOperatioName) {
            this.requestByOperatioName = requestByOperatioName;
            return this;
        }

        public NamingPolicy getRequestUrlNamingPolicy() {
            return this.requestUrlNamingPolicy;
        }

        public Config setRequestUrlNamingPolicy(NamingPolicy requestUrlNamingPolicy) {
            this.requestUrlNamingPolicy = requestUrlNamingPolicy;
            return this;
        }

        public NamingPolicy getRequestParamNamingPolicy() {
            return this.requestParamNamingPolicy;
        }

        public Config setRequestParamNamingPolicy(NamingPolicy requestParamNamingPolicy) {
            this.requestParamNamingPolicy = requestParamNamingPolicy;
            return this;
        }

        public Map<String, OperationConfig> getOperationConfigs() {
            return this.operationConfigs;
        }

        public Config setOperationConfigs(Map<String, OperationConfig> operationConfigs) {
            this.operationConfigs = operationConfigs;
            return this;
        }

        public String getEncryptionUserName() {
            return this.encryptionUserName;
        }

        public Config setEncryptionUserName(String encryptionUserName) {
            this.encryptionUserName = encryptionUserName;
            return this;
        }

        public byte[] getEncryptionPassword() {
            return this.encryptionPassword;
        }

        public Config setEncryptionPassword(byte[] encryptionPassword) {
            this.encryptionPassword = encryptionPassword;
            return this;
        }

        public MessageEncryption getEncryptionMessage() {
            return this.encryptionMessage;
        }

        public Config setEncryptionMessage(MessageEncryption encryptionMessage) {
            this.encryptionMessage = encryptionMessage;
            return this;
        }

        public String toString() {
            return "{parser=" + this.parser + ", sc=" + this.sc + ", dc=" + this.dc + ", handler=" + this.handler + ", executedByThreadPool=" + this.executedByThreadPool + ", asyncExecutor=" + this.asyncExecutor + ", requestSettings=" + this.requestSettings + ", requestByOperatioName=" + this.requestByOperatioName + ", requestUrlNamingPolicy=" + (Object)((Object)this.requestUrlNamingPolicy) + ", requestParamNamingPolicy=" + (Object)((Object)this.requestParamNamingPolicy) + ", operationConfigs=" + this.operationConfigs + "}";
        }
    }
}

