/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.http.AbstractHttpClient;
import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HTTP;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpResponse;
import com.landawn.abacus.http.HttpSettings;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.ByteArrayOutputStream;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.URLEncodedUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class OKHttpClient
extends AbstractHttpClient {
    static final Logger logger = LoggerFactory.getLogger(OKHttpClient.class);
    private static final Map<String, MediaType> mediaTypePool = new ConcurrentHashMap<String, MediaType>();
    private final OkHttpClient client;
    private final AtomicInteger _activeConnectionCounter;

    protected OKHttpClient(String url) {
        this(url, 16);
    }

    protected OKHttpClient(String url, int maxConnection) {
        this(url, maxConnection, 8000L, 16000L);
    }

    protected OKHttpClient(String url, int maxConnection, long connTimeout, long readTimeout) {
        this(url, maxConnection, connTimeout, readTimeout, null);
    }

    protected OKHttpClient(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings) throws UncheckedIOException {
        this(url, maxConnection, connTimeout, readTimeout, settings, new AtomicInteger(0));
    }

    protected OKHttpClient(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings, AtomicInteger sharedActiveConnectionCounter) {
        super(url, maxConnection, connTimeout, readTimeout, settings);
        SSLSocketFactory ssf = settings == null ? null : settings.getSSLSocketFactory();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (ssf != null) {
            builder.socketFactory((SocketFactory)ssf);
        }
        this.client = builder.connectionPool(new ConnectionPool(Math.min(8, maxConnection), 5L, TimeUnit.MINUTES)).connectTimeout(connTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).build();
        this._activeConnectionCounter = sharedActiveConnectionCounter;
    }

    protected OKHttpClient(OkHttpClient client, String url, int maxConnection) {
        this(client, url, maxConnection, null);
    }

    protected OKHttpClient(OkHttpClient client, String url, int maxConnection, HttpSettings settings) throws UncheckedIOException {
        this(client, url, maxConnection, settings, new AtomicInteger(0));
    }

    protected OKHttpClient(OkHttpClient client, String url, int maxConnection, HttpSettings settings, AtomicInteger sharedActiveConnectionCounter) {
        super(url, maxConnection, client.connectTimeoutMillis(), client.readTimeoutMillis(), settings);
        this.client = client;
        this._activeConnectionCounter = sharedActiveConnectionCounter;
    }

    public static OKHttpClient create(String url) {
        return new OKHttpClient(url);
    }

    public static OKHttpClient create(String url, int maxConnection) {
        return new OKHttpClient(url, maxConnection);
    }

    public static OKHttpClient create(String url, long connTimeout, long readTimeout) {
        return new OKHttpClient(url, 16, connTimeout, readTimeout);
    }

    public static OKHttpClient create(String url, int maxConnection, long connTimeout, long readTimeout) {
        return new OKHttpClient(url, maxConnection, connTimeout, readTimeout);
    }

    public static OKHttpClient create(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings) throws UncheckedIOException {
        return new OKHttpClient(url, maxConnection, connTimeout, readTimeout, settings);
    }

    public static OKHttpClient create(String url, int maxConnection, long connTimeout, long readTimeout, HttpSettings settings, AtomicInteger sharedActiveConnectionCounter) {
        return new OKHttpClient(url, maxConnection, connTimeout, readTimeout, settings, sharedActiveConnectionCounter);
    }

    public static OKHttpClient create(OkHttpClient client, String url, int maxConnection) {
        return new OKHttpClient(client, url, maxConnection);
    }

    public static OKHttpClient create(OkHttpClient client, String url, int maxConnection, HttpSettings settings) throws UncheckedIOException {
        return new OKHttpClient(client, url, maxConnection, settings);
    }

    public static OKHttpClient create(OkHttpClient client, String url, int maxConnection, HttpSettings settings, AtomicInteger sharedActiveConnectionCounter) {
        return new OKHttpClient(client, url, maxConnection, settings, sharedActiveConnectionCounter);
    }

    @Override
    public <T> T execute(Class<T> resultClass, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, null, null, httpMethod, request, settings);
    }

    @Override
    public void execute(File output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(output);
            this.execute(os, httpMethod, request, settings);
        }
        catch (FileNotFoundException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void execute(OutputStream output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        this.execute(null, output, null, httpMethod, request, settings);
    }

    @Override
    public void execute(Writer output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        this.execute(null, null, output, httpMethod, request, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(Class<T> resultClass, OutputStream outputStream, Writer outputWriter, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        if (this._activeConnectionCounter.incrementAndGet() > this._maxConnection) {
            this._activeConnectionCounter.decrementAndGet();
            throw new AbacusException("Can not get connection, exceeded max connection number: " + this._maxConnection);
        }
        ContentFormat requestContentFormat = this.getContentFormat(settings);
        String contentType = this.getContentType(settings);
        String contentEncoding = this.getContentEncoding(settings);
        Charset requestCharset = HTTP.getCharset(settings == null || settings.headers().isEmpty() ? this._settings.headers() : settings.headers());
        Request httpRequest = null;
        Response httpResponse = null;
        boolean closeOkHttpResponse = true;
        try {
            T t;
            Object br;
            OutputStream os;
            Request.Builder requestBuilder = new Request.Builder().url(request != null && (httpMethod.equals((Object)HttpMethod.GET) || httpMethod.equals((Object)HttpMethod.DELETE)) ? URLEncodedUtil.encode(this._url, request) : this._url);
            this.setHeaders(requestBuilder, settings == null ? this._settings : settings);
            if (request != null && (httpMethod.equals((Object)HttpMethod.POST) || httpMethod.equals((Object)HttpMethod.PUT))) {
                MediaType mediaType = null;
                if (N.notNullOrEmpty(contentType) && (mediaType = mediaTypePool.get(contentType)) == null && (mediaType = MediaType.parse((String)contentType)) != null) {
                    mediaTypePool.put(contentType, mediaType);
                }
                RequestBody body = null;
                Type type = N.typeOf(request.getClass());
                ByteArrayOutputStream bos = Objectory.createByteArrayOutputStream();
                try {
                    os = HTTP.wrapOutputStream(bos, requestContentFormat);
                    if (request instanceof File) {
                        try (FileInputStream fileInputStream = new FileInputStream((File)request);){
                            IOUtil.write(os, (InputStream)fileInputStream);
                        }
                    }
                    if (type.isInputStream()) {
                        IOUtil.write(os, (InputStream)request);
                    } else {
                        BufferedWriter bw;
                        if (type.isReader()) {
                            bw = Objectory.createBufferedWriter(new OutputStreamWriter(os, requestCharset));
                            try {
                                IOUtil.write((Writer)bw, (Reader)request);
                                bw.flush();
                            }
                            finally {
                                Objectory.recycle(bw);
                            }
                        }
                        if (request instanceof String) {
                            IOUtil.write(os, ((String)request).getBytes(requestCharset));
                        } else if (request.getClass().equals(byte[].class)) {
                            IOUtil.write(os, (byte[])request);
                        } else if (requestContentFormat == ContentFormat.KRYO && HTTP.kryoParser != null) {
                            HTTP.kryoParser.serialize(os, request);
                        } else {
                            bw = Objectory.createBufferedWriter(new OutputStreamWriter(os, requestCharset));
                            try {
                                HTTP.getParser(requestContentFormat).serialize(bw, request);
                                bw.flush();
                            }
                            finally {
                                Objectory.recycle(bw);
                            }
                        }
                    }
                    HTTP.flush(os);
                    body = RequestBody.create((MediaType)mediaType, (byte[])bos.toByteArray());
                }
                finally {
                    Objectory.recycle(bos);
                }
                requestBuilder.method(httpMethod.name(), body);
                if (N.notNullOrEmpty(contentType)) {
                    requestBuilder.addHeader("Content-Type", contentType);
                }
                if (N.notNullOrEmpty(contentEncoding)) {
                    requestBuilder.addHeader("Content-Encoding", contentEncoding);
                }
            } else {
                requestBuilder.method(httpMethod.name(), null);
            }
            httpRequest = requestBuilder.build();
            httpResponse = this.client.newCall(httpRequest).execute();
            Map respHeaders = httpResponse.headers().toMultimap();
            Charset respCharset = HTTP.getCharset(respHeaders);
            ContentFormat respContentFormat = HTTP.getContentFormat(httpResponse.header("Content-Type"), httpResponse.header("Content-Encoding"));
            InputStream is = N.defaultIfNull(HTTP.wrapInputStream(httpResponse.body().byteStream(), respContentFormat), N.emptyInputStream());
            if (!(httpResponse.isSuccessful() || resultClass != null && (resultClass.equals(HttpResponse.class) || resultClass.equals(Response.class)))) {
                throw new UncheckedIOException(new IOException(httpResponse.code() + ": " + httpResponse.message() + ". " + IOUtil.readString(is, respCharset)));
            }
            if (this.isOneWayRequest(settings)) {
                os = null;
                return (T)os;
            }
            if (resultClass != null && resultClass.equals(Response.class)) {
                closeOkHttpResponse = false;
                os = httpResponse;
                return (T)os;
            }
            if (outputStream != null) {
                IOUtil.write(outputStream, is, true);
                os = null;
                return (T)os;
            }
            if (outputWriter != null) {
                br = Objectory.createBufferedReader(new InputStreamReader(is, respCharset));
                try {
                    IOUtil.write(outputWriter, (Reader)br, true);
                }
                finally {
                    Objectory.recycle((BufferedReader)br);
                }
                t = null;
                return t;
            }
            if (resultClass != null && resultClass.equals(HttpResponse.class)) {
                br = new HttpResponse(httpResponse.sentRequestAtMillis(), httpResponse.receivedResponseAtMillis(), httpResponse.code(), httpResponse.message(), respHeaders, IOUtil.readBytes(is), respContentFormat);
                return (T)br;
            }
            if (resultClass == null || resultClass.equals(String.class)) {
                br = IOUtil.readString(is, respCharset);
                return (T)br;
            }
            if (byte[].class.equals(resultClass)) {
                br = IOUtil.readBytes(is);
                return (T)br;
            }
            if (respContentFormat == ContentFormat.KRYO && HTTP.kryoParser != null) {
                br = HTTP.kryoParser.deserialize((Class)resultClass, is);
                return (T)br;
            }
            br = Objectory.createBufferedReader(new InputStreamReader(is, respCharset));
            try {
                t = HTTP.getParser(respContentFormat).deserialize(resultClass, (Reader)br);
            }
            catch (Throwable throwable) {
                try {
                    Objectory.recycle((BufferedReader)br);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Objectory.recycle((BufferedReader)br);
            return t;
        }
        finally {
            this._activeConnectionCounter.decrementAndGet();
            if (httpResponse != null && closeOkHttpResponse) {
                httpResponse.close();
            }
        }
    }

    private void setHeaders(Request.Builder requestBuilder, HttpSettings settings) throws UncheckedIOException {
        HttpHeaders headers = settings.headers();
        if (headers != null) {
            Object headerValue = null;
            for (String headerName : headers.headerNameSet()) {
                headerValue = headers.get(headerName);
                if (headerValue instanceof Collection) {
                    Iterator iter = ((Collection)headerValue).iterator();
                    if (iter.hasNext()) {
                        requestBuilder.header(headerName, N.stringOf(iter.next()));
                    }
                    while (iter.hasNext()) {
                        requestBuilder.addHeader(headerName, N.stringOf(iter.next()));
                    }
                    continue;
                }
                requestBuilder.header(headerName, N.stringOf(headerValue));
            }
        }
    }
}

