/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.http.HTTP;
import com.landawn.abacus.http.MessageEncryption;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.util.ByteArrayOutputStream;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.WSSecurityUtil;
import java.io.Serializable;

public abstract class SecurityDTO
implements Serializable {
    private static final long serialVersionUID = -386078752923025834L;
    private static final JSONSerializationConfig jsc = JSONSerializationConfig.JSC.of(false, false);
    private String userName;
    private String password;
    private String nonce;
    private String created;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void encrypt(String userName, String password) {
        this.encrypt(userName, password.getBytes(Charsets.UTF_8), MessageEncryption.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encrypt(String userName, byte[] password, MessageEncryption msgEncryption) {
        this.setUserName(null);
        this.setPassword(null);
        this.setNonce(null);
        this.setCreated(null);
        byte[] nonce = null;
        switch (msgEncryption) {
            case NONE: {
                nonce = WSSecurityUtil.generateNonce(32);
                break;
            }
            case JSON: {
                ByteArrayOutputStream os = Objectory.createByteArrayOutputStream();
                try {
                    HTTP.jsonParser.serialize(os, (Object)this, jsc);
                    nonce = os.toByteArray();
                    break;
                }
                finally {
                    Objectory.recycle(os);
                }
            }
            case KRYO: {
                ByteArrayOutputStream os = Objectory.createByteArrayOutputStream();
                try {
                    HTTP.kryoParser.serialize(os, (Object)this);
                    nonce = os.toByteArray();
                    break;
                }
                finally {
                    Objectory.recycle(os);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported Message encryption way: " + (Object)((Object)msgEncryption));
            }
        }
        String created = String.valueOf(System.currentTimeMillis());
        this.setUserName(userName);
        this.setPassword(WSSecurityUtil.doPasswordDigest(nonce, created.getBytes(Charsets.UTF_8), password));
        this.setNonce(N.base64Encode(nonce));
        this.setCreated(created);
    }

    public boolean decrypt(String userName, String password) {
        return this.decrypt(userName, password.getBytes(Charsets.UTF_8), MessageEncryption.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrypt(String userName, byte[] password, MessageEncryption msgEncryption) {
        long ceratedTime;
        long now = System.currentTimeMillis();
        if (now - (ceratedTime = Long.valueOf(this.getCreated()).longValue()) > 180000L || !this.getUserName().equals(userName)) {
            return false;
        }
        String orgUserName = this.getUserName();
        String orgPassword = this.getPassword();
        String orgNonce = this.getNonce();
        String orgCreated = this.getCreated();
        this.setUserName(null);
        this.setPassword(null);
        this.setNonce(null);
        this.setCreated(null);
        try {
            byte[] nonce = null;
            switch (msgEncryption) {
                case NONE: {
                    nonce = N.base64Decode(orgNonce);
                    break;
                }
                case JSON: {
                    ByteArrayOutputStream os = Objectory.createByteArrayOutputStream();
                    try {
                        HTTP.jsonParser.serialize(os, (Object)this, jsc);
                        nonce = os.toByteArray();
                        break;
                    }
                    finally {
                        Objectory.recycle(os);
                    }
                }
                case KRYO: {
                    ByteArrayOutputStream os = Objectory.createByteArrayOutputStream();
                    try {
                        HTTP.kryoParser.serialize(os, (Object)this);
                        nonce = os.toByteArray();
                        break;
                    }
                    finally {
                        Objectory.recycle(os);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Message encryption way: " + (Object)((Object)msgEncryption));
                }
            }
            boolean bl = orgPassword.equals(WSSecurityUtil.doPasswordDigest(nonce, orgCreated.getBytes(Charsets.UTF_8), password));
            return bl;
        }
        finally {
            this.setUserName(orgUserName);
            this.setPassword(orgPassword);
            this.setNonce(orgNonce);
            this.setCreated(orgCreated);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.nonce == null ? 0 : this.nonce.hashCode());
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SecurityDTO) {
            SecurityDTO other = (SecurityDTO)obj;
            return N.equals(this.userName, other.userName) && N.equals(this.password, other.password) && N.equals(this.nonce, other.nonce) && N.equals(this.created, other.created);
        }
        return false;
    }

    public String toString() {
        return "{userName=" + this.userName + ", password=" + this.password + ", nonce=" + this.nonce + ", created=" + this.created + "}";
    }
}

