/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http.okhttp;

import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HTTP;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.KryoParser;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.util.AndroidUtil;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;

public class OkHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpRequest.class);
    private static final Executor DEFAULT_EXECUTOR = IOUtil.IS_PLATFORM_ANDROID ? AndroidUtil.getThreadPoolExecutor() : new ThreadPoolExecutor(Math.max(8, IOUtil.CPU_CORES), Math.max(64, IOUtil.CPU_CORES), 180L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    static final XMLParser xmlParser = ParserFactory.isXMLAvailable() ? ParserFactory.createXMLParser() : null;
    static final KryoParser kryoParser = ParserFactory.isKryoAvailable() ? ParserFactory.createKryoParser() : null;
    static final OkHttpClient defaultClient = new OkHttpClient();
    final OkHttpClient httpClient;
    final Request.Builder builder = new Request.Builder();
    RequestBody body;

    OkHttpRequest(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static OkHttpRequest create() {
        return new OkHttpRequest(defaultClient);
    }

    public static OkHttpRequest create(OkHttpClient httpClient) {
        return new OkHttpRequest(httpClient);
    }

    public OkHttpRequest url(String url) {
        this.builder.url(url);
        return this;
    }

    public OkHttpRequest url(URL url) {
        this.builder.url(url);
        return this;
    }

    public OkHttpRequest url(HttpUrl url) {
        this.builder.url(url);
        return this;
    }

    public OkHttpRequest cacheControl(CacheControl cacheControl) {
        this.builder.cacheControl(cacheControl);
        return this;
    }

    public OkHttpRequest tag(Object tag) {
        this.builder.tag(tag);
        return this;
    }

    public OkHttpRequest header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public OkHttpRequest headers(String name1, String value1, String name2, String value2) {
        this.builder.header(name1, value1);
        this.builder.header(name2, value2);
        return this;
    }

    public OkHttpRequest headers(String name1, String value1, String name2, String value2, String name3, String value3) {
        this.builder.header(name1, value1);
        this.builder.header(name2, value2);
        this.builder.header(name3, value3);
        return this;
    }

    public OkHttpRequest headers(Headers headers) {
        this.builder.headers(headers);
        return this;
    }

    public OkHttpRequest addHeader(String name, String value) {
        this.builder.addHeader(name, value);
        return this;
    }

    public OkHttpRequest removeHeader(String name) {
        this.builder.removeHeader(name);
        return this;
    }

    public OkHttpRequest body(Map<?, ?> formBodyByMap) {
        if (N.isNullOrEmpty(formBodyByMap)) {
            this.body = Util.EMPTY_REQUEST;
            return this;
        }
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<?, ?> entry : formBodyByMap.entrySet()) {
            builder.add(N.stringOf(entry.getKey()), N.stringOf(entry.getValue()));
        }
        this.body = builder.build();
        return this;
    }

    public OkHttpRequest body(Object formBodyByEntity) {
        if (formBodyByEntity == null) {
            this.body = Util.EMPTY_REQUEST;
            return this;
        }
        Class<?> cls = formBodyByEntity.getClass();
        N.checkArgument(ClassUtil.isEntity(cls), "{} is not an entity class with getter/setter methods", cls);
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, Method> entry : ClassUtil.getPropGetMethodList(cls).entrySet()) {
            builder.add(entry.getKey(), N.stringOf(ClassUtil.getPropValue(formBodyByEntity, entry.getValue())));
        }
        this.body = builder.build();
        return this;
    }

    public OkHttpRequest body(RequestBody body) {
        this.body = body;
        return this;
    }

    public Response get() throws IOException {
        return this.execute("GET");
    }

    public <T> T get(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, "GET");
    }

    public Response post() throws IOException {
        return this.execute("POST");
    }

    public <T> T post(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, "POST");
    }

    public Response put() throws IOException {
        return this.execute("PUT");
    }

    public <T> T put(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, "PUT");
    }

    public Response delete() throws IOException {
        return this.execute("DELETE");
    }

    public <T> T delete(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, "DELETE");
    }

    public Response head() throws IOException {
        return this.execute("HEAD");
    }

    public Response patch() throws IOException {
        return this.execute("PATCH");
    }

    protected Response execute(String method) throws IOException {
        this.body = this.body == null && "DELETE".equals(method) ? Util.EMPTY_REQUEST : this.body;
        return this.httpClient.newCall(this.builder.method(method, this.body).build()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T execute(Class<T> resultClass, String method) throws IOException {
        N.checkArgNotNull(resultClass, "resultClass");
        Throwable throwable = null;
        try (Response resp = this.execute(method);){
            T t;
            if (!resp.isSuccessful()) throw new IOException(resp.code() + ": " + resp.message());
            ContentFormat respContentFormat = HTTP.getContentFormat(resp.header("Content-Type"), resp.header("Content-Encoding"));
            Charset respCharset = HTTP.getCharset(resp.header("Content-Type"));
            InputStream is = HTTP.wrapInputStream(resp.body().byteStream(), respContentFormat);
            if (resultClass == null || resultClass.equals(String.class)) {
                String string = IOUtil.readString(is, respCharset);
                return (T)string;
            }
            if (byte[].class.equals(resultClass)) {
                byte[] byArray = IOUtil.readBytes(is);
                return (T)byArray;
            }
            if (respContentFormat == ContentFormat.KRYO && kryoParser != null) {
                Object object = kryoParser.deserialize((Class)resultClass, is);
                return (T)object;
            }
            BufferedReader br = Objectory.createBufferedReader(new InputStreamReader(is, respCharset));
            try {
                t = HTTP.getParser(respContentFormat).deserialize(resultClass, br);
            }
            catch (Throwable throwable2) {
                try {
                    Objectory.recycle(br);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Objectory.recycle(br);
            return t;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (DEFAULT_EXECUTOR instanceof ExecutorService) {
                    ExecutorService executorService = (ExecutorService)DEFAULT_EXECUTOR;
                    logger.warn("Starting to shutdown task in OkHttpRequest");
                    try {
                        executorService.shutdown();
                        executorService.awaitTermination(60L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        logger.warn("Not all the requests/tasks executed in OkHttpRequest are completed successfully before shutdown.");
                    }
                    finally {
                        logger.warn("Completed to shutdown task in OkHttpRequest");
                    }
                }
            }
        });
    }
}

