/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.logging;

import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.function.Supplier;

public abstract class AbstractLogger
implements Logger {
    protected final String name;

    protected AbstractLogger(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void trace(String template, Object arg) {
        if (this.isTraceEnabled()) {
            this.trace(AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void trace(String template, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.trace(AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void trace(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isTraceEnabled()) {
            this.trace(AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void trace(String template, Object ... args) {
        if (this.isTraceEnabled()) {
            this.trace(AbstractLogger.format(template, args));
        }
    }

    @Override
    public void trace(Throwable t, String msg) {
        this.trace(msg, t);
    }

    @Override
    public void trace(Throwable t, String template, Object arg) {
        if (this.isTraceEnabled()) {
            this.trace(t, AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void trace(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.trace(t, AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void trace(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isTraceEnabled()) {
            this.trace(t, AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void trace(Supplier<String> supplier) {
        if (this.isTraceEnabled()) {
            this.trace(supplier.get());
        }
    }

    @Override
    public void trace(Supplier<String> supplier, Throwable t) {
        if (this.isTraceEnabled()) {
            this.trace(t, supplier.get());
        }
    }

    @Override
    public void trace(Throwable t, Supplier<String> supplier) {
        if (this.isTraceEnabled()) {
            this.trace(t, supplier.get());
        }
    }

    @Override
    public void debug(String template, Object arg) {
        if (this.isDebugEnabled()) {
            this.debug(AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void debug(String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debug(AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void debug(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.debug(AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void debug(String template, Object ... args) {
        if (this.isDebugEnabled()) {
            this.debug(AbstractLogger.format(template, args));
        }
    }

    @Override
    public void debug(Throwable t, String msg) {
        this.debug(msg, t);
    }

    @Override
    public void debug(Throwable t, String template, Object arg) {
        if (this.isDebugEnabled()) {
            this.debug(t, AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void debug(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debug(t, AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void debug(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.debug(t, AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void debug(Supplier<String> supplier) {
        if (this.isDebugEnabled()) {
            this.debug(supplier.get());
        }
    }

    @Override
    public void debug(Supplier<String> supplier, Throwable t) {
        if (this.isDebugEnabled()) {
            this.debug(t, supplier.get());
        }
    }

    @Override
    public void debug(Throwable t, Supplier<String> supplier) {
        if (this.isDebugEnabled()) {
            this.debug(t, supplier.get());
        }
    }

    @Override
    public void info(String template, Object arg) {
        if (this.isInfoEnabled()) {
            this.info(AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void info(String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.info(AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void info(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.info(AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void info(String template, Object ... args) {
        if (this.isInfoEnabled()) {
            this.info(AbstractLogger.format(template, args));
        }
    }

    @Override
    public void info(Throwable t, String msg) {
        this.info(msg, t);
    }

    @Override
    public void info(Throwable t, String template, Object arg) {
        if (this.isInfoEnabled()) {
            this.info(t, AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void info(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.info(t, AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void info(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.info(t, AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void info(Supplier<String> supplier) {
        if (this.isInfoEnabled()) {
            this.info(supplier.get());
        }
    }

    @Override
    public void info(Supplier<String> supplier, Throwable t) {
        if (this.isInfoEnabled()) {
            this.info(t, supplier.get());
        }
    }

    @Override
    public void info(Throwable t, Supplier<String> supplier) {
        if (this.isInfoEnabled()) {
            this.info(t, supplier.get());
        }
    }

    @Override
    public void warn(String template, Object arg) {
        if (this.isWarnEnabled()) {
            this.warn(AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void warn(String template, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warn(AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void warn(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarnEnabled()) {
            this.warn(AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void warn(String template, Object ... args) {
        if (this.isWarnEnabled()) {
            this.warn(AbstractLogger.format(template, args));
        }
    }

    @Override
    public void warn(Throwable t, String msg) {
        this.warn(msg, t);
    }

    @Override
    public void warn(Throwable t, String template, Object arg) {
        if (this.isWarnEnabled()) {
            this.warn(t, AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void warn(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warn(t, AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void warn(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarnEnabled()) {
            this.warn(t, AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void warn(Supplier<String> supplier) {
        if (this.isWarnEnabled()) {
            this.warn(supplier.get());
        }
    }

    @Override
    public void warn(Supplier<String> supplier, Throwable t) {
        if (this.isWarnEnabled()) {
            this.warn(t, supplier.get());
        }
    }

    @Override
    public void warn(Throwable t, Supplier<String> supplier) {
        if (this.isWarnEnabled()) {
            this.warn(t, supplier.get());
        }
    }

    @Override
    public void error(String template, Object arg) {
        if (this.isErrorEnabled()) {
            this.error(AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void error(String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.error(AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void error(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.error(AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void error(String template, Object ... args) {
        if (this.isErrorEnabled()) {
            this.error(AbstractLogger.format(template, args));
        }
    }

    @Override
    public void error(Throwable t, String msg) {
        this.error(msg, t);
    }

    @Override
    public void error(Throwable t, String template, Object arg) {
        if (this.isErrorEnabled()) {
            this.error(t, AbstractLogger.format(template, arg));
        }
    }

    @Override
    public void error(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.error(t, AbstractLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void error(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.error(t, AbstractLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void error(Supplier<String> supplier) {
        if (this.isErrorEnabled()) {
            this.error(supplier.get());
        }
    }

    @Override
    public void error(Supplier<String> supplier, Throwable t) {
        if (this.isErrorEnabled()) {
            this.error(t, supplier.get());
        }
    }

    @Override
    public void error(Throwable t, Supplier<String> supplier) {
        if (this.isErrorEnabled()) {
            this.error(t, supplier.get());
        }
    }

    static String format(String template, Object arg) {
        template = String.valueOf(template);
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 16);
        String placeholder = "{}";
        int placeholderStart = template.indexOf(placeholder);
        if (placeholderStart < 0) {
            placeholder = "%s";
            placeholderStart = template.indexOf(placeholder);
        }
        if (placeholderStart >= 0) {
            sb.append(template, 0, placeholderStart);
            sb.append(N.toString(arg));
            sb.append(template, placeholderStart + 2, template.length());
        } else {
            sb.append(" [");
            sb.append(N.toString(arg));
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    static String format(String template, Object arg1, Object arg2) {
        template = String.valueOf(template);
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 32);
        String placeholder = "{}";
        int placeholderStart = template.indexOf(placeholder);
        if (placeholderStart < 0) {
            placeholder = "%s";
            placeholderStart = template.indexOf(placeholder);
        }
        int templateStart = 0;
        int cnt = 0;
        if (placeholderStart >= 0) {
            ++cnt;
            sb.append(template, templateStart, placeholderStart);
            sb.append(N.toString(arg1));
            templateStart = placeholderStart + 2;
            placeholderStart = template.indexOf(placeholder, templateStart);
            if (placeholderStart >= 0) {
                ++cnt;
                sb.append(template, templateStart, placeholderStart);
                sb.append(N.toString(arg2));
                templateStart = placeholderStart + 2;
            }
            sb.append(template, templateStart, template.length());
        }
        if (cnt == 0) {
            sb.append(" [");
            sb.append(N.toString(arg1));
            sb.append(", ");
            sb.append(N.toString(arg2));
            sb.append(']');
        } else if (cnt == 1) {
            sb.append(" [");
            sb.append(N.toString(arg2));
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    static String format(String template, Object arg1, Object arg2, Object arg3) {
        template = String.valueOf(template);
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 48);
        String placeholder = "{}";
        int placeholderStart = template.indexOf(placeholder);
        if (placeholderStart < 0) {
            placeholder = "%s";
            placeholderStart = template.indexOf(placeholder);
        }
        int templateStart = 0;
        int cnt = 0;
        if (placeholderStart >= 0) {
            ++cnt;
            sb.append(template, templateStart, placeholderStart);
            sb.append(N.toString(arg1));
            templateStart = placeholderStart + 2;
            placeholderStart = template.indexOf(placeholder, templateStart);
            if (placeholderStart >= 0) {
                ++cnt;
                sb.append(template, templateStart, placeholderStart);
                sb.append(N.toString(arg2));
                templateStart = placeholderStart + 2;
                placeholderStart = template.indexOf(placeholder, templateStart);
                if (placeholderStart >= 0) {
                    ++cnt;
                    sb.append(template, templateStart, placeholderStart);
                    sb.append(N.toString(arg3));
                    templateStart = placeholderStart + 2;
                }
            }
            sb.append(template, templateStart, template.length());
        }
        if (cnt == 0) {
            sb.append(" [");
            sb.append(N.toString(arg1));
            sb.append(", ");
            sb.append(N.toString(arg2));
            sb.append(", ");
            sb.append(N.toString(arg3));
            sb.append(']');
        } else if (cnt == 1) {
            sb.append(" [");
            sb.append(N.toString(arg2));
            sb.append(", ");
            sb.append(N.toString(arg3));
            sb.append(']');
        } else if (cnt == 2) {
            sb.append(" [");
            sb.append(N.toString(arg3));
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    static String format(String template, Object ... args) {
        template = String.valueOf(template);
        if (N.isNullOrEmpty(args)) {
            return template;
        }
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        String placeholder = "{}";
        int placeholderStart = template.indexOf(placeholder);
        if (placeholderStart < 0) {
            placeholder = "%s";
            placeholderStart = template.indexOf(placeholder);
        }
        while (placeholderStart >= 0 && i < args.length) {
            sb.append(template, templateStart, placeholderStart);
            sb.append(N.toString(args[i++]));
            templateStart = placeholderStart + 2;
            placeholderStart = template.indexOf(placeholder, templateStart);
        }
        sb.append(template, templateStart, template.length());
        if (i < args.length) {
            sb.append(" [");
            sb.append(N.toString(args[i++]));
            while (i < args.length) {
                sb.append(", ");
                sb.append(N.toString(args[i++]));
            }
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }
}

