/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.parser.AbstractParser;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.N;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

abstract class AbstractJSONParser
extends AbstractParser<JSONSerializationConfig, JSONDeserializationConfig>
implements JSONParser {
    protected static final char _BRACE_L = '{';
    protected static final char _BRACE_R = '}';
    protected static final char _BRACKET_L = '[';
    protected static final char _BRACKET_R = ']';
    protected static final char _D_QUOTATION = '\"';
    protected static final char _S_QUOTATION = '\'';
    protected static final char _COLON = ':';
    protected static final char _COMMA = ',';
    protected static final JSONSerializationConfig defaultJSONSerializationConfig = new JSONSerializationConfig();
    protected static final JSONDeserializationConfig defaultJSONDeserializationConfig = new JSONDeserializationConfig();
    protected static final Type<Object> objType = TypeFactory.getType(Object.class);
    protected static final Type<String> strType = TypeFactory.getType(String.class);
    protected static final Type<Boolean> boolType = TypeFactory.getType(Boolean.class);
    protected static final Type<?> defaultKeyType = objType;
    protected static final Type<?> defaultValueType = objType;
    protected static final String[] REPLACEMENT_CHARS;
    protected static final Set<String> ignoredDirtyMarkerPropNames;

    AbstractJSONParser() {
    }

    @Override
    public <T> T readString(Class<T> targetClass, String str) {
        return this.readString(targetClass, str, null);
    }

    @Override
    public <T> T readString(Class<T> targetClass, String str, JSONDeserializationConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readString(Object[] outResult, String str) {
        this.readString(outResult, str, null);
    }

    @Override
    public void readString(Object[] outResult, String str, JSONDeserializationConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readString(Collection<?> outResult, String str) {
        this.readString(outResult, str, null);
    }

    @Override
    public void readString(Collection<?> outResult, String str, JSONDeserializationConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readString(Map<?, ?> outResult, String str) {
        this.readString(outResult, str, null);
    }

    @Override
    public void readString(Map<?, ?> outResult, String str, JSONDeserializationConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String str, int fromIndex, int toIndex) {
        return this.deserialize(targetClass, str, fromIndex, toIndex, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String str, int fromIndex, int toIndex, JSONDeserializationConfig config) {
        return this.deserialize(targetClass, str.substring(fromIndex, toIndex), config);
    }

    protected JSONSerializationConfig check(JSONSerializationConfig config) {
        if (config == null) {
            config = defaultJSONSerializationConfig;
        }
        return config;
    }

    protected JSONDeserializationConfig check(JSONDeserializationConfig config) {
        if (config == null) {
            config = defaultJSONDeserializationConfig;
        }
        return config;
    }

    static {
        int length = 128;
        REPLACEMENT_CHARS = new String[128];
        for (int i = 0; i < 128; ++i) {
            AbstractJSONParser.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        ignoredDirtyMarkerPropNames = N.asSet("signedPropNames", "dirtyPropNames", "frozen", "version", "isDirty", "dirtyMarkerImpl");
    }
}

