/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.DeserializationConfig;
import com.landawn.abacus.parser.Parser;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.N;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;

abstract class AbstractParser<SC extends SerializationConfig<?>, DC extends DeserializationConfig<?>>
implements Parser<SC, DC> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractParser.class);
    static final String NULL_STRING = "null".intern();
    static final char[] NULL_CHAR_ARRAY = NULL_STRING.toCharArray();
    static final String TRUE = Boolean.TRUE.toString().intern();
    static final char[] TRUE_CHAR_ARRAY = TRUE.toCharArray();
    static final String FALSE = Boolean.FALSE.toString().intern();
    static final char[] FALSE_CHAR_ARRAY = FALSE.toCharArray();
    static final int POOL_SIZE = 1000;
    static final int CLS_POOL_SIZE = 3000;

    AbstractParser() {
    }

    @Override
    public String serialize(Object obj) {
        return this.serialize(obj, null);
    }

    @Override
    public void serialize(File file, Object obj) {
        this.serialize(file, obj, null);
    }

    @Override
    public void serialize(OutputStream os, Object obj) {
        this.serialize(os, obj, null);
    }

    @Override
    public void serialize(Writer writer, Object obj) {
        this.serialize(writer, obj, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String st) {
        return this.deserialize(targetClass, st, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file) {
        return this.deserialize(targetClass, file, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is) {
        return this.deserialize(targetClass, is, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader) {
        return this.deserialize(targetClass, reader, null);
    }

    protected static <T> T newPropInstance(Class<?> propClass, Class<?> attribeTypeClass) {
        block4: {
            if (attribeTypeClass != null && (propClass == null || propClass.isAssignableFrom(attribeTypeClass))) {
                try {
                    return (T)N.newInstance(attribeTypeClass);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info("Failed to new instance by type attribute: " + attribeTypeClass.getCanonicalName());
                }
            }
        }
        if (propClass != null) {
            return (T)N.newInstance(propClass);
        }
        throw new ParseException("Failed to create property instance with property class: " + propClass + " and attribute " + attribeTypeClass);
    }

    protected static Class<?> getConcreteClass(Class<?> targetClass, Class<?> typeClass) {
        if (typeClass == null) {
            return targetClass;
        }
        if (targetClass == null) {
            return typeClass;
        }
        if (targetClass == typeClass || targetClass.isAssignableFrom(typeClass)) {
            return typeClass;
        }
        return targetClass;
    }

    protected static <T> T collection2Array(Class<?> targetClass, Collection<?> c) {
        if (c == null) {
            return null;
        }
        Type targetType = N.typeOf(targetClass);
        if (targetType.isPrimitiveArray()) {
            return targetType.collection2Array(c);
        }
        for (Object e : c) {
            if (e == null) continue;
            if (targetClass.getComponentType().isAssignableFrom(e.getClass())) {
                return targetType.collection2Array(c);
            }
            return (T)c.toArray((Object[])N.newArray(e.getClass(), c.size()));
        }
        return targetType.collection2Array(c);
    }
}

