/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.AbstractParser;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.parser.XMLDeserializationConfig;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.parser.XMLSerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.XMLUtil;
import java.io.Reader;
import java.lang.reflect.Modifier;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

abstract class AbstractXMLParser
extends AbstractParser<XMLSerializationConfig, XMLDeserializationConfig>
implements XMLParser {
    private static final Logger logger = LoggerFactory.getLogger(AbstractXMLParser.class);
    protected static final XMLSerializationConfig defaultXMLSerializationConfig = XMLSerializationConfig.XSC.create();
    protected static final XMLDeserializationConfig defaultXMLDeserializationConfig = XMLDeserializationConfig.XDC.create();
    protected static final JSONParser jsonParser = ParserFactory.createJSONParser();
    protected static final JSONSerializationConfig jsc = (JSONSerializationConfig)JSONSerializationConfig.JSC.create().setCharQuotation('\u0000');
    protected static final JSONSerializationConfig jscWithCircularRefSupported = (JSONSerializationConfig)((JSONSerializationConfig)JSONSerializationConfig.JSC.create().setCharQuotation('\u0000')).supportCircularReference(true);
    protected static final Type<Object> objType = TypeFactory.getType(Object.class);
    protected static final Type<String> strType = TypeFactory.getType(String.class);
    protected static final Type<Boolean> boolType = TypeFactory.getType(Boolean.class);
    protected static final Type<?> defaultKeyType = objType;
    protected static final Type<?> defaultValueType = objType;

    AbstractXMLParser() {
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Node node) {
        return this.deserialize(targetClass, node, null);
    }

    protected XMLStreamReader createXMLStreamReader(Reader br) {
        return XMLUtil.createFilteredStreamReader(XMLUtil.createXMLStreamReader(br), new StreamFilter(){

            @Override
            public boolean accept(XMLStreamReader reader) {
                return !reader.isWhiteSpace() && reader.getEventType() != 5;
            }
        });
    }

    protected Object getPropValue(String propName, Type<?> propType, ParserUtil.PropInfo propInfo, Node propNode) {
        Node attrNode;
        String txtValue = XMLUtil.getTextContent(propNode);
        if (N.isNullOrEmpty(txtValue) && (attrNode = propNode.getAttributes().getNamedItem("isNull")) != null && Boolean.valueOf(attrNode.getNodeValue()).booleanValue()) {
            return null;
        }
        if (propType == null) {
            throw new ParseException("Can't parse property " + propName + " with value: " + txtValue);
        }
        if (propInfo != null && propInfo.hasFormat) {
            return propInfo.readPropValue(txtValue);
        }
        return propType.valueOf(txtValue);
    }

    protected static <T> T newPropInstance(Class<?> propClass, Node node) {
        block3: {
            if (propClass != null && !Modifier.isAbstract(propClass.getModifiers())) {
                try {
                    return (T)N.newInstance(propClass);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info("Failed to new instance by class: " + propClass.getName());
                }
            }
        }
        Class<?> attribeTypeClass = AbstractXMLParser.getAttributeTypeClass(node);
        return AbstractXMLParser.newPropInstance(propClass, attribeTypeClass);
    }

    protected static <T> T newPropInstance(Class<?> propClass, Attributes atts) {
        block3: {
            if (propClass != null && !Modifier.isAbstract(propClass.getModifiers())) {
                try {
                    return (T)N.newInstance(propClass);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info("Failed to new instance by class: " + propClass.getName());
                }
            }
        }
        Class<?> attribeTypeClass = AbstractXMLParser.getAttributeTypeClass(atts);
        return AbstractXMLParser.newPropInstance(propClass, attribeTypeClass);
    }

    protected static String getAttribute(XMLStreamReader xmlReader, String attrName) {
        int attrCount = xmlReader.getAttributeCount();
        if (attrCount == 0) {
            return null;
        }
        if (attrCount == 1) {
            if (attrName.equals(xmlReader.getAttributeLocalName(0))) {
                return xmlReader.getAttributeValue(0);
            }
            return null;
        }
        for (int i = 0; i < attrCount; ++i) {
            if (!attrName.equals(xmlReader.getAttributeLocalName(i))) continue;
            return xmlReader.getAttributeValue(i);
        }
        return null;
    }

    protected static Class<?> getAttributeTypeClass(Node node) {
        String typeAttr = XMLUtil.getAttribute(node, "type");
        if (typeAttr == null) {
            return null;
        }
        return N.typeOf(typeAttr).clazz();
    }

    protected static Class<?> getAttributeTypeClass(Attributes atts) {
        if (atts == null) {
            return null;
        }
        String typeAttr = atts.getValue("type");
        if (typeAttr == null) {
            return null;
        }
        return N.typeOf(typeAttr).clazz();
    }

    protected static Class<?> getAttributeTypeClass(XMLStreamReader xmlReader) {
        if (xmlReader.getAttributeCount() == 0) {
            return null;
        }
        String typeAttr = AbstractXMLParser.getAttribute(xmlReader, "type");
        if (typeAttr == null) {
            return null;
        }
        return N.typeOf(typeAttr).clazz();
    }

    protected static Class<?> getConcreteClass(Class<?> targetClass, Node node) {
        if (node == null) {
            return targetClass;
        }
        Class<?> typeClass = AbstractXMLParser.getAttributeTypeClass(node);
        return AbstractXMLParser.getConcreteClass(targetClass, typeClass);
    }

    protected static Class<?> getConcreteClass(Class<?> targetClass, Attributes atts) {
        if (atts == null) {
            return targetClass;
        }
        Class<?> typeClass = AbstractXMLParser.getAttributeTypeClass(atts);
        return AbstractXMLParser.getConcreteClass(targetClass, typeClass);
    }

    protected static Class<?> getConcreteClass(Class<?> targetClass, XMLStreamReader xmlReader) {
        if (xmlReader.getAttributeCount() == 0) {
            return targetClass;
        }
        Class<?> typeClass = AbstractXMLParser.getAttributeTypeClass(xmlReader);
        return AbstractXMLParser.getConcreteClass(targetClass, typeClass);
    }

    protected static Node checkOneNode(Node eleNode) {
        NodeList subEleNodes = eleNode.getChildNodes();
        Node subEleNode = null;
        if (subEleNodes.getLength() == 1) {
            subEleNode = subEleNodes.item(0);
        } else {
            for (int j = 0; j < subEleNodes.getLength(); ++j) {
                if (subEleNodes.item(j).getNodeType() == 3) continue;
                if (subEleNode == null) {
                    subEleNode = subEleNodes.item(j);
                    continue;
                }
                throw new ParseException("Only one child node is supported");
            }
        }
        return subEleNode;
    }

    protected JSONSerializationConfig getJSC(XMLSerializationConfig config) {
        return config == null || !config.supportCircularReference ? jsc : jscWithCircularRefSupported;
    }

    static enum NodeType {
        ENTITY,
        PROPERTY,
        ARRAY,
        ELEMENT,
        COLLECTION,
        MAP,
        ENTRY,
        KEY,
        VALUE;

    }
}

