/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.AbstractJSONParser;
import com.landawn.abacus.parser.Exclusion;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Primitives;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;

final class FastJSONParser
extends AbstractJSONParser {
    private static final Feature[] generalFeatures = new Feature[]{Feature.AllowISO8601DateFormat, Feature.AllowSingleQuotes, Feature.AllowUnQuotedFieldNames};
    private static final Feature[] generalFeaturesWithIgnoreNotMatch = new Feature[]{Feature.AllowISO8601DateFormat, Feature.AllowSingleQuotes, Feature.AllowUnQuotedFieldNames, Feature.IgnoreNotMatch};

    FastJSONParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize(Object obj, JSONSerializationConfig config) {
        if (obj == null) {
            return N.EMPTY_STRING;
        }
        com.landawn.abacus.util.BufferedWriter bw = Objectory.createBufferedWriter();
        try {
            this.write(bw, obj, config);
            String string = bw.toString();
            return string;
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(File file, Object obj, JSONSerializationConfig config) {
        FileOutputStream os = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            this.serialize((OutputStream)os, obj, config);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void serialize(OutputStream os, Object obj, JSONSerializationConfig config) {
        com.landawn.abacus.util.BufferedWriter bw = Objectory.createBufferedWriter(os);
        try {
            this.write(bw, obj, config);
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(Writer writer, Object obj, JSONSerializationConfig config) {
        boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
        Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
        try {
            this.write(bw, obj, config);
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(Writer writer, Object obj, JSONSerializationConfig config) {
        config = this.check(config);
        if (obj == null) {
            IOUtil.write(writer, (CharSequence)N.EMPTY_STRING);
            return;
        }
        SerializeWriter out = new SerializeWriter(writer);
        JSONSerializer serializer = new JSONSerializer(out);
        final Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(obj.getClass());
        if (N.notNullOrEmpty(ignoredClassPropNames)) {
            serializer.getPropertyFilters().add(new PropertyFilter(){

                public boolean apply(Object object, String name, Object value) {
                    return !ignoredClassPropNames.contains(name);
                }
            });
        }
        if (config.getExclusion() == Exclusion.NULL) {
            serializer.getPropertyFilters().add(new PropertyFilter(){

                public boolean apply(Object object, String name, Object value) {
                    return value != null;
                }
            });
        } else if (config.getExclusion() == Exclusion.DEFAULT) {
            serializer.getPropertyFilters().add(new PropertyFilter(){

                public boolean apply(Object object, String name, Object value) {
                    return value != null && (!Primitives.isWrapperType(value.getClass()) || !value.equals(N.defaultValueOf(Primitives.unwrap(value.getClass()))));
                }
            });
        }
        if (config.getDateTimeFormat() != null) {
            switch (config.getDateTimeFormat()) {
                case LONG: {
                    break;
                }
                case ISO_8601_DATETIME: {
                    serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
                    serializer.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
                    break;
                }
                case ISO_8601_TIMESTAMP: {
                    serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
                    serializer.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
                    break;
                }
                default: {
                    throw new ParseException("Unsupported data format: " + (Object)((Object)config.getDateTimeFormat()));
                }
            }
        }
        serializer.config(SerializerFeature.SkipTransientField, config.isSkipTransientField());
        if (config.isPrettyFormat()) {
            serializer.config(SerializerFeature.PrettyFormat, true);
        }
        serializer.config(SerializerFeature.QuoteFieldNames, config.isQuotePropName() || config.isQuoteMapKey());
        if (config.getStringQuotation() == '\'') {
            serializer.config(SerializerFeature.UseSingleQuotes, true);
        }
        try {
            serializer.write(obj);
        }
        finally {
            out.close();
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String st, JSONDeserializationConfig config) {
        return this.read(targetClass, st, config);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file, JSONDeserializationConfig config) {
        config = this.check(config);
        return this.read(targetClass, IOUtil.readString(file), config);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is, JSONDeserializationConfig config) {
        config = this.check(config);
        return this.read(targetClass, IOUtil.readString(is), config);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader, JSONDeserializationConfig config) {
        config = this.check(config);
        return this.read(targetClass, IOUtil.readString(reader), config);
    }

    protected <T> T read(Class<T> targetClass, String st, JSONDeserializationConfig config) {
        config = this.check(config);
        if (N.isNullOrEmpty(st)) {
            return N.defaultValueOf(targetClass);
        }
        if (config.isIgnoreUnknownProperty()) {
            return (T)JSON.parseObject((String)st, targetClass, (Feature[])generalFeaturesWithIgnoreNotMatch);
        }
        return (T)JSON.parseObject((String)st, targetClass, (Feature[])generalFeatures);
    }

    @Override
    protected JSONDeserializationConfig check(JSONDeserializationConfig config) {
        if (config == null) {
            return defaultJSONDeserializationConfig;
        }
        if (N.notNullOrEmpty(config.getIgnoredPropNames())) {
            throw new ParseException("'ignoredPropNames' is not supported");
        }
        return config;
    }
}

