/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.DataSet;
import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.core.MapEntity;
import com.landawn.abacus.core.RowDataSet;
import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.AbstractJSONParser;
import com.landawn.abacus.parser.Exclusion;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONReader;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.parser.JSONStreamReader;
import com.landawn.abacus.parser.JSONStringReader;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.BufferedJSONWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.IdentityHashSet;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Properties;
import com.landawn.abacus.util.Triple;
import com.landawn.abacus.util.Tuple;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class JSONParserImpl
extends AbstractJSONParser {
    private static final String ENTITY_NAME = "entityName";
    private static final String ENTITY_TYPE = "entityType";
    private static final String COLUMN_NAMES = "columnNames";
    private static final String COLUMN_TYPES = "columnTypes";
    private static final String PROPERTIES = "properties";
    private static final String FROZEN = "frozen";
    private static final Map<String, Integer> dataSetPropOrder = new HashMap<String, Integer>();
    private static final JSONDeserializationConfig jdcForStringElement;
    private static final JSONDeserializationConfig jdcForTypeElement;
    private static final JSONDeserializationConfig jdcForPropertiesElement;
    private static final Map<Class<?>, List2PairTripleConverter> list2PairTripleConverterMap;

    JSONParserImpl() {
    }

    @Override
    public <T> T readString(Class<T> targetClass, String str, JSONDeserializationConfig config) {
        config = this.check(config);
        if (N.isNullOrEmpty(str)) {
            return N.defaultValueOf(targetClass);
        }
        char[] cbuf = Objectory.createCharArrayBuffer();
        try {
            JSONReader jr = JSONStringReader.parse(str, cbuf);
            T t = this.readString(null, targetClass, str, jr, config);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(cbuf);
        }
    }

    @Override
    public void readString(Object[] outResult, String str, JSONDeserializationConfig config) {
        config = this.check(config);
        if (N.isNullOrEmpty(str)) {
            return;
        }
        char[] cbuf = Objectory.createCharArrayBuffer();
        try {
            JSONReader jr = JSONStringReader.parse(str, cbuf);
            this.readString(outResult, outResult.getClass(), str, jr, config);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(cbuf);
        }
    }

    @Override
    public void readString(Collection<?> outResult, String str, JSONDeserializationConfig config) {
        config = this.check(config);
        if (N.isNullOrEmpty(str)) {
            return;
        }
        char[] cbuf = Objectory.createCharArrayBuffer();
        try {
            JSONReader jr = JSONStringReader.parse(str, cbuf);
            this.readString(outResult, null, str, jr, config);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(cbuf);
        }
    }

    @Override
    public void readString(Map<?, ?> outResult, String str, JSONDeserializationConfig config) {
        config = this.check(config);
        if (N.isNullOrEmpty(str)) {
            return;
        }
        char[] cbuf = Objectory.createCharArrayBuffer();
        try {
            JSONReader jr = JSONStringReader.parse(str, cbuf);
            this.readString(outResult, null, str, jr, config);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(cbuf);
        }
    }

    protected <T> T readString(Object outResult, Class<T> targetClass, String str, JSONReader jr, JSONDeserializationConfig config) throws IOException {
        Type type = outResult == null ? N.typeOf(targetClass) : N.typeOf(outResult.getClass());
        Object[] a = outResult != null && outResult instanceof Object[] ? (Object[])outResult : null;
        Collection c = outResult != null && outResult instanceof Collection ? (Collection)outResult : null;
        Map m = outResult != null && outResult instanceof Map ? (Map)outResult : null;
        switch (type.getSerializationType()) {
            case SERIALIZABLE: {
                if (type.isArray()) {
                    return this.readArray(a, targetClass, jr, config, null, true);
                }
                if (type.isCollection()) {
                    return this.readCollection(c, targetClass, jr, config, null, true);
                }
                return type.valueOf(str);
            }
            case ENTITY: {
                return this.readEntity(targetClass, jr, config, null, true);
            }
            case MAP: {
                return this.readMap(m, targetClass, jr, config, null, true);
            }
            case ARRAY: {
                return this.readArray(a, targetClass, jr, config, null, true);
            }
            case COLLECTION: {
                return this.readCollection(c, targetClass, jr, config, null, true);
            }
            case DATA_SET: {
                return this.readDataSet(targetClass, jr, config, true);
            }
        }
        int firstToken = jr.nextToken();
        if (Object.class.equals(targetClass)) {
            if (firstToken == 1) {
                return (T)this.readMap(null, Map.class, jr, config, null, false);
            }
            if (firstToken == 3) {
                return (T)this.readCollection(null, List.class, jr, config, null, false);
            }
        }
        throw new ParseException("Unsupported class: " + ClassUtil.getCanonicalClassName(type.clazz()) + ". Only Array/List/Map and Entity class with getter/setter methods are supported");
    }

    @Override
    public String serialize(Object obj, JSONSerializationConfig config) {
        config = this.check(config);
        if (obj == null) {
            return N.EMPTY_STRING;
        }
        Class<?> cls = obj.getClass();
        Type<Object> type = N.typeOf(cls);
        if (type.isSerializable() && !type.isArray() && !type.isCollection()) {
            return type.stringOf(obj);
        }
        BufferedJSONWriter bw = Objectory.createBufferedJSONWriter();
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, false, serializedObjects);
            String string = bw.toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(File file, Object obj, JSONSerializationConfig config) {
        config = this.check(config);
        if (obj == null) {
            IOUtil.write(file, (CharSequence)N.EMPTY_STRING);
            return;
        }
        Class<?> cls = obj.getClass();
        Type<Object> type = N.typeOf(cls);
        if (type.isSerializable() && !type.isArray() && !type.isCollection()) {
            IOUtil.write(file, (CharSequence)type.stringOf(obj));
            return;
        }
        FileOutputStream os = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            this.serialize((OutputStream)os, obj, config);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void serialize(OutputStream os, Object obj, JSONSerializationConfig config) {
        config = this.check(config);
        if (obj == null) {
            IOUtil.write(os, (CharSequence)N.EMPTY_STRING);
            return;
        }
        Class<?> cls = obj.getClass();
        Type<Object> type = N.typeOf(cls);
        if (type.isSerializable() && !type.isArray() && !type.isCollection()) {
            IOUtil.write(os, (CharSequence)type.stringOf(obj), true);
            return;
        }
        BufferedJSONWriter bw = Objectory.createBufferedJSONWriter(os);
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, true, serializedObjects);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(Writer writer, Object obj, JSONSerializationConfig config) {
        config = this.check(config);
        if (obj == null) {
            IOUtil.write(writer, (CharSequence)N.EMPTY_STRING);
            return;
        }
        Class<?> cls = obj.getClass();
        Type<Object> type = N.typeOf(cls);
        if (type.isSerializable() && !type.isArray() && !type.isCollection()) {
            IOUtil.write(writer, (CharSequence)type.stringOf(obj), true);
            return;
        }
        boolean isBufferedWriter = writer instanceof BufferedJSONWriter;
        BufferedJSONWriter bw = isBufferedWriter ? (BufferedJSONWriter)writer : Objectory.createBufferedJSONWriter(writer);
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, true, serializedObjects);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle(bw);
            }
        }
    }

    protected void write(BufferedJSONWriter bw, Object obj, JSONSerializationConfig config, boolean flush, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (config.isBracketRootValue()) {
            this.write(bw, obj, config, flush, true, null, serializedObjects);
        } else {
            Type type = N.typeOf(obj.getClass());
            if (type.isSerializable()) {
                if (type.isObjectArray()) {
                    this.writeArray(bw, type, obj, config, true, null, serializedObjects);
                } else if (type.isCollection()) {
                    this.writeCollection(bw, type, (Collection)obj, config, true, null, serializedObjects);
                } else if (type.isPrimitiveArray()) {
                    this.writeArray(bw, type, obj, config, true, null, serializedObjects);
                } else {
                    this.write(bw, obj, config, flush, true, null, serializedObjects);
                }
            } else {
                this.write(bw, obj, config, flush, true, null, serializedObjects);
            }
        }
    }

    protected void write(BufferedJSONWriter bw, Object obj, JSONSerializationConfig config, boolean flush, boolean isFirstCall, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (obj == null) {
            return;
        }
        this.write(bw, obj, config, isFirstCall, indentation, serializedObjects);
        if (flush) {
            bw.flush();
        }
    }

    protected void write(BufferedJSONWriter bw, Object obj, JSONSerializationConfig config, boolean isFirstCall, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        Type<Object> type = N.typeOf(obj.getClass());
        switch (type.getSerializationType()) {
            case SERIALIZABLE: {
                type.writeCharacter(bw, obj, config);
                break;
            }
            case ENTITY: {
                this.writeEntity(bw, type, obj, config, isFirstCall, indentation, serializedObjects);
                break;
            }
            case MAP: {
                this.writeMap(bw, type, (Map)obj, config, isFirstCall, indentation, serializedObjects);
                break;
            }
            case ARRAY: {
                this.writeArray(bw, type, obj, config, isFirstCall, indentation, serializedObjects);
                break;
            }
            case COLLECTION: {
                this.writeCollection(bw, type, (Collection)obj, config, isFirstCall, indentation, serializedObjects);
                break;
            }
            case MAP_ENTITY: {
                this.writeMapEntity(bw, type, (MapEntity)obj, config, isFirstCall, indentation, serializedObjects);
                break;
            }
            case DATA_SET: {
                this.writeDataSet(bw, type, (DataSet)obj, config, isFirstCall, indentation, serializedObjects);
                break;
            }
            default: {
                throw new ParseException("Unsupported class: " + ClassUtil.getCanonicalClassName(type.clazz()) + ". Only Array/List/Map and Entity class with getter/setter methods are supported");
            }
        }
    }

    protected void writeEntity(BufferedJSONWriter bw, Type<?> type, Object obj, JSONSerializationConfig config, boolean isFirstCall, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        String nextIndentation;
        String propName2;
        if (this.hasCircularReference(bw, obj, serializedObjects)) {
            return;
        }
        Class<?> cls = type.clazz();
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(cls);
        if (N.isNullOrEmpty(entityInfo.seriPropInfos)) {
            throw new ParseException("No serializable property is found in class: " + ClassUtil.getCanonicalClassName(cls));
        }
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(cls);
        boolean ignoreNullProperty = config.getExclusion() == Exclusion.NULL || config.getExclusion() == Exclusion.DEFAULT;
        boolean ignoreDefaultProperty = config.getExclusion() == Exclusion.DEFAULT;
        boolean quotePropName = config.isQuotePropName();
        boolean isPrettyFormat = config.isPrettyFormat();
        Set signedPropNameSet = null;
        if (ignoreNullProperty && obj instanceof DirtyMarker) {
            Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)obj);
            if (N.isNullOrEmpty(signedPropNames)) {
                return;
            }
            signedPropNameSet = Objectory.createSet();
            for (String propName2 : signedPropNames) {
                signedPropNameSet.add(entityInfo.getPropInfo((String)propName2).name);
            }
        }
        ParserUtil.PropInfo[] propInfoList = config.isSkipTransientField() ? entityInfo.nonTransientSeriPropInfos : entityInfo.seriPropInfos;
        ParserUtil.PropInfo propInfo2 = null;
        propName2 = null;
        Object propValue = null;
        if (config.isBracketRootValue() || !isFirstCall) {
            bw.write('{');
        }
        String string = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : (nextIndentation = null);
        if (config.isWrapRootValue()) {
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
                bw.write(config.getIndentation());
            }
            if (config.isQuotePropName()) {
                bw.write('\"');
                bw.write(ClassUtil.getSimpleClassName(cls));
                bw.write('\"');
            } else {
                bw.write(ClassUtil.getSimpleClassName(cls));
            }
            bw.write(':');
            bw.write('{');
            nextIndentation = nextIndentation + config.getIndentation();
        }
        if (config.getPropNamingPolicy() == null || config.getPropNamingPolicy() == NamingPolicy.LOWER_CAMEL_CASE) {
            int k = 0;
            for (ParserUtil.PropInfo propInfo2 : propInfoList) {
                propName2 = propInfo2.name;
                if (signedPropNameSet != null && !signedPropNameSet.contains(propName2) || ignoredClassPropNames != null && ignoredClassPropNames.contains(propName2)) continue;
                propValue = propInfo2.getPropValue(obj);
                if (ignoreNullProperty && propValue == null || ignoreDefaultProperty && propValue != null && propInfo2.jsonXmlType != null && propInfo2.jsonXmlType.isPrimitiveType() && propValue.equals(propInfo2.jsonXmlType.defaultValue())) continue;
                if (k++ > 0) {
                    bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                }
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(nextIndentation);
                }
                if (propValue == null) {
                    if (quotePropName) {
                        bw.write(propInfo2.jsonInfo.quotedNameNull);
                        continue;
                    }
                    bw.write(propInfo2.jsonInfo.nameNull);
                    continue;
                }
                if (quotePropName) {
                    bw.write(propInfo2.jsonInfo.quotedNameWithColon);
                } else {
                    bw.write(propInfo2.jsonInfo.nameWithColon);
                }
                if (propInfo2.jsonXmlType.isSerializable()) {
                    propInfo2.writePropValue(bw, propValue, config);
                    continue;
                }
                this.write(bw, propValue, config, false, nextIndentation, serializedObjects);
            }
        } else if (config.getPropNamingPolicy() == NamingPolicy.LOWER_CASE_WITH_UNDERSCORE) {
            int k = 0;
            for (ParserUtil.PropInfo propInfo2 : propInfoList) {
                propName2 = propInfo2.name;
                if (signedPropNameSet != null && !signedPropNameSet.contains(propName2) || ignoredClassPropNames != null && ignoredClassPropNames.contains(propName2)) continue;
                propValue = propInfo2.getPropValue(obj);
                if (ignoreNullProperty && propValue == null || ignoreDefaultProperty && propValue != null && propInfo2.jsonXmlType != null && propInfo2.jsonXmlType.isPrimitiveType() && propValue.equals(propInfo2.jsonXmlType.defaultValue())) continue;
                if (k++ > 0) {
                    bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                }
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(nextIndentation);
                }
                if (propValue == null) {
                    if (quotePropName) {
                        bw.write(propInfo2.jsonInfo._quotedNameNull);
                        continue;
                    }
                    bw.write(propInfo2.jsonInfo._nameNull);
                    continue;
                }
                if (quotePropName) {
                    bw.write(propInfo2.jsonInfo._quotedNameWithColon);
                } else {
                    bw.write(propInfo2.jsonInfo._nameWithColon);
                }
                if (propInfo2.jsonXmlType.isSerializable()) {
                    propInfo2.writePropValue(bw, propValue, config);
                    continue;
                }
                this.write(bw, propValue, config, false, nextIndentation, serializedObjects);
            }
        } else {
            throw new ParseException("Unsupported WritePropNamingPolicy: " + (Object)((Object)config.getPropNamingPolicy()));
        }
        if (config.isWrapRootValue()) {
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
                bw.write(config.getIndentation());
            }
            bw.write('}');
        }
        if (config.isBracketRootValue() || !isFirstCall) {
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
            }
            bw.write('}');
        }
        Objectory.recycle(signedPropNameSet);
    }

    protected void writeMap(BufferedJSONWriter bw, Type<?> type, Map<?, ?> m, JSONSerializationConfig config, boolean isFirstCall, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, m, serializedObjects)) {
            return;
        }
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
        boolean isQuoteMapKey = config.isQuoteMapKey();
        boolean isPrettyFormat = config.isPrettyFormat();
        Object value = null;
        Type<?> keyType = null;
        int i = 0;
        if (config.isBracketRootValue() || !isFirstCall) {
            bw.write('{');
        }
        String nextIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        for (Object key : m.keySet()) {
            if (key != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(key.toString())) continue;
            value = m.get(key);
            if (i++ > 0) {
                bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
            }
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(nextIndentation);
            }
            if (key == null) {
                bw.write(NULL_CHAR_ARRAY);
            } else {
                keyType = N.typeOf(key.getClass());
                if (keyType.isSerializable()) {
                    if (isQuoteMapKey || !keyType.isNumber() && !keyType.isBoolean()) {
                        bw.write('\"');
                        bw.writeCharacter(keyType.stringOf(key));
                        bw.write('\"');
                    } else {
                        bw.writeCharacter(keyType.stringOf(key));
                    }
                } else {
                    this.write(bw, key, config, false, nextIndentation, serializedObjects);
                }
            }
            bw.write(':');
            if (value == null) {
                bw.write(NULL_CHAR_ARRAY);
                continue;
            }
            this.write(bw, value, config, false, nextIndentation, serializedObjects);
        }
        if (config.isBracketRootValue() || !isFirstCall) {
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
            }
            bw.write('}');
        }
    }

    protected void writeArray(BufferedJSONWriter bw, Type<?> type, Object obj, JSONSerializationConfig config, boolean isFirstCall, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, obj, serializedObjects)) {
            return;
        }
        boolean isPrimitiveArray = type.isPrimitiveArray();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (config.isBracketRootValue() || !isFirstCall) {
            bw.write('[');
        }
        String nextIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        Object[] a = isPrimitiveArray ? null : (Object[])obj;
        int len = isPrimitiveArray ? Array.getLength(obj) : a.length;
        Object val = null;
        for (int i = 0; i < len; ++i) {
            val = (isPrimitiveArray ? Array.get(obj, i) : a[i]);
            if (i > 0) {
                bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
            }
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(nextIndentation);
            }
            if (val == null) {
                bw.write(NULL_CHAR_ARRAY);
                continue;
            }
            this.write(bw, val, config, false, nextIndentation, serializedObjects);
        }
        if (config.isBracketRootValue() || !isFirstCall) {
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
            }
            bw.write(']');
        }
    }

    protected void writeCollection(BufferedJSONWriter bw, Type<?> type, Collection<?> c, JSONSerializationConfig config, boolean isFirstCall, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, c, serializedObjects)) {
            return;
        }
        boolean isPrettyFormat = config.isPrettyFormat();
        if (config.isBracketRootValue() || !isFirstCall) {
            bw.write('[');
        }
        String nextIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        int i = 0;
        for (Object e : c) {
            if (i++ > 0) {
                bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
            }
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(nextIndentation);
            }
            if (e == null) {
                bw.write(NULL_CHAR_ARRAY);
                continue;
            }
            this.write(bw, e, config, false, nextIndentation, serializedObjects);
        }
        if (config.isBracketRootValue() || !isFirstCall) {
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
            }
            bw.write(']');
        }
    }

    protected void writeMapEntity(BufferedJSONWriter bw, Type<?> type, MapEntity mapEntity, JSONSerializationConfig config, boolean isFirstCall, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, mapEntity, serializedObjects)) {
            return;
        }
        boolean quotePropName = config.isQuotePropName();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (config.isBracketRootValue() || !isFirstCall) {
            bw.write('{');
        }
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
            bw.write(config.getIndentation());
        }
        if (quotePropName) {
            bw.write('\"');
            bw.write(mapEntity.entityName());
            bw.write('\"');
        } else {
            bw.write(mapEntity.entityName());
        }
        bw.write(':');
        bw.write('{');
        if (!mapEntity.isEmpty()) {
            String nextIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() + config.getIndentation() : null;
            int i = 0;
            for (String propName : mapEntity.keySet()) {
                if (i++ > 0) {
                    bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                }
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(nextIndentation);
                }
                if (quotePropName) {
                    bw.write('\"');
                    bw.write(propName);
                    bw.write('\"');
                } else {
                    bw.write(propName);
                }
                bw.write(':');
                this.write(bw, mapEntity.get(propName), config, false, nextIndentation, serializedObjects);
            }
        }
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
            bw.write(config.getIndentation());
        }
        bw.write('}');
        if (config.isBracketRootValue() || !isFirstCall) {
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
            }
            bw.write('}');
        }
    }

    protected void writeDataSet(BufferedJSONWriter bw, Type<?> type, DataSet ds, JSONSerializationConfig config, boolean isFirstCall, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        String nextIndentation;
        if (this.hasCircularReference(bw, ds, serializedObjects)) {
            return;
        }
        boolean quotePropName = config.isQuotePropName();
        boolean isPrettyFormat = config.isPrettyFormat();
        String string = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : (nextIndentation = null);
        if (config.isBracketRootValue() || !isFirstCall) {
            bw.write('{');
        }
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
            bw.write(config.getIndentation());
        }
        ImmutableList<String> columnNames = ds.columnNameList();
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
            bw.write(config.getIndentation());
        }
        if (quotePropName) {
            bw.write('\"');
            bw.write(COLUMN_NAMES);
            bw.write('\"');
        } else {
            bw.write(COLUMN_NAMES);
        }
        bw.write(':');
        this.write(bw, columnNames, config, false, nextIndentation, serializedObjects);
        bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
            bw.write(config.getIndentation());
        }
        if (quotePropName) {
            bw.write('\"');
            bw.write(COLUMN_TYPES);
            bw.write('\"');
        } else {
            bw.write(COLUMN_TYPES);
        }
        bw.write(':');
        List types = Objectory.createList();
        String typeName = null;
        ImmutableList column = null;
        int len = columnNames.size();
        for (int i = 0; i < len; ++i) {
            typeName = null;
            column = ds.getColumn(i);
            for (Object value : column) {
                if (value == null) continue;
                typeName = N.typeOf(value.getClass()).name();
                break;
            }
            types.add(typeName);
        }
        this.write(bw, types, config, false, nextIndentation, serializedObjects);
        Objectory.recycle(types);
        if (N.notNullOrEmpty(ds.properties())) {
            bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
                bw.write(config.getIndentation());
            }
            if (quotePropName) {
                bw.write('\"');
                bw.write(PROPERTIES);
                bw.write('\"');
            } else {
                bw.write(PROPERTIES);
            }
            bw.write(':');
            this.write(bw, ds.properties(), config, false, nextIndentation, serializedObjects);
        }
        if (ds.frozen()) {
            bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
                bw.write(config.getIndentation());
            }
            if (quotePropName) {
                bw.write('\"');
                bw.write(FROZEN);
                bw.write('\"');
            } else {
                bw.write(FROZEN);
            }
            bw.write(':');
            bw.write(ds.frozen());
        }
        if (columnNames.size() > 0) {
            bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
            String columnName = null;
            int len2 = columnNames.size();
            for (int i = 0; i < len2; ++i) {
                columnName = (String)columnNames.get(i);
                column = ds.getColumn(i);
                if (i > 0) {
                    bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                }
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(nextIndentation);
                }
                if (quotePropName) {
                    bw.write('\"');
                    bw.write(columnName);
                    bw.write('\"');
                } else {
                    bw.write(columnName);
                }
                bw.write(':');
                this.write(bw, column, config, false, nextIndentation, serializedObjects);
            }
        }
        if (config.isBracketRootValue() || !isFirstCall) {
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                if (indentation != null) {
                    bw.write(indentation);
                }
            }
            bw.write('}');
        }
    }

    private boolean hasCircularReference(BufferedJSONWriter bw, Object obj, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (obj != null && serializedObjects != null) {
            if (serializedObjects.contains(obj)) {
                bw.write("null");
                return true;
            }
            serializedObjects.add(obj);
        }
        return false;
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String str, JSONDeserializationConfig config) {
        if (N.isNullOrEmpty(str)) {
            return N.defaultValueOf(targetClass);
        }
        config = this.check(config);
        char[] cbuf = Objectory.createCharArrayBuffer();
        try {
            JSONReader jr = JSONStringReader.parse(str, cbuf);
            T t = this.read(targetClass, str, jr, config);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(cbuf);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String str, int fromIndex, int toIndex, JSONDeserializationConfig config) {
        if (N.isNullOrEmpty(str)) {
            return N.defaultValueOf(targetClass);
        }
        config = this.check(config);
        char[] cbuf = Objectory.createCharArrayBuffer();
        try {
            JSONReader jr = JSONStringReader.parse(str, fromIndex, toIndex, cbuf);
            T t = this.read(targetClass, str, jr, config);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(cbuf);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file, JSONDeserializationConfig config) {
        T t;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            t = this.deserialize(targetClass, (InputStream)is, config);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
        return t;
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is, JSONDeserializationConfig config) {
        InputStreamReader reader = new InputStreamReader(is);
        return this.deserialize(targetClass, (Reader)reader, config);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader, JSONDeserializationConfig config) {
        return this.read(targetClass, reader, config);
    }

    protected <T> T read(Class<T> targetClass, Reader reader, JSONDeserializationConfig config) {
        config = this.check(config);
        char[] rbuf = Objectory.createCharArrayBuffer();
        char[] cbuf = Objectory.createCharArrayBuffer();
        try {
            JSONReader jr = JSONStreamReader.parse(reader, rbuf, cbuf);
            T t = this.read(targetClass, reader, jr, config);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(cbuf);
            Objectory.recycle(rbuf);
        }
    }

    protected <T> T read(Class<T> targetClass, Object input, JSONReader jr, JSONDeserializationConfig config) throws IOException {
        Type type = N.typeOf(targetClass);
        switch (type.getSerializationType()) {
            case SERIALIZABLE: {
                if (type.isArray()) {
                    return this.readArray(null, targetClass, jr, config, null, true);
                }
                if (type.isCollection()) {
                    return this.readCollection(null, targetClass, jr, config, null, true);
                }
                return type.valueOf(input instanceof String ? (String)input : IOUtil.readString((Reader)input));
            }
            case ENTITY: {
                return this.readEntity(targetClass, jr, config, null, true);
            }
            case MAP: {
                return this.readMap(null, targetClass, jr, config, null, true);
            }
            case ARRAY: {
                return this.readArray(null, targetClass, jr, config, null, true);
            }
            case COLLECTION: {
                return this.readCollection(null, targetClass, jr, config, null, true);
            }
            case MAP_ENTITY: {
                return this.readMapEntity(targetClass, jr, config, true);
            }
            case DATA_SET: {
                return this.readDataSet(targetClass, jr, config, true);
            }
        }
        int firstToken = jr.nextToken();
        if (Object.class.equals(targetClass)) {
            if (firstToken == 1) {
                return (T)this.readMap(null, Map.class, jr, config, null, false);
            }
            if (firstToken == 3) {
                return (T)this.readCollection(null, List.class, jr, config, null, false);
            }
        }
        throw new ParseException("Unsupported class: " + ClassUtil.getCanonicalClassName(targetClass) + ". Only Array/List/Map and Entity class with getter/setter methods are supported");
    }

    protected <T> T readEntity(Class<T> targetClass, JSONReader jr, JSONDeserializationConfig config, Type<?> propType, boolean isFirstCall) throws IOException {
        int firstToken;
        boolean hasPropTypes = N.notNullOrEmpty(config.getPropTypes());
        boolean ignoreUnknownProperty = config.isIgnoreUnknownProperty();
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(targetClass);
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(targetClass);
        T result = N.newInstance(targetClass);
        ParserUtil.PropInfo propInfo = null;
        String propName = null;
        Object propValue = null;
        boolean isPropName = true;
        propType = null;
        int n = firstToken = isFirstCall ? jr.nextToken() : 1;
        if (firstToken == -1) {
            if (isFirstCall && N.notNullOrEmpty(jr.getText())) {
                throw new ParseException("Can't parse: " + jr.getText());
            }
            return null;
        }
        int token = firstToken == 1 ? jr.nextToken() : firstToken;
        while (true) {
            switch (token) {
                case 5: 
                case 7: {
                    break;
                }
                case 6: 
                case 8: {
                    if (isPropName) {
                        propInfo = jr.readPropInfo(entityInfo);
                        if (propInfo == null) {
                            propName = jr.getText();
                            propInfo = entityInfo.getPropInfo(propName);
                        } else {
                            propName = propInfo.name;
                        }
                        if (propInfo == null) {
                            propType = null;
                        } else {
                            Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                            if (propType == null) {
                                propType = propInfo.jsonXmlType;
                            }
                        }
                        if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName) || propInfo != null || ignoreUnknownProperty) break;
                        throw new ParseException("Unknown property: " + propName);
                    }
                    if (propInfo == null || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) break;
                    propValue = this.readPropValue(propInfo.jsonXmlType, propInfo, jr);
                    propInfo.setPropValue(result, propValue);
                    break;
                }
                case 9: {
                    if (isPropName) {
                        isPropName = false;
                        if (!jr.hasText()) break;
                        propName = jr.getText();
                        propInfo = entityInfo.getPropInfo(propName);
                        if (propInfo == null) {
                            propType = null;
                        } else {
                            Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                            if (propType == null) {
                                propType = propInfo.jsonXmlType;
                            }
                        }
                        if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName) || propInfo != null || ignoreUnknownProperty) break;
                        throw new ParseException("Unknown property: " + propName);
                    }
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
                case 10: {
                    if (isPropName) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    isPropName = true;
                    if (!jr.hasText() || propInfo == null || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) break;
                    propValue = this.readPropValue(propInfo.jsonXmlType, propInfo, jr);
                    propInfo.setPropValue(result, propValue);
                    break;
                }
                case 1: {
                    if (isPropName) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    if (propInfo == null || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                        propValue = this.readMap(null, Map.class, jr, defaultJSONDeserializationConfig, null, false);
                        break;
                    }
                    propValue = this.readBracedValue(propType, jr, config);
                    propInfo.setPropValue(result, propValue);
                    break;
                }
                case 3: {
                    if (isPropName) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    if (propInfo == null || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                        propValue = this.readCollection(null, List.class, jr, defaultJSONDeserializationConfig, null, false);
                        break;
                    }
                    propValue = this.readBracketedValue(propType, jr, config);
                    propInfo.setPropValue(result, propValue);
                    break;
                }
                case -1: 
                case 2: {
                    if (isPropName && propInfo != null) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    if (firstToken == 1 && token != 2 || firstToken != 1 && token == 2) {
                        throw new ParseException("The JSON text should be wrapped or unwrapped with \"[]\" or \"{}\"");
                    }
                    if (jr.hasText() && propInfo != null && (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName))) {
                        propValue = this.readPropValue(propInfo.jsonXmlType, propInfo, jr);
                        propInfo.setPropValue(result, propValue);
                    }
                    return result;
                }
                default: {
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
            }
            token = jr.nextToken();
        }
    }

    protected <T> T readMap(Map<Object, Object> outResult, Class<T> targetClass, JSONReader jr, JSONDeserializationConfig config, Type<?> propType, boolean isFirstCall) throws IOException {
        int firstToken;
        Type<Object> keyType = defaultKeyType;
        if (propType != null && propType.isMap() && !Object.class.equals(propType.getParameterTypes()[0].clazz())) {
            keyType = propType.getParameterTypes()[0];
        } else if (config.getMapKeyType() != null && !Object.class.equals(config.getMapKeyType().clazz())) {
            keyType = config.getMapKeyType();
        }
        boolean isStringKey = String.class == keyType.clazz();
        Type<Object> valueType = defaultValueType;
        if (propType != null && propType.isMap() && !Object.class.equals(propType.getParameterTypes()[1].clazz())) {
            valueType = propType.getParameterTypes()[1];
        } else if (config.getMapValueType() != null && !Object.class.equals(config.getMapValueType().clazz())) {
            valueType = config.getMapValueType();
        }
        boolean hasPropTypes = N.notNullOrEmpty(config.getPropTypes());
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
        Map result = outResult == null ? (Map)JSONParserImpl.newPropInstance(targetClass, null) : outResult;
        String propName = null;
        boolean isKey = true;
        propType = null;
        Object key = null;
        Object value = null;
        int n = firstToken = isFirstCall ? jr.nextToken() : 1;
        if (firstToken == -1) {
            if (isFirstCall && N.notNullOrEmpty(jr.getText())) {
                throw new ParseException("Can't parse: " + jr.getText());
            }
            return null;
        }
        int token = firstToken == 1 ? jr.nextToken() : firstToken;
        while (true) {
            switch (token) {
                case 5: 
                case 7: {
                    break;
                }
                case 6: 
                case 8: {
                    if (isKey) {
                        key = jr.readValue(keyType);
                        propName = isStringKey ? (String)key : (key == null ? "null" : key.toString());
                        Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                        if (propType != null) break;
                        propType = valueType;
                        break;
                    }
                    if (key != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(key.toString())) break;
                    value = this.readPropValue(propType, jr);
                    result.put(key, value);
                    break;
                }
                case 9: {
                    if (isKey) {
                        isKey = false;
                        if (jr.hasText()) {
                            key = jr.readValue(keyType);
                            propName = isStringKey ? (String)key : (key == null ? "null" : key.toString());
                            Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                        }
                        if (propType != null) break;
                        propType = valueType;
                        break;
                    }
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
                case 10: {
                    if (isKey) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    isKey = true;
                    if (!jr.hasText() || key != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(key.toString())) break;
                    value = this.readPropValue(propType, jr);
                    result.put(key, value);
                    break;
                }
                case 1: {
                    if (isKey) {
                        key = this.readBracedValue(keyType, jr, config);
                        propType = valueType;
                        break;
                    }
                    if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                        value = this.readMap(null, Map.class, jr, defaultJSONDeserializationConfig, null, false);
                        break;
                    }
                    value = this.readBracedValue(propType, jr, config);
                    result.put(key, value);
                    break;
                }
                case 3: {
                    if (isKey) {
                        key = this.readBracketedValue(keyType, jr, config);
                        propType = valueType;
                        break;
                    }
                    if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                        value = this.readCollection(null, List.class, jr, defaultJSONDeserializationConfig, null, false);
                        break;
                    }
                    value = this.readBracketedValue(propType, jr, config);
                    result.put(key, value);
                    break;
                }
                case -1: 
                case 2: {
                    if (isKey && key != null) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    if (firstToken == 1 && token != 2 || firstToken != 1 && token == 2) {
                        throw new ParseException("The JSON text should be wrapped or unwrapped with \"[]\" or \"{}\"");
                    }
                    if (jr.hasText() && (key == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(key.toString()))) {
                        value = this.readPropValue(propType, jr);
                        result.put(key, value);
                    }
                    return (T)result;
                }
                default: {
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
            }
            token = jr.nextToken();
        }
    }

    protected <T> T readArray(Object[] a, Class<T> targetClass, JSONReader jr, JSONDeserializationConfig config, Type<?> propType, boolean isFirstCall) throws IOException {
        int firstToken;
        Type<Object> eleType = defaultValueType;
        eleType = propType != null && (propType.isArray() || propType.isCollection()) && !Object.class.equals(propType.getElementType().clazz()) ? propType.getElementType() : (config.getElementType() != null && !Object.class.equals(config.getElementType().clazz()) ? config.getElementType() : N.typeOf(targetClass.isArray() && !Object.class.equals(targetClass.getComponentType()) ? targetClass.getComponentType() : Object.class));
        int n = firstToken = isFirstCall ? jr.nextToken() : 3;
        if (firstToken == -1) {
            if (isFirstCall && N.notNullOrEmpty(jr.getText())) {
                throw new ParseException("Can't parse: " + jr.getText());
            }
            return null;
        }
        if (a == null) {
            List c = Objectory.createList();
            Object propValue = null;
            try {
                int preToken = firstToken;
                int token = firstToken == 3 ? jr.nextToken() : firstToken;
                while (true) {
                    switch (token) {
                        case 5: 
                        case 7: {
                            break;
                        }
                        case 6: 
                        case 8: {
                            propValue = this.readPropValue(eleType, jr);
                            c.add(propValue);
                            break;
                        }
                        case 10: {
                            if (!jr.hasText() && preToken != 10) break;
                            propValue = this.readPropValue(eleType, jr);
                            c.add(propValue);
                            break;
                        }
                        case 1: {
                            propValue = this.readBracedValue(eleType, jr, config);
                            c.add(propValue);
                            break;
                        }
                        case 3: {
                            propValue = this.readBracketedValue(eleType, jr, config);
                            c.add(propValue);
                            break;
                        }
                        case -1: 
                        case 4: {
                            if (firstToken == 3 && token != 4 || firstToken != 3 && token == 4) {
                                throw new ParseException("The JSON text should be wrapped or unwrapped with \"[]\" or \"{}\"");
                            }
                            if (jr.hasText()) {
                                propValue = this.readPropValue(eleType, jr);
                                c.add(propValue);
                            }
                            Object t = JSONParserImpl.collection2Array(targetClass, c);
                            return t;
                        }
                        default: {
                            throw new ParseException(this.getErrorMsg(jr, token));
                        }
                    }
                    preToken = token;
                    token = jr.nextToken();
                }
            }
            finally {
                Objectory.recycle(c);
            }
        }
        int idx = 0;
        Object propValue = null;
        int preToken = firstToken;
        int token = firstToken == 3 ? jr.nextToken() : firstToken;
        while (true) {
            switch (token) {
                case 5: 
                case 7: {
                    break;
                }
                case 6: 
                case 8: {
                    propValue = this.readPropValue(eleType, jr);
                    a[idx++] = propValue;
                    break;
                }
                case 10: {
                    if (!jr.hasText() && preToken != 10) break;
                    propValue = this.readPropValue(eleType, jr);
                    a[idx++] = propValue;
                    break;
                }
                case 1: {
                    propValue = this.readBracedValue(eleType, jr, config);
                    a[idx++] = propValue;
                    break;
                }
                case 3: {
                    propValue = this.readBracketedValue(eleType, jr, config);
                    a[idx++] = propValue;
                    break;
                }
                case -1: 
                case 4: {
                    if (firstToken == 3 && token != 4 || firstToken != 3 && token == 4) {
                        throw new ParseException("The JSON text should be wrapped or unwrapped with \"[]\" or \"{}\"");
                    }
                    if (jr.hasText()) {
                        propValue = this.readPropValue(eleType, jr);
                        a[idx++] = propValue;
                    }
                    return (T)a;
                }
                default: {
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
            }
            preToken = token;
            token = jr.nextToken();
        }
    }

    protected <T> T readCollection(Collection<Object> outResult, Class<T> targetClass, JSONReader jr, JSONDeserializationConfig config, Type<?> propType, boolean isFirstCall) throws IOException {
        int firstToken;
        Type<Object> eleType = defaultValueType;
        if (propType != null && (propType.isCollection() || propType.isArray()) && !Object.class.equals(propType.getElementType().clazz())) {
            eleType = propType.getElementType();
        } else if (config.getElementType() != null && !Object.class.equals(config.getElementType().clazz())) {
            eleType = config.getElementType();
        }
        Collection result = outResult == null ? (Collection)JSONParserImpl.newPropInstance(targetClass, null) : outResult;
        Object propValue = null;
        int n = firstToken = isFirstCall ? jr.nextToken() : 3;
        if (firstToken == -1) {
            if (isFirstCall && N.notNullOrEmpty(jr.getText())) {
                throw new ParseException("Can't parse: " + jr.getText());
            }
            return null;
        }
        int preToken = firstToken;
        int token = firstToken == 3 ? jr.nextToken() : firstToken;
        while (true) {
            switch (token) {
                case 5: 
                case 7: {
                    break;
                }
                case 6: 
                case 8: {
                    propValue = this.readPropValue(eleType, jr);
                    result.add(propValue);
                    break;
                }
                case 10: {
                    if (!jr.hasText() && preToken != 10) break;
                    propValue = this.readPropValue(eleType, jr);
                    result.add(propValue);
                    break;
                }
                case 1: {
                    propValue = this.readBracedValue(eleType, jr, config);
                    result.add(propValue);
                    break;
                }
                case 3: {
                    propValue = this.readBracketedValue(eleType, jr, config);
                    result.add(propValue);
                    break;
                }
                case -1: 
                case 4: {
                    if (firstToken == 3 && token != 4 || firstToken != 3 && token == 4) {
                        throw new ParseException("The JSON text should be wrapped or unwrapped with \"[]\" or \"{}\"");
                    }
                    if (jr.hasText()) {
                        propValue = this.readPropValue(eleType, jr);
                        result.add(propValue);
                    }
                    return (T)result;
                }
                default: {
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
            }
            preToken = token;
            token = jr.nextToken();
        }
    }

    protected <T> T readMapEntity(Class<T> targetClass, JSONReader jr, JSONDeserializationConfig config, boolean isFirstCall) throws IOException {
        int firstToken;
        MapEntity mapEntity = null;
        int n = firstToken = isFirstCall ? jr.nextToken() : 3;
        if (firstToken == -1) {
            if (isFirstCall && N.notNullOrEmpty(jr.getText())) {
                throw new ParseException("Can't parse: " + jr.getText());
            }
            return null;
        }
        int token = firstToken == 1 ? jr.nextToken() : firstToken;
        while (true) {
            switch (token) {
                case 5: 
                case 7: {
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    if (jr.hasText()) {
                        if (mapEntity == null) {
                            mapEntity = new MapEntity(jr.getText());
                            break;
                        }
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    if (mapEntity != null) break;
                    throw new ParseException("Entity name can't be null or empty");
                }
                case 1: {
                    Map props = this.readMap(null, Map.class, jr, config, null, false);
                    for (String propName : props.keySet()) {
                        mapEntity.set(propName, props.get(propName));
                    }
                    break;
                }
                case -1: 
                case 2: {
                    if (firstToken == 1 && token != 2 || firstToken != 1 && token == 2) {
                        throw new ParseException("The JSON text should be wrapped or unwrapped with \"[]\" or \"{}\"");
                    }
                    return (T)mapEntity;
                }
                default: {
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
            }
            token = jr.nextToken();
        }
    }

    protected <T> T readDataSet(Class<T> targetClass, JSONReader jr, JSONDeserializationConfig config, boolean isFirstCall) throws IOException {
        int firstToken;
        RowDataSet rs = null;
        List columnNameList = null;
        ArrayList<List> columnList = null;
        Properties<String, Object> properties = null;
        boolean frozen = false;
        List columnTypeList = null;
        String propName = null;
        Type propValueType = defaultValueType;
        boolean isKey = true;
        int n = firstToken = isFirstCall ? jr.nextToken() : 1;
        if (firstToken == -1) {
            if (isFirstCall && N.notNullOrEmpty(jr.getText())) {
                throw new ParseException("Can't parse: " + jr.getText());
            }
            return null;
        }
        int token = firstToken == 1 ? jr.nextToken() : firstToken;
        while (true) {
            block0 : switch (token) {
                case 5: 
                case 7: {
                    break;
                }
                case 6: 
                case 8: {
                    if (isKey) {
                        propName = jr.getText();
                        break;
                    }
                    Integer order = dataSetPropOrder.get(propName);
                    if (order == null) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    switch (order) {
                        case 6: {
                            frozen = (Boolean)jr.readValue(boolType);
                            break block0;
                        }
                    }
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
                case 9: {
                    if (isKey) {
                        isKey = false;
                        if (!jr.hasText()) break;
                        propName = jr.getText();
                        break;
                    }
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
                case 10: {
                    if (isKey) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    isKey = true;
                    if (!jr.hasText()) break;
                    Integer order = dataSetPropOrder.get(propName);
                    if (order == null) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    switch (order) {
                        case 6: {
                            frozen = (Boolean)jr.readValue(boolType);
                            break block0;
                        }
                    }
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
                case 3: {
                    Integer order = dataSetPropOrder.get(propName);
                    if (order == null || columnNameList != null && columnNameList.contains(propName)) {
                        int index = N.indexOf(columnNameList, (Object)propName);
                        propValueType = (Type)columnTypeList.get(index);
                        if (propValueType == null) {
                            propValueType = defaultValueType;
                        }
                        List column = this.readCollection(null, List.class, jr, JSONDeserializationConfig.JDC.of(propValueType.clazz()), null, false);
                        if (columnList == null) {
                            columnList = new ArrayList<List>(columnNameList.size());
                            N.fill(columnList, 0, columnNameList.size(), null);
                        }
                        columnList.set(index, column);
                        break;
                    }
                    switch (order) {
                        case 3: {
                            columnNameList = this.readCollection(null, List.class, jr, jdcForStringElement, null, false);
                            break block0;
                        }
                        case 4: {
                            columnTypeList = this.readCollection(null, List.class, jr, jdcForTypeElement, null, false);
                            break block0;
                        }
                    }
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
                case 1: {
                    if (!PROPERTIES.equals(propName)) {
                        throw new ParseException(this.getErrorMsg(jr, token) + ". Key: " + propName + ",  Value: " + jr.getText());
                    }
                    properties = Properties.from(this.readMap(null, Map.class, jr, jdcForPropertiesElement, null, false));
                    break;
                }
                case -1: 
                case 2: {
                    if (firstToken == 1 && token != 2 || firstToken != 1 && token == 2) {
                        throw new ParseException("The JSON text should be wrapped or unwrapped with \"[]\" or \"{}\"");
                    }
                    if (isKey && propName != null) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    if (jr.hasText()) {
                        throw new ParseException(this.getErrorMsg(jr, token));
                    }
                    rs = new RowDataSet(columnNameList, columnList, properties);
                    if (frozen) {
                        rs.freeze();
                    }
                    return (T)rs;
                }
                default: {
                    throw new ParseException(this.getErrorMsg(jr, token));
                }
            }
            token = jr.nextToken();
        }
    }

    protected Object readBracketedValue(Type<?> eleType, JSONReader jr, JSONDeserializationConfig config) throws IOException {
        if (eleType.isArray()) {
            return this.readArray(null, eleType.clazz(), jr, config, eleType, false);
        }
        if (eleType.isCollection()) {
            return this.readCollection(null, eleType.clazz(), jr, config, eleType, false);
        }
        List list = this.readCollection(null, List.class, jr, config, eleType, false);
        List2PairTripleConverter converter = list2PairTripleConverterMap.get(eleType.clazz());
        return converter == null ? list : converter.convert(list, eleType);
    }

    protected Object readBracedValue(Type<?> eleType, JSONReader jr, JSONDeserializationConfig config) throws IOException {
        if (eleType.isEntity()) {
            return this.readEntity(eleType.clazz(), jr, config, eleType, false);
        }
        if (eleType.isMap()) {
            return this.readMap(null, eleType.clazz(), jr, config, eleType, false);
        }
        if (eleType.isDataSet()) {
            return this.readDataSet(DataSet.class, jr, config, false);
        }
        return this.readMap(null, Map.class, jr, config, eleType, false);
    }

    protected Object readPropValue(Type<?> propType, JSONReader jr) throws IOException {
        return jr.readValue(propType);
    }

    protected Object readPropValue(Type<?> propType, ParserUtil.PropInfo propInfo, JSONReader jr) throws IOException {
        return propInfo != null && propInfo.hasFormat ? propInfo.readPropValue((String)jr.readValue(strType)) : jr.readValue(propType);
    }

    private String getErrorMsg(JSONReader jr, int token) throws IOException {
        switch (token) {
            case 1: {
                return "Error on parsing at '{' with " + jr.getText();
            }
            case 2: {
                return "Error on parsing at '}' with " + jr.getText();
            }
            case 3: {
                return "Error on parsing at '[' with " + jr.getText();
            }
            case 4: {
                return "Error on parsing at ']' with " + jr.getText();
            }
            case 5: {
                return "Error on parsing at starting '\"' with " + jr.getText();
            }
            case 6: {
                return "Error on parsing at ending '\"' with " + jr.getText();
            }
            case 7: {
                return "Error on parsing at starting ''' with " + jr.getText();
            }
            case 8: {
                return "Error on parsing at ending ''' with " + jr.getText();
            }
            case 9: {
                return "Error on parsing at ':' with " + jr.getText();
            }
            case 10: {
                return "Error on parsing at ',' with " + jr.getText();
            }
        }
        return "Unknown error on event : " + token + " with " + jr.getText();
    }

    static {
        dataSetPropOrder.put(ENTITY_NAME, 1);
        dataSetPropOrder.put(ENTITY_TYPE, 2);
        dataSetPropOrder.put(COLUMN_NAMES, 3);
        dataSetPropOrder.put(COLUMN_TYPES, 4);
        dataSetPropOrder.put(PROPERTIES, 5);
        dataSetPropOrder.put(FROZEN, 6);
        jdcForStringElement = JSONDeserializationConfig.JDC.of(String.class);
        jdcForTypeElement = JSONDeserializationConfig.JDC.of(Type.class);
        jdcForPropertiesElement = (JSONDeserializationConfig)JSONDeserializationConfig.JDC.of(String.class).setMapKeyType(String.class);
        list2PairTripleConverterMap = new HashMap();
        list2PairTripleConverterMap.put(Pair.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Pair.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]));
            }
        });
        list2PairTripleConverterMap.put(Triple.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Triple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]), N.convert(list.get(2), paramTypes[2]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple1.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple2.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple3.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]), N.convert(list.get(2), paramTypes[2]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple4.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]), N.convert(list.get(2), paramTypes[2]), N.convert(list.get(3), paramTypes[3]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple5.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]), N.convert(list.get(2), paramTypes[2]), N.convert(list.get(3), paramTypes[3]), N.convert(list.get(4), paramTypes[4]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple6.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]), N.convert(list.get(2), paramTypes[2]), N.convert(list.get(3), paramTypes[3]), N.convert(list.get(4), paramTypes[4]), N.convert(list.get(5), paramTypes[5]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple7.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]), N.convert(list.get(2), paramTypes[2]), N.convert(list.get(3), paramTypes[3]), N.convert(list.get(4), paramTypes[4]), N.convert(list.get(5), paramTypes[5]), N.convert(list.get(6), paramTypes[6]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple8.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]), N.convert(list.get(2), paramTypes[2]), N.convert(list.get(3), paramTypes[3]), N.convert(list.get(4), paramTypes[4]), N.convert(list.get(5), paramTypes[5]), N.convert(list.get(6), paramTypes[6]), N.convert(list.get(7), paramTypes[7]));
            }
        });
        list2PairTripleConverterMap.put(Tuple.Tuple9.class, new List2PairTripleConverter(){

            @Override
            public <T> T convert(List<?> list, Type<?> eleType) {
                Type<?>[] paramTypes = eleType.getParameterTypes();
                return (T)Tuple.of(N.convert(list.get(0), paramTypes[0]), N.convert(list.get(1), paramTypes[1]), N.convert(list.get(2), paramTypes[2]), N.convert(list.get(3), paramTypes[3]), N.convert(list.get(4), paramTypes[4]), N.convert(list.get(5), paramTypes[5]), N.convert(list.get(6), paramTypes[6]), N.convert(list.get(7), paramTypes[7]), N.convert(list.get(8), paramTypes[8]));
            }
        });
    }

    private static interface List2PairTripleConverter {
        public <T> T convert(List<?> var1, Type<?> var2);
    }
}

