/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.parser.AbstractJSONReader;
import com.landawn.abacus.parser.JSONReader;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.u;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class JSONStringReader
extends AbstractJSONReader {
    static final Map<Class<?>, Object> defaultOptionals = new HashMap(16);
    final Reader reader;
    final char[] strValue;
    int strEndIndex = 0;
    int strBeginIndex = 0;
    int strStart = 0;
    int strEnd = 0;
    final char[] cbuf;
    int nextEvent = -1;
    int nextChar = 0;

    JSONStringReader(String str, char[] cbuf) {
        this(str, 0, str.length(), cbuf);
    }

    JSONStringReader(String str, int beginIndex, int toIndex, char[] cbuf) {
        this(StringUtil.getCharsForReadOnly(str), beginIndex, toIndex, cbuf, null);
    }

    JSONStringReader(char[] strValue, int beginIndex, int endIndex, char[] cbuf, Reader reader) {
        if (beginIndex < 0 || endIndex < 0 || endIndex < beginIndex) {
            throw new IllegalArgumentException("Invalid beginIndex or endIndex: " + beginIndex + ", " + endIndex);
        }
        this.reader = reader;
        this.strValue = strValue;
        this.strBeginIndex = beginIndex;
        this.strEndIndex = endIndex;
        this.cbuf = cbuf;
    }

    public static JSONReader parse(String str, char[] cbuf) {
        return new JSONStringReader(str, cbuf);
    }

    public static JSONReader parse(String str, int beginIndex, int endIndex, char[] cbuf) {
        return new JSONStringReader(str, beginIndex, endIndex, cbuf);
    }

    @Override
    public boolean hasText() throws IOException {
        return this.nextChar > 0 || this.strEnd > this.strStart;
    }

    @Override
    public int nextToken() throws IOException {
        this.nextChar = 0;
        this.strStart = this.strBeginIndex;
        if (this.nextEvent == 5) {
            char ch = '\u0000';
            while (this.strBeginIndex < this.strEndIndex) {
                if ((ch = this.strValue[this.strBeginIndex++]) == '\"') {
                    this.strEnd = this.strBeginIndex - 1;
                    this.nextEvent = 6;
                    return this.nextEvent;
                }
                if (this.nextChar > 0) {
                    this.cbuf[this.nextChar++] = ch == '\\' ? this.readEscapeCharacter() : (char)ch;
                    continue;
                }
                if (ch != '\\') continue;
                this.strEnd = this.strBeginIndex - 1;
                N.copy(this.strValue, this.strStart, this.cbuf, 0, this.strEnd - this.strStart);
                this.nextChar = this.strEnd - this.strStart;
                this.cbuf[this.nextChar++] = this.readEscapeCharacter();
            }
        } else if (this.nextEvent == 7) {
            char ch = '\u0000';
            while (this.strBeginIndex < this.strEndIndex) {
                if ((ch = this.strValue[this.strBeginIndex++]) == '\'') {
                    this.strEnd = this.strBeginIndex - 1;
                    this.nextEvent = 8;
                    return this.nextEvent;
                }
                if (this.nextChar > 0) {
                    this.cbuf[this.nextChar++] = ch == '\\' ? this.readEscapeCharacter() : (char)ch;
                    continue;
                }
                if (ch != '\\') continue;
                this.strEnd = this.strBeginIndex - 1;
                N.copy(this.strValue, this.strStart, this.cbuf, 0, this.strEnd - this.strStart);
                this.nextChar = this.strEnd - this.strStart;
                this.cbuf[this.nextChar++] = this.readEscapeCharacter();
            }
        } else {
            char ch = '\u0000';
            while (this.strBeginIndex < this.strEndIndex) {
                if ((ch = this.strValue[this.strBeginIndex++]) < '\u0080') {
                    this.nextEvent = charEvents[ch];
                    if (this.nextEvent > 0) {
                        this.strEnd = this.strBeginIndex - 1;
                        return this.nextEvent;
                    }
                }
                if (this.nextChar > 0) {
                    if (ch == '\\') {
                        ch = this.readEscapeCharacter();
                    }
                    if (ch < '!') continue;
                    this.cbuf[this.nextChar++] = ch;
                    continue;
                }
                if (ch < '!') {
                    if (this.strStart == this.strBeginIndex - 1) {
                        ++this.strStart;
                        continue;
                    }
                    this.strEnd = this.strBeginIndex - 1;
                    N.copy(this.strValue, this.strStart, this.cbuf, 0, this.strEnd - this.strStart);
                    this.nextChar = this.strEnd - this.strStart;
                    continue;
                }
                if (ch != '\\') continue;
                this.strEnd = this.strBeginIndex - 1;
                N.copy(this.strValue, this.strStart, this.cbuf, 0, this.strEnd - this.strStart);
                this.nextChar = this.strEnd - this.strStart;
                ch = this.readEscapeCharacter();
                if (ch < '!') continue;
                this.cbuf[this.nextChar++] = ch;
            }
        }
        this.strEnd = this.strBeginIndex;
        this.nextEvent = -1;
        return this.nextEvent;
    }

    @Override
    public String getText() throws IOException {
        return this.nextChar > 0 ? String.valueOf(this.cbuf, 0, this.nextChar) : String.valueOf(this.strValue, this.strStart, this.strEnd - this.strStart);
    }

    @Override
    public <T> T readValue(Type<T> type) throws IOException {
        if (this.nextEvent != 6 && this.nextEvent != 8) {
            if (this.nextChar == 4 && this.cbuf[0] == 'n' && this.cbuf[1] == 'u' && this.cbuf[2] == 'l' && this.cbuf[3] == 'l' || this.strEnd - this.strStart == 4 && this.strValue[this.strStart] == 'n' && this.strValue[this.strStart + 1] == 'u' && this.strValue[this.strStart + 2] == 'l' && this.strValue[this.strStart + 3] == 'l') {
                return (T)(type.isOptionalOrNullable() ? defaultOptionals.get(type.clazz()) : null);
            }
            if (type.clazz().equals(Object.class)) {
                if (this.nextChar == 4 && this.cbuf[0] == 't' && this.cbuf[1] == 'r' && this.cbuf[2] == 'u' && this.cbuf[3] == 'e' || this.strEnd - this.strStart == 4 && this.strValue[this.strStart] == 't' && this.strValue[this.strStart + 1] == 'r' && this.strValue[this.strStart + 2] == 'u' && this.strValue[this.strStart + 3] == 'e') {
                    return (T)Boolean.TRUE;
                }
                if (this.nextChar == 5 && this.cbuf[0] == 'f' && this.cbuf[1] == 'a' && this.cbuf[2] == 'l' && this.cbuf[3] == 's' && this.cbuf[4] == 'e' || this.strEnd - this.strStart == 5 && this.strValue[this.strStart] == 'f' && this.strValue[this.strStart + 1] == 'a' && this.strValue[this.strStart + 2] == 'l' && this.strValue[this.strStart + 3] == 's' && this.strValue[this.strStart + 4] == 'e') {
                    return (T)Boolean.FALSE;
                }
                String str = new String(this.nextChar > 0 ? N.copyOfRange(this.cbuf, 0, this.nextChar) : N.copyOfRange(this.strValue, this.strStart, this.strEnd));
                try {
                    return (T)StringUtil.createNumber(str).get();
                }
                catch (Exception exception) {
                    return type.valueOf(str);
                }
            }
        }
        return this.nextChar > 0 ? type.valueOf(this.cbuf, 0, this.nextChar) : type.valueOf(this.strValue, this.strStart, this.strEnd - this.strStart);
    }

    @Override
    public ParserUtil.PropInfo readPropInfo(JSONReader.SymbolReader symbolReader) {
        return this.nextChar > 0 ? symbolReader.readPropInfo(this.cbuf, 0, this.nextChar) : symbolReader.readPropInfo(this.strValue, this.strStart, this.strEnd);
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    protected char readEscapeCharacter() throws IOException {
        char escaped = this.strValue[this.strBeginIndex++];
        switch (escaped) {
            case 'u': {
                char result = '\u0000';
                char c = '\u0000';
                for (int i = 0; i < 4; ++i) {
                    c = this.strValue[this.strBeginIndex++];
                    result = (char)(result << 4);
                    if (c >= '0' && c <= '9') {
                        result = (char)(result + (c - 48));
                        continue;
                    }
                    if (c >= 'a' && c <= 'f') {
                        result = (char)(result + (c - 97 + 10));
                        continue;
                    }
                    if (c >= 'A' && c <= 'F') {
                        result = (char)(result + (c - 65 + 10));
                        continue;
                    }
                    throw new ParseException("Number format fxception: \\u" + String.valueOf(this.cbuf));
                }
                return result;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return escaped;
    }

    static {
        defaultOptionals.put(u.OptionalBoolean.class, u.OptionalBoolean.empty());
        defaultOptionals.put(u.OptionalChar.class, u.OptionalChar.empty());
        defaultOptionals.put(u.OptionalByte.class, u.OptionalByte.empty());
        defaultOptionals.put(u.OptionalShort.class, u.OptionalShort.empty());
        defaultOptionals.put(u.OptionalInt.class, u.OptionalInt.empty());
        defaultOptionals.put(u.OptionalLong.class, u.OptionalLong.empty());
        defaultOptionals.put(u.OptionalFloat.class, u.OptionalFloat.empty());
        defaultOptionals.put(u.OptionalDouble.class, u.OptionalDouble.empty());
        defaultOptionals.put(u.Optional.class, u.Optional.empty());
        defaultOptionals.put(u.Nullable.class, u.Nullable.empty());
    }
}

