/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.AbstractJSONParser;
import com.landawn.abacus.parser.Exclusion;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.DateUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class JacksonParser
extends AbstractJSONParser {
    private static final List<ObjectMapper> mapperPool = new ArrayList<ObjectMapper>(1000);
    private static final SerializationConfig defaultSerializationConfig;
    private static final DeserializationConfig defaultDeserializationConfig;

    JacksonParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize(Object obj, JSONSerializationConfig config) {
        if (obj == null) {
            return N.EMPTY_STRING;
        }
        BufferedWriter bw = Objectory.createBufferedWriter();
        try {
            this.write(bw, obj, config);
            String string = bw.toString();
            return string;
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(File file, Object obj, JSONSerializationConfig config) {
        FileOutputStream os = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            this.serialize((OutputStream)os, obj, config);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void serialize(OutputStream os, Object obj, JSONSerializationConfig config) {
        BufferedWriter bw = Objectory.createBufferedWriter(os);
        try {
            this.write(bw, obj, config);
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(Writer writer, Object obj, JSONSerializationConfig config) {
        boolean isBufferedWriter = writer instanceof BufferedWriter || writer instanceof java.io.BufferedWriter;
        Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
        try {
            this.write(bw, obj, config);
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle((BufferedWriter)bw);
            }
        }
    }

    protected void write(Writer writer, Object obj, JSONSerializationConfig config) {
        ObjectWriter objectWriter;
        ObjectMapper mapper;
        boolean isRecycable;
        block36: {
            block35: {
                config = this.check(config);
                if (obj == null) {
                    IOUtil.write(writer, (CharSequence)N.EMPTY_STRING);
                    return;
                }
                Class<?> cls = obj.getClass();
                Collection<String> ignorePropNames = config.getIgnoredPropNames(cls);
                if (config.isSkipTransientField()) {
                    ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(cls);
                    if (N.notNullOrEmpty(entityInfo.transientSeriPropNameSet)) {
                        if (N.isNullOrEmpty(ignorePropNames)) {
                            ignorePropNames = entityInfo.transientSeriPropNameSet;
                        } else {
                            ignorePropNames = N.newHashSet(ignorePropNames);
                            ignorePropNames.addAll(entityInfo.transientSeriPropNameSet);
                        }
                    }
                }
                mapper = (isRecycable = N.isNullOrEmpty(ignorePropNames)) ? JacksonParser.getObjectMapper() : new ObjectMapper();
                objectWriter = null;
                mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
                mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, config.isQuotePropName() || config.isQuoteMapKey());
                mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, config.isWrapRootValue());
                if (config.getExclusion() == Exclusion.NULL) {
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                } else if (config.getExclusion() == Exclusion.DEFAULT) {
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
                } else {
                    mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
                }
                if (N.notNullOrEmpty(ignorePropNames)) {
                    Set<String> ignorePropNameSet = ignorePropNames instanceof Set ? (Set<String>)ignorePropNames : N.newHashSet(ignorePropNames);
                    SimpleFilterProvider filters = new SimpleFilterProvider();
                    filters.addFilter("PropertyFilterByName", SimpleBeanPropertyFilter.serializeAllExcept(ignorePropNameSet));
                    mapper.addMixIn(cls, PropertyFilterMixIn.class);
                    objectWriter = mapper.writer((FilterProvider)filters);
                }
                if (config.getDateTimeFormat() == null) break block35;
                switch (config.getDateTimeFormat()) {
                    case LONG: {
                        if (objectWriter == null) {
                            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
                        } else {
                            objectWriter = objectWriter.with(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
                        }
                        break block36;
                    }
                    case ISO_8601_DATETIME: {
                        if (objectWriter == null) {
                            objectWriter = mapper.writer();
                        }
                        objectWriter = objectWriter.with((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")).with(DateUtil.UTC_TIME_ZONE);
                        break block36;
                    }
                    case ISO_8601_TIMESTAMP: {
                        if (objectWriter == null) {
                            objectWriter = mapper.writer();
                        }
                        objectWriter = objectWriter.with((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).with(DateUtil.UTC_TIME_ZONE);
                        break block36;
                    }
                    default: {
                        throw new ParseException("Unsupported data format: " + (Object)((Object)config.getDateTimeFormat()));
                    }
                }
            }
            if (objectWriter == null) {
                mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
            } else {
                objectWriter = objectWriter.with(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            }
        }
        if (config.isPrettyFormat()) {
            if (objectWriter == null) {
                mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            } else {
                objectWriter = objectWriter.with(SerializationFeature.INDENT_OUTPUT);
            }
        } else if (objectWriter == null) {
            mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
        }
        try {
            if (objectWriter == null) {
                mapper.writeValue(writer, obj);
            } else {
                objectWriter.writeValue(writer, obj);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (isRecycable) {
                JacksonParser.recycle(mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, String str, JSONDeserializationConfig config) {
        if (N.isNullOrEmpty(str)) {
            return N.defaultValueOf(targetClass);
        }
        BufferedReader br = Objectory.createBufferedReader(str);
        try {
            T t = this.read(targetClass, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file, JSONDeserializationConfig config) {
        T t;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            t = this.deserialize(targetClass, (InputStream)is, config);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is, JSONDeserializationConfig config) {
        BufferedReader br = Objectory.createBufferedReader(is);
        try {
            T t = this.read(targetClass, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader, JSONDeserializationConfig config) {
        return this.read(targetClass, reader, config);
    }

    protected <T> T read(Class<T> targetClass, Reader reader, JSONDeserializationConfig config) {
        if (config == null) {
            config = defaultJSONDeserializationConfig;
        } else if (N.notNullOrEmpty(config.getIgnoredPropNames())) {
            throw new ParseException("'ignoredPropNames' is not supported");
        }
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, !config.isIgnoreUnknownProperty());
        try {
            Object object = mapper.readValue(reader, targetClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            JacksonParser.recycle(mapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ObjectMapper getObjectMapper() {
        List<ObjectMapper> list = mapperPool;
        synchronized (list) {
            if (mapperPool.size() > 0) {
                return mapperPool.remove(mapperPool.size() - 1);
            }
            return new ObjectMapper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void recycle(ObjectMapper mapper) {
        if (mapper == null) {
            return;
        }
        List<ObjectMapper> list = mapperPool;
        synchronized (list) {
            if (mapperPool.size() < 1000) {
                mapper.setConfig(defaultSerializationConfig);
                mapper.setConfig(defaultDeserializationConfig);
                mapperPool.add(mapper);
            }
        }
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        defaultSerializationConfig = mapper.getSerializationConfig();
        defaultDeserializationConfig = mapper.getDeserializationConfig();
    }

    @JsonFilter(value="PropertyFilterByName")
    class PropertyFilterMixIn {
        PropertyFilterMixIn() {
        }
    }
}

