/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.AbstractXMLParser;
import com.landawn.abacus.parser.Exclusion;
import com.landawn.abacus.parser.JacksonParser;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.parser.XMLDeserializationConfig;
import com.landawn.abacus.parser.XMLSerializationConfig;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

final class JacksonXMLParser
extends AbstractXMLParser {
    private static final List<XmlMapper> mapperPool = new ArrayList<XmlMapper>(1000);

    JacksonXMLParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize(Object obj, XMLSerializationConfig config) {
        if (obj == null) {
            return N.EMPTY_STRING;
        }
        com.landawn.abacus.util.BufferedWriter bw = Objectory.createBufferedWriter();
        try {
            this.write(bw, obj, config);
            String string = bw.toString();
            return string;
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(File file, Object obj, XMLSerializationConfig config) {
        FileOutputStream os = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            this.serialize((OutputStream)os, obj, config);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void serialize(OutputStream os, Object obj, XMLSerializationConfig config) {
        com.landawn.abacus.util.BufferedWriter bw = Objectory.createBufferedWriter(os);
        try {
            this.write(bw, obj, config);
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(Writer writer, Object obj, XMLSerializationConfig config) {
        boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
        Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
        try {
            this.write(bw, obj, config);
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
            }
        }
    }

    protected void write(Writer writer, Object obj, XMLSerializationConfig config) {
        boolean isRecycable;
        if (config == null) {
            config = defaultXMLSerializationConfig;
        }
        if (obj == null) {
            IOUtil.write(writer, (CharSequence)N.EMPTY_STRING);
            return;
        }
        Class<?> cls = obj.getClass();
        Collection<String> ignorePropNames = config.getIgnoredPropNames(cls);
        if (config.isSkipTransientField()) {
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(cls);
            if (N.notNullOrEmpty(entityInfo.transientSeriPropNameSet)) {
                if (N.isNullOrEmpty(ignorePropNames)) {
                    ignorePropNames = entityInfo.transientSeriPropNameSet;
                } else {
                    ignorePropNames = N.newHashSet(ignorePropNames);
                    ignorePropNames.addAll(entityInfo.transientSeriPropNameSet);
                }
            }
        }
        XmlMapper mapper = (isRecycable = N.isNullOrEmpty(ignorePropNames)) ? JacksonXMLParser.getXmlMapper() : new XmlMapper();
        ObjectWriter objectWriter = null;
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        if (config.getExclusion() == Exclusion.NULL) {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        } else if (config.getExclusion() == Exclusion.DEFAULT) {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        } else {
            mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        }
        if (N.notNullOrEmpty(ignorePropNames)) {
            Set<String> ignorePropNameSet = ignorePropNames instanceof Set ? (Set<String>)ignorePropNames : N.newHashSet(ignorePropNames);
            SimpleFilterProvider filters = new SimpleFilterProvider();
            filters.addFilter("PropertyFilterByName", SimpleBeanPropertyFilter.serializeAllExcept(ignorePropNameSet));
            mapper.addMixIn(cls, JacksonParser.PropertyFilterMixIn.class);
            objectWriter = mapper.writer((FilterProvider)filters);
        }
        try {
            if (objectWriter == null) {
                mapper.writeValue(writer, obj);
            } else {
                objectWriter.writeValue(writer, obj);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (isRecycable) {
                JacksonXMLParser.recycle(mapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, String st, XMLDeserializationConfig config) {
        if (N.isNullOrEmpty(st)) {
            return N.defaultValueOf(targetClass);
        }
        BufferedReader br = Objectory.createBufferedReader(st);
        try {
            T t = this.read(targetClass, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file, XMLDeserializationConfig config) {
        T t;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            t = this.deserialize(targetClass, (InputStream)is, config);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is, XMLDeserializationConfig config) {
        BufferedReader br = Objectory.createBufferedReader(is);
        try {
            T t = this.read(targetClass, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader, XMLDeserializationConfig config) {
        return this.read(targetClass, reader, config);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Node node, XMLDeserializationConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T deserialize(Map<String, Class<?>> nodeClasses, InputStream is, XMLDeserializationConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T deserialize(Map<String, Class<?>> nodeClasses, Reader reader, XMLDeserializationConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T deserialize(Map<String, Class<?>> nodeClasses, Node node, XMLDeserializationConfig config) {
        throw new UnsupportedOperationException();
    }

    protected <T> T read(Class<T> targetClass, Reader reader, XMLDeserializationConfig config) {
        if (config == null) {
            config = defaultXMLDeserializationConfig;
        } else if (N.notNullOrEmpty(config.getIgnoredPropNames())) {
            throw new ParseException("'ignoredPropNames' is not supported");
        }
        XmlMapper mapper = JacksonXMLParser.getXmlMapper();
        mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, !config.isIgnoreUnknownProperty());
        try {
            Object object = mapper.readValue(reader, targetClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            JacksonXMLParser.recycle(mapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static XmlMapper getXmlMapper() {
        List<XmlMapper> list = mapperPool;
        synchronized (list) {
            if (mapperPool.size() > 0) {
                return mapperPool.remove(mapperPool.size() - 1);
            }
            return new XmlMapper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void recycle(XmlMapper mapper) {
        if (mapper == null) {
            return;
        }
        List<XmlMapper> list = mapperPool;
        synchronized (list) {
            if (mapperPool.size() < 1000) {
                mapperPool.add(mapper);
            }
        }
    }
}

