/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.parser.FastJSONParser;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.JSONParserImpl;
import com.landawn.abacus.parser.KryoParser;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.parser.XMLParserImpl;
import com.landawn.abacus.parser.XMLParserType;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.function.Function;
import java.lang.reflect.Method;
import java.util.Map;

public final class ParserFactory {
    private static final boolean isXMLAvailable;
    private static final boolean isKryoAvailable;
    private static final boolean isFastJSONAvailable;

    private ParserFactory() {
    }

    public static boolean isXMLAvailable() {
        return isXMLAvailable;
    }

    public static boolean isKryoAvailable() {
        return isKryoAvailable;
    }

    public static boolean isFastJSONAvailable() {
        return isFastJSONAvailable;
    }

    public static KryoParser createKryoParser() {
        return new KryoParser();
    }

    public static JSONParser createJSONParser() {
        return new JSONParserImpl();
    }

    public static JSONParser createFastJSONParser() {
        return new FastJSONParser();
    }

    public static XMLParser createXMLParser() {
        return new XMLParserImpl(XMLParserType.StAX);
    }

    public static void registerXMLBindingClass(Class<?> cls) {
        ClassUtil.registerXMLBindingClassForPropGetSetMethod(cls);
        ParserUtil.refreshEntityPropInfo(cls);
    }

    public static void registerXMLPropNameMapper(Class<?> cls, Map<String, String> propNameMapper) {
        ParserFactory.registerPropGetSetMethod(cls, propNameMapper);
        ParserUtil.registerXMLPropNameMapper(cls, propNameMapper);
    }

    public static void registerXMLPropNameMapper(Class<?> cls, Function<String, String> propNameMapper) {
        ParserFactory.registerPropGetSetMethod(cls, propNameMapper);
        ParserUtil.registerXMLPropNameMapper(cls, propNameMapper);
    }

    public static void registerJSONPropNameMapper(Class<?> cls, Map<String, String> propNameMapper) {
        ParserFactory.registerPropGetSetMethod(cls, propNameMapper);
        ParserUtil.registerJSONPropNameMapper(cls, propNameMapper);
    }

    public static void registerJSONPropNameMapper(Class<?> cls, Function<String, String> propNameMapper) {
        ParserFactory.registerPropGetSetMethod(cls, propNameMapper);
        ParserUtil.registerJSONPropNameMapper(cls, propNameMapper);
    }

    private static void registerPropGetSetMethod(Class<?> cls, Map<String, String> propNameMapper) {
        Method method = null;
        for (String key : propNameMapper.keySet()) {
            method = ClassUtil.getPropGetMethod(cls, key);
            if (method == null) {
                method = ClassUtil.getPropSetMethod(cls, key);
            }
            if (method == null) {
                throw new AbacusException("No method found by name: " + key + " in class: " + cls.getCanonicalName());
            }
            ClassUtil.registerPropGetSetMethod(propNameMapper.get(key), method);
        }
    }

    private static void registerPropGetSetMethod(Class<?> cls, Function<String, String> propNameMapper) {
        String propAlias = null;
        for (String propName : ClassUtil.getPropGetMethodList(cls).keySet()) {
            propAlias = propNameMapper.apply(propName);
            if (N.isNullOrEmpty(propAlias) || propName.equals(propAlias) || ClassUtil.getPropGetMethod(cls, propAlias) != null) continue;
            if (ClassUtil.getPropGetMethod(cls, propName) != null) {
                ClassUtil.registerPropGetSetMethod(propAlias, ClassUtil.getPropGetMethod(cls, propName));
                continue;
            }
            if (ClassUtil.getPropSetMethod(cls, propName) == null) continue;
            ClassUtil.registerPropGetSetMethod(propAlias, ClassUtil.getPropSetMethod(cls, propName));
        }
    }

    static {
        Boolean isAvailable = false;
        try {
            new XMLParserImpl(XMLParserType.StAX);
            isAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isXMLAvailable = isAvailable;
        isAvailable = false;
        try {
            Class.forName("com.esotericsoftware.kryo.Kryo");
            ParserFactory.createKryoParser();
            isAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isKryoAvailable = isAvailable;
        isAvailable = false;
        try {
            Class.forName("com.alibaba.fastjson.JSON");
            ParserFactory.createFastJSONParser();
            isAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isFastJSONAvailable = isAvailable;
    }
}

