/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.alibaba.fastjson.annotation.JSONField;
import com.esotericsoftware.reflectasm.FieldAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.annotation.JsonXmlField;
import com.landawn.abacus.annotation.Type;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.ASMUtil;
import com.landawn.abacus.parser.JSONReader;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.DateUtil;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.function.Function;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

@Internal
public final class ParserUtil {
    static final Logger logger = LoggerFactory.getLogger(ParserUtil.class);
    private static final PropInfo PROP_INFO_MASK = new PropInfo("PROP_INFO_MASK");
    private static final String PROP_NAME_SEPARATOR = ".".intern();
    private static final String GET = "get".intern();
    private static final String SET = "set".intern();
    private static final String IS = "is".intern();
    private static final String HAS = "has".intern();
    private static final int POOL_SIZE = 1024;
    private static final Map<Class<?>, Function<String, String>> xmlPropNameMapperPool = new ObjectPool(1024);
    private static final Map<Class<?>, Function<String, String>> jsonPropNameMapperPool = new ObjectPool(1024);
    private static final Map<Class<?>, EntityInfo> entityInfoPool = new ObjectPool(1024);

    static void registerXMLPropNameMapper(Class<?> cls, final Map<String, String> propNameMap) {
        if (N.notNullOrEmpty(propNameMap)) {
            Function<String, String> nameMapper = new Function<String, String>(){
                private final Map<String, String> localPropNameMap;
                {
                    this.localPropNameMap = propNameMap;
                }

                @Override
                public String apply(String propName) {
                    return Maps.getOrDefault(this.localPropNameMap, propName, propName);
                }
            };
            ParserUtil.registerXMLPropNameMapper(cls, nameMapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerXMLPropNameMapper(Class<?> cls, Function<String, String> nameMapper) {
        N.checkArgNotNull(cls, "cls");
        N.checkArgNotNull(nameMapper, "nameMapper");
        Map<Class<?>, EntityInfo> map = entityInfoPool;
        synchronized (map) {
            xmlPropNameMapperPool.put(cls, nameMapper);
            ParserUtil.refreshEntityPropInfo(cls);
        }
    }

    static void registerJSONPropNameMapper(Class<?> cls, final Map<String, String> propNameMap) {
        if (N.notNullOrEmpty(propNameMap)) {
            Function<String, String> nameMapper = new Function<String, String>(){
                private final Map<String, String> localPropNameMap;
                {
                    this.localPropNameMap = propNameMap;
                }

                @Override
                public String apply(String propName) {
                    return Maps.getOrDefault(this.localPropNameMap, propName, propName);
                }
            };
            ParserUtil.registerJSONPropNameMapper(cls, nameMapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerJSONPropNameMapper(Class<?> cls, Function<String, String> nameMapper) {
        N.checkArgNotNull(cls, "cls");
        N.checkArgNotNull(nameMapper, "nameMapper");
        Map<Class<?>, EntityInfo> map = entityInfoPool;
        synchronized (map) {
            jsonPropNameMapperPool.put(cls, nameMapper);
            ParserUtil.refreshEntityPropInfo(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshEntityPropInfo(Class<?> cls) {
        Map<Class<?>, EntityInfo> map = entityInfoPool;
        synchronized (map) {
            entityInfoPool.remove(cls);
        }
    }

    static boolean isSerializable(Field field) {
        if (field == null || Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (field.isAnnotationPresent(JsonXmlField.class) && field.getAnnotation(JsonXmlField.class).ignore()) {
            return false;
        }
        try {
            if (field.isAnnotationPresent(JSONField.class) && !field.getAnnotation(JSONField.class).serialize()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (field.isAnnotationPresent(JsonIgnore.class) && field.getAnnotation(JsonIgnore.class).value()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    static String getDateFormat(Field field) {
        if (field == null) {
            return null;
        }
        if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).dateFormat())) {
            return field.getAnnotation(JsonXmlField.class).dateFormat();
        }
        try {
            if (field.isAnnotationPresent(JSONField.class) && N.notNullOrEmpty(field.getAnnotation(JSONField.class).format())) {
                return field.getAnnotation(JSONField.class).format();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (field.isAnnotationPresent(JsonFormat.class) && N.notNullOrEmpty(field.getAnnotation(JsonFormat.class).pattern())) {
                return field.getAnnotation(JsonFormat.class).pattern();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static String getTimeZone(Field field) {
        if (field == null) {
            return null;
        }
        if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).timeZone())) {
            return field.getAnnotation(JsonXmlField.class).timeZone();
        }
        try {
            if (field.isAnnotationPresent(JsonFormat.class) && N.notNullOrEmpty(field.getAnnotation(JsonFormat.class).timezone())) {
                return field.getAnnotation(JsonFormat.class).timezone();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static String getNumberFormat(Field field) {
        if (field == null) {
            return null;
        }
        if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).numberFormat())) {
            return field.getAnnotation(JsonXmlField.class).numberFormat();
        }
        return null;
    }

    static String getJSONName(Field field) {
        if (field == null) {
            return null;
        }
        if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).name())) {
            return field.getAnnotation(JsonXmlField.class).name();
        }
        try {
            if (field.isAnnotationPresent(JSONField.class) && N.notNullOrEmpty(field.getAnnotation(JSONField.class).name())) {
                return field.getAnnotation(JSONField.class).name();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (field.isAnnotationPresent(JsonProperty.class) && N.notNullOrEmpty(field.getAnnotation(JsonProperty.class).value())) {
                return field.getAnnotation(JsonProperty.class).value();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerPropNameMapper(Class<?> cls) {
        final HashMap<String, String> propNameMap = new HashMap<String, String>();
        Field field = null;
        String jsonName = null;
        for (Map.Entry<String, Method> entry : ClassUtil.getPropGetMethodList(cls).entrySet()) {
            field = ClassUtil.getPropField(cls, entry.getKey());
            if (field == null || !N.notNullOrEmpty(jsonName = StringUtil.trim(ParserUtil.getJSONName(field)))) continue;
            propNameMap.put(entry.getKey(), jsonName);
        }
        if (N.notNullOrEmpty(propNameMap)) {
            Map<Class<?>, EntityInfo> map = entityInfoPool;
            synchronized (map) {
                final Function<String, String> jsonNameMapper = jsonPropNameMapperPool.get(cls);
                if (jsonNameMapper == null) {
                    ParserFactory.registerJSONPropNameMapper(cls, propNameMap);
                } else {
                    Function<String, String> newJSONNameMapper = new Function<String, String>(){

                        @Override
                        public String apply(String propName) {
                            String propAlias = (String)jsonNameMapper.apply(propName);
                            return propName.equals(propAlias) ? Maps.getOrDefault(propNameMap, propName, propName) : propAlias;
                        }
                    };
                    ParserFactory.registerJSONPropNameMapper(cls, newJSONNameMapper);
                }
                final Function<String, String> xmlNameMapper = xmlPropNameMapperPool.get(cls);
                if (xmlNameMapper == null) {
                    ParserFactory.registerXMLPropNameMapper(cls, propNameMap);
                } else {
                    Function<String, String> newXMLNameMapper = new Function<String, String>(){

                        @Override
                        public String apply(String propName) {
                            String propAlias = (String)xmlNameMapper.apply(propName);
                            return propName.equals(propAlias) ? Maps.getOrDefault(propNameMap, propName, propName) : propAlias;
                        }
                    };
                    ParserFactory.registerXMLPropNameMapper(cls, newXMLNameMapper);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityInfo getEntityInfo(Class<?> cls) {
        EntityInfo entityInfo = entityInfoPool.get(cls);
        if (entityInfo == null) {
            Map<Class<?>, EntityInfo> map = entityInfoPool;
            synchronized (map) {
                entityInfo = entityInfoPool.get(cls);
                if (entityInfo == null) {
                    ParserUtil.registerPropNameMapper(cls);
                    entityInfo = new EntityInfo(cls);
                    entityInfoPool.put(cls, entityInfo);
                }
            }
        }
        return entityInfo;
    }

    static class XMLInfo {
        final char[] name;
        final char[] _name;
        final char[] epStart;
        final char[] _epStart;
        final char[] epStartWithType;
        final char[] _epStartWithType;
        final char[] epEnd;
        final char[] epNull;
        final char[] _epNull;
        final char[] epNullWithType;
        final char[] _epNullWithType;
        final char[] namedStart;
        final char[] _namedStart;
        final char[] namedStartWithType;
        final char[] _namedStartWithType;
        final char[] namedEnd;
        final char[] _namedEnd;
        final char[] namedNull;
        final char[] _namedNull;
        final char[] namedNullWithType;
        final char[] _namedNullWithType;

        public XMLInfo(String name, String typeName, boolean isEntity) {
            String lowerCaseName = ClassUtil.toLowerCaseWithUnderscore(name);
            this.name = name.toCharArray();
            this._name = lowerCaseName.toCharArray();
            String typeAttr = typeName.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            if (isEntity) {
                this.epStart = ("<entity name=\"" + name + "\">").toCharArray();
                this._epStart = ("<entity name=\"" + lowerCaseName + "\">").toCharArray();
                this.epStartWithType = ("<entity name=\"" + name + "\" type=\"" + typeAttr + "\">").toCharArray();
                this._epStartWithType = ("<entity name=\"" + lowerCaseName + "\" type=\"" + typeAttr + "\">").toCharArray();
                this.epEnd = "</entity>".toCharArray();
                this.epNull = ("<entity name=\"" + name + "\" isNull=\"true\" />").toCharArray();
                this._epNull = ("<entity name=\"" + lowerCaseName + "\" isNull=\"true\" />").toCharArray();
                this.epNullWithType = ("<entity name=\"" + name + "\" type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
                this._epNullWithType = ("<entity name=\"" + lowerCaseName + "\" type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
            } else {
                this.epStart = ("<property name=\"" + name + "\">").toCharArray();
                this._epStart = ("<property name=\"" + lowerCaseName + "\">").toCharArray();
                this.epStartWithType = ("<property name=\"" + name + "\" type=\"" + typeAttr + "\">").toCharArray();
                this._epStartWithType = ("<property name=\"" + lowerCaseName + "\" type=\"" + typeAttr + "\">").toCharArray();
                this.epEnd = "</property>".toCharArray();
                this.epNull = ("<property name=\"" + name + "\" isNull=\"true\" />").toCharArray();
                this._epNull = ("<property name=\"" + lowerCaseName + "\" isNull=\"true\" />").toCharArray();
                this.epNullWithType = ("<property name=\"" + name + "\" type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
                this._epNullWithType = ("<property name=\"" + lowerCaseName + "\" type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
            }
            this.namedStart = ("<" + name + ">").toCharArray();
            this._namedStart = ("<" + lowerCaseName + ">").toCharArray();
            this.namedStartWithType = ("<" + name + " type=\"" + typeAttr + "\">").toCharArray();
            this._namedStartWithType = ("<" + lowerCaseName + " type=\"" + typeAttr + "\">").toCharArray();
            this.namedEnd = ("</" + name + ">").toCharArray();
            this._namedEnd = ("</" + lowerCaseName + ">").toCharArray();
            this.namedNull = ("<" + name + " isNull=\"true\" />").toCharArray();
            this._namedNull = ("<" + lowerCaseName + " isNull=\"true\" />").toCharArray();
            this.namedNullWithType = ("<" + name + " type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
            this._namedNullWithType = ("<" + lowerCaseName + " type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
        }

        public int hashCode() {
            return this.name == null ? 0 : N.hashCode(this.name);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof XMLInfo && N.equals(((XMLInfo)obj).name, this.name);
        }

        public String toString() {
            return N.toString(this.name);
        }
    }

    static class JSONInfo {
        final char[] name;
        final char[] _name;
        final char[] nameWithColon;
        final char[] _nameWithColon;
        final char[] nameNull;
        final char[] _nameNull;
        final char[] quotedName;
        final char[] _quotedName;
        final char[] quotedNameWithColon;
        final char[] _quotedNameWithColon;
        final char[] quotedNameNull;
        final char[] _quotedNameNull;

        public JSONInfo(String name) {
            String lowerCaseName = ClassUtil.toLowerCaseWithUnderscore(name);
            this.name = name.toCharArray();
            this._name = lowerCaseName.toCharArray();
            this.nameWithColon = (name + ":").toCharArray();
            this._nameWithColon = (lowerCaseName + ":").toCharArray();
            this.nameNull = (name + ":null").toCharArray();
            this._nameNull = (lowerCaseName + ":null").toCharArray();
            this.quotedName = ("\"" + name + "\"").toCharArray();
            this._quotedName = ("\"" + lowerCaseName + "\"").toCharArray();
            this.quotedNameWithColon = ("\"" + name + "\":").toCharArray();
            this._quotedNameWithColon = ("\"" + lowerCaseName + "\":").toCharArray();
            this.quotedNameNull = ("\"" + name + "\":null").toCharArray();
            this._quotedNameNull = ("\"" + lowerCaseName + "\":null").toCharArray();
        }

        public int hashCode() {
            return this.name == null ? 0 : N.hashCode(this.name);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof JSONInfo && N.equals(((JSONInfo)obj).name, this.name);
        }

        public String toString() {
            return N.toString(this.name);
        }
    }

    static class ASMPropInfo
    extends PropInfo {
        final MethodAccess methodAccess;
        final int getMethodAccessIndex;
        final int setMethodAccessIndex;
        final FieldAccess fieldAccess;
        final int fieldAccessIndex;

        public ASMPropInfo(String name, String xmlPropName, String jsonPropName, Method getMethod) {
            super(name, xmlPropName, jsonPropName, getMethod);
            Class<?> cls = getMethod.getDeclaringClass();
            this.methodAccess = MethodAccess.get(cls);
            this.getMethodAccessIndex = this.methodAccess.getIndex(getMethod.getName(), 0);
            this.setMethodAccessIndex = this.setMethod == null ? -1 : this.methodAccess.getIndex(this.setMethod.getName(), (Class[])this.setMethod.getParameterTypes());
            this.fieldAccess = FieldAccess.get(cls);
            this.fieldAccessIndex = this.field == null || Modifier.isPrivate(this.field.getModifiers()) || Modifier.isStatic(this.field.getModifiers()) ? -1 : this.fieldAccess.getIndex(this.field.getName());
        }

        @Override
        public <T> T getPropValue(Object obj) {
            return (T)(this.fieldAccessIndex > -1 ? this.fieldAccess.get(obj, this.fieldAccessIndex) : this.methodAccess.invoke(obj, this.getMethodAccessIndex, new Object[0]));
        }

        @Override
        public void setPropValue(Object obj, Object propValue) {
            try {
                if (!this.isDirtyMark && this.fieldAccessIndex > -1) {
                    this.fieldAccess.set(obj, this.fieldAccessIndex, propValue);
                } else if (this.setMethodAccessIndex > -1) {
                    this.methodAccess.invoke(obj, this.setMethodAccessIndex, new Object[]{propValue});
                } else {
                    ClassUtil.setPropValueByGet(obj, this.getMethod, propValue);
                }
            }
            catch (Exception e) {
                if (this.setMethod != null) {
                    ClassUtil.setPropValue(obj, this.setMethod, propValue);
                }
                throw N.toRuntimeException(e);
            }
        }
    }

    public static class PropInfo {
        static final char[] NULL_CHAR_ARRAY = "null".toCharArray();
        public final Class<?> declaringClass;
        public final String name;
        public final Method getMethod;
        public final Method setMethod;
        public final com.landawn.abacus.type.Type<Object> jsonXmlType;
        public final com.landawn.abacus.type.Type<Object> dbType;
        final Field field;
        final Class<?> clazz;
        final JSONInfo jsonInfo;
        final XMLInfo xmlInfo;
        final boolean isDirtyMark;
        final String dateFormat;
        final TimeZone timeZone;
        final boolean isLongDateFormat;
        final NumberFormat numberFormat;
        final boolean hasFormat;

        PropInfo(String propName) {
            this.declaringClass = null;
            this.name = propName;
            this.field = null;
            this.getMethod = null;
            this.setMethod = null;
            this.clazz = null;
            this.jsonXmlType = null;
            this.dbType = null;
            this.xmlInfo = null;
            this.jsonInfo = null;
            this.isDirtyMark = false;
            this.dateFormat = null;
            this.timeZone = null;
            this.isLongDateFormat = false;
            this.numberFormat = null;
            this.hasFormat = false;
        }

        public PropInfo(String propName, String xmlPropName, String jsonPropName, Method getMethod) {
            this.declaringClass = getMethod.getDeclaringClass();
            this.name = propName;
            this.field = ClassUtil.getPropField(this.declaringClass, propName);
            this.getMethod = getMethod;
            this.setMethod = ClassUtil.getPropSetMethod(this.declaringClass, propName);
            this.clazz = this.field == null ? (this.setMethod == null ? getMethod.getReturnType() : this.setMethod.getParameterTypes()[0]) : this.field.getType();
            this.jsonXmlType = this.getType(this.getJsonXmlAnnoType(this.field, this.getMethod, this.setMethod, this.clazz), this.field, this.getMethod, this.setMethod, this.clazz, this.declaringClass);
            this.dbType = this.getType(this.getDBAnnoType(this.field, this.getMethod, this.setMethod, this.clazz), this.field, this.getMethod, this.setMethod, this.clazz, this.declaringClass);
            this.jsonInfo = new JSONInfo(jsonPropName);
            this.xmlInfo = new XMLInfo(xmlPropName, this.jsonXmlType.name(), false);
            this.isDirtyMark = DirtyMarkerUtil.isDirtyMarker(this.declaringClass);
            String timeZoneStr = StringUtil.trim(ParserUtil.getTimeZone(this.field));
            String dateFormatStr = StringUtil.trim(ParserUtil.getDateFormat(this.field));
            this.dateFormat = N.isNullOrEmpty(dateFormatStr) ? null : dateFormatStr;
            this.timeZone = N.isNullOrEmpty(timeZoneStr) ? null : TimeZone.getTimeZone(timeZoneStr);
            this.isLongDateFormat = N.notNullOrEmpty(this.dateFormat) && "long".equalsIgnoreCase(this.dateFormat);
            String numberFormatStr = StringUtil.trim(ParserUtil.getNumberFormat(this.field));
            this.numberFormat = N.isNullOrEmpty(numberFormatStr) ? null : new DecimalFormat(numberFormatStr);
            this.hasFormat = N.notNullOrEmpty(this.dateFormat) || this.numberFormat != null;
        }

        public <T> T getPropValue(Object obj) {
            try {
                return (T)(this.field == null ? this.getMethod.invoke(obj, new Object[0]) : this.field.get(obj));
            }
            catch (Exception e) {
                throw N.toRuntimeException(e);
            }
        }

        public void setPropValue(Object obj, Object propValue) {
            try {
                if (!this.isDirtyMark && this.field != null) {
                    this.field.set(obj, propValue);
                } else if (this.setMethod != null) {
                    this.setMethod.invoke(obj, propValue);
                } else {
                    ClassUtil.setPropValueByGet(obj, this.getMethod, propValue);
                }
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn(e, "Failed to set value for field: {} in class: {}", (Object)this.field, this.declaringClass);
                }
                if (this.setMethod != null) {
                    ClassUtil.setPropValue(obj, this.setMethod, propValue);
                }
                throw N.toRuntimeException(e);
            }
        }

        public Object readPropValue(String strValue) {
            if (N.notNullOrEmpty(this.dateFormat)) {
                if (java.util.Date.class.equals(this.clazz)) {
                    if (this.isLongDateFormat) {
                        return new java.util.Date(N.parseLong(strValue));
                    }
                    return DateUtil.parseJUDate(strValue, this.dateFormat, this.timeZone);
                }
                if (Calendar.class.equals(this.clazz)) {
                    if (this.isLongDateFormat) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(N.parseLong(strValue));
                        return calendar;
                    }
                    return DateUtil.parseCalendar(strValue, this.dateFormat, this.timeZone);
                }
                if (Timestamp.class.equals(this.clazz)) {
                    if (this.isLongDateFormat) {
                        return new Timestamp(N.parseLong(strValue));
                    }
                    return DateUtil.parseTimestamp(strValue, this.dateFormat, this.timeZone);
                }
                if (Date.class.equals(this.clazz)) {
                    if (this.isLongDateFormat) {
                        return new Date(N.parseLong(strValue));
                    }
                    return DateUtil.parseDate(strValue, this.dateFormat, this.timeZone);
                }
                if (Time.class.equals(this.clazz)) {
                    if (this.isLongDateFormat) {
                        return new Time(N.parseLong(strValue));
                    }
                    return DateUtil.parseTime(strValue, this.dateFormat, this.timeZone);
                }
                throw new UnsupportedOperationException("'DateFormat' annotation for field: " + this.field + " is only supported for types: java.util.Date and java.util.Calendar, not supported for: " + ClassUtil.getCanonicalClassName(this.clazz));
            }
            return this.jsonXmlType.valueOf(strValue);
        }

        public void writePropValue(CharacterWriter writer, Object x, SerializationConfig<?> config) throws IOException {
            if (this.hasFormat) {
                if (x == null) {
                    writer.write(NULL_CHAR_ARRAY);
                } else if (this.dateFormat != null) {
                    boolean isQuote;
                    boolean bl = isQuote = config != null && config.getStringQuotation() != '\u0000';
                    if (isQuote) {
                        writer.write(config.getStringQuotation());
                    }
                    if (x instanceof java.util.Date) {
                        if (this.isLongDateFormat) {
                            writer.write(((java.util.Date)x).getTime());
                        } else {
                            DateUtil.format((Writer)writer, (java.util.Date)x, this.dateFormat, this.timeZone);
                        }
                    } else if (x instanceof Calendar) {
                        if (this.isLongDateFormat) {
                            writer.write(((Calendar)x).getTimeInMillis());
                        } else {
                            DateUtil.format((Writer)writer, (Calendar)x, this.dateFormat, this.timeZone);
                        }
                    } else {
                        throw new UnsupportedOperationException("'DateFormat' annotation for field: " + this.field + " is only supported for types: java.util.Date and java.util.Calendar, not supported for: " + ClassUtil.getCanonicalClassName(x.getClass()));
                    }
                    if (isQuote) {
                        writer.write(config.getStringQuotation());
                    }
                } else {
                    writer.write(this.numberFormat.format(x));
                }
            } else {
                this.jsonXmlType.writeCharacter(writer, x, config);
            }
        }

        private String getJsonXmlAnnoType(Field field, Method getMethod, Method setMethod, Class<?> propClass) {
            Type typeAnno;
            JsonXmlField jsonXmlFieldAnno;
            JsonXmlField jsonXmlField = jsonXmlFieldAnno = field == null ? null : field.getAnnotation(JsonXmlField.class);
            if (jsonXmlFieldAnno == null && getMethod != null) {
                jsonXmlFieldAnno = getMethod.getAnnotation(JsonXmlField.class);
            }
            if (jsonXmlFieldAnno == null && setMethod != null) {
                jsonXmlFieldAnno = setMethod.getAnnotation(JsonXmlField.class);
            }
            if (jsonXmlFieldAnno != null) {
                if (N.notNullOrEmpty(jsonXmlFieldAnno.type())) {
                    return jsonXmlFieldAnno.type();
                }
                if (propClass.isEnum()) {
                    return ClassUtil.getCanonicalClassName(propClass) + "(" + String.valueOf(jsonXmlFieldAnno.enumerated() == Type.EnumType.ORDINAL) + ")";
                }
            }
            Type type = typeAnno = field == null ? null : field.getAnnotation(Type.class);
            if (typeAnno == null && getMethod != null) {
                typeAnno = getMethod.getAnnotation(Type.class);
            }
            if (typeAnno == null && setMethod != null) {
                typeAnno = setMethod.getAnnotation(Type.class);
            }
            if (typeAnno != null && (typeAnno.scope() == Type.Scope.ALL || typeAnno.scope() == Type.Scope.PARSER)) {
                if (N.notNullOrEmpty(typeAnno.value())) {
                    return typeAnno.value();
                }
                if (N.notNullOrEmpty(typeAnno.name())) {
                    return typeAnno.name();
                }
                if (propClass.isEnum()) {
                    return ClassUtil.getCanonicalClassName(propClass) + "(" + String.valueOf(typeAnno.enumerated() == Type.EnumType.ORDINAL) + ")";
                }
            }
            return null;
        }

        private String getDBAnnoType(Field field, Method getMethod, Method setMethod, Class<?> propClass) {
            Type typeAnno;
            Type type = typeAnno = field == null ? null : field.getAnnotation(Type.class);
            if (typeAnno == null && getMethod != null) {
                typeAnno = getMethod.getAnnotation(Type.class);
            }
            if (typeAnno == null && setMethod != null) {
                typeAnno = setMethod.getAnnotation(Type.class);
            }
            if (typeAnno != null && (typeAnno.scope() == Type.Scope.ALL || typeAnno.scope() == Type.Scope.DB)) {
                if (N.notNullOrEmpty(typeAnno.value())) {
                    return typeAnno.value();
                }
                if (N.notNullOrEmpty(typeAnno.name())) {
                    return typeAnno.name();
                }
                if (propClass.isEnum()) {
                    return ClassUtil.getCanonicalClassName(propClass) + "(" + String.valueOf(typeAnno.enumerated() == Type.EnumType.ORDINAL) + ")";
                }
            }
            return null;
        }

        private <T> com.landawn.abacus.type.Type<T> getType(String annoType, Field field, Method getMethod, Method setMethod, Class<?> propClass, Class<?> entityClass) {
            if (N.isNullOrEmpty(annoType)) {
                Class<?>[] typeArgs = ClassUtil.getTypeArgumentsByMethod(setMethod == null ? getMethod : setMethod);
                if (typeArgs.length == 0) {
                    return N.typeOf(propClass);
                }
                return N.typeOf(ClassUtil.getParameterizedTypeNameByMethod(setMethod == null ? getMethod : setMethod));
            }
            if (N.isNullOrEmpty(ClassUtil.getPackageName(entityClass))) {
                return N.typeOf(annoType);
            }
            String pkgName = ClassUtil.getPackageName(entityClass);
            StringBuilder sb = new StringBuilder();
            int start = 0;
            int len = annoType.length();
            for (int i = 0; i < len; ++i) {
                char ch = annoType.charAt(i);
                if (ch != '<' && ch != '>' && ch != ' ' && ch != ',') continue;
                String str = annoType.substring(start, i);
                if (str.length() > 0 && N.typeOf(str).clazz().equals(Object.class) && !N.typeOf(pkgName + "." + str).clazz().equals(Object.class)) {
                    sb.append(pkgName + "." + str);
                } else {
                    sb.append(str);
                }
                sb.append(ch);
                start = i + 1;
            }
            if (start < annoType.length()) {
                String str = annoType.substring(start);
                if (N.typeOf(str).clazz().equals(Object.class) && !N.typeOf(pkgName + "." + str).clazz().equals(Object.class)) {
                    sb.append(pkgName + "." + str);
                } else {
                    sb.append(str);
                }
            }
            return N.typeOf(sb.toString());
        }

        public int hashCode() {
            return (this.name == null ? 0 : this.name.hashCode()) * 31 + (this.field == null ? 0 : this.field.hashCode());
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof PropInfo && ((PropInfo)obj).name.equals(this.name) && N.equals(((PropInfo)obj).field, this.field);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class EntityInfo
    implements JSONReader.SymbolReader {
        final String name;
        public final Class<?> cls;
        public final com.landawn.abacus.type.Type<Object> type;
        public final List<PropInfo> propInfoList;
        final String typeName;
        final JSONInfo jsonInfo;
        final XMLInfo xmlInfo;
        final PropInfo[] propInfos;
        final PropInfo[] seriPropInfos;
        final PropInfo[] nonTransientSeriPropInfos;
        final PropInfo[] transientSeriPropInfos;
        final Set<String> transientSeriPropNameSet = N.newHashSet();
        private final Map<String, PropInfo> propInfoMap;
        private final Map<String, List<PropInfo>> propInfoQueueMap;
        private final PropInfo[] propInfoArray;
        private final Map<Integer, PropInfo> hashPropInfoMap;

        public EntityInfo(Class<?> cls) {
            this.name = ClassUtil.formalizePropName(cls.getSimpleName());
            this.cls = cls;
            this.type = N.typeOf(cls);
            this.typeName = this.type.name();
            this.jsonInfo = new JSONInfo(this.name);
            this.xmlInfo = new XMLInfo(this.name, this.typeName, true);
            Map<String, Method> methodMap = ClassUtil.getPropGetMethodList(cls);
            this.propInfos = new PropInfo[methodMap.size()];
            this.propInfoMap = new ObjectPool<String, PropInfo>((methodMap.size() + 1) * 2);
            this.propInfoQueueMap = new ObjectPool<String, List<PropInfo>>((methodMap.size() + 1) * 2);
            this.hashPropInfoMap = new ObjectPool<Integer, PropInfo>((methodMap.size() + 1) * 2);
            Function<String, String> xmlPropNameMapper = Maps.getOrDefault(xmlPropNameMapperPool, cls, Fn.identity());
            Function<String, String> jsonPropNameMapper = Maps.getOrDefault(jsonPropNameMapperPool, cls, Fn.identity());
            ArrayList<ASMPropInfo> seriPropInfoList = new ArrayList<ASMPropInfo>();
            ArrayList<ASMPropInfo> nonTransientSeriPropInfoList = new ArrayList<ASMPropInfo>();
            ArrayList<ASMPropInfo> transientSeriPropInfoList = new ArrayList<ASMPropInfo>();
            PropInfo propInfo = null;
            String xmlPropName = null;
            String jsonPropName = null;
            int i = 0;
            Multiset<Integer> multiSet = new Multiset<Integer>(methodMap.size() + 16);
            int maxLength = 0;
            for (String propName : methodMap.keySet()) {
                xmlPropName = (String)xmlPropNameMapper.apply(propName);
                jsonPropName = (String)jsonPropNameMapper.apply(propName);
                propInfo = ASMUtil.isASMAvailable() ? new ASMPropInfo(propName, xmlPropName, jsonPropName, methodMap.get(propName)) : new PropInfo(propName, xmlPropName, jsonPropName, methodMap.get(propName));
                this.propInfos[i++] = propInfo;
                this.propInfoMap.put(propName, propInfo);
                if (ParserUtil.isSerializable(propInfo.field)) {
                    seriPropInfoList.add((ASMPropInfo)propInfo);
                    if (propInfo.field != null && Modifier.isTransient(propInfo.field.getModifiers())) {
                        this.transientSeriPropNameSet.add(propName);
                        transientSeriPropInfoList.add((ASMPropInfo)propInfo);
                    } else {
                        nonTransientSeriPropInfoList.add((ASMPropInfo)propInfo);
                    }
                }
                multiSet.add(propInfo.name.length());
                maxLength = Math.max(propInfo.name.length(), maxLength);
            }
            this.seriPropInfos = seriPropInfoList.toArray(new PropInfo[seriPropInfoList.size()]);
            this.nonTransientSeriPropInfos = nonTransientSeriPropInfoList.toArray(new PropInfo[nonTransientSeriPropInfoList.size()]);
            this.transientSeriPropInfos = transientSeriPropInfoList.toArray(new PropInfo[transientSeriPropInfoList.size()]);
            this.propInfoArray = new PropInfo[maxLength + 1];
            int len = 0;
            for (PropInfo e : this.propInfos) {
                this.hashPropInfoMap.put(this.hashCode(e.jsonInfo.name), e);
                len = e.name.length();
                if (multiSet.get(len) != 1) continue;
                this.propInfoArray[len] = e;
            }
            this.propInfoList = ImmutableList.of(this.propInfos);
        }

        public PropInfo getPropInfo(String propName) {
            PropInfo propInfo = this.propInfoMap.get(propName);
            if (propInfo == null) {
                Method method;
                Function propNameMapper = (Function)xmlPropNameMapperPool.get(this.cls);
                if (propNameMapper == null) {
                    propNameMapper = (Function)jsonPropNameMapperPool.get(this.cls);
                }
                if (propNameMapper != null) {
                    for (String key : this.propInfoMap.keySet()) {
                        if (!propName.equals(propNameMapper.apply(key))) continue;
                        propInfo = this.propInfoMap.get(key);
                        break;
                    }
                }
                if (propInfo == null && (method = ClassUtil.getPropGetMethod(this.cls, propName)) != null) {
                    propInfo = this.propInfoMap.get(ClassUtil.getPropNameByMethod(method));
                }
                if (propInfo == null) {
                    for (String key : this.propInfoMap.keySet()) {
                        if (!this.isPropName(this.cls, propName, key)) continue;
                        propInfo = this.propInfoMap.get(key);
                        break;
                    }
                    if (propInfo == null && !propName.equalsIgnoreCase(ClassUtil.formalizePropName(propName))) {
                        propInfo = this.getPropInfo(ClassUtil.formalizePropName(propName));
                    }
                }
                if (propInfo == null) {
                    propInfo = PROP_INFO_MASK;
                } else if (propInfo != PROP_INFO_MASK) {
                    this.hashPropInfoMap.put(this.hashCode(propInfo.jsonInfo.name), propInfo);
                }
                this.propInfoMap.put(propName, propInfo);
            }
            return propInfo == PROP_INFO_MASK ? null : propInfo;
        }

        public <T> T getPropValue(Object obj, String propName) {
            PropInfo propInfo = this.getPropInfo(propName);
            if (propInfo == null) {
                List<PropInfo> propInfoQueue = this.getPropInfoQueue(propName);
                if (propInfoQueue.size() == 0) {
                    throw new AbacusException("No property method found with property name: " + propName + " in class: " + this.cls.getCanonicalName());
                }
                Object propEntity = obj;
                int len = propInfoQueue.size();
                for (int i = 0; i < len; ++i) {
                    propEntity = propInfoQueue.get(i).getPropValue(propEntity);
                    if (propEntity != null) continue;
                    return (T)N.defaultValueOf(propInfoQueue.get((int)(len - 1)).clazz);
                }
                return (T)propEntity;
            }
            return propInfo.getPropValue(obj);
        }

        public void setPropValue(Object obj, String propName, Object propValue) {
            PropInfo propInfo = this.getPropInfo(propName);
            if (propInfo == null) {
                List<PropInfo> propInfoQueue = this.getPropInfoQueue(propName);
                if (propInfoQueue.size() == 0) {
                    throw new AbacusException("No property method found with property name: " + propName + " in class: " + this.cls.getCanonicalName());
                }
                Object propEntity = obj;
                int len = propInfoQueue.size();
                for (int i = 0; i < len; ++i) {
                    propInfo = propInfoQueue.get(i);
                    if (i == len - 1) {
                        propInfo.setPropValue(propEntity, propValue);
                        continue;
                    }
                    Object tmp = propInfo.getPropValue(propEntity);
                    if (tmp == null) {
                        tmp = N.newInstance(propInfo.clazz);
                        propInfo.setPropValue(propEntity, tmp);
                    }
                    propEntity = tmp;
                }
            } else {
                propInfo.setPropValue(obj, propValue);
            }
        }

        private boolean isPropName(Class<?> cls, String inputPropName, String propNameByMethod) {
            if (inputPropName.length() > 128) {
                throw new AbacusException("The property name execeed 128: " + inputPropName);
            }
            return (inputPropName = inputPropName.trim()).equalsIgnoreCase(propNameByMethod) || inputPropName.replace("_", N.EMPTY_STRING).equalsIgnoreCase(propNameByMethod) || inputPropName.equalsIgnoreCase(ClassUtil.getSimpleClassName(cls) + '.' + propNameByMethod) || inputPropName.startsWith(GET) && inputPropName.substring(3).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(SET) && inputPropName.substring(3).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(IS) && inputPropName.substring(2).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(HAS) && inputPropName.substring(2).equalsIgnoreCase(propNameByMethod);
        }

        private List<PropInfo> getPropInfoQueue(String propName) {
            List<PropInfo> propInfoQueue = this.propInfoQueueMap.get(propName);
            if (propInfoQueue == null) {
                propInfoQueue = new ArrayList<PropInfo>();
                String[] strs = Splitter.with(PROP_NAME_SEPARATOR).splitToArray(propName);
                if (strs.length > 1) {
                    Class<?> propClass = this.cls;
                    PropInfo propInfo = null;
                    int len = strs.length;
                    for (int i = 0; i < len; ++i) {
                        propInfo = ParserUtil.getEntityInfo(propClass).getPropInfo(strs[i]);
                        if (propInfo == null) {
                            propInfoQueue.clear();
                            break;
                        }
                        propInfoQueue.add(propInfo);
                        propClass = propInfo.clazz;
                    }
                }
                this.propInfoQueueMap.put(propName, propInfoQueue);
            }
            return propInfoQueue;
        }

        @Override
        public PropInfo readPropInfo(char[] cbuf, int from, int to) {
            int len = to - from;
            if (len == 0) {
                return null;
            }
            PropInfo propInfo = null;
            if (len < this.propInfoArray.length) {
                propInfo = this.propInfoArray[len];
            }
            if (propInfo == null) {
                propInfo = this.hashPropInfoMap.get(this.hashCode(cbuf, from, to));
            }
            if (propInfo != null) {
                char[] tmp = propInfo.jsonInfo.name;
                for (int i = 0; i < len; ++i) {
                    if (cbuf[i + from] == tmp[i]) continue;
                    return null;
                }
            }
            return propInfo;
        }

        public int hashCode() {
            return this.cls == null ? 0 : this.cls.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof EntityInfo && N.equals(((EntityInfo)obj).cls, this.cls);
        }

        public String toString() {
            return ClassUtil.getCanonicalClassName(this.cls);
        }

        private int hashCode(char[] a) {
            int result = 1;
            for (char e : a) {
                result = 31 * result + e;
            }
            return result;
        }

        private int hashCode(char[] a, int from, int to) {
            return N.hashCode(a, from, to);
        }
    }
}

