/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.core.MapEntity;
import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.AbstractXMLParser;
import com.landawn.abacus.parser.Exclusion;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.parser.XMLConstants;
import com.landawn.abacus.parser.XMLDeserializationConfig;
import com.landawn.abacus.parser.XMLParserType;
import com.landawn.abacus.parser.XMLSerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.BufferedXMLWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.IdentityHashSet;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XMLParserImpl
extends AbstractXMLParser {
    private final XMLParserType parserType;

    public XMLParserImpl(XMLParserType parserType) {
        this.parserType = parserType;
    }

    @Override
    public String serialize(Object obj, XMLSerializationConfig config) {
        if (obj == null) {
            return N.EMPTY_STRING;
        }
        BufferedXMLWriter bw = Objectory.createBufferedXMLWriter();
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, false, null, serializedObjects);
            String string = bw.toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(File file, Object obj, XMLSerializationConfig config) {
        FileOutputStream os = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            this.serialize((OutputStream)os, obj, config);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void serialize(OutputStream os, Object obj, XMLSerializationConfig config) {
        BufferedXMLWriter bw = Objectory.createBufferedXMLWriter(os);
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, true, null, serializedObjects);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(Writer writer, Object obj, XMLSerializationConfig config) {
        boolean isBufferedWriter = writer instanceof BufferedXMLWriter;
        BufferedXMLWriter bw = isBufferedWriter ? (BufferedXMLWriter)writer : Objectory.createBufferedXMLWriter(writer);
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, true, null, serializedObjects);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle(bw);
            }
        }
    }

    protected void write(BufferedXMLWriter bw, Object obj, XMLSerializationConfig config, boolean flush, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (config == null) {
            config = defaultXMLSerializationConfig;
        }
        if (obj == null) {
            IOUtil.write((Writer)bw, (CharSequence)N.EMPTY_STRING);
            return;
        }
        Class<?> cls = obj.getClass();
        Type<Object> type = N.typeOf(cls);
        switch (type.getSerializationType()) {
            case SERIALIZABLE: {
                if (type.isObjectArray()) {
                    this.writeArray(bw, obj, config, indentation, serializedObjects);
                    break;
                }
                if (type.isCollection()) {
                    this.writeCollection(bw, (Collection)obj, config, indentation, serializedObjects);
                    break;
                }
                type.writeCharacter(bw, obj, config);
                break;
            }
            case ENTITY: {
                this.writeEntity(bw, obj, config, indentation, serializedObjects);
                break;
            }
            case MAP: {
                this.writeMap(bw, (Map)obj, config, indentation, serializedObjects);
                break;
            }
            case MAP_ENTITY: {
                this.writeMapEntity(bw, (MapEntity)obj, config, indentation, serializedObjects);
                break;
            }
            case ARRAY: {
                this.writeArray(bw, obj, config, indentation, serializedObjects);
                break;
            }
            case COLLECTION: {
                this.writeCollection(bw, (Collection)obj, config, indentation, serializedObjects);
                break;
            }
            default: {
                throw new ParseException("Unsupported class: " + ClassUtil.getCanonicalClassName(cls) + ". Only Array/List/Map and Entity class with getter/setter methods are supported");
            }
        }
        if (flush) {
            bw.flush();
        }
    }

    protected void writeEntity(BufferedXMLWriter bw, Object obj, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, obj, serializedObjects)) {
            return;
        }
        Class<?> cls = obj.getClass();
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(cls);
        if (N.isNullOrEmpty(entityInfo.seriPropInfos)) {
            throw new ParseException("No serializable property is found in class: " + ClassUtil.getCanonicalClassName(cls));
        }
        boolean tagByPropertyName = config.isTagByPropertyName();
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        if (tagByPropertyName) {
            if (ignoreTypeInfo) {
                bw.write(entityInfo.xmlInfo.namedStart);
            } else {
                bw.write(entityInfo.xmlInfo.namedStartWithType);
            }
        } else if (ignoreTypeInfo) {
            bw.write(entityInfo.xmlInfo.epStart);
        } else {
            bw.write(entityInfo.xmlInfo.epStartWithType);
        }
        String propIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        this.writeProperties(bw, obj, config, propIndentation, serializedObjects);
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        if (tagByPropertyName) {
            bw.write(entityInfo.xmlInfo.namedEnd);
        } else {
            bw.write(entityInfo.xmlInfo.epEnd);
        }
    }

    protected void writeProperties(BufferedXMLWriter bw, Object obj, XMLSerializationConfig config, String propIndentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, obj, serializedObjects)) {
            return;
        }
        Class<?> cls = obj.getClass();
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(cls);
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(cls);
        boolean ignoreNullProperty = config.getExclusion() == Exclusion.NULL || config.getExclusion() == Exclusion.DEFAULT;
        boolean ignoreDefaultProperty = config.getExclusion() == Exclusion.DEFAULT;
        boolean tagByPropertyName = config.isTagByPropertyName();
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        Set signedPropNameSet = null;
        if (ignoreNullProperty && obj instanceof DirtyMarker) {
            Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)obj);
            if (N.isNullOrEmpty(signedPropNames)) {
                return;
            }
            signedPropNameSet = Objectory.createSet();
            for (String propName : signedPropNames) {
                signedPropNameSet.add(entityInfo.getPropInfo((String)propName).name);
            }
        }
        String nextIndentation = isPrettyFormat ? (propIndentation == null ? N.EMPTY_STRING : propIndentation) + config.getIndentation() : null;
        ParserUtil.PropInfo[] propInfoList = config.isSkipTransientField() ? entityInfo.nonTransientSeriPropInfos : entityInfo.seriPropInfos;
        ParserUtil.PropInfo propInfo2 = null;
        String propName = null;
        Object propValue = null;
        if (config.getPropNamingPolicy() == null || config.getPropNamingPolicy() == NamingPolicy.LOWER_CAMEL_CASE) {
            for (ParserUtil.PropInfo propInfo2 : propInfoList) {
                propName = propInfo2.name;
                if (signedPropNameSet != null && !signedPropNameSet.contains(propName) || ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) continue;
                propValue = propInfo2.getPropValue(obj);
                if (ignoreNullProperty && propValue == null || ignoreDefaultProperty && propValue != null && propInfo2.jsonXmlType != null && propInfo2.jsonXmlType.isPrimitiveType() && propValue.equals(propInfo2.jsonXmlType.defaultValue())) continue;
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(propIndentation);
                }
                if (propValue == null) {
                    if (tagByPropertyName) {
                        if (ignoreTypeInfo) {
                            bw.write(propInfo2.xmlInfo.namedNull);
                            continue;
                        }
                        bw.write(propInfo2.xmlInfo.namedNullWithType);
                        continue;
                    }
                    if (ignoreTypeInfo) {
                        bw.write(propInfo2.xmlInfo.epNull);
                        continue;
                    }
                    bw.write(propInfo2.xmlInfo.epNullWithType);
                    continue;
                }
                if (tagByPropertyName) {
                    if (ignoreTypeInfo) {
                        bw.write(propInfo2.xmlInfo.namedStart);
                    } else {
                        bw.write(propInfo2.xmlInfo.namedStartWithType);
                    }
                } else if (ignoreTypeInfo) {
                    bw.write(propInfo2.xmlInfo.epStart);
                } else {
                    bw.write(propInfo2.xmlInfo.epStartWithType);
                }
                if (propInfo2.hasFormat) {
                    propInfo2.writePropValue(bw, propValue, config);
                } else {
                    this.writeValue(bw, propInfo2.jsonXmlType, propInfo2, propValue, config, isPrettyFormat, propIndentation, nextIndentation, serializedObjects);
                }
                if (tagByPropertyName) {
                    bw.write(propInfo2.xmlInfo.namedEnd);
                    continue;
                }
                bw.write(propInfo2.xmlInfo.epEnd);
            }
        } else if (config.getPropNamingPolicy() == NamingPolicy.LOWER_CASE_WITH_UNDERSCORE) {
            for (ParserUtil.PropInfo propInfo2 : propInfoList) {
                propName = propInfo2.name;
                if (signedPropNameSet != null && !signedPropNameSet.contains(propName) || ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) continue;
                propValue = propInfo2.getPropValue(obj);
                if (ignoreNullProperty && propValue == null || ignoreDefaultProperty && propValue != null && propInfo2.jsonXmlType != null && propInfo2.jsonXmlType.isPrimitiveType() && propValue.equals(propInfo2.jsonXmlType.defaultValue())) continue;
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(propIndentation);
                }
                if (propValue == null) {
                    if (tagByPropertyName) {
                        if (ignoreTypeInfo) {
                            bw.write(propInfo2.xmlInfo._namedNull);
                            continue;
                        }
                        bw.write(propInfo2.xmlInfo._namedNullWithType);
                        continue;
                    }
                    if (ignoreTypeInfo) {
                        bw.write(propInfo2.xmlInfo._epNull);
                        continue;
                    }
                    bw.write(propInfo2.xmlInfo._epNullWithType);
                    continue;
                }
                if (tagByPropertyName) {
                    if (ignoreTypeInfo) {
                        bw.write(propInfo2.xmlInfo._namedStart);
                    } else {
                        bw.write(propInfo2.xmlInfo._namedStartWithType);
                    }
                } else if (ignoreTypeInfo) {
                    bw.write(propInfo2.xmlInfo._epStart);
                } else {
                    bw.write(propInfo2.xmlInfo._epStartWithType);
                }
                if (propInfo2.hasFormat) {
                    propInfo2.writePropValue(bw, propValue, config);
                } else {
                    this.writeValue(bw, propInfo2.jsonXmlType, propInfo2, propValue, config, isPrettyFormat, propIndentation, nextIndentation, serializedObjects);
                }
                if (tagByPropertyName) {
                    bw.write(propInfo2.xmlInfo._namedEnd);
                    continue;
                }
                bw.write(propInfo2.xmlInfo.epEnd);
            }
        } else {
            throw new ParseException("Unsupported WritePropNamingPolicy: " + (Object)((Object)config.getPropNamingPolicy()));
        }
        Objectory.recycle(signedPropNameSet);
    }

    protected void writeMap(BufferedXMLWriter bw, Map<?, ?> m, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, m, serializedObjects)) {
            return;
        }
        Class<?> cls = m.getClass();
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        if (ignoreTypeInfo) {
            bw.write("<map>");
        } else {
            bw.write(XMLConstants.START_MAP_ELE_WITH_TYPE);
            bw.write(N.typeOf(cls).xmlName());
            bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
        }
        String propIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        String nextIndentation = propIndentation + config.getIndentation();
        String strKey = null;
        Object value = null;
        Type<Object> valueType = null;
        for (Object key : m.keySet()) {
            if (ignoredClassPropNames != null && ignoredClassPropNames.contains(key)) continue;
            strKey = key == null ? NULL_STRING : key.toString();
            value = m.get(key);
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(propIndentation);
            }
            if (value == null) {
                bw.write('<');
                bw.write(strKey);
                bw.write(" isNull=\"true\"");
                bw.write(XMLConstants.END_ELEMENT);
                continue;
            }
            valueType = N.typeOf(value.getClass());
            bw.write('<');
            bw.write(strKey);
            if (ignoreTypeInfo) {
                bw.write('>');
            } else {
                bw.write(" type=\"");
                bw.write(valueType.xmlName());
                bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
            }
            this.writeValue(bw, valueType, null, value, config, isPrettyFormat, propIndentation, nextIndentation, serializedObjects);
            bw.write('<');
            bw.write('/');
            bw.write(strKey);
            bw.write('>');
        }
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        bw.write("</map>");
    }

    protected void writeMapEntity(BufferedXMLWriter bw, MapEntity mapEntity, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, mapEntity, serializedObjects)) {
            return;
        }
        Class<?> cls = mapEntity.getClass();
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        bw.write('<');
        bw.write(mapEntity.entityName());
        if (ignoreTypeInfo) {
            bw.write('>');
        } else {
            bw.write(" type=\"");
            bw.write(N.typeOf(cls).xmlName());
            bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
        }
        String propIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        String nextIndentation = propIndentation + config.getIndentation();
        String strKey = null;
        Object value = null;
        Type<Object> valueType = null;
        for (String key : mapEntity.keySet()) {
            if (ignoredClassPropNames != null && ignoredClassPropNames.contains(key)) continue;
            value = mapEntity.get(key);
            String string = strKey = key == null ? NULL_STRING : key.toString();
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(propIndentation);
            }
            if (value == null) {
                bw.write('<');
                bw.write(strKey);
                bw.write(" isNull=\"true\"");
                bw.write(XMLConstants.END_ELEMENT);
                continue;
            }
            valueType = N.typeOf(value.getClass());
            bw.write('<');
            bw.write(strKey);
            if (ignoreTypeInfo) {
                bw.write('>');
            } else {
                bw.write(" type=\"");
                bw.write(valueType.xmlName());
                bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
            }
            this.writeValue(bw, valueType, null, value, config, isPrettyFormat, propIndentation, nextIndentation, serializedObjects);
            bw.write('<');
            bw.write('/');
            bw.write(strKey);
            bw.write('>');
        }
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        bw.write('<');
        bw.write('/');
        bw.write(mapEntity.entityName());
        bw.write('>');
    }

    protected void writeArray(BufferedXMLWriter bw, Object obj, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, obj, serializedObjects)) {
            return;
        }
        Class<?> cls = obj.getClass();
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        if (ignoreTypeInfo) {
            bw.write("<array>");
        } else {
            bw.write(XMLConstants.START_ARRAY_ELE_WITH_TYPE);
            bw.write(N.typeOf(cls).xmlName());
            bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
        }
        String nextIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        Object[] a = (Object[])obj;
        boolean isSerializableByJSON = this.isSerializableByJSON(a);
        if (isSerializableByJSON) {
            strType.writeCharacter(bw, jsonParser.serialize(a, this.getJSC(config)), config);
        } else {
            for (Object e : a) {
                if (e == null) {
                    bw.write("<null isNull=\"true\" />");
                    continue;
                }
                this.write(bw, e, config, false, nextIndentation, serializedObjects);
            }
        }
        if (isPrettyFormat && !isSerializableByJSON) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        bw.write("</array>");
    }

    protected void writeCollection(BufferedXMLWriter bw, Collection<?> c, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, c, serializedObjects)) {
            return;
        }
        Class<?> cls = c.getClass();
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        if (ignoreTypeInfo) {
            bw.write("<list>");
        } else {
            bw.write(XMLConstants.START_LIST_ELE_WITH_TYPE);
            bw.write(N.typeOf(cls).xmlName());
            bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
        }
        String nextIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        boolean isSerializableByJSON = this.isSerializableByJSON(c);
        if (isSerializableByJSON) {
            strType.writeCharacter(bw, jsonParser.serialize(c, this.getJSC(config)), config);
        } else {
            for (Object e : c) {
                if (e == null) {
                    bw.write("<null isNull=\"true\" />");
                    continue;
                }
                this.write(bw, e, config, false, nextIndentation, serializedObjects);
            }
        }
        if (isPrettyFormat && !isSerializableByJSON) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        bw.write("</list>");
    }

    protected void writeValue(BufferedXMLWriter bw, Type<Object> valueType, ParserUtil.PropInfo propInfo, Object value, XMLSerializationConfig config, boolean isPrettyFormat, String propIndentation, String nextIndentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (valueType.isSerializable()) {
            if (valueType.isObjectArray() || valueType.isCollection()) {
                strType.writeCharacter(bw, jsonParser.serialize(value, this.getJSC(config)), config);
            } else if (propInfo != null && propInfo.hasFormat) {
                propInfo.writePropValue(bw, value, config);
            } else {
                valueType.writeCharacter(bw, value, config);
            }
        } else if (valueType.isObjectArray()) {
            Object[] a = (Object[])value;
            boolean isSerializableByJSON = this.isSerializableByJSON(a);
            if (isSerializableByJSON) {
                strType.writeCharacter(bw, jsonParser.serialize(a, this.getJSC(config)), config);
            } else {
                for (Object e : a) {
                    if (e == null) {
                        if (isPrettyFormat) {
                            bw.write(IOUtil.LINE_SEPARATOR);
                            bw.write(nextIndentation);
                        }
                        bw.write("<null isNull=\"true\" />");
                        continue;
                    }
                    this.write(bw, e, config, false, nextIndentation, serializedObjects);
                }
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(propIndentation);
                }
            }
        } else if (valueType.isCollection()) {
            Collection c = (Collection)value;
            boolean isSerializableByJSON = this.isSerializableByJSON(c);
            if (isSerializableByJSON) {
                strType.writeCharacter(bw, jsonParser.serialize(c, this.getJSC(config)), config);
            } else {
                for (Object e : c) {
                    if (e == null) {
                        if (isPrettyFormat) {
                            bw.write(IOUtil.LINE_SEPARATOR);
                            bw.write(nextIndentation);
                        }
                        bw.write("<null isNull=\"true\" />");
                        continue;
                    }
                    this.write(bw, e, config, false, nextIndentation, serializedObjects);
                }
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(propIndentation);
                }
            }
        } else {
            this.write(bw, value, config, false, nextIndentation, serializedObjects);
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(propIndentation);
            }
        }
    }

    private boolean hasCircularReference(BufferedXMLWriter bw, Object obj, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (obj != null && serializedObjects != null) {
            if (serializedObjects.contains(obj)) {
                bw.write("null");
                return true;
            }
            serializedObjects.add(obj);
        }
        return false;
    }

    protected boolean isSerializableByJSON(Object[] a) {
        if (N.typeOf(a.getClass().getComponentType()).isSerializable()) {
            return true;
        }
        for (Object e : a) {
            if (e == null || !N.typeOf(e.getClass()).isSerializable()) continue;
            return true;
        }
        return false;
    }

    protected boolean isSerializableByJSON(Collection<?> c) {
        for (Object e : c) {
            if (e == null || !N.typeOf(e.getClass()).isSerializable()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, String st, XMLDeserializationConfig config) {
        if (N.isNullOrEmpty(st)) {
            return N.defaultValueOf(targetClass);
        }
        BufferedReader br = Objectory.createBufferedReader(st);
        try {
            T t = this.read(null, targetClass, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file, XMLDeserializationConfig config) {
        T t;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            t = this.deserialize(targetClass, (InputStream)is, config);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is, XMLDeserializationConfig config) {
        BufferedReader br = Objectory.createBufferedReader(is);
        try {
            T t = this.read(null, targetClass, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader, XMLDeserializationConfig config) {
        return this.read(null, targetClass, reader, config);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Node node, XMLDeserializationConfig config) {
        return this.readByDOMParser(targetClass, node, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Map<String, Class<?>> nodeClasses, InputStream is, XMLDeserializationConfig config) {
        BufferedReader br = Objectory.createBufferedReader(is);
        try {
            T t = this.read(nodeClasses, null, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Map<String, Class<?>> nodeClasses, Reader reader, XMLDeserializationConfig config) {
        return this.read(nodeClasses, null, reader, config);
    }

    @Override
    public <T> T deserialize(Map<String, Class<?>> nodeClasses, Node node, XMLDeserializationConfig config) {
        Class<?> targetClass = null;
        if (N.notNullOrEmpty(nodeClasses)) {
            String nodeName = XMLUtil.getAttribute(node, "name");
            if (N.isNullOrEmpty(nodeName)) {
                nodeName = node.getNodeName();
            }
            targetClass = nodeClasses.get(nodeName);
        }
        if (targetClass == null) {
            throw new ParseException("No target class is specified");
        }
        return this.readByDOMParser(targetClass, node, config);
    }

    protected <T> T read(Map<String, Class<?>> nodeClasses, Class<T> targetClass, Reader br, XMLDeserializationConfig config) {
        if (config == null) {
            config = defaultXMLDeserializationConfig;
        }
        switch (this.parserType) {
            case StAX: {
                try {
                    XMLStreamReader xmlReader = this.createXMLStreamReader(br);
                    int event = xmlReader.next();
                    while (event != 1 && xmlReader.hasNext()) {
                        event = xmlReader.next();
                    }
                    if (targetClass == null && N.notNullOrEmpty(nodeClasses)) {
                        String nodeName = null;
                        if (xmlReader.getAttributeCount() > 0) {
                            nodeName = xmlReader.getAttributeValue(null, "name");
                        }
                        if (N.isNullOrEmpty(nodeName)) {
                            nodeName = xmlReader.getLocalName();
                        }
                        targetClass = nodeClasses.get(nodeName);
                    }
                    if (targetClass == null) {
                        throw new ParseException("No target class is specified");
                    }
                    return this.readByStreamParser(targetClass, xmlReader, config);
                }
                catch (XMLStreamException e) {
                    throw new ParseException(e);
                }
            }
            case DOM: {
                DocumentBuilder docBuilder = XMLUtil.createContentParser();
                try {
                    Document doc = docBuilder.parse(new InputSource(br));
                    Node node = doc.getFirstChild();
                    if (targetClass == null && N.notNullOrEmpty(nodeClasses)) {
                        String nodeName = XMLUtil.getAttribute(node, "name");
                        if (N.isNullOrEmpty(nodeName)) {
                            nodeName = node.getNodeName();
                        }
                        targetClass = nodeClasses.get(nodeName);
                    }
                    if (targetClass == null) {
                        throw new ParseException("No target class is specified");
                    }
                    T t = this.readByDOMParser(targetClass, node, config);
                    return t;
                }
                catch (SAXException e) {
                    throw new ParseException(e);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    XMLUtil.recycleContentParser(docBuilder);
                }
            }
        }
        throw new ParseException("Unsupported parser: " + (Object)((Object)this.parserType));
    }

    protected <T> T readByStreamParser(Class<T> targetClass, XMLStreamReader xmlReader, XMLDeserializationConfig config) throws XMLStreamException {
        return this.readByStreamParser(targetClass, xmlReader, config, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected <T> T readByStreamParser(Class<?> targetClass, XMLStreamReader xmlReader, XMLDeserializationConfig config, Type<?> propType, ParserUtil.PropInfo propInfo) throws XMLStreamException {
        hasPropTypes = N.notNullOrEmpty(config.getPropTypes());
        if (hasPropTypes && xmlReader.getEventType() == 1 && config.hasPropType(xmlReader.getLocalName())) {
            targetClass = config.getPropType(xmlReader.getLocalName()).clazz();
        }
        serializationType = this.getDeserializationType(targetClass);
        propName = null;
        propValue = null;
        switch (1.$SwitchMap$com$landawn$abacus$type$Type$SerializationType[serializationType.ordinal()]) {
            case 2: {
                ignoreUnknownProperty = config.isIgnoreUnknownProperty();
                ignoredClassPropNames = config.getIgnoredPropNames(targetClass);
                entityInfo = ParserUtil.getEntityInfo(targetClass);
                entity = N.newInstance(targetClass);
                attrCount = 0;
                event = xmlReader.next();
                while (xmlReader.hasNext()) {
                    switch (event) {
                        case 1: {
                            if (propName != null) ** GOTO lbl43
                            propName = xmlReader.getLocalName();
                            propInfo = entityInfo.getPropInfo(propName);
                            if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) break;
                            if (propInfo == null) {
                                if (ignoreUnknownProperty) break;
                                throw new ParseException("Unknown property element: " + propName + " for class: " + targetClass.getCanonicalName());
                            }
                            v0 /* !! */  = propType = hasPropTypes != false ? config.getPropType(propName) : null;
                            if (propType != null) break;
                            if (propInfo.jsonXmlType.isSerializable()) {
                                propType = propInfo.jsonXmlType;
                                break;
                            }
                            attrCount = xmlReader.getAttributeCount();
                            if (attrCount != 1) ** GOTO lbl35
                            if (!"type".equals(xmlReader.getAttributeLocalName(0))) ** GOTO lbl40
                            propType = N.typeOf(xmlReader.getAttributeValue(0));
                            ** GOTO lbl40
lbl35:
                            // 1 sources

                            if (attrCount > 1) {
                                for (i = 0; i < attrCount; ++i) {
                                    if (!"type".equals(xmlReader.getAttributeLocalName(i))) continue;
                                    propType = N.typeOf(xmlReader.getAttributeValue(i));
                                    break;
                                }
                            }
lbl40:
                            // 6 sources

                            if (propType != null) break;
                            propType = propInfo.jsonXmlType;
                            break;
lbl43:
                            // 1 sources

                            if (propInfo == null || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                                startCount = 1;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else if (Map.class.isAssignableFrom(propType.clazz()) || ClassUtil.isEntity(propType.clazz())) {
                                propValue = this.readByStreamParser(propType.clazz(), xmlReader, config, propType, propInfo);
                                startCount = 0;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else {
                                c = Collection.class.isAssignableFrom(propType.clazz()) != false ? (Collection)N.newInstance(propType.clazz()) : new ArrayList<E>();
                                propEleType = this.getPropEleType(propType);
                                do {
                                    if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                        c.add(null);
                                        xmlReader.next();
                                        continue;
                                    }
                                    c.add(this.readByStreamParser(propEleType.clazz(), xmlReader, XMLParserImpl.defaultXMLDeserializationConfig, propType, null));
                                } while (xmlReader.hasNext() && xmlReader.next() == 1);
                                v1 = propValue = propType.clazz().isArray() != false ? XMLParserImpl.collection2Array(propType.clazz(), c) : c;
                            }
                            if (xmlReader.getEventType() == 2 && xmlReader.getLocalName().equals(propName)) {
                                if (!(propInfo == null || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName))) {
                                    propInfo.setPropValue(entity, propValue);
                                }
                                propName = null;
                                propValue = null;
                                propInfo = null;
                                break;
                            }
                            throw new ParseException("Unknown parser error at element: " + xmlReader.getLocalName());
                        }
                        case 4: {
                            if (propInfo == null) break;
                            propValue = propInfo.hasFormat != false ? propInfo.readPropValue(xmlReader.getText()) : propType.valueOf(xmlReader.getText());
                            break;
                        }
                        case 2: {
                            if (propName == null) {
                                return (T)entity;
                            }
                            if (!(propInfo == null || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName))) {
                                propInfo.setPropValue(entity, propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            propInfo = null;
                            break;
                        }
                    }
                    event = xmlReader.next();
                }
                throw new ParseException("Unknown parser error");
            }
            case 3: {
                ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
                keyType = XMLParserImpl.defaultKeyType;
                if (propInfo != null && propInfo.jsonXmlType.getParameterTypes().length == 2 && !Object.class.equals(propInfo.jsonXmlType.getParameterTypes()[0].clazz())) {
                    keyType = propInfo.jsonXmlType.getParameterTypes()[0];
                } else if (propType != null && propType.getParameterTypes().length == 2 && Map.class.isAssignableFrom(propType.clazz()) && !Object.class.equals(propType.getParameterTypes()[0].clazz())) {
                    keyType = propType.getParameterTypes()[0];
                } else if (config.getMapKeyType() != null && !Object.class.equals(config.getMapKeyType().clazz())) {
                    keyType = config.getMapKeyType();
                }
                isStringKey = keyType.clazz() == String.class;
                valueType /* !! */  = XMLParserImpl.defaultValueType;
                if (propInfo != null && propInfo.jsonXmlType.getParameterTypes().length == 2 && !Object.class.equals(propInfo.jsonXmlType.getParameterTypes()[1].clazz())) {
                    valueType /* !! */  = propInfo.jsonXmlType.getParameterTypes()[1];
                } else if (propType != null && propType.getParameterTypes().length == 2 && Map.class.isAssignableFrom(propType.clazz()) && !Object.class.equals(propType.getParameterTypes()[1].clazz())) {
                    valueType /* !! */  = propType.getParameterTypes()[1];
                } else if (config.getMapValueType() != null && !Object.class.equals(config.getMapValueType().clazz())) {
                    valueType /* !! */  = config.getMapValueType();
                }
                map = (Map)N.newInstance(targetClass);
                attrCount = 0;
                event = xmlReader.next();
                while (xmlReader.hasNext()) {
                    switch (event) {
                        case 1: {
                            if (propName != null) ** GOTO lbl139
                            propName = xmlReader.getLocalName();
                            v2 /* !! */  = propType = hasPropTypes != false ? config.getPropType(propName) : null;
                            if (propType != null) break;
                            attrCount = xmlReader.getAttributeCount();
                            if (attrCount != 1) ** GOTO lbl131
                            if (!"type".equals(xmlReader.getAttributeLocalName(0))) ** GOTO lbl136
                            propType = N.typeOf(xmlReader.getAttributeValue(0));
                            ** GOTO lbl136
lbl131:
                            // 1 sources

                            if (attrCount > 1) {
                                for (i = 0; i < attrCount; ++i) {
                                    if (!"type".equals(xmlReader.getAttributeLocalName(i))) continue;
                                    propType = N.typeOf(xmlReader.getAttributeValue(i));
                                    break;
                                }
                            }
lbl136:
                            // 6 sources

                            if (propType != null) break;
                            propType = valueType /* !! */ ;
                            break;
lbl139:
                            // 1 sources

                            if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                                startCount = 1;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else if (Map.class.isAssignableFrom(propType.clazz()) || ClassUtil.isEntity(propType.clazz())) {
                                propValue = this.readByStreamParser(propType.clazz(), xmlReader, config, propType, null);
                                startCount = 0;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else {
                                c = Collection.class.isAssignableFrom(propType.clazz()) != false ? (Collection)N.newInstance(propType.clazz()) : new ArrayList<E>();
                                propEleType = this.getPropEleType(propType);
                                do {
                                    if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                        c.add(null);
                                        xmlReader.next();
                                        continue;
                                    }
                                    c.add(this.readByStreamParser(propEleType.clazz(), xmlReader, XMLParserImpl.defaultXMLDeserializationConfig, propType, null));
                                } while (xmlReader.hasNext() && xmlReader.next() == 1);
                                v3 = propValue = propType.clazz().isArray() != false ? XMLParserImpl.collection2Array(propType.clazz(), c) : c;
                            }
                            if (xmlReader.getEventType() == 2 && xmlReader.getLocalName().equals(propName)) {
                                if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                    map.put(isStringKey != false ? propName : keyType.valueOf(propName), propValue);
                                }
                                propName = null;
                                propValue = null;
                                break;
                            }
                            throw new ParseException("Unknown parser error at element: " + xmlReader.getLocalName());
                        }
                        case 4: {
                            propValue = propType.valueOf(xmlReader.getText());
                            break;
                        }
                        case 2: {
                            if (propName == null) {
                                return (T)map;
                            }
                            if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                map.put(isStringKey != false ? propName : keyType.valueOf(propName), propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            break;
                        }
                    }
                    event = xmlReader.next();
                }
                throw new ParseException("Unknown parser error");
            }
            case 4: {
                ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
                valueType /* !! */  = XMLParserImpl.defaultValueType;
                if (propInfo != null && propInfo.jsonXmlType.getParameterTypes().length == 2 && !Object.class.equals(propInfo.jsonXmlType.getParameterTypes()[1].clazz())) {
                    valueType /* !! */  = propInfo.jsonXmlType.getParameterTypes()[1];
                } else if (propType != null && propType.getParameterTypes().length == 2 && Map.class.isAssignableFrom(propType.clazz()) && !Object.class.equals(propType.getParameterTypes()[1].clazz())) {
                    valueType /* !! */  = propType.getParameterTypes()[1];
                } else if (config.getMapValueType() != null && !Object.class.equals(config.getMapValueType().clazz())) {
                    valueType /* !! */  = config.getMapValueType();
                }
                mapEntity = N.newEntity(MapEntity.class, xmlReader.getLocalName());
                attrCount = 0;
                event = xmlReader.next();
                while (xmlReader.hasNext()) {
                    switch (event) {
                        case 1: {
                            if (propName != null) ** GOTO lbl224
                            propName = xmlReader.getLocalName();
                            v4 /* !! */  = propType = hasPropTypes != false ? config.getPropType(propName) : null;
                            if (propType != null) break;
                            attrCount = xmlReader.getAttributeCount();
                            if (attrCount != 1) ** GOTO lbl216
                            if (!"type".equals(xmlReader.getAttributeLocalName(0))) ** GOTO lbl221
                            propType = N.typeOf(xmlReader.getAttributeValue(0));
                            ** GOTO lbl221
lbl216:
                            // 1 sources

                            if (attrCount > 1) {
                                for (i = 0; i < attrCount; ++i) {
                                    if (!"type".equals(xmlReader.getAttributeLocalName(i))) continue;
                                    propType = N.typeOf(xmlReader.getAttributeValue(i));
                                    break;
                                }
                            }
lbl221:
                            // 6 sources

                            if (propType != null) break;
                            propType = valueType /* !! */ ;
                            break;
lbl224:
                            // 1 sources

                            if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                                startCount = 1;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else if (Map.class.isAssignableFrom(propType.clazz()) || ClassUtil.isEntity(propType.clazz())) {
                                propValue = this.readByStreamParser(propType.clazz(), xmlReader, config, propType, null);
                                startCount = 0;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else {
                                c = Collection.class.isAssignableFrom(propType.clazz()) != false ? (Collection)N.newInstance(propType.clazz()) : new ArrayList<E>();
                                propEleType = this.getPropEleType(propType);
                                do {
                                    if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                        c.add(null);
                                        xmlReader.next();
                                        continue;
                                    }
                                    c.add(this.readByStreamParser(propEleType.clazz(), xmlReader, XMLParserImpl.defaultXMLDeserializationConfig, propType, null));
                                } while (xmlReader.hasNext() && xmlReader.next() == 1);
                                v5 = propValue = propType.clazz().isArray() != false ? XMLParserImpl.collection2Array(propType.clazz(), c) : c;
                            }
                            if (xmlReader.getEventType() == 2 && xmlReader.getLocalName().equals(propName)) {
                                if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                    mapEntity.set(propName, propValue);
                                }
                                propName = null;
                                propValue = null;
                                break;
                            }
                            throw new ParseException("Unknown parser error at element: " + xmlReader.getLocalName());
                        }
                        case 4: {
                            propValue = propType.valueOf(xmlReader.getText());
                            break;
                        }
                        case 2: {
                            if (propName == null) {
                                return (T)mapEntity;
                            }
                            if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                mapEntity.set(propName, propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            break;
                        }
                    }
                    event = xmlReader.next();
                }
                throw new ParseException("Unknown parser error");
            }
            case 5: {
                eleType = null;
                eleType = propInfo != null && propInfo.clazz.isArray() != false && Object.class.equals(propInfo.clazz.getComponentType()) == false ? N.typeOf(propInfo.clazz.getComponentType()) : (config.getElementType() != null && Object.class.equals(config.getElementType().clazz()) == false ? config.getElementType() : N.typeOf(targetClass.isArray() != false ? targetClass.getComponentType() : String.class));
                list = Objectory.createList();
                try {
                    event = xmlReader.next();
                    while (xmlReader.hasNext()) {
                        switch (event) {
                            case 1: {
                                if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                    list.add(null);
                                    break;
                                }
                                if (String.class == eleType.clazz() || Object.class == eleType.clazz()) {
                                    list.add(this.readByStreamParser(Map.class, xmlReader, config, eleType, null));
                                    break;
                                }
                                list.add(this.readByStreamParser(eleType.clazz(), xmlReader, config, eleType, null));
                                break;
                            }
                            case 4: {
                                propValue = eleType.clazz() == String.class || eleType.clazz() == Object.class ? N.typeOf(targetClass).valueOf(xmlReader.getText()) : XMLParserImpl.jsonParser.deserialize(targetClass, xmlReader.getText(), JSONDeserializationConfig.JDC.of(eleType.clazz()));
                            }
                            case 2: {
                                if (propValue != null) {
                                    var13_28 = propValue;
                                    return (T)var13_28;
                                }
                                var13_29 = XMLParserImpl.collection2Array(targetClass, list);
                                return var13_29;
                            }
                        }
                        event = xmlReader.next();
                    }
                }
                finally {
                    Objectory.recycle(list);
                }
                throw new ParseException("Unknown parser error");
            }
            case 6: {
                eleType = XMLParserImpl.defaultValueType;
                if (propInfo != null && propInfo.clazz.isArray() && !Object.class.equals(propInfo.clazz.getComponentType())) {
                    eleType = N.typeOf(propInfo.clazz.getComponentType());
                } else if (propType != null && propType.getParameterTypes().length == 1 && Collection.class.isAssignableFrom(propType.clazz()) && !Object.class.equals(propType.getParameterTypes()[0].clazz())) {
                    eleType = propType.getParameterTypes()[0];
                } else if (config.getElementType() != null && !Object.class.equals(config.getElementType().clazz())) {
                    eleType = config.getElementType();
                }
                result = (Collection)N.newInstance(targetClass);
                event = xmlReader.next();
                while (xmlReader.hasNext()) {
                    switch (event) {
                        case 1: {
                            if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                result.add(null);
                                break;
                            }
                            if (String.class == eleType.clazz() || Object.class == eleType.clazz()) {
                                result.add(this.readByStreamParser(Map.class, xmlReader, config, eleType, null));
                                break;
                            }
                            result.add(this.readByStreamParser(eleType.clazz(), xmlReader, config, eleType, null));
                            break;
                        }
                        case 4: {
                            propValue = eleType.clazz() == String.class || eleType.clazz() == Object.class ? (Object)N.typeOf(targetClass).valueOf(xmlReader.getText()) : XMLParserImpl.jsonParser.deserialize(targetClass, xmlReader.getText(), JSONDeserializationConfig.JDC.of(eleType.clazz()));
                        }
                        case 2: {
                            if (propValue != null) {
                                return (T)propValue;
                            }
                            return (T)result;
                        }
                    }
                    event = xmlReader.next();
                }
                throw new ParseException("Unknown parser error");
            }
        }
        throw new ParseException("Unsupported class type: " + ClassUtil.getCanonicalClassName(targetClass) + ". Only array, collection, map and entity types are supported");
    }

    protected <T> T readByDOMParser(Class<T> targetClass, Node node, XMLDeserializationConfig config) {
        if (config == null) {
            config = defaultXMLDeserializationConfig;
        }
        return this.readByDOMParser(targetClass, node, config, null, config.getElementType(), false, false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T readByDOMParser(Class<T> inputClass, Node node, XMLDeserializationConfig config, String propName, Type<?> propType, boolean checkedAttr, boolean isTagByPropertyName, boolean ignoreTypeInfo, boolean isFirstCall) {
        if (node.getNodeType() == 3) {
            return null;
        }
        boolean hasPropTypes = N.notNullOrEmpty(config.getPropTypes());
        Class<Object> targetClass = null;
        if (isFirstCall) {
            targetClass = inputClass;
        } else {
            if (propType == null || String.class.equals(propType.clazz()) || Object.class.equals(propType.clazz())) {
                String nameAttr;
                String nodeName = null;
                nodeName = checkedAttr ? (isTagByPropertyName ? node.getNodeName() : XMLUtil.getAttribute(node, "name")) : (N.notNullOrEmpty(nameAttr = XMLUtil.getAttribute(node, "name")) ? nameAttr : node.getNodeName());
                targetClass = hasPropTypes && config.hasPropType(nodeName) ? config.getPropType(nodeName).clazz() : null;
            } else {
                targetClass = propType.clazz();
            }
            if (targetClass == null || String.class.equals(targetClass) || Object.class.equals(targetClass)) {
                targetClass = List.class;
            }
        }
        Class<Object> typeClass = checkedAttr ? (ignoreTypeInfo ? targetClass : XMLParserImpl.getConcreteClass(targetClass, node)) : XMLParserImpl.getConcreteClass(targetClass, node);
        Type.SerializationType deserializationType = this.getDeserializationType(targetClass);
        ParserUtil.PropInfo propInfo = null;
        Node propNode = null;
        Object propValue = null;
        NodeList propNodes = node.getChildNodes();
        int propNodeLength = propNodes == null ? 0 : propNodes.getLength();
        switch (deserializationType) {
            case ENTITY: {
                boolean ignoreUnknownProperty = config.isIgnoreUnknownProperty();
                Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(typeClass);
                ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(typeClass);
                Object entity = N.newInstance(typeClass);
                for (int i = 0; i < propNodeLength; ++i) {
                    propNode = propNodes.item(i);
                    if (propNode.getNodeType() == 3) continue;
                    if (!checkedAttr) {
                        isTagByPropertyName = N.isNullOrEmpty(XMLUtil.getAttribute(propNode, "name"));
                        ignoreTypeInfo = N.isNullOrEmpty(XMLUtil.getAttribute(propNode, "type"));
                        checkedAttr = true;
                    }
                    propName = isTagByPropertyName ? propNode.getNodeName() : XMLUtil.getAttribute(propNode, "name");
                    propInfo = entityInfo.getPropInfo(propName);
                    if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) continue;
                    if (propInfo == null) {
                        if (ignoreUnknownProperty) continue;
                        throw new ParseException("Unknown property element: " + propName + " for class: " + typeClass.getCanonicalName());
                    }
                    Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                    if (propType == null) {
                        propType = propInfo.jsonXmlType.isSerializable() ? propInfo.jsonXmlType : (ignoreTypeInfo ? propInfo.jsonXmlType : N.typeOf(XMLParserImpl.getConcreteClass(propInfo.jsonXmlType.clazz(), propNode)));
                    }
                    propValue = this.getPropValue(inputClass, propNode, config, propName, propType, propInfo, checkedAttr, isTagByPropertyName, ignoreTypeInfo, true);
                    propInfo.setPropValue(entity, propValue);
                }
                return (T)entity;
            }
            case MAP: {
                Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
                Type<Object> keyType = defaultKeyType;
                if (propType != null && propType.isMap() && !Object.class.equals(propType.getParameterTypes()[0].clazz())) {
                    keyType = propType.getParameterTypes()[0];
                } else if (config.getMapKeyType() != null && !Object.class.equals(config.getMapKeyType().clazz())) {
                    keyType = config.getMapKeyType();
                }
                boolean isStringKey = keyType.clazz() == String.class;
                Type<Object> valueType = defaultValueType;
                if (propType != null && propType.isMap() && !Object.class.equals(propType.getParameterTypes()[1].clazz())) {
                    valueType = propType.getParameterTypes()[1];
                } else if (config.getMapValueType() != null && !Object.class.equals(config.getMapValueType().clazz())) {
                    valueType = config.getMapValueType();
                }
                Map mResult = (Map)XMLParserImpl.newPropInstance(typeClass, node);
                propNodes = node.getChildNodes();
                propNodeLength = propNodes == null ? 0 : propNodes.getLength();
                propNode = null;
                propType = null;
                propValue = null;
                for (int i = 0; i < propNodeLength; ++i) {
                    propNode = propNodes.item(i);
                    if (propNode.getNodeType() == 3) continue;
                    if (!checkedAttr) {
                        isTagByPropertyName = N.isNullOrEmpty(XMLUtil.getAttribute(propNode, "name"));
                        ignoreTypeInfo = N.isNullOrEmpty(XMLUtil.getAttribute(propNode, "type"));
                        checkedAttr = true;
                    }
                    String string = propName = isTagByPropertyName ? propNode.getNodeName() : XMLUtil.getAttribute(propNode, "name");
                    if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) continue;
                    Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                    if (propType == null) {
                        Type<Object> type2 = propType = ignoreTypeInfo ? valueType : N.typeOf(XMLParserImpl.getConcreteClass(valueType.clazz(), propNode));
                    }
                    if (propType.clazz() == Object.class) {
                        propType = defaultValueType;
                    }
                    propValue = this.getPropValue(inputClass, propNode, config, propName, propType, propInfo, checkedAttr, isTagByPropertyName, ignoreTypeInfo, true);
                    mResult.put(isStringKey ? propName : keyType.valueOf(propName), propValue);
                }
                return (T)mResult;
            }
            case MAP_ENTITY: {
                Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
                Type<Object> valueType = null;
                valueType = propType != null && propType.isMap() && !Object.class.equals(propType.getParameterTypes()[1].clazz()) ? propType.getParameterTypes()[1] : (config.getMapValueType() != null && !Object.class.equals(config.getMapValueType().clazz()) ? config.getMapValueType() : objType);
                MapEntity mResult = N.newEntity(MapEntity.class, node.getNodeName());
                propNodes = node.getChildNodes();
                propNodeLength = propNodes == null ? 0 : propNodes.getLength();
                propNode = null;
                propType = null;
                propValue = null;
                for (int i = 0; i < propNodeLength; ++i) {
                    propNode = propNodes.item(i);
                    if (propNode.getNodeType() == 3) continue;
                    if (!checkedAttr) {
                        isTagByPropertyName = N.isNullOrEmpty(XMLUtil.getAttribute(propNode, "name"));
                        ignoreTypeInfo = N.isNullOrEmpty(XMLUtil.getAttribute(propNode, "type"));
                        checkedAttr = true;
                    }
                    String string = propName = isTagByPropertyName ? propNode.getNodeName() : XMLUtil.getAttribute(propNode, "name");
                    if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) continue;
                    Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                    if (propType == null) {
                        Type<Object> type3 = propType = ignoreTypeInfo ? valueType : N.typeOf(XMLParserImpl.getConcreteClass(valueType.clazz(), propNode));
                    }
                    if (propType.clazz() == Object.class) {
                        propType = defaultValueType;
                    }
                    propValue = this.getPropValue(inputClass, propNode, config, propName, propType, propInfo, checkedAttr, isTagByPropertyName, ignoreTypeInfo, true);
                    mResult.set(propName, propValue);
                }
                return (T)mResult;
            }
            case ARRAY: {
                Type<Object> eleType = null;
                eleType = propType != null && (propType.isArray() || propType.isCollection()) && propType.getElementType() != null && !Object.class.equals(propType.getElementType().clazz()) ? propType.getElementType() : (config.getElementType() != null && !Object.class.equals(config.getElementType().clazz()) ? config.getElementType() : N.typeOf(typeClass.isArray() ? typeClass.getComponentType() : Object.class));
                if (XMLUtil.isTextElement(node)) {
                    if (eleType.clazz() == String.class || eleType.clazz() == Object.class) {
                        return N.typeOf(typeClass).valueOf(XMLUtil.getTextContent(node));
                    }
                    return (T)jsonParser.deserialize(typeClass, XMLUtil.getTextContent(node), JSONDeserializationConfig.JDC.of(eleType.clazz()));
                }
                List c = Objectory.createList();
                try {
                    NodeList eleNodes = node.getChildNodes();
                    Node eleNode = null;
                    for (int i = 0; i < eleNodes.getLength(); ++i) {
                        eleNode = eleNodes.item(i);
                        if (eleNode.getNodeType() == 3) continue;
                        if (!checkedAttr) {
                            isTagByPropertyName = N.isNullOrEmpty(XMLUtil.getAttribute(eleNode, "name"));
                            ignoreTypeInfo = N.isNullOrEmpty(XMLUtil.getAttribute(eleNode, "type"));
                            checkedAttr = true;
                        }
                        propName = isTagByPropertyName ? eleNode.getNodeName() : XMLUtil.getAttribute(eleNode, "name");
                        Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                        if (propType == null) {
                            Type<Object> type4 = propType = ignoreTypeInfo ? eleType : N.typeOf(XMLParserImpl.getConcreteClass(eleType.clazz(), eleNode));
                        }
                        if (propType.clazz() == Object.class) {
                            propType = defaultValueType;
                        }
                        propValue = this.getPropValue(inputClass, eleNode, config, propName, propType, propInfo, checkedAttr, isTagByPropertyName, ignoreTypeInfo, false);
                        c.add(propValue);
                    }
                    Object i = XMLParserImpl.collection2Array(typeClass, c);
                    return i;
                }
                finally {
                    Objectory.recycle(c);
                }
            }
            case COLLECTION: {
                Type<Object> eleType = null;
                eleType = propType != null && (propType.isCollection() || propType.isArray()) && !Object.class.equals(propType.getElementType().clazz()) ? propType.getElementType() : (config.getElementType() != null && !Object.class.equals(config.getElementType().clazz()) ? config.getElementType() : objType);
                if (XMLUtil.isTextElement(node)) {
                    if (eleType.clazz() == String.class || eleType.clazz() == Object.class) {
                        return N.typeOf(typeClass).valueOf(XMLUtil.getTextContent(node));
                    }
                    return (T)jsonParser.deserialize(typeClass, XMLUtil.getTextContent(node), JSONDeserializationConfig.JDC.of(eleType.clazz()));
                }
                Collection result = (Collection)XMLParserImpl.newPropInstance(typeClass, node);
                NodeList eleNodes = node.getChildNodes();
                Node eleNode = null;
                for (int i = 0; i < eleNodes.getLength(); ++i) {
                    eleNode = eleNodes.item(i);
                    if (eleNode.getNodeType() == 3) continue;
                    if (!checkedAttr) {
                        isTagByPropertyName = N.isNullOrEmpty(XMLUtil.getAttribute(eleNode, "name"));
                        ignoreTypeInfo = N.isNullOrEmpty(XMLUtil.getAttribute(eleNode, "type"));
                        checkedAttr = true;
                    }
                    propName = isTagByPropertyName ? eleNode.getNodeName() : XMLUtil.getAttribute(eleNode, "name");
                    Type<Object> type = propType = hasPropTypes ? config.getPropType(propName) : null;
                    if (propType == null) {
                        Type<Object> type5 = propType = ignoreTypeInfo ? eleType : N.typeOf(XMLParserImpl.getConcreteClass(eleType.clazz(), eleNode));
                    }
                    if (eleType.clazz() == Object.class) {
                        propType = defaultValueType;
                    }
                    propValue = this.getPropValue(inputClass, eleNode, config, propName, propType, propInfo, checkedAttr, isTagByPropertyName, ignoreTypeInfo, false);
                    result.add(propValue);
                }
                return (T)result;
            }
        }
        throw new ParseException("Unsupported class type: " + ClassUtil.getCanonicalClassName(targetClass) + ". Only array, collection, map and entity types are supported");
    }

    protected Type.SerializationType getDeserializationType(Class<?> targetClass) {
        Type type = N.typeOf(targetClass);
        Type.SerializationType serializationType = type.getSerializationType();
        if (type.isSerializable()) {
            if (type.isObjectArray()) {
                serializationType = Type.SerializationType.ARRAY;
            } else if (type.isCollection()) {
                serializationType = Type.SerializationType.COLLECTION;
            }
        }
        return serializationType;
    }

    private <T> Object getPropValue(Class<T> inputClass, Node propNode, XMLDeserializationConfig config, String propName, Type<?> propType, ParserUtil.PropInfo propInfo, boolean checkedAttr, boolean isTagByPropertyName, boolean ignoreTypeInfo, boolean isProp) {
        Collection<T> propValue;
        if (XMLUtil.isTextElement(propNode)) {
            propValue = this.getPropValue(propName, propType, propInfo, propNode);
        } else if (Map.class.isAssignableFrom(propType.clazz()) || ClassUtil.isEntity(propType.clazz())) {
            if (isProp) {
                propNode = XMLParserImpl.checkOneNode(propNode);
            }
            propValue = this.readByDOMParser(inputClass, propNode, config, propName, propType, checkedAttr, isTagByPropertyName, ignoreTypeInfo, false);
        } else {
            Collection<T> coll = Collection.class.isAssignableFrom(propType.clazz()) ? (Collection)N.newInstance(propType.clazz()) : new ArrayList();
            Type<?> propEleType = this.getPropEleType(propType);
            NodeList subPropNodes = propNode.getChildNodes();
            int subPropNodeLength = subPropNodes == null ? 0 : subPropNodes.getLength();
            Node subPropNode = null;
            for (int k = 0; k < subPropNodeLength; ++k) {
                subPropNode = subPropNodes.item(k);
                if (subPropNode.getNodeType() == 3) continue;
                coll.add(this.readByDOMParser(inputClass, subPropNode, config, propName, propEleType, checkedAttr, isTagByPropertyName, ignoreTypeInfo, false));
            }
            propValue = propType.clazz().isArray() ? XMLParserImpl.collection2Array(propType.clazz(), coll) : coll;
        }
        return propValue;
    }

    private Type<?> getPropEleType(Type<?> propType) {
        Type<Object> propEleType = null;
        propEleType = propType.clazz().isArray() && (ClassUtil.isEntity(propType.getElementType().clazz()) || Map.class.isAssignableFrom(propType.getElementType().clazz())) ? propType.getElementType() : (propType.getParameterTypes().length == 1 && (ClassUtil.isEntity(propType.getParameterTypes()[0].clazz()) || Map.class.isAssignableFrom(propType.getParameterTypes()[0].clazz())) ? propType.getParameterTypes()[0] : N.typeOf(Map.class));
        return propEleType;
    }
}

