/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.pool;

import java.io.Serializable;

public final class ActivityPrint
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -45207875951748322L;
    private long createTime;
    private long liveTime;
    private long maxIdleTime;
    private long lastAccessTime;
    private int accessCount;

    public ActivityPrint(long liveTime, long maxIdleTime) throws IllegalArgumentException {
        if (liveTime <= 0L) {
            throw new IllegalArgumentException("Illegal liveTime[" + liveTime + "]. ");
        }
        if (maxIdleTime <= 0L) {
            throw new IllegalArgumentException("Illegal maxIdleTime[" + maxIdleTime + "]. ");
        }
        this.createTime = System.currentTimeMillis();
        this.liveTime = liveTime;
        this.maxIdleTime = maxIdleTime;
        this.lastAccessTime = this.createTime;
        this.accessCount = 0;
    }

    public static ActivityPrint valueOf(long liveTime, long maxIdleTime) {
        return new ActivityPrint(liveTime, maxIdleTime);
    }

    public long getLiveTime() {
        return this.liveTime;
    }

    public ActivityPrint setLiveTime(long liveTime) throws IllegalArgumentException {
        if (liveTime < 0L) {
            throw new IllegalArgumentException("Illegal live time: " + liveTime);
        }
        this.liveTime = liveTime;
        return this;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public ActivityPrint setMaxIdleTime(long maxIdleTime) throws IllegalArgumentException {
        if (maxIdleTime < 0L) {
            throw new IllegalArgumentException("Illegal idle time: " + maxIdleTime);
        }
        this.maxIdleTime = maxIdleTime;
        return this;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    ActivityPrint setCreateTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public void updateAccessCount() {
        ++this.accessCount;
    }

    public long getExpirationTime() {
        return Long.MAX_VALUE - this.createTime < this.liveTime ? Long.MAX_VALUE : this.createTime + this.liveTime;
    }

    public boolean isExpired() {
        long now = System.currentTimeMillis();
        return this.maxIdleTime < now - this.lastAccessTime || this.liveTime < now - this.createTime;
    }

    public Object clone() {
        ActivityPrint result = null;
        try {
            result = (ActivityPrint)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }

    public int hashCode() {
        long h = 7L;
        h = h * 31L + this.createTime;
        h = h * 31L + this.liveTime;
        h = h * 31L + this.maxIdleTime;
        h = h * 31L + this.lastAccessTime;
        h = h * 31L + (long)this.accessCount;
        return (int)h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ActivityPrint) {
            ActivityPrint other = (ActivityPrint)obj;
            return this.createTime == other.createTime && this.liveTime == other.liveTime && this.maxIdleTime == other.maxIdleTime && this.lastAccessTime == other.lastAccessTime && this.accessCount == other.accessCount;
        }
        return false;
    }

    public String toString() {
        return "{createTime=" + this.createTime + ", liveTime=" + this.liveTime + ", maxIdleTime=" + this.maxIdleTime + ", lastAccessedTime=" + this.lastAccessTime + ", accessCount=" + this.accessCount + "}";
    }
}

