/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.pool;

import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.pool.AbstractPool;
import com.landawn.abacus.pool.ActivityPrint;
import com.landawn.abacus.pool.EvictionPolicy;
import com.landawn.abacus.pool.KeyedObjectPool;
import com.landawn.abacus.pool.Poolable;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ExceptionUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class GenericKeyedObjectPool<K, E extends Poolable>
extends AbstractPool
implements KeyedObjectPool<K, E> {
    private static final long serialVersionUID = 2208516321399679864L;
    private final long maxMemorySize;
    private final KeyedObjectPool.MemoryMeasure<K, E> memoryMeasure;
    private volatile long usedMemorySize = 0L;
    final Map<K, E> pool;
    final Comparator<Map.Entry<K, E>> cmp;
    ScheduledFuture<?> scheduleFuture;

    protected GenericKeyedObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy) {
        this(capacity, evictDelay, evictionPolicy, 0L, null);
    }

    protected GenericKeyedObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, long maxMemorySize, KeyedObjectPool.MemoryMeasure<K, E> memoryMeasure) {
        this(capacity, evictDelay, evictionPolicy, true, 0.2f, maxMemorySize, memoryMeasure);
    }

    protected GenericKeyedObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor) {
        this(capacity, evictDelay, evictionPolicy, autoBalance, balanceFactor, 0L, null);
    }

    protected GenericKeyedObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor, long maxMemorySize, KeyedObjectPool.MemoryMeasure<K, E> memoryMeasure) {
        super(capacity, evictDelay, evictionPolicy, autoBalance, balanceFactor);
        this.maxMemorySize = maxMemorySize;
        this.memoryMeasure = memoryMeasure;
        this.pool = new HashMap<K, E>(capacity > 1000 ? 1000 : capacity);
        switch (this.evictionPolicy) {
            case LAST_ACCESS_TIME: {
                this.cmp = new Comparator<Map.Entry<K, E>>(){

                    @Override
                    public int compare(Map.Entry<K, E> o1, Map.Entry<K, E> o2) {
                        return Long.compare(((Poolable)o1.getValue()).activityPrint().getLastAccessTime(), ((Poolable)o2.getValue()).activityPrint().getLastAccessTime());
                    }
                };
                break;
            }
            case ACCESS_COUNT: {
                this.cmp = new Comparator<Map.Entry<K, E>>(){

                    @Override
                    public int compare(Map.Entry<K, E> o1, Map.Entry<K, E> o2) {
                        return Long.compare(((Poolable)o1.getValue()).activityPrint().getAccessCount(), ((Poolable)o2.getValue()).activityPrint().getAccessCount());
                    }
                };
                break;
            }
            case EXPIRATION_TIME: {
                this.cmp = new Comparator<Map.Entry<K, E>>(){

                    @Override
                    public int compare(Map.Entry<K, E> o1, Map.Entry<K, E> o2) {
                        return Long.compare(((Poolable)o1.getValue()).activityPrint().getExpirationTime(), ((Poolable)o2.getValue()).activityPrint().getExpirationTime());
                    }
                };
                break;
            }
            default: {
                throw new AbacusException("Unsupproted eviction policy: " + evictionPolicy.name());
            }
        }
        if (evictDelay > 0L) {
            Runnable evictTask = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            GenericKeyedObjectPool.this.evict();
                        }
                        catch (Exception e) {
                            if (!AbstractPool.logger.isWarnEnabled()) break block2;
                            AbstractPool.logger.warn(ExceptionUtil.getMessage(e));
                        }
                    }
                }
            };
            this.scheduleFuture = scheduledExecutor.scheduleWithFixedDelay(evictTask, evictDelay, evictDelay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, E e) {
        this.assertNotClosed();
        if (key == null || e == null) {
            throw new NullPointerException();
        }
        if (e.activityPrint().isExpired()) {
            return false;
        }
        this.putCount.incrementAndGet();
        this.lock.lock();
        try {
            if (this.pool.size() >= this.capacity || this.usedMemorySize > this.maxMemorySize) {
                if (this.autoBalance) {
                    this.vacate();
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.memoryMeasure != null && this.memoryMeasure.sizeOf(key, e) > this.maxMemorySize - this.usedMemorySize) {
                boolean bl = false;
                return bl;
            }
            Poolable oldValue = (Poolable)this.pool.put(key, e);
            if (oldValue != null) {
                this.destroy(key, oldValue);
            }
            if (this.memoryMeasure != null) {
                this.usedMemorySize += this.memoryMeasure.sizeOf(key, e);
            }
            this.notEmpty.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, E e, boolean autoDestroyOnFailedToPut) {
        boolean sucess = false;
        try {
            sucess = this.put(key, e);
        }
        finally {
            if (autoDestroyOnFailedToPut && !sucess && e != null) {
                e.destroy();
            }
        }
        return sucess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(K key) {
        this.assertNotClosed();
        Poolable e = null;
        this.lock.lock();
        try {
            e = (Poolable)this.pool.get(key);
            if (e != null) {
                ActivityPrint activityPrint = e.activityPrint();
                activityPrint.updateLastAccessTime();
                activityPrint.updateAccessCount();
                this.hitCount.incrementAndGet();
            } else {
                this.missCount.incrementAndGet();
            }
            Poolable poolable = e;
            return (E)poolable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(K key) {
        this.assertNotClosed();
        Poolable e = null;
        this.lock.lock();
        try {
            e = (Poolable)this.pool.remove(key);
            if (e != null) {
                ActivityPrint activityPrint = e.activityPrint();
                activityPrint.updateLastAccessTime();
                activityPrint.updateAccessCount();
                if (this.memoryMeasure != null) {
                    this.usedMemorySize -= this.memoryMeasure.sizeOf(key, e);
                }
                this.notFull.signal();
            }
            Poolable poolable = e;
            return (E)poolable;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E peek(K key) {
        this.assertNotClosed();
        this.lock.lock();
        try {
            Poolable poolable = (Poolable)this.pool.get(key);
            return (E)poolable;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsKey(K key) {
        this.assertNotClosed();
        this.lock.lock();
        try {
            boolean bl = this.pool.containsKey(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsValue(E e) {
        this.assertNotClosed();
        this.lock.lock();
        try {
            boolean bl = this.pool.containsValue(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        this.assertNotClosed();
        this.lock.lock();
        try {
            Set<K> set = N.newHashSet(this.pool.keySet());
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<E> values() {
        this.assertNotClosed();
        this.lock.lock();
        try {
            ArrayList<E> arrayList = new ArrayList<E>(this.pool.values());
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.assertNotClosed();
        this.removeAll();
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (this.scheduleFuture != null) {
                this.scheduleFuture.cancel(true);
            }
        }
        finally {
            this.removeAll();
        }
    }

    @Override
    public void vacate() {
        this.assertNotClosed();
        this.lock.lock();
        try {
            this.vacate((int)((float)this.pool.size() * this.balanceFactor));
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.pool.size();
    }

    public int hashCode() {
        return this.pool.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof GenericKeyedObjectPool && N.equals(((GenericKeyedObjectPool)obj).pool, this.pool);
    }

    public String toString() {
        return this.pool.toString();
    }

    protected void vacate(int vacationNumber) {
        int size = this.pool.size();
        if (vacationNumber >= size) {
            this.destroyAll(new HashMap<K, E>(this.pool));
            this.pool.clear();
        } else {
            PriorityQueue<Map.Entry<K, Map.Entry<K, E>>> heap = new PriorityQueue<Map.Entry<K, Map.Entry<K, E>>>(vacationNumber, this.cmp);
            for (Map.Entry<K, E> entry : this.pool.entrySet()) {
                if (heap.size() < vacationNumber) {
                    heap.offer(entry);
                    continue;
                }
                if (this.cmp.compare(entry, (Map.Entry<K, E>)heap.peek()) >= 0) continue;
                heap.poll();
                heap.offer(entry);
            }
            HashMap removingObjects = new HashMap(N.initHashCapacity(heap.size()));
            for (Map.Entry entry : heap) {
                this.pool.remove(entry.getKey());
                removingObjects.put(entry.getKey(), entry.getValue());
            }
            this.destroyAll(removingObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        this.lock.lock();
        Map<K, E> removingObjects = null;
        try {
            for (Map.Entry<K, E> entry : this.pool.entrySet()) {
                if (!((Poolable)entry.getValue()).activityPrint().isExpired()) continue;
                if (removingObjects == null) {
                    removingObjects = Objectory.createMap();
                }
                removingObjects.put(entry.getKey(), entry.getValue());
            }
            if (N.notNullOrEmpty(removingObjects)) {
                for (Map.Entry<K, Object> key : removingObjects.keySet()) {
                    this.pool.remove(key);
                }
                this.destroyAll(removingObjects);
                this.notFull.signalAll();
            }
        }
        finally {
            this.lock.unlock();
            Objectory.recycle(removingObjects);
        }
    }

    protected void destroy(K key, E value) {
        block5: {
            this.evictionCount.incrementAndGet();
            if (value != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Destroying cached object " + ClassUtil.getSimpleClassName(value.getClass()) + " with activity print: " + value.activityPrint());
                }
                if (this.memoryMeasure != null) {
                    this.usedMemorySize -= this.memoryMeasure.sizeOf(key, value);
                }
                try {
                    value.destroy();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn(ExceptionUtil.getMessage(e));
                }
            }
        }
    }

    protected void destroyAll(Map<K, E> map) {
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<K, E> entry : map.entrySet()) {
                this.destroy(entry.getKey(), (Poolable)entry.getValue());
            }
        }
    }

    private void removeAll() {
        this.lock.lock();
        try {
            this.destroyAll(new HashMap<K, E>(this.pool));
            this.pool.clear();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        this.lock.lock();
        try {
            os.defaultWriteObject();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.lock.lock();
        try {
            is.defaultReadObject();
        }
        finally {
            this.lock.unlock();
        }
    }
}

