/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.pool;

import com.landawn.abacus.pool.EvictionPolicy;
import com.landawn.abacus.pool.GenericKeyedObjectPool;
import com.landawn.abacus.pool.GenericObjectPool;
import com.landawn.abacus.pool.KeyedObjectPool;
import com.landawn.abacus.pool.ObjectPool;
import com.landawn.abacus.pool.Poolable;

public abstract class PoolFactory {
    private PoolFactory() {
    }

    public static <E extends Poolable> ObjectPool<E> createObjectPool(int capacity) {
        return new GenericObjectPool(capacity, 3000L, EvictionPolicy.LAST_ACCESS_TIME);
    }

    public static <E extends Poolable> ObjectPool<E> createObjectPool(int capacity, long evictDelay) {
        return new GenericObjectPool(capacity, evictDelay, EvictionPolicy.LAST_ACCESS_TIME);
    }

    public static <E extends Poolable> ObjectPool<E> createObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy) {
        return new GenericObjectPool(capacity, evictDelay, evictionPolicy);
    }

    public static <E extends Poolable> ObjectPool<E> createObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, long maxMemorySize, ObjectPool.MemoryMeasure<E> memoryMeasure) {
        return new GenericObjectPool<E>(capacity, evictDelay, evictionPolicy, maxMemorySize, memoryMeasure);
    }

    public static <E extends Poolable> ObjectPool<E> createObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor) {
        return new GenericObjectPool(capacity, evictDelay, evictionPolicy, autoBalance, balanceFactor);
    }

    public static <E extends Poolable> ObjectPool<E> createObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor, long maxMemorySize, ObjectPool.MemoryMeasure<E> memoryMeasure) {
        return new GenericObjectPool<E>(capacity, evictDelay, evictionPolicy, autoBalance, balanceFactor, maxMemorySize, memoryMeasure);
    }

    public static <K, E extends Poolable> KeyedObjectPool<K, E> createKeyedObjectPool(int capacity) {
        return new GenericKeyedObjectPool(capacity, 3000L, EvictionPolicy.LAST_ACCESS_TIME);
    }

    public static <K, E extends Poolable> KeyedObjectPool<K, E> createKeyedObjectPool(int capacity, long evictDelay) {
        return new GenericKeyedObjectPool(capacity, evictDelay, EvictionPolicy.LAST_ACCESS_TIME);
    }

    public static <K, E extends Poolable> KeyedObjectPool<K, E> createKeyedObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy) {
        return new GenericKeyedObjectPool(capacity, evictDelay, evictionPolicy);
    }

    public static <K, E extends Poolable> KeyedObjectPool<K, E> createKeyedObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, long maxMemorySize, KeyedObjectPool.MemoryMeasure<K, E> memoryMeasure) {
        return new GenericKeyedObjectPool<K, E>(capacity, evictDelay, evictionPolicy, maxMemorySize, memoryMeasure);
    }

    public static <K, E extends Poolable> KeyedObjectPool<K, E> createKeyedObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor) {
        return new GenericKeyedObjectPool(capacity, evictDelay, evictionPolicy, autoBalance, balanceFactor);
    }

    public static <K, E extends Poolable> KeyedObjectPool<K, E> createKeyedObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor, long maxMemorySize, KeyedObjectPool.MemoryMeasure<K, E> memoryMeasure) {
        return new GenericKeyedObjectPool<K, E>(capacity, evictDelay, evictionPolicy, autoBalance, balanceFactor, maxMemorySize, memoryMeasure);
    }
}

