/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.pool;

import com.landawn.abacus.pool.AbstractPoolable;
import com.landawn.abacus.util.N;

public final class PoolableWrapper<T>
extends AbstractPoolable {
    private T srcObject;

    public PoolableWrapper(T srcObject) {
        this(srcObject, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public PoolableWrapper(T srcObject, long liveTime, long maxIdleTime) {
        super(liveTime, maxIdleTime);
        this.srcObject = srcObject;
    }

    public static <T> PoolableWrapper<T> of(T srcObject) {
        return new PoolableWrapper<T>(srcObject);
    }

    public static <T> PoolableWrapper<T> of(T srcObject, long liveTime, long maxIdleTime) {
        return new PoolableWrapper<T>(srcObject, liveTime, maxIdleTime);
    }

    public T value() {
        return this.srcObject;
    }

    @Override
    public void destroy() {
    }

    public int hashCode() {
        return N.hashCode(this.srcObject.hashCode());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PoolableWrapper && N.equals(((PoolableWrapper)obj).srcObject, this.srcObject);
    }

    public String toString() {
        return "{srcObject=" + this.srcObject + "; activityPrint=" + this.activityPrint + "}";
    }
}

