/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.N;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public abstract class AbstractArrayType<T>
extends AbstractType<T> {
    protected AbstractArrayType(String typeName) {
        super(typeName);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Type.SerializationType getSerializationType() {
        return this.isSerializable() ? Type.SerializationType.SERIALIZABLE : Type.SerializationType.ARRAY;
    }

    @Override
    public <E> Collection<E> array2Collection(Class<?> collClass, T x) {
        if (x == null) {
            return null;
        }
        Collection<E> c = this.newCollection(collClass, Array.getLength(x));
        return ((AbstractType)this).array2Collection(c, x);
    }

    protected <E> Collection<E> newCollection(Class<?> cls, int len) {
        Collection<Object> c = null;
        c = Modifier.isAbstract(cls.getModifiers()) ? (List.class.isAssignableFrom(cls) ? new ArrayList(len) : (Set.class.isAssignableFrom(cls) ? N.newHashSet(N.initHashCapacity(len)) : (Queue.class.isAssignableFrom(cls) ? new ArrayDeque(len) : (Collection)N.newInstance(cls)))) : (ArrayList)N.newInstance(cls);
        return c;
    }

    protected String[] split(String str) {
        int len;
        String[] strs = str.split(ELEMENT_SEPARATOR);
        if (strs.length == 1 && str.indexOf(44) > 0) {
            strs = str.split(",");
        }
        if ((len = strs.length) > 0) {
            int lastIndex = len - 1;
            if (strs[0].charAt(0) == '[' && strs[lastIndex].charAt(strs[lastIndex].length() - 1) == ']') {
                strs[0] = strs[0].substring(1);
                strs[lastIndex] = strs[lastIndex].substring(0, strs[lastIndex].length() - 1);
            }
        }
        return strs;
    }
}

