/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractPrimaryType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractCharacterType
extends AbstractPrimaryType<Character> {
    protected AbstractCharacterType(String typeName) {
        super(typeName);
    }

    @Override
    public String stringOf(Character x) {
        return x == null ? null : N.stringOf(x.charValue());
    }

    @Override
    public Character valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return (Character)this.defaultValue();
        }
        return Character.valueOf(N.parseChar(str));
    }

    @Override
    public Character valueOf(char[] cbuf, int offset, int len) {
        if (N.isNullOrEmpty(cbuf)) {
            return (Character)this.defaultValue();
        }
        return Character.valueOf(len == 1 ? cbuf[offset] : (char)AbstractCharacterType.parseInt(cbuf, offset, len));
    }

    @Override
    public void write(Writer writer, Character x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.charValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Character x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            char ch;
            char c = ch = config == null ? (char)'\u0000' : config.getCharQuotation();
            if (ch == '\u0000') {
                writer.writeCharacter(x.charValue());
            } else {
                writer.write(ch);
                writer.writeCharacter(x.charValue());
                writer.write(ch);
            }
        }
    }
}

