/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.DateTimeFormat;
import com.landawn.abacus.util.DateUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;

public abstract class AbstractDateType<T extends Date>
extends AbstractType<T> {
    protected AbstractDateType(String typeName) {
        super(typeName);
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public String stringOf(T x) {
        return x == null ? null : DateUtil.format(x);
    }

    @Override
    public void write(Writer writer, T x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            DateUtil.format(writer, x, null, null);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, T x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isQuote;
            boolean bl = isQuote = config != null && config.getStringQuotation() != '\u0000' && config.getDateTimeFormat() != DateTimeFormat.LONG;
            if (isQuote) {
                writer.write(config.getStringQuotation());
            }
            if (config == null || config.getDateTimeFormat() == null) {
                DateUtil.format((Writer)writer, x);
            } else {
                switch (config.getDateTimeFormat()) {
                    case LONG: {
                        writer.write(((Date)x).getTime());
                        break;
                    }
                    case ISO_8601_DATETIME: {
                        DateUtil.format((Writer)writer, x, "yyyy-MM-dd'T'HH:mm:ss'Z'", null);
                        break;
                    }
                    case ISO_8601_TIMESTAMP: {
                        DateUtil.format((Writer)writer, x, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", null);
                        break;
                    }
                    default: {
                        throw new AbacusException("unsupported operation");
                    }
                }
            }
            if (isQuote) {
                writer.write(config.getStringQuotation());
            }
        }
    }
}

