/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.NumberType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractDoubleType
extends NumberType<Number> {
    protected AbstractDoubleType(String typeName) {
        super(typeName);
    }

    @Override
    public String stringOf(Double x) {
        if (x == null) {
            return null;
        }
        return N.stringOf(x);
    }

    @Override
    public Double valueOf(String str) {
        try {
            return N.isNullOrEmpty(str) ? (Double)this.defaultValue() : Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            char ch;
            if (str.length() > 1 && ((ch = str.charAt(str.length() - 1)) == 'l' || ch == 'L' || ch == 'f' || ch == 'F' || ch == 'd' || ch == 'D')) {
                return Double.valueOf(str.substring(0, str.length() - 1));
            }
            throw e;
        }
    }

    @Override
    public void write(Writer writer, Number x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.doubleValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Number x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(x.doubleValue());
        }
    }
}

