/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.NumberType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractFloatType
extends NumberType<Number> {
    protected AbstractFloatType(String typeName) {
        super(typeName);
    }

    @Override
    public String stringOf(Float x) {
        if (x == null) {
            return null;
        }
        return N.stringOf(x.floatValue());
    }

    @Override
    public Float valueOf(String st) {
        try {
            return N.isNullOrEmpty(st) ? (Float)this.defaultValue() : Float.valueOf(st);
        }
        catch (NumberFormatException e) {
            char ch;
            if (st.length() > 1 && ((ch = st.charAt(st.length() - 1)) == 'l' || ch == 'L' || ch == 'f' || ch == 'F' || ch == 'd' || ch == 'D')) {
                return Float.valueOf(st.substring(0, st.length() - 1));
            }
            throw e;
        }
    }

    @Override
    public void write(Writer writer, Number x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.floatValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Number x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write((Writer)writer, x.floatValue());
        }
    }
}

