/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.NumberType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractIntegerType
extends NumberType<Number> {
    protected AbstractIntegerType(String typeName) {
        super(typeName);
    }

    @Override
    public String stringOf(Integer x) {
        if (x == null) {
            return null;
        }
        return N.stringOf(x);
    }

    @Override
    public Integer valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return (Integer)this.defaultValue();
        }
        try {
            return N.parseInt(str);
        }
        catch (NumberFormatException e) {
            char ch;
            if (str.length() > 1 && ((ch = str.charAt(str.length() - 1)) == 'l' || ch == 'L' || ch == 'f' || ch == 'F' || ch == 'd' || ch == 'D')) {
                return AbstractIntegerType.parseInt(StringUtil.getCharsForReadOnly(str), 0, str.length() - 1);
            }
            throw e;
        }
    }

    @Override
    public Integer valueOf(char[] cbuf, int offset, int len) {
        return cbuf == null || len == 0 ? (Integer)this.defaultValue() : Integer.valueOf(AbstractIntegerType.parseInt(cbuf, offset, len));
    }

    @Override
    public void write(Writer writer, Number x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.intValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Number x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.writeInt(x.intValue());
        }
    }
}

