/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.util.CharacterWriter;
import java.io.IOException;
import java.io.Writer;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractJodaDateTimeType<T extends BaseDateTime>
extends AbstractType<T> {
    protected static final DateTimeFormatter iso8601DateTimeFT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected static final DateTimeFormatter iso8601TimestampFT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    protected AbstractJodaDateTimeType(String typeName) {
        super(typeName);
    }

    @Override
    public boolean isJodaDateTime() {
        return true;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public String stringOf(T x) {
        return x == null ? null : iso8601TimestampFT.print(x);
    }

    @Override
    public void write(Writer writer, T x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            iso8601TimestampFT.printTo(writer, x);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, T x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isQuote;
            boolean bl = isQuote = config != null && config.getStringQuotation() != '\u0000' && config.getDateTimeFormat() != com.landawn.abacus.util.DateTimeFormat.LONG;
            if (isQuote) {
                writer.write(config.getStringQuotation());
            }
            if (config == null || config.getDateTimeFormat() == null) {
                iso8601TimestampFT.printTo((Writer)writer, x);
            } else {
                switch (config.getDateTimeFormat()) {
                    case LONG: {
                        writer.write(x.getMillis());
                        break;
                    }
                    case ISO_8601_DATETIME: {
                        iso8601DateTimeFT.printTo((Writer)writer, x);
                        break;
                    }
                    case ISO_8601_TIMESTAMP: {
                        iso8601TimestampFT.printTo((Writer)writer, x);
                        break;
                    }
                    default: {
                        throw new AbacusException("unsupported operation");
                    }
                }
            }
            if (isQuote) {
                writer.write(config.getStringQuotation());
            }
        }
    }
}

