/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.NumberType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractLongType
extends NumberType<Number> {
    protected AbstractLongType(String typeName) {
        super(typeName);
    }

    @Override
    public String stringOf(Long x) {
        if (x == null) {
            return null;
        }
        return N.stringOf(x);
    }

    @Override
    public Long valueOf(String st) {
        if (N.isNullOrEmpty(st)) {
            return (Long)this.defaultValue();
        }
        try {
            return N.parseLong(st);
        }
        catch (NumberFormatException e) {
            char ch;
            if (st.length() > 1 && ((ch = st.charAt(st.length() - 1)) == 'l' || ch == 'L' || ch == 'f' || ch == 'F' || ch == 'd' || ch == 'D')) {
                return AbstractLongType.parseLong(StringUtil.getCharsForReadOnly(st), 0, st.length() - 1);
            }
            throw e;
        }
    }

    @Override
    public Long valueOf(char[] cbuf, int offset, int len) {
        return cbuf == null || len == 0 ? (Long)this.defaultValue() : Long.valueOf(AbstractLongType.parseLong(cbuf, offset, len));
    }

    @Override
    public void write(Writer writer, Number x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.longValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Number x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(x.longValue());
        }
    }
}

