/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.NumberType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractShortType
extends NumberType<Number> {
    protected AbstractShortType(String typeName) {
        super(typeName);
    }

    @Override
    public String stringOf(Short x) {
        if (x == null) {
            return null;
        }
        return N.stringOf(x);
    }

    @Override
    public Short valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return (Short)this.defaultValue();
        }
        try {
            return N.parseShort(str);
        }
        catch (NumberFormatException e) {
            char ch;
            if (str.length() > 1 && ((ch = str.charAt(str.length() - 1)) == 'l' || ch == 'L' || ch == 'f' || ch == 'F' || ch == 'd' || ch == 'D')) {
                return N.parseShort(str.substring(0, str.length() - 1));
            }
            throw e;
        }
    }

    @Override
    public Short valueOf(char[] cbuf, int offset, int len) {
        if (cbuf == null || len == 0) {
            return (Short)this.defaultValue();
        }
        int i = AbstractShortType.parseInt(cbuf, offset, len);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + i + "\" Radix:" + 10);
        }
        return (short)i;
    }

    @Override
    public void write(Writer writer, Number x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.shortValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Number x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(x.shortValue());
        }
    }
}

