/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractType<T>
implements Type<T> {
    static final String SYS_TIME = "sysTime";
    static final String NULL_STRING = "null".intern();
    static final char[] NULL_CHAR_ARRAY = NULL_STRING.toCharArray();
    static final String TRUE = Boolean.TRUE.toString().intern();
    static final char[] TRUE_CHAR_ARRAY = TRUE.toCharArray();
    static final String FALSE = Boolean.FALSE.toString().intern();
    static final char[] FALSE_CHAR_ARRAY = FALSE.toCharArray();
    protected static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static final Map<String, String> separatorConvertor = new HashMap<String, String>();
    private final String name;
    private final String xmlName;

    protected AbstractType(String typeName) {
        String simpleName = typeName;
        if (typeName.indexOf(46) > 0) {
            int index = typeName.indexOf(60);
            String tmpTypeName = index > 0 ? typeName.substring(0, index) : typeName;
            try {
                Class cls = ClassUtil.forClass(tmpTypeName);
                if (cls != null && (cls = ClassUtil.forClass(ClassUtil.getSimpleClassName(cls))) != null) {
                    simpleName = ClassUtil.getSimpleClassName(cls) + (index > 0 ? typeName.substring(index) : N.EMPTY_STRING);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.name = simpleName;
        this.xmlName = this.name.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String declaringName() {
        return this.name;
    }

    @Override
    public String xmlName() {
        return this.xmlName;
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    @Override
    public boolean isPrimitiveWrapper() {
        return false;
    }

    @Override
    public boolean isPrimitiveList() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isDate() {
        return false;
    }

    @Override
    public boolean isCalendar() {
        return false;
    }

    @Override
    public boolean isJodaDateTime() {
        return false;
    }

    @Override
    public boolean isPrimitiveArray() {
        return false;
    }

    @Override
    public boolean isPrimitiveByteArray() {
        return false;
    }

    @Override
    public boolean isObjectArray() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isMapEntity() {
        return false;
    }

    @Override
    public boolean isEntityId() {
        return false;
    }

    @Override
    public boolean isDataSet() {
        return false;
    }

    @Override
    public boolean isInputStream() {
        return false;
    }

    @Override
    public boolean isReader() {
        return false;
    }

    @Override
    public boolean isByteBuffer() {
        return false;
    }

    @Override
    public boolean isGenericType() {
        return N.notNullOrEmpty(this.getParameterTypes());
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    @Override
    public Type.SerializationType getSerializationType() {
        return this.isSerializable() ? Type.SerializationType.SERIALIZABLE : Type.SerializationType.UNKNOWN;
    }

    @Override
    public boolean isOptionalOrNullable() {
        return false;
    }

    @Override
    public Type<?> getElementType() {
        return null;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return EMPTY_TYPE_ARRAY;
    }

    @Override
    public T defaultValue() {
        return null;
    }

    @Override
    public int compare(T x, T y) {
        if (this.isComparable()) {
            return x == null ? (y == null ? 0 : -1) : (y == null ? 1 : ((Comparable)x).compareTo(y));
        }
        throw new UnsupportedOperationException(this.name() + " doesn't support compare Operation");
    }

    @Override
    public T valueOf(Object obj) {
        return this.valueOf(obj == null ? null : N.typeOf(obj.getClass()).stringOf(obj));
    }

    @Override
    public T valueOf(char[] cbuf, int offset, int len) {
        return this.valueOf(cbuf == null ? null : String.valueOf(cbuf, offset, len));
    }

    @Override
    public void write(Writer writer, T x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(this.stringOf(x));
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, T x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            char ch;
            char c = ch = config == null ? (char)'\u0000' : config.getStringQuotation();
            if (ch == '\u0000') {
                writer.writeCharacter(this.stringOf(x));
            } else {
                writer.write(ch);
                writer.writeCharacter(this.stringOf(x));
                writer.write(ch);
            }
        }
    }

    @Override
    public T collection2Array(Collection<?> c) {
        throw new UnsupportedOperationException(this.name() + " doesn't support collection2Array Operation");
    }

    @Override
    public <E> Collection<E> array2Collection(Class<?> collClass, T x) {
        throw new UnsupportedOperationException(this.name() + " doesn't support array2Collection Operation");
    }

    @Override
    public <E> Collection<E> array2Collection(Collection<E> resultCollection, T x) {
        throw new UnsupportedOperationException(this.name() + " doesn't support array2Collection Operation");
    }

    @Override
    public int hashCode(T x) {
        return N.hashCode(x);
    }

    @Override
    public int deepHashCode(T x) {
        return N.hashCode(x);
    }

    @Override
    public boolean equals(T x, T y) {
        return N.equals(x, y);
    }

    @Override
    public boolean deepEquals(T x, T y) {
        return N.equals(x, y);
    }

    @Override
    public String toString(T x) {
        return N.toString(x);
    }

    @Override
    public String deepToString(T x) {
        return N.toString(x);
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof AbstractType && N.equals(((AbstractType)obj).name, this.name);
    }

    public String toString() {
        return this.name();
    }

    protected static String[] split(String st, String separator) {
        String newValue = separatorConvertor.get(separator);
        return newValue == null ? st.split(separator) : st.split(newValue);
    }

    protected static int parseInt(char[] cbuf, int offset, int len) throws NumberFormatException {
        if (offset < 0 || len < 0) {
            throw new IllegalArgumentException("'offset' and 'len' can't be negative");
        }
        if (len == 0 || N.isNullOrEmpty(cbuf) && offset == 0) {
            return 0;
        }
        switch (len) {
            case 1: {
                char ch = cbuf[offset];
                if (ch < '0' || ch > '9') {
                    throw new NumberFormatException("Invalid numeric String: \"" + String.valueOf(ch) + "\"");
                }
                return ch - 48;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                boolean isNagtive = cbuf[offset] == '-';
                int result = 0;
                char ch = '\u0000';
                int to = offset + len;
                for (int i = cbuf[offset] == '-' || cbuf[offset] == '+' ? offset + 1 : offset; i < to; ++i) {
                    ch = cbuf[i];
                    if (ch < '0' || ch > '9') {
                        throw new NumberFormatException("Invalid numeric String: \"" + new String(cbuf, offset, len) + "\"");
                    }
                    result = result * 10 + (ch - 48);
                }
                return isNagtive ? -result : result;
            }
        }
        return N.parseInt(new String(cbuf, offset, len));
    }

    protected static long parseLong(char[] cbuf, int offset, int len) throws NumberFormatException {
        if (offset < 0 || len < 0) {
            throw new IllegalArgumentException("'offset' and 'len' can't be negative");
        }
        if (len == 0 || N.isNullOrEmpty(cbuf) && offset == 0) {
            return 0L;
        }
        switch (len) {
            case 1: {
                char ch = cbuf[offset];
                if (ch < '0' || ch > '9') {
                    throw new NumberFormatException("Invalid numeric String: \"" + String.valueOf(ch) + "\"");
                }
                return ch - 48;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                boolean isNagtive = cbuf[offset] == '-';
                long result = 0L;
                char ch = '\u0000';
                int to = offset + len;
                for (int i = cbuf[offset] == '-' || cbuf[offset] == '+' ? offset + 1 : offset; i < to; ++i) {
                    ch = cbuf[i];
                    if (ch < '0' || ch > '9') {
                        throw new NumberFormatException("Invalid numeric String: \"" + new String(cbuf, offset, len) + "\"");
                    }
                    result = result * 10L + (long)(ch - 48);
                }
                return isNagtive ? -result : result;
            }
        }
        return N.parseLong(new String(cbuf, offset, len));
    }

    static {
        separatorConvertor.put(".", "\\.");
        separatorConvertor.put("|", "\\|");
        separatorConvertor.put("-", "\\-");
        separatorConvertor.put("*", "\\*");
        separatorConvertor.put("?", "\\?");
        separatorConvertor.put("+", "\\+");
        separatorConvertor.put("$", "\\$");
        separatorConvertor.put("^", "\\^");
        separatorConvertor.put("\\", "\\\\");
    }
}

