/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.ObjectArrayType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;

public final class CharacterArrayType
extends ObjectArrayType<Character> {
    CharacterArrayType() {
        super(Character[].class);
    }

    @Override
    public String stringOf(Character[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            if (x[i] == null) {
                sb.append(NULL_CHAR_ARRAY);
                continue;
            }
            sb.append("'");
            sb.append(x[i]);
            sb.append("'");
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public Character[] valueOf(String str) {
        Character[] a;
        block6: {
            if (N.isNullOrEmpty(str)) {
                return null;
            }
            String[] strs = this.split(str);
            int len = strs.length;
            a = new Character[len];
            if (len <= 0) break block6;
            boolean isQuoted = false;
            if (strs[0].length() > 1 && (strs[0].charAt(0) == '\'' || strs[0].charAt(0) == '\"')) {
                isQuoted = true;
            }
            if (isQuoted) {
                for (int i = 0; i < len; ++i) {
                    a[i] = strs[i].length() == 4 && strs[i].equals(NULL_STRING) ? null : (Character)this.elementType.valueOf(strs[i].substring(1, strs[i].length() - 1));
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    a[i] = strs[i].length() == 4 && strs[i].equals(NULL_STRING) ? null : (Character)this.elementType.valueOf(strs[i]);
                }
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, Character[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (x[i] == null) {
                    writer.write(NULL_CHAR_ARRAY);
                    continue;
                }
                writer.write(x[i].charValue());
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Character[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            char charQuotation = config == null ? (char)'\u0000' : config.getCharQuotation();
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (x[i] == null) {
                    writer.write(NULL_CHAR_ARRAY);
                    continue;
                }
                if (charQuotation > '\u0000') {
                    writer.write(charQuotation);
                    writer.writeCharacter(x[i].charValue());
                    writer.write(charQuotation);
                    continue;
                }
                writer.writeCharacter(x[i].charValue());
            }
            writer.write(']');
        }
    }

    @Override
    public String toString(Character[] x) {
        if (x == null) {
            return NULL_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            if (x[i] == null) {
                sb.append(NULL_CHAR_ARRAY);
                continue;
            }
            sb.append(x[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }
}

